/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.jpedal.io.JAIHelper;
import org.jpedal.utils.LogWriter;

public class TiffDecoder {
    byte[] bytes = null;

    public TiffDecoder(int w, int h, Map values, byte[] data) {
        boolean isBlack = false;
        int k = 0;
        String value = (String)values.get("K");
        if (value != null) {
            k = Integer.parseInt(value);
        }
        if ((value = (String)values.get("BlackIs1")) != null) {
            isBlack = Boolean.valueOf(value);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String[] headerValues = new String[]{"4d", "4d", "00", "2a", "00", "00", "00", "08"};
        int i = 0;
        while (i < headerValues.length) {
            bos.write(Integer.parseInt(headerValues[i], 16));
            ++i;
        }
        int tagCount = 9;
        boolean stripCount = true;
        this.writeWord(String.valueOf(tagCount), bos);
        this.writeTag("256", "04", "01", String.valueOf(w), bos);
        this.writeTag("257", "04", "01", String.valueOf(h), bos);
        this.writeTag("258", "03", "01", "00010000h", bos);
        if (k == 0) {
            this.writeTag("259", "03", "01", "00030000h", bos);
        } else if (k > 0) {
            this.writeTag("259", "03", "01", "00020000h", bos);
        } else if (k < 0) {
            this.writeTag("259", "03", "01", "00040000h", bos);
        }
        if (!isBlack) {
            this.writeTag("262", "03", "01", "00000000h", bos);
        } else {
            this.writeTag("262", "03", "01", "00010000h", bos);
        }
        this.writeTag("273", "04", "1", "122", bos);
        this.writeTag("277", "03", "01", "00010000h", bos);
        this.writeTag("278", "04", "01", String.valueOf(h), bos);
        this.writeTag("279", "04", "1", String.valueOf(data.length), bos);
        this.writeDWord("0", bos);
        try {
            bos.write(data);
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            JAIHelper.confirmJAIOnClasspath();
            ByteArraySeekableStream fss = new ByteArraySeekableStream(bos.toByteArray());
            RenderedOp op = JAI.create((String)"stream", (Object)fss);
            Raster raster = op.getData();
            DataBuffer db = raster.getDataBuffer();
            DataBufferByte dbb = (DataBufferByte)db;
            this.bytes = dbb.getData();
            if (!isBlack) {
                int bcount = this.bytes.length;
                int i2 = 0;
                while (i2 < bcount) {
                    this.bytes[i2] = (byte)(255 - this.bytes[i2]);
                    ++i2;
                }
            }
        }
        catch (Error err) {
            LogWriter.writeLog("[PDF] Tiff error " + err);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getRawBytes() {
        return this.bytes;
    }

    private void writeWord(String i, ByteArrayOutputStream bos) {
        int value = 0;
        value = i.endsWith("h") ? Integer.parseInt(i.substring(0, i.length() - 1), 16) : (i.endsWith("o") ? Integer.parseInt(i.substring(0, i.length() - 1), 8) : Integer.parseInt(i));
        bos.write(value >> 8);
        bos.write(value & 0xFF);
    }

    private void writeDWord(String i, ByteArrayOutputStream bos) {
        int value = 0;
        value = i.endsWith("h") ? Integer.parseInt(i.substring(0, i.length() - 1), 16) : (i.endsWith("o") ? Integer.parseInt(i.substring(0, i.length() - 1), 8) : Integer.parseInt(i));
        bos.write(value >> 24 & 0xFF);
        bos.write(value >> 16 & 0xFF);
        bos.write(value >> 8 & 0xFF);
        bos.write(value & 0xFF);
    }

    private void writeTag(String TagId, String dataType, String DataCount, String DataOffset, ByteArrayOutputStream bos) {
        this.writeWord(TagId, bos);
        this.writeWord(dataType, bos);
        this.writeDWord(DataCount, bos);
        this.writeDWord(DataOffset, bos);
    }
}

