/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

public class TextTokens {
    private byte[] content;
    private int length = 0;
    private int currentCharPointer;

    public TextTokens(byte[] rawText) {
        this.content = rawText;
        this.length = rawText.length;
        this.currentCharPointer = 0;
    }

    public boolean hasMoreTokens() {
        return this.currentCharPointer < this.length;
    }

    public char nextUnicodeToken() {
        char first = '\u0000';
        char second = '\u0000';
        first = this.nextToken();
        if (first == '\r' & this.hasMoreTokens()) {
            first = this.nextToken();
        }
        if (this.hasMoreTokens() && (second = this.nextToken()) == '\r' & this.hasMoreTokens()) {
            second = this.nextToken();
        }
        return (char)((first << 8) + second);
    }

    private char getChar(int pointer) {
        int number = this.content[pointer] & 0xFF;
        return (char)number;
    }

    public char nextToken() {
        char nextChar = this.getChar(this.currentCharPointer);
        ++this.currentCharPointer;
        return nextChar;
    }

    public boolean isUnicode() {
        if (this.length >= 2 && this.nextToken() == '\u00fe' && this.nextToken() == '\u00ff') {
            return true;
        }
        this.currentCharPointer = 0;
        return false;
    }
}

