/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import org.jpedal.io.RandomAccessBuffer;

public class RandomAccessDataBuffer
implements RandomAccessBuffer {
    private byte[] data;
    private long pointer;

    public RandomAccessDataBuffer(byte[] data) {
        this.data = data;
        this.pointer = -1L;
    }

    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    public void seek(long pos) throws IOException {
        if (!this.checkPos(pos)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = pos;
    }

    public void close() throws IOException {
        this.data = null;
        this.pointer = -1L;
    }

    public long length() throws IOException {
        if (this.data != null) {
            return this.data.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            return RandomAccessDataBuffer.b2i(this.data[(int)this.pointer++]);
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            return RandomAccessDataBuffer.b2i(this.data[(int)this.pointer]);
        }
        return -1;
    }

    public String readLine() throws IOException {
        int c;
        if (this.pointer >= (long)(this.data.length - 1)) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        while ((c = this.read()) >= 0) {
            if (c == 10 || c == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == c) break;
                this.read();
                break;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public int read(byte[] b) throws IOException {
        if (this.data == null) {
            throw new IOException("Data buffer not initialized.");
        }
        if (this.pointer < 0L || this.pointer >= (long)this.data.length) {
            return -1;
        }
        int length = Math.min(b.length, this.data.length - (int)this.pointer);
        int i = 0;
        while (i < length) {
            b[i] = this.data[(int)this.pointer++];
            ++i;
        }
        return length;
    }

    private static final int b2i(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    private boolean checkPos(long pos) throws IOException {
        return pos >= 0L && pos < this.length();
    }

    public byte[] getPdfBuffer() {
        return this.data;
    }
}

