/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jpedal.constants.PDFflags;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.SetSecurity;
import org.jpedal.io.TextTokens;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfReader
extends PdfFilteredReader
implements PdfObjectReader,
Serializable {
    private int startStreamPointer;
    private int endStreamPointer;
    private boolean debugAES = false;
    private byte[] lastCompressedStream = null;
    private Map fields = new HashMap();
    private Vector_Int xref = new Vector_Int(100);
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private int lastFirst;
    private Map objData = null;
    private Map nameLookup = new HashMap();
    private String lastRef = "";
    PdfFileInformation currentFileInformation = new PdfFileInformation();
    private static final String pattern = "obj";
    private boolean extractionIsAllowed = true;
    private static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    private static final byte[] endObj = new byte[]{32, 111, 98, 106};
    private static final byte[] lengthString = new byte[]{47, 76, 101, 110, 103, 116, 104};
    private static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private static final byte[] endStream = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    private boolean isEncrypted = false;
    private boolean isInitialised = false;
    private byte[] encryptionPassword = new byte[0];
    private String infoObject = null;
    private byte[] encryptionKey = null;
    private boolean isFileViewable = true;
    private int rev = 0;
    private int keyLength = 5;
    private int P = 0;
    private byte[] O = new byte[0];
    private byte[] U = new byte[0];
    private String ID = "";
    private boolean isPasswordSupplied = false;
    private Cipher cipher = null;
    private String[] padding = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private int[] ObjLengthTable;
    private boolean refTableInvalid = false;
    private static final boolean testOp = false;
    private int miniumumCacheSize;
    public boolean interruptRefReading = false;
    String EFF;
    String CFM;
    boolean isMetaDataEncypted = true;
    Map StrF;
    Map StmF;
    boolean stringsEncoded = false;
    String StrFname;
    String StmFname;
    private int passwordStatus = 0;
    private Javascript javascript;
    private static boolean alwaysReinitCipher = false;
    private static final int[] powers;

    static {
        String flag = null;
        if (flag != null && flag.toLowerCase().equals("true")) {
            alwaysReinitCipher = true;
        }
        powers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    public PdfReader() {
        this.fields.put("T", "x");
        this.fields.put("TM", "x");
        this.fields.put("TU", "x");
        this.fields.put("CA", "x");
        this.fields.put("R", "x");
        this.fields.put("V", "x");
        this.fields.put("RC", "x");
        this.fields.put("DA", "x");
        this.fields.put("DV", "x");
        this.fields.put("JS", "x");
        this.fields.put("Contents", "x");
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    public final int readFirstStartRef() throws PdfException {
        this.refTableInvalid = false;
        int pointer = -1;
        int i = 1019;
        StringBuffer startRef = new StringBuffer();
        int block = 1024;
        byte[] lastBytes = new byte[block];
        int[] EndOfFileMarker = new int[]{37, 37, 69, 79, 70};
        int valReached = 4;
        boolean EOFFound = false;
        try {
            long end;
            block20: {
                end = this.pdf_datafile.length();
                int bufSize = 255;
                do {
                    byte[] buffer = new byte[bufSize];
                    this.movePointer(end - (long)bufSize);
                    this.pdf_datafile.read(buffer);
                    int offset = 0;
                    int ii = bufSize - 1;
                    while (ii > -1) {
                        if (!EOFFound) {
                            valReached = 4;
                        }
                        if (buffer[ii] == EndOfFileMarker[valReached]) {
                            --valReached;
                            EOFFound = true;
                        } else {
                            EOFFound = false;
                        }
                        --offset;
                        if (valReached < 0) {
                            ii = -1;
                        }
                        --ii;
                    }
                    if (valReached >= 0) continue;
                    end -= (long)offset;
                    break block20;
                } while ((end -= (long)bufSize) >= 0L);
                end = this.pdf_datafile.length();
            }
            int count = (int)(end - (long)block);
            if (count < 0) {
                count = 0;
                int size = (int)this.pdf_datafile.length();
                lastBytes = new byte[size];
                i = size + 3;
            }
            this.movePointer(count);
            this.pdf_datafile.read(lastBytes);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading last 1024 bytes");
            throw new PdfException(e + " reading last 1024 bytes");
        }
        int fileSize = lastBytes.length;
        if (i > fileSize) {
            i = fileSize - 5;
        }
        while (i > -1) {
            if (lastBytes[i] == 116 && lastBytes[i + 1] == 120 && lastBytes[i + 2] == 114 && lastBytes[i + 3] == 101 && lastBytes[i + 4] == 102) break;
            --i;
        }
        if (i == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception " + e1 + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        i += 5;
        while (i < 1024 && lastBytes[i] == 10 | lastBytes[i] == 32 | lastBytes[i] == 13) {
            ++i;
        }
        while (i < 1024 && lastBytes[i] != 10 && lastBytes[i] != 32 && lastBytes[i] != 13) {
            startRef.append((char)lastBytes[i]);
            ++i;
        }
        if (startRef.length() > 0) {
            pointer = Integer.parseInt(startRef.toString());
        }
        if (pointer == -1) {
            LogWriter.writeLog("No Startref found in last 1024 bytes ");
            try {
                this.pdf_datafile.close();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception " + e1 + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return pointer;
    }

    public void setEncryptionPassword(String password) {
        this.encryptionPassword = password.getBytes();
    }

    public Map directValuesToMap(String value, boolean keepPrefix) {
        int level = 0;
        HashMap<String, Object> colorValues = new HashMap<String, Object>();
        HashMap<Integer, HashMap<String, Object>> maps = new HashMap<Integer, HashMap<String, Object>>();
        int start = value.indexOf("<<");
        int end = value.lastIndexOf(">>");
        String values = value.substring(start + 2, end).trim();
        StringTokenizer vals = new StringTokenizer(values, "/");
        while (vals.hasMoreTokens()) {
            Map newMap;
            String operand;
            String key;
            String nextValue = vals.nextToken().trim();
            int pointer = nextValue.indexOf(32);
            if (pointer == -1) {
                key = nextValue;
                operand = String.valueOf('/') + vals.nextToken().trim();
            } else {
                key = nextValue.substring(0, pointer);
                operand = nextValue.substring(pointer + 1);
            }
            if (keepPrefix) {
                key = String.valueOf('/') + key;
            }
            if (operand.equals("<<")) {
                newMap = new HashMap();
                colorValues.put(key, newMap);
                maps.put(new Integer(level), colorValues);
                colorValues = newMap;
                ++level;
                continue;
            }
            if (operand.endsWith(">>")) {
                operand = operand.substring(0, operand.length() - 2);
                if ((newMap = (Map)maps.get(new Integer(--level))) != null) {
                    colorValues = newMap;
                }
            }
            colorValues.put(key, operand);
        }
        return colorValues;
    }

    public Object resolveToMapOrString(String command, Object field) {
        if (this.fields != null && this.fields.get(command) != null && field instanceof byte[]) {
            byte[] fieldBytes = this.getByteTextStringValue(field, this.fields);
            field = this.getTextString(fieldBytes);
        } else if (field instanceof String && ((String)field).endsWith(" R")) {
            Object newObj = this.getObjectValue(field);
            if (newObj instanceof Map) {
                Map newField = (Map)newObj;
                this.readStream((String)field, true);
                field = newField;
            } else {
                field = newObj;
            }
        }
        return field;
    }

    private byte[] readObjectDataTEST(int bufSize, boolean lengthSet) {
        boolean debugCache = false;
        if (!debugCache) {
            return this.readObjectData(bufSize);
        }
        byte[] testData = this.readObjectData(bufSize);
        return null;
    }

    private byte[] readObjectData(int bufSize) {
        int rawSize = bufSize;
        int realPos = 0;
        boolean debug = false;
        boolean debugFaster = false;
        boolean lengthSet = false;
        boolean streamFound = false;
        boolean isDefaultSize = false;
        if (bufSize < 1) {
            isDefaultSize = true;
            bufSize = 128;
        }
        if (this.miniumumCacheSize != -1 && bufSize > this.miniumumCacheSize) {
            bufSize = this.miniumumCacheSize;
        }
        this.startStreamPointer = -1;
        this.endStreamPointer = -1;
        int charReached = 0;
        int charReached2 = 0;
        int charReached3 = 0;
        int startStreamCount = 0;
        int endStreamCount = 0;
        int bytesAddedToTempStream = 0;
        int miniumumCacheSize = this.miniumumCacheSize;
        boolean cacheStream = this.miniumumCacheSize != -1;
        int start = 0;
        byte[] tempStreamData = null;
        if (cacheStream) {
            tempStreamData = new byte[miniumumCacheSize];
        }
        byte[] array = null;
        byte[] buffer = null;
        byte[] dataRead = null;
        boolean inStream = false;
        boolean inLimits = false;
        long pointer = 0L;
        long lastEndStream = -1L;
        long objStart = -1L;
        ByteArrayOutputStream bis = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte currentByte = 0;
            int i = bufSize - 1;
            int offset = -bufSize;
            int blocksRead = 0;
            int lastEnd = -1;
            int lastComment = -1;
            while (true) {
                if (++i == bufSize) {
                    if (!cacheStream) {
                        if (blocksRead == 1) {
                            dataRead = buffer;
                        } else if (blocksRead > 1) {
                            bytesRead = dataRead.length;
                            int newBytes = buffer.length;
                            byte[] tmp = new byte[bytesRead + newBytes];
                            System.arraycopy(dataRead, 0, tmp, 0, bytesRead);
                            System.arraycopy(buffer, 0, tmp, bytesRead, newBytes);
                            dataRead = tmp;
                        }
                        ++blocksRead;
                    }
                    if ((pointer = this.getPointer()) + (long)bufSize > this.eof) {
                        bufSize = (int)(this.eof - pointer);
                    }
                    buffer = new byte[bufSize += 6];
                    this.pdf_datafile.read(buffer);
                    offset += i;
                    i = 0;
                }
                byte lastByte = currentByte;
                currentByte = buffer[i];
                boolean ignoreByte = false;
                if (currentByte == 37) {
                    lastComment = realPos;
                }
                charReached = currentByte == endPattern[charReached] && !inStream ? ++charReached : 0;
                charReached2 = streamFound && currentByte == endObj[charReached2] && !inStream ? ++charReached2 : 0;
                if (!lengthSet && rawSize != -1) {
                    if (!streamFound && currentByte == lengthString[charReached3] && !inStream) {
                        if (++charReached3 == 6) {
                            lengthSet = true;
                        }
                    } else {
                        charReached3 = 0;
                    }
                }
                if (cacheStream) {
                    if (!inStream && currentByte == 62 && lastByte == 62) {
                        inLimits = false;
                    }
                    if (!inStream) {
                        startStreamCount = startStreamCount < 6 && currentByte == startStream[startStreamCount] && !inLimits ? ++startStreamCount : 0;
                        if (startStreamCount == 6) {
                            inStream = true;
                            streamFound = true;
                            if (bis != null) {
                                bis.write(currentByte);
                            }
                            if (this.startStreamPointer == -1) {
                                ignoreByte = true;
                                startStreamCount = 0;
                                start = i + 1;
                                if (buffer[start] == 13 && buffer[start + 1] == 10) {
                                    start += 2;
                                } else if (buffer[start] == 10 | buffer[start] == 13) {
                                    ++start;
                                }
                                this.startStreamPointer = (int)((long)start + pointer);
                            }
                            start += offset;
                        }
                    } else {
                        if (bytesAddedToTempStream < miniumumCacheSize) {
                            tempStreamData[bytesAddedToTempStream] = currentByte;
                            ++bytesAddedToTempStream;
                            ignoreByte = true;
                        }
                        if (currentByte == endStream[endStreamCount] && !inLimits) {
                            ++endStreamCount;
                        } else {
                            endStreamCount = 0;
                            if (currentByte == endStream[endStreamCount] && !inLimits) {
                                ++endStreamCount;
                            }
                        }
                        if (endStreamCount == 9) {
                            endStreamCount = 0;
                            int j = i - 9;
                            if (bytesAddedToTempStream < miniumumCacheSize) {
                                int aa = 0;
                                while (aa < bytesAddedToTempStream) {
                                    bis.write(tempStreamData[aa]);
                                    ++aa;
                                }
                                this.startStreamPointer = -1;
                            }
                            if (this.startStreamPointer != -1) {
                                this.endStreamPointer = (int)((long)j + pointer);
                            }
                            if (this.endStreamPointer < this.startStreamPointer) {
                                this.startStreamPointer = -1;
                                this.endStreamPointer = -1;
                            }
                            inStream = false;
                            ignoreByte = true;
                        }
                    }
                    if (!inStream && currentByte == 60 && lastByte == 60) {
                        inLimits = true;
                    }
                }
                if (charReached == 6 || charReached2 == 4) {
                    if (!lengthSet) break;
                    charReached = 0;
                    charReached2 = 0;
                    lastEnd = realPos;
                }
                if (lengthSet && realPos >= rawSize) break;
                if (cacheStream) {
                    bis.write(currentByte);
                }
                ++realPos;
            }
            if (cacheStream) {
                bis.close();
                array = bis.toByteArray();
            } else {
                if (blocksRead == 1) {
                    array = new byte[i];
                    System.arraycopy(buffer, 0, array, 0, i);
                } else {
                    bytesRead = dataRead.length;
                    array = new byte[bytesRead + i];
                    System.arraycopy(dataRead, 0, array, 0, bytesRead);
                    System.arraycopy(buffer, 0, array, bytesRead, i);
                }
                if (lengthSet && lastEnd != -1 && lastComment != -1 && lastComment > lastEnd) {
                    byte[] newArray = new byte[lastEnd];
                    System.arraycopy(array, 0, newArray, 0, lastEnd);
                    array = newArray;
                }
            }
            if (!cacheStream && !lengthSet) {
                array = this.checkEndObject(array, objStart, lastEndStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogWriter.writeLog("Exception " + e + " reading object");
        }
        return array;
    }

    private byte[] checkEndObject(byte[] array, long objStart, long lastEndStream) {
        int ObjStartCount = 0;
        int i = 0;
        while (i < array.length - 8) {
            if (ObjStartCount < 2 && array[i] == 32 && array[i + 1] == 111 && array[i + 2] == 98 && array[i + 3] == 106) {
                ++ObjStartCount;
                objStart = i;
            }
            if (ObjStartCount < 2 && array[i] == 101 && array[i + 1] == 110 && array[i + 2] == 100 && array[i + 3] == 115 && array[i + 4] == 116 && array[i + 5] == 114 && array[i + 6] == 101 && array[i + 7] == 97 && array[i + 8] == 109) {
                lastEndStream = i + 9;
            }
            ++i;
        }
        if (lastEndStream > 0L && objStart > lastEndStream) {
            byte[] newArray = new byte[(int)lastEndStream];
            System.arraycopy(array, 0, newArray, 0, (int)lastEndStream);
            array = newArray;
        }
        return array;
    }

    private void verifyCachedData(boolean cacheStream, byte[] fullArray, int start) throws IOException {
        try {
            int arrayLength = this.endStreamPointer - this.startStreamPointer;
            if (arrayLength < 0) {
                System.out.println("Array size negative " + arrayLength);
                System.out.println(String.valueOf(this.startStreamPointer) + " " + this.endStreamPointer);
                System.out.println(" ");
                int jj = 0;
                while (jj < this.startStreamPointer + 30) {
                    System.err.println(String.valueOf(jj) + " " + (char)fullArray[jj]);
                    ++jj;
                }
                System.exit(1);
            }
            byte[] array = new byte[arrayLength];
            this.movePointer(this.startStreamPointer);
            this.pdf_datafile.read(array);
            arrayLength = array.length;
            boolean failed = false;
            int ii = 0;
            while (ii < arrayLength) {
                if (fullArray[ii + start] != array[ii]) {
                    System.out.println("X1 Not same value at " + ii + " ==" + fullArray[ii + start] + ' ' + array[ii]);
                    failed = true;
                    System.exit(1);
                }
                ++ii;
            }
            if (failed) {
                System.exit(1);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int readDictionary(String objectRef, int level, Map rootObject, int i, byte[] raw, boolean isEncryptionObject, Map textFields, int endPoint) {
        preserveTextString = false;
        debug = false;
        operand = null;
        key = new StringBuffer(20);
        while (!(++i >= raw.length || endPoint != -1 && i >= endPoint || raw[i] == 62 && raw[i + 1] == 62 || raw[i] == 101 && raw[i + 1] == 110 && raw[i + 2] == 100 && raw[i + 3] == 111)) {
            if (raw[i] == 60 && raw[i + 1] == 60) {
                ++i;
                dataValues = new HashMap<K, V>();
                rootObject.put(key.toString(), dataValues);
                i = this.readDictionary(objectRef, ++level, dataValues, i, raw, isEncryptionObject, textFields, endPoint);
                key = new StringBuffer(20);
                --level;
                if (raw[i] != 62 || raw[i + 1] != 62) continue;
                ++i;
                continue;
            }
            if (raw[i] == 47 && raw[i + 1] == 47 && key.length() == 0) {
                key = new StringBuffer(32);
                ++i;
                continue;
            }
            if (raw[i] == 47 & key.length() == 0) {
                key = new StringBuffer(20);
                ++i;
                while (raw[i] != 32 && raw[i] != 13 && raw[i] != 9 && raw[i] != 10 && raw[i] != 91 && raw[i] != 47 && raw[i] != 40 && raw[i] != 60) {
                    if (raw[i] == 35) {
                        // empty if block
                    }
                    key.append((char)raw[i]);
                    ++i;
                }
                if (raw[i] == 32 && raw[i - 1] == 47) {
                    key.append(' ');
                }
                preserveTextString = textFields != null && key.length() > 0 && textFields.containsKey(key.toString()) != false;
                if (!(raw[i] == 47 | raw[i] == 40 | raw[i] == 60 | raw[i] == 91)) continue;
                --i;
                continue;
            }
            if (raw[i] == 32 | raw[i] == 13 | raw[i] == 10) continue;
            if (raw[i] == 60 && preserveTextString) {
                debug2 = true;
                bis = null;
                bis = new ByteArrayOutputStream();
                count = 0;
                i2 = ++i;
                do {
                    i2 += 2;
                    ++count;
                    while (raw[i2] == 13 | raw[i2] == 10) {
                        ++i2;
                    }
                } while (raw[i2] != 62);
                streamData = new byte[count];
                count = 0;
                do {
                    newValue = new StringBuffer(2);
                    j = 0;
                    while (j < 2) {
                        newValue.append((char)raw[i]);
                        ++i;
                        ++j;
                    }
                    bis.write(Integer.parseInt(newValue.toString(), 16));
                    streamData[count] = (byte)Integer.parseInt(newValue.toString(), 16);
                    ++count;
                    while (raw[i] == 13 | raw[i] == 10) {
                        ++i;
                    }
                } while (raw[i] != 62);
                try {
                    bis.close();
                    stream2 = bis.toByteArray();
                    if (streamData.length != stream2.length) {
                        System.out.println("Different lengths " + streamData.length + ' ' + stream2.length);
                        System.exit(1);
                    }
                    jj = 0;
                    while (jj < stream2.length) {
                        if (stream2[jj] != streamData[jj]) {
                            System.out.println(String.valueOf(jj) + " Different values " + stream2[jj] + ' ' + streamData[jj]);
                            System.exit(1);
                        }
                        ++jj;
                    }
                    streamData = this.decrypt(streamData, objectRef, false, null, false, false);
                    rootObject.put(key.toString(), streamData);
                }
                catch (Exception e) {
                    LogWriter.writeLog("[PDF] Problem " + e + " writing text string" + key);
                    e.printStackTrace();
                }
                key = new StringBuffer(20);
                continue;
            }
            if (raw[i] == 40) {
                block147: {
                    if (preserveTextString) {
                        bis = new ByteArrayOutputStream();
                        try {
                            if (raw[i + 1] != 41) {
                                while (true) {
                                    isOctal = false;
                                    if (raw[++i] == 92) {
                                        if (raw[++i] == 98) {
                                            raw[i] = 8;
                                        } else if (raw[i] == 110) {
                                            raw[i] = 10;
                                        } else if (raw[i] == 116) {
                                            raw[i] = 9;
                                        } else if (raw[i] == 114) {
                                            raw[i] = 13;
                                        } else if (raw[i] == 102) {
                                            raw[i] = 12;
                                        } else if (raw[i] == 92) {
                                            raw[i] = 92;
                                        } else if (Character.isDigit((char)raw[i])) {
                                            octal = new StringBuffer(3);
                                            ii = 0;
                                            while (ii < 3) {
                                                octal.append((char)raw[i]);
                                                ++i;
                                                ++ii;
                                            }
                                            isOctal = true;
                                            raw[--i] = (byte)Integer.parseInt(octal.toString(), 8);
                                        }
                                    }
                                    if (!isOctal && raw[i] == 41 && raw[i - 1] != 92 | (raw[i - 1] == 92 && raw[i - 2] == 92)) break;
                                    bis.write(raw[i]);
                                }
                            }
                            bis.close();
                            streamData = bis.toByteArray();
                            streamData = this.decrypt(streamData, objectRef, false, null, false, true);
                            if (key.toString().equals("Dest")) {
                                destKey = this.getTextString(streamData);
                                rootObject.put(key.toString(), this.nameLookup.get(destKey));
                                break block147;
                            }
                            rootObject.put(key.toString(), streamData);
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("[PDF] Problem " + e + " handling text string" + key);
                        }
                    } else if (isEncryptionObject && key.length() == 1 && key.charAt(0) == 'U' | key.charAt(0) == 'O') {
                        count = 32;
                        bis = new ByteArrayOutputStream();
                        do {
                            if ((next = raw[++i]) == 92) {
                                if ((next = raw[++i]) == 114) {
                                    next = 13;
                                } else if (next == 110) {
                                    next = 10;
                                } else if (next == 116) {
                                    next = 9;
                                } else if (next == 102) {
                                    next = 12;
                                } else if (next == 98) {
                                    next = 8;
                                } else if (next > 47 && next < 58) {
                                    octal = new StringBuffer(3);
                                    ii = 0;
                                    while (ii < 3) {
                                        octal.append((char)raw[i + ii]);
                                        ++ii;
                                    }
                                    i += 2;
                                    next = (byte)Integer.parseInt(octal.toString(), 8);
                                }
                            }
                            bis.write(next);
                        } while (--count != 0);
                        try {
                            bis.close();
                            rootObject.put(key.toString(), bis.toByteArray());
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("[PDF] Problem " + e + " writing " + key);
                        }
                    } else {
                        startValue = i;
                        opPointer = 0;
                        inComment = false;
                        while (true) {
                            if (!inComment) {
                                ++opPointer;
                            }
                            if ((raw[i - 1] != 92 || raw[i - 2] == 92) && raw[i] == 41) break;
                            if (raw[++i] != 37 || raw[i - 1] == 92) continue;
                            inComment = true;
                        }
                        inComment = false;
                        p = 0;
                        value = new char[opPointer];
                        while (true) {
                            if (!inComment) {
                                if (raw[startValue] == 13 | raw[startValue] == 10) {
                                    value[p] = 32;
                                    ++p;
                                } else {
                                    value[p] = (char)raw[startValue];
                                    ++p;
                                }
                            }
                            if (raw[startValue] != 92 && raw[startValue - 1] == 92 && raw[startValue - 2] == 92) {
                                raw[startValue - 1] = 0;
                            }
                            if (raw[startValue - 1] != 92 & raw[startValue] == 41) break;
                            if (raw[++startValue] != 37 || raw[startValue - 1] == 92) continue;
                            inComment = true;
                        }
                        finalOp = String.copyValueOf(value, 0, opPointer);
                        if (!finalOp.equals("null")) {
                            rootObject.put(key.toString(), finalOp);
                        }
                    }
                }
                key = new StringBuffer(20);
                continue;
            }
            if (raw[i] == 91 && this.isFDF) {
                fdfTable = new HashMap<String, String>();
                while (true) {
                    if (raw[i + 1] != 60 && raw[i + 2] != 60 && raw[i] != 93) {
                        ++i;
                        continue;
                    }
                    end = i;
                    while (raw[end + 1] != 62 && raw[end + 2] != 62 && raw[end] != 93) {
                        ++end;
                    }
                    if (raw[i] == 93) break;
                    ref = new HashMap<K, V>();
                    i = this.readDictionary(objectRef, 1, ref, i + 2, raw, isEncryptionObject, textFields, end);
                    --i;
                    --i;
                    fdfkey = null;
                    value = "";
                    pdfFile = this.getByteTextStringValue(ref.get("T"), ref);
                    if (pdfFile != null) {
                        fdfkey = this.getTextString(pdfFile);
                    }
                    if ((pdfFile = this.getByteTextStringValue(ref.get("V"), ref)) != null) {
                        value = this.getTextString(pdfFile);
                    }
                    if (fdfkey == null) continue;
                    fdfTable.put(fdfkey, value);
                }
                rootObject.put(key.toString(), fdfTable);
                key = new StringBuffer(20);
                continue;
            }
            if (raw[i] == 91) {
                startValue = i;
                opPointer = 0;
                inComment = false;
                convertToHex = false;
                squareCount = 0;
                count = 0;
                next = 32;
                last = 32;
                containsIndexKeyword = false;
                while (raw[i] == 32) {
                    ++opPointer;
                    ++i;
                }
                while (true) {
                    if (raw[i] == 92) {
                        ++i;
                    }
                    if (opPointer > 7 && !containsIndexKeyword && raw[i - 7] == 47 && raw[i - 6] == 73 && raw[i - 5] == 110 && raw[i - 4] == 100 && raw[i - 3] == 101 && raw[i - 2] == 120 && raw[i - 1] == 101 && raw[i] == 100) {
                        containsIndexKeyword = true;
                    }
                    if (raw[i] == 40 && raw[i - 1] != 92 && containsIndexKeyword) {
                        convertToHex = true;
                        opPointer += 2;
                    } else if (convertToHex) {
                        if (raw[i] == 41 && raw[i - 1] != 92) {
                            ++opPointer;
                            convertToHex = false;
                        } else {
                            hex_value = Integer.toHexString(raw[i] & 255);
                            if (hex_value.length() < 2) {
                                ++opPointer;
                            }
                            opPointer += hex_value.length();
                        }
                    } else if (!inComment) {
                        if (raw[i] == 13 || raw[i] == 10) {
                            ++opPointer;
                        } else {
                            next = (char)raw[i];
                            if (next == 47 && last != 32) {
                                ++opPointer;
                            }
                            if (next != 32 && last == 41) {
                                ++opPointer;
                            }
                            ++opPointer;
                            last = next;
                        }
                    }
                    if (raw[i - 1] != 92 || raw[i - 1] == 92 && raw[i - 2] == 92 && raw[i - 3] != 92) {
                        if (raw[i] == 40) {
                            ++count;
                        } else if (raw[i] == 41) {
                            --count;
                        }
                        if (count == 0) {
                            if (raw[i] == 91) {
                                ++squareCount;
                            } else if (raw[i] == 93) {
                                --squareCount;
                            }
                        }
                    }
                    if (squareCount == 0 && raw[i - 1] != 92 && raw[i] == 93) break;
                    if (raw[++i] != 37 || raw[i - 1] == 92 || squareCount != 0) continue;
                    inComment = true;
                }
                value = new char[opPointer * 2];
                pt = 0;
                i = startValue;
                while (raw[i] == 32) {
                    value[pt] = (char)raw[i];
                    ++pt;
                    ++i;
                }
                inComment = false;
                convertToHex = false;
                squareCount = 0;
                count = 0;
                next = 32;
                last = 32;
                while (true) {
                    if (i > 7 && !containsIndexKeyword && raw[i - 7] == 47 && raw[i - 6] == 73 && raw[i - 5] == 110 && raw[i - 4] == 100 && raw[i - 3] == 101 && raw[i - 2] == 120 && raw[i - 1] == 101 && raw[i] == 100) {
                        containsIndexKeyword = true;
                    }
                    if (raw[i] == 40 & raw[i - 1] != 92 && containsIndexKeyword) {
                        start = i + 1;
                        end = i;
                        while (end < raw.length) {
                            if (raw[++end] == 41 & (raw[end - 1] != 92 || raw[end - 1] == 92 && raw[end - 2] == 92)) break;
                        }
                        length = end - start;
                        fieldBytes = new byte[length];
                        a = 0;
                        while (a < length) {
                            if (start == end) break;
                            b = raw[start];
                            if (b != 92) {
                                fieldBytes[a] = b;
                            } else if (raw[++start] == 98) {
                                fieldBytes[a] = 8;
                            } else if (raw[start] == 110) {
                                fieldBytes[a] = 10;
                            } else if (raw[start] == 116) {
                                fieldBytes[a] = 9;
                            } else if (raw[start] == 114) {
                                fieldBytes[a] = 13;
                            } else if (raw[start] == 102) {
                                fieldBytes[a] = 12;
                            } else if (raw[start] == 92) {
                                fieldBytes[a] = 92;
                            } else if (Character.isDigit((char)raw[start])) {
                                octal = new StringBuffer(3);
                                ii = 0;
                                while (ii < 3) {
                                    if (raw[start] == 92 || raw[start] == 41) break;
                                    octal.append((char)raw[start]);
                                    ++start;
                                    ++ii;
                                }
                                --start;
                                fieldBytes[a] = (byte)Integer.parseInt(octal.toString(), 8);
                            } else {
                                fieldBytes[a] = raw[start];
                            }
                            ++start;
                            ++a;
                        }
                        try {
                            fieldBytes = this.decrypt(fieldBytes, objectRef, false, null, false, false);
                        }
                        catch (PdfSecurityException e) {
                            e.printStackTrace();
                        }
                        value[pt] = 32;
                        value[++pt] = 60;
                        ++pt;
                        jj = 0;
                        while (jj < length) {
                            hex_value = Integer.toHexString(fieldBytes[jj] & 255);
                            if (hex_value.length() < 2) {
                                value[pt] = 48;
                                ++pt;
                            }
                            hCount = hex_value.length();
                            j = 0;
                            while (j < hCount) {
                                value[pt] = hex_value.charAt(j);
                                ++pt;
                                ++j;
                            }
                            ++jj;
                        }
                        value[pt] = 62;
                        ++pt;
                    } else if (!inComment) {
                        if (raw[i] == 13 | raw[i] == 10) {
                            value[pt] = 32;
                            ++pt;
                        } else {
                            next = (char)raw[i];
                            if (next == 47 && last != 32) {
                                value[pt] = 32;
                                ++pt;
                            }
                            if (next != 32 && last == 41) {
                                value[pt] = 32;
                                ++pt;
                            }
                            value[pt] = next;
                            ++pt;
                            last = next;
                        }
                    }
                    if (raw[i - 1] != 92 | (raw[i - 1] == 92 && raw[i - 2] == 92 && raw[i - 3] != 92)) {
                        if (raw[i] == 40) {
                            ++count;
                        } else if (raw[i] == 41) {
                            --count;
                        }
                        if (count == 0) {
                            if (raw[i] == 91) {
                                ++squareCount;
                            } else if (raw[i] == 93) {
                                --squareCount;
                            }
                        }
                    }
                    if (squareCount == 0 && raw[i - 1] != 92 & raw[i] == 93) break;
                    if (raw[++i] != 37 || raw[i - 1] == 92 || squareCount != 0) continue;
                    inComment = true;
                }
                finalOp = String.copyValueOf(value, 0, pt);
                if (!finalOp.equals("null")) {
                    rootObject.put(key.toString(), finalOp);
                }
                key = new StringBuffer(20);
                continue;
            }
            if (raw[i] == 62 || raw[i] == 60 || key.length() <= 0) continue;
            inComment = false;
            startValue = i;
            opPointer = 0;
            while (true) {
                if (raw[i] != 13 && raw[i] != 9 && raw[i] != 10 && !inComment) {
                    ++opPointer;
                }
                if (raw[i + 1] == 47 || raw[i] != 62 && raw[i + 1] == 62) ** GOTO lbl452
                if (raw[++i] != 37 || raw[i - 1] == 92) continue;
                inComment = true;
            }
lbl-1000:
            // 1 sources

            {
                --opPointer;
lbl452:
                // 2 sources

                ** while (opPointer > 0 && (raw[startValue + opPointer - 1] == 32 || raw[startValue + opPointer - 1] == 10 || raw[startValue + opPointer - 1] == 13 || raw[startValue + opPointer - 1] == 9))
            }
lbl453:
            // 1 sources

            value = new char[opPointer];
            --opPointer;
            p = 0;
            do {
                if (raw[startValue] != 13 && raw[startValue] != 9 && raw[startValue] != 10) {
                    value[p] = (char)raw[startValue];
                    ++p;
                }
                ++startValue;
            } while (p <= opPointer);
            finalOp = String.copyValueOf(value, 0, p);
            if (!finalOp.equals("null")) {
                rootObject.put(key.toString(), finalOp);
            }
            key = new StringBuffer(20);
        }
        return i;
    }

    public final byte[] readStream(Map objData, String objectRef, boolean cacheValue, boolean decompress, boolean keepRaw, boolean isMetaData, boolean isCompressedStream) {
        byte[] stream;
        Object data = objData.get("DecodedStream");
        BufferedOutputStream streamCache = null;
        String cacheName = null;
        boolean isCachedOnDisk = false;
        if (data == null) {
            stream = (byte[])objData.get("Stream");
            boolean bl = isCachedOnDisk = objData.get("startStreamOnDisk") != null && this.endStreamPointer - this.startStreamPointer >= 0;
            if (isCachedOnDisk) {
                try {
                    File tempFile = File.createTempFile("jpedal", ".bin");
                    cacheName = tempFile.getAbsolutePath();
                    this.cachedObjects.put(cacheName, "x");
                    streamCache = new BufferedOutputStream(new FileOutputStream(tempFile));
                    int buffer = 8192;
                    int ptr = this.startStreamPointer;
                    do {
                        int remainingBytes;
                        if ((remainingBytes = 1 + this.endStreamPointer - ptr) < buffer) {
                            buffer = remainingBytes;
                        }
                        byte[] bytes = new byte[buffer];
                        this.movePointer(ptr);
                        this.pdf_datafile.read(bytes);
                        streamCache.write(bytes);
                    } while ((ptr += buffer) < this.endStreamPointer);
                    streamCache.close();
                    File tt = new File(cacheName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (!(isCompressedStream || !this.isMetaDataEncypted && isMetaData)) {
                        this.decrypt(null, objectRef, false, cacheName, false, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    stream = null;
                    LogWriter.writeLog("Exception " + e);
                }
                objData.put("CachedStream", cacheName);
            }
            if (stream != null) {
                try {
                    if (!(isCompressedStream || !this.isMetaDataEncypted && isMetaData)) {
                        stream = this.decrypt(stream, objectRef, false, null, false, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    stream = null;
                    LogWriter.writeLog("Exception " + e);
                }
            }
            if (keepRaw) {
                objData.remove("Stream");
            }
            int length = 1;
            if (stream != null || isCachedOnDisk) {
                int height = 1;
                int width = 1;
                String value = (String)objData.get("Height");
                if (value != null) {
                    Map heightObj;
                    Object indirectHeight;
                    if (value.indexOf(82) != -1 && (indirectHeight = (heightObj = this.readObject(value, false, null)).get("rawValue")) != null) {
                        value = (String)indirectHeight;
                    }
                    height = Integer.parseInt(value);
                }
                if ((value = (String)objData.get("Width")) != null) {
                    width = Integer.parseInt(value);
                }
                if ((value = this.getValue((String)objData.get("Length"))) != null) {
                    length = Integer.parseInt(value);
                }
                if (height * width == 1) {
                    width = length;
                }
                String filter = this.getValue((String)objData.get("Filter"));
                boolean isImageMask = false;
                Object maskFlag = objData.get("ImageMask");
                if (maskFlag != null && maskFlag.equals("true")) {
                    isImageMask = true;
                }
                if (filter != null && !filter.startsWith("/JPXDecode") && !filter.startsWith("/DCT")) {
                    try {
                        String ref;
                        Object param = objData.get("DecodeParms");
                        if (param != null && param instanceof String && (ref = (String)param).endsWith(" R")) {
                            Map paramObj = this.readObject(ref, false, null);
                            objData.put("DecodeParms", paramObj);
                        }
                        stream = this.decodeFilters(stream, filter, objData, width, height, true, cacheName);
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("[PDF] Problem " + e + " decompressing stream " + filter);
                        stream = null;
                        isCachedOnDisk = false;
                    }
                    length = 1;
                } else if (stream != null && length != 1 && length < stream.length && stream.length != length) {
                    byte[] newStream = new byte[length];
                    System.arraycopy(stream, 0, newStream, 0, length);
                    stream = newStream;
                }
            }
            if (stream != null && cacheValue) {
                objData.put("DecodedStream", stream);
            }
            if (decompress && isCachedOnDisk) {
                int streamLength = (int)new File(cacheName).length();
                byte[] bytes = new byte[streamLength];
                try {
                    new BufferedInputStream(new FileInputStream(cacheName)).read(bytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (length != 1 && length < streamLength) {
                    byte[] newStream = new byte[length];
                    System.arraycopy(bytes, 0, newStream, 0, length);
                    bytes = newStream;
                }
                return bytes;
            }
        } else {
            stream = (byte[])data;
        }
        return stream;
    }

    public final String getStreamOnDisk(String ref) {
        int cacheSetting = this.miniumumCacheSize;
        this.miniumumCacheSize = 0;
        Map obj = this.readObject(ref, false, null);
        this.readStream(ref, true);
        this.miniumumCacheSize = cacheSetting;
        if (obj == null) {
            return null;
        }
        return (String)obj.get("CachedStream");
    }

    public int getObjectSize(String objectRef) {
        int size = -1;
        if (!this.refTableInvalid) {
            boolean isCompressed = this.isCompressed(objectRef);
            if (objectRef.endsWith(" R")) {
                byte[] stream = null;
                byte[] raw = null;
                if (isCompressed) {
                    int objectID = Integer.parseInt(objectRef.substring(0, objectRef.indexOf(32)));
                    int compressedID = this.getCompressedStreamObject(objectRef);
                    String compressedRef = String.valueOf(compressedID) + " 0 R";
                    String startID = null;
                    HashMap offsetStart = this.lastOffsetStart;
                    HashMap offsetEnd = this.lastOffsetEnd;
                    int First = this.lastFirst;
                    boolean isCached = true;
                    byte[] compressedStream = this.lastCompressedStream;
                    if (this.lastOffsetStart != null) {
                        startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
                    }
                    while (startID == null) {
                        isCached = false;
                        try {
                            this.movePointer(compressedRef);
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception moving pointer to " + objectRef);
                        }
                        raw = this.readObjectData(this.ObjLengthTable[compressedID]);
                        size = this.ObjLengthTable[compressedID];
                        HashMap compressedObject = new HashMap();
                        this.convertObjectBytesToMap(compressedObject, objectRef, false, new HashMap(), false, false, stream, raw, false);
                        offsetStart = new HashMap();
                        offsetEnd = new HashMap();
                        First = Integer.parseInt((String)compressedObject.get("First"));
                        compressedStream = this.readStream(compressedObject, objectRef, true, true, false, false, true);
                        this.extractCompressedObjectOffset(offsetStart, offsetEnd, First, compressedStream);
                        startID = (String)offsetStart.get(String.valueOf(objectID));
                        compressedRef = (String)compressedObject.get("Extends");
                    }
                    if (!isCached) {
                        this.lastCompressedStream = compressedStream;
                        this.lastOffsetStart = offsetStart;
                        this.lastOffsetEnd = offsetEnd;
                        this.lastFirst = First;
                    }
                } else {
                    int pointer = objectRef.indexOf(32);
                    int id = Integer.parseInt(objectRef.substring(0, pointer));
                    size = this.ObjLengthTable[id];
                }
            }
            if (size == 0) {
                size = -1;
            }
        }
        return size;
    }

    public final byte[] readStream(String ref, boolean decompress) {
        Map currentValues = this.readObject(ref, false, null);
        return this.readStream(currentValues, ref, true, decompress, false, false, false);
    }

    public final Map readObject(int objectRef) {
        boolean debug = false;
        boolean preserveTextString = false;
        this.objData = new HashMap();
        byte[] stream = null;
        try {
            this.movePointer(objectRef);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception moving pointer to " + objectRef);
        }
        byte[] raw = this.readObjectData(-1);
        StringBuffer objectName = new StringBuffer();
        int last = 32;
        int matched = 0;
        int i = 0;
        while (i < raw.length) {
            char current = (char)raw[i];
            if (current == '\n' || current == '\r') {
                current = ' ';
            }
            if (current == ' ' && last == 32) {
                matched = 0;
            } else if (current == pattern.charAt(matched)) {
                ++matched;
            } else {
                matched = 0;
                objectName.append(current);
            }
            if (matched == 3) break;
            last = current;
            ++i;
        }
        objectName.append('R');
        this.objData.put("Reference", objectName.toString());
        this.convertObjectBytesToMap(this.objData, objectName.toString(), false, null, debug, preserveTextString, stream, raw, false);
        this.lastRef = "-1";
        return this.objData;
    }

    public final void flushObjectCache() {
        this.lastRef = null;
    }

    public final synchronized Map readObject(String objectRef, boolean isEncryptionObject, Map textFields) {
        if (this.lastRef != null && objectRef.equals(this.lastRef)) {
            return this.objData;
        }
        this.lastRef = objectRef;
        boolean debug = false;
        boolean preserveTextString = false;
        this.objData = new HashMap();
        preserveTextString = textFields != null;
        if (debug) {
            System.err.println("reading objectRef=" + objectRef + '<');
        }
        if (objectRef.endsWith("]")) {
            objectRef = Strip.removeArrayDeleminators(objectRef);
        }
        if (debug) {
            System.err.println("reading objectRef=" + objectRef + "< isCompressed=" + this.isCompressed(objectRef));
        }
        boolean isCompressed = this.isCompressed(objectRef);
        if (objectRef.endsWith(" R")) {
            byte[] stream = null;
            byte[] raw = null;
            if (isCompressed) {
                int objectID = Integer.parseInt(objectRef.substring(0, objectRef.indexOf(32)));
                int compressedID = this.getCompressedStreamObject(objectRef);
                String compressedRef = String.valueOf(compressedID) + " 0 R";
                String startID = null;
                HashMap offsetStart = this.lastOffsetStart;
                HashMap offsetEnd = this.lastOffsetEnd;
                int First = this.lastFirst;
                boolean isCached = true;
                byte[] compressedStream = this.lastCompressedStream;
                if (this.lastOffsetStart != null) {
                    startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
                }
                while (startID == null) {
                    isCached = false;
                    try {
                        this.movePointer(compressedRef);
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception moving pointer to " + objectRef);
                    }
                    raw = this.readObjectData(this.ObjLengthTable[compressedID]);
                    HashMap compressedObject = new HashMap();
                    this.convertObjectBytesToMap(compressedObject, compressedRef, isEncryptionObject, textFields, debug, preserveTextString, stream, raw, false);
                    offsetStart = new HashMap();
                    offsetEnd = new HashMap();
                    First = Integer.parseInt((String)compressedObject.get("First"));
                    compressedStream = this.readStream(compressedObject, compressedRef, true, true, false, false, false);
                    this.extractCompressedObjectOffset(offsetStart, offsetEnd, First, compressedStream);
                    startID = (String)offsetStart.get(String.valueOf(objectID));
                    compressedRef = (String)compressedObject.get("Extends");
                }
                if (!isCached) {
                    this.lastCompressedStream = compressedStream;
                    this.lastOffsetStart = offsetStart;
                    this.lastOffsetEnd = offsetEnd;
                    this.lastFirst = First;
                }
                int start = First + Integer.parseInt(startID);
                int end = compressedStream.length;
                String endID = (String)offsetEnd.get(String.valueOf(objectID));
                if (endID != null) {
                    end = First + Integer.parseInt(endID);
                }
                int streamLength = end - start;
                raw = new byte[streamLength];
                System.arraycopy(compressedStream, start, raw, 0, streamLength);
            } else {
                try {
                    this.movePointer(objectRef);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception moving pointer to " + objectRef);
                }
                int pointer = objectRef.indexOf(32);
                int id = Integer.parseInt(objectRef.substring(0, pointer));
                if (isEncryptionObject | this.refTableInvalid) {
                    raw = this.readObjectData(-1);
                } else if (id > this.ObjLengthTable.length || this.ObjLengthTable[id] == 0) {
                    LogWriter.writeLog(String.valueOf(objectRef) + " cannot have offset 0");
                    raw = new byte[]{};
                } else {
                    raw = this.readObjectData(this.ObjLengthTable[id]);
                }
            }
            if (debug) {
                System.out.println("convertObjectsToMap");
            }
            if (this.startStreamPointer != -1 || raw.length > 1) {
                this.convertObjectBytesToMap(this.objData, objectRef, isEncryptionObject, textFields, debug, preserveTextString, stream, raw, isCompressed);
            }
            if (debug) {
                System.out.println("converted");
            }
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int ii = 0;
                while (ii < objectRef.length()) {
                    bos.write((byte)objectRef.charAt(ii));
                    ++ii;
                }
                if (debug) {
                    System.out.println("reading dictionary");
                }
                bos.close();
                byte[] bytes = bos.toByteArray();
                if (bytes.length > 0) {
                    this.readDictionary(objectRef, 1, this.objData, 0, bytes, isEncryptionObject, textFields, -1);
                }
                LogWriter.writeLog("Direct object read " + objectRef + "<<");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (debug) {
            System.out.println("object read");
        }
        return this.objData;
    }

    public final synchronized byte[] readObjectAsByteArray(String objectRef, boolean isEncryptionObject) {
        byte[] raw = null;
        if (objectRef.endsWith("]")) {
            objectRef = Strip.removeArrayDeleminators(objectRef);
        }
        boolean isCompressed = this.isCompressed(objectRef);
        if (objectRef.endsWith(" R")) {
            byte[] stream = null;
            if (isCompressed) {
                int objectID = Integer.parseInt(objectRef.substring(0, objectRef.indexOf(32)));
                int compressedID = this.getCompressedStreamObject(objectRef);
                String compressedRef = String.valueOf(compressedID) + " 0 R";
                String startID = null;
                int compressedIndex = this.getOffsetInCompressedStream(objectRef);
                HashMap offsetStart = this.lastOffsetStart;
                HashMap offsetEnd = this.lastOffsetEnd;
                int First = this.lastFirst;
                boolean isCached = true;
                byte[] compressedStream = this.lastCompressedStream;
                if (this.lastOffsetStart != null) {
                    startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
                }
                while (startID == null) {
                    isCached = false;
                    try {
                        this.movePointer(compressedRef);
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception moving pointer to " + objectRef);
                    }
                    raw = this.readObjectData(this.ObjLengthTable[compressedID]);
                    HashMap compressedObject = new HashMap();
                    this.convertObjectBytesToMap(compressedObject, objectRef, isEncryptionObject, null, false, false, stream, raw, false);
                    offsetStart = new HashMap();
                    offsetEnd = new HashMap();
                    First = Integer.parseInt((String)compressedObject.get("First"));
                    compressedStream = this.readStream(compressedObject, objectRef, true, true, false, false, true);
                    this.extractCompressedObjectOffset(offsetStart, offsetEnd, First, compressedStream);
                    startID = (String)offsetStart.get(String.valueOf(objectID));
                    compressedRef = (String)compressedObject.get("Extends");
                }
                if (!isCached) {
                    this.lastCompressedStream = compressedStream;
                    this.lastOffsetStart = offsetStart;
                    this.lastOffsetEnd = offsetEnd;
                    this.lastFirst = First;
                }
                int start = First + Integer.parseInt(startID);
                int end = compressedStream.length;
                String endID = (String)offsetEnd.get(String.valueOf(objectID));
                if (endID != null) {
                    end = First + Integer.parseInt(endID);
                }
                int streamLength = end - start;
                raw = new byte[streamLength];
                System.arraycopy(compressedStream, start, raw, 0, streamLength);
            } else {
                try {
                    this.movePointer(objectRef);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception moving pointer to " + objectRef);
                }
                int pointer = objectRef.indexOf(32);
                int id = Integer.parseInt(objectRef.substring(0, pointer));
                raw = isEncryptionObject | this.refTableInvalid ? this.readObjectData(-1) : this.readObjectData(this.ObjLengthTable[id]);
            }
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int ii = 0;
            while (ii < objectRef.length()) {
                bos.write((byte)objectRef.charAt(ii));
                ++ii;
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            raw = bos.toByteArray();
        }
        return raw;
    }

    private void extractCompressedObjectOffset(Map offsetStart, Map offsetEnd, int First, byte[] compressedStream) {
        String lastKey = null;
        String key = null;
        String offset = null;
        boolean debug = true;
        StringBuffer rawKey = null;
        StringBuffer rawOffset = null;
        int startKey = 0;
        int endKey = 0;
        int startOff = 0;
        int endOff = 0;
        int ii = 0;
        while (ii < First) {
            rawKey = new StringBuffer();
            rawOffset = new StringBuffer();
            startKey = ii;
            while (compressedStream[ii] != 32) {
                rawKey.append((char)compressedStream[ii]);
                ++ii;
            }
            endKey = ii - 1;
            int length = endKey - startKey + 1;
            char[] newCommand = new char[length];
            int i = 0;
            while (i < length) {
                newCommand[i] = (char)compressedStream[startKey + i];
                ++i;
            }
            key = new String(newCommand);
            if (!key.equals(rawKey.toString())) {
                System.out.println("Different=" + key + "<>" + rawKey + '<');
                System.exit(1);
            }
            while (compressedStream[ii] == 32) {
                ++ii;
            }
            startOff = ii;
            while (compressedStream[ii] != 32 && ii < First) {
                rawOffset.append((char)compressedStream[ii]);
                ++ii;
            }
            endOff = ii - 1;
            length = endOff - startOff + 1;
            newCommand = new char[length];
            i = 0;
            while (i < length) {
                newCommand[i] = (char)compressedStream[startOff + i];
                ++i;
            }
            offset = new String(newCommand);
            if (!offset.equals(rawOffset.toString())) {
                System.out.println("Different=" + offset + "<>" + rawOffset + '<');
                System.exit(1);
            }
            offsetStart.put(key, offset);
            if (lastKey != null) {
                offsetEnd.put(lastKey, offset);
            }
            lastKey = key;
            ++ii;
        }
    }

    private void convertObjectBytesToMap(Map objData, String objectRef, boolean isEncryptionObject, Map textFields, boolean debug, boolean preserveTextString, byte[] stream, byte[] raw, boolean isCompressed) {
        int ii;
        int i = 0;
        ByteArrayOutputStream rawStringAsBytes = new ByteArrayOutputStream();
        char remainderLastChar = ' ';
        StringBuffer remainder = new StringBuffer();
        if (!isCompressed) {
            while (raw[i] != 111 || raw[i + 1] != 98 || raw[i + 2] != 106) {
                ++i;
            }
            i += 2;
            while (raw[i] != 47 && !(raw[++i] == 10 | raw[i] == 13 | raw[i] == 60 | raw[i] == 91 | raw[i] == 32)) {
            }
        }
        if (debug) {
            int j = i;
            while (j < raw.length - 7) {
                System.err.print((char)raw[j]);
                ++j;
            }
            System.err.print("<===\n\n");
        }
        if (raw[i] == 47 | raw[i] == 91) {
            --i;
        }
        while (i < raw.length - 7) {
            ++i;
            if (debug) {
                System.err.println((char)raw[i]);
            }
            if (raw[i] == 111 && raw[i + 1] == 98 && raw[i + 2] == 106) break;
            if (raw[i] == 60 && raw[i + 1] == 60 | raw[i - 1] == 60) {
                if (raw[i - 1] != 60) {
                    ++i;
                }
                if (debug) {
                    System.err.println("Read dictionary");
                }
                i = this.readDictionary(objectRef, 1, objData, i, raw, isEncryptionObject, textFields, -1);
                continue;
            }
            if (raw[i] == 115 && raw[i + 1] == 116 && raw[i + 2] == 114 && raw[i + 3] == 101 && raw[i + 4] == 97 && raw[i + 5] == 109) {
                if (debug) {
                    System.err.println("Read stream");
                }
                if (raw[i += 6] == 13 && raw[i + 1] == 10) {
                    i += 2;
                } else if (raw[i] == 10 | raw[i] == 13) {
                    // empty if block
                }
                int start = ++i;
                --i;
                int streamLength = 0;
                String setLength = (String)objData.get("Length");
                if (setLength != null) {
                    if (setLength.indexOf(" R") != -1) {
                        try {
                            int ii2;
                            long currentPos = this.movePointer(setLength);
                            int buffSize = 128;
                            if (currentPos + (long)buffSize > this.eof) {
                                buffSize = (int)(this.eof - currentPos - 1L);
                            }
                            StringBuffer rawChars = new StringBuffer();
                            byte[] buf = new byte[buffSize];
                            this.pdf_datafile.read(buf);
                            for (ii2 = 3; ii2 >= buffSize || buf[ii2 - 3] != 111 || buf[ii2 - 2] != 98 || buf[ii2 - 1] != 106; ++ii2) {
                            }
                            while (ii2 >= buffSize || !Character.isDigit((char)buf[ii2])) {
                                ++ii2;
                            }
                            while (ii2 < buffSize && Character.isDigit((char)buf[ii2])) {
                                rawChars.append((char)buf[ii2]);
                                ++ii2;
                            }
                            this.movePointer(currentPos);
                            setLength = rawChars.toString();
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception moving pointer to " + objectRef);
                            setLength = null;
                        }
                    }
                    if (setLength != null) {
                        streamLength = Integer.parseInt(setLength);
                        i = start + streamLength;
                        if (i < raw.length && raw[i] == 13 && i + 1 < raw.length && raw[i + 1] == 10) {
                            i += 2;
                        }
                        if (raw.length <= i + 9 || raw[i] != 101 || raw[i + 1] != 110 || raw[i + 2] != 100 || raw[i + 3] != 115 || raw[i + 4] != 116 || raw[i + 5] != 114 || raw[i + 6] != 101 || raw[i + 7] != 97 || raw[i + 8] != 109) {
                            boolean isValid = false;
                            int current = i;
                            if (i < raw.length) {
                                while (!isValid && ++i != raw.length) {
                                    if (raw[i] != 101 || raw[i + 1] != 110 || raw[i + 2] != 100 || raw[i + 3] != 115 || raw[i + 4] != 116 || raw[i + 5] != 114 || raw[i + 6] != 101 || raw[i + 7] != 97 || raw[i + 8] != 109) continue;
                                    streamLength = i - start;
                                    isValid = true;
                                }
                            }
                            if (!isValid) {
                                i = current;
                                if (i > raw.length) {
                                    i = raw.length;
                                }
                                while (!isValid && --i >= 0) {
                                    if (raw[i] != 101 || raw[i + 1] != 110 || raw[i + 2] != 100 || raw[i + 3] != 115 || raw[i + 4] != 116 || raw[i + 5] != 114 || raw[i + 6] != 101 || raw[i + 7] != 97 || raw[i + 8] != 109) continue;
                                    streamLength = i - start;
                                    isValid = true;
                                }
                            }
                            if (!isValid) {
                                i = current;
                            }
                        }
                    }
                } else {
                    while (++i != raw.length && (raw[i] != 101 || raw[i + 1] != 110 || raw[i + 2] != 100 || raw[i + 3] != 115 || raw[i + 4] != 116 || raw[i + 5] != 114 || raw[i + 6] != 101 || raw[i + 7] != 97 || raw[i + 8] != 109)) {
                    }
                    int end = i - 1;
                    if (end > start) {
                        streamLength = end - start + 1;
                    }
                }
                if (this.startStreamPointer == -1) {
                    if (start + streamLength > raw.length) {
                        streamLength = raw.length - start;
                    }
                    stream = new byte[streamLength];
                    System.arraycopy(raw, start, stream, 0, streamLength);
                }
                if (this.startStreamPointer != -1) {
                    objData.put("startStreamOnDisk", new Integer(this.startStreamPointer));
                    objData.put("endStreamOnDisk", new Integer(this.endStreamPointer));
                }
                i += 9;
                continue;
            }
            if (raw[i] == 91) {
                if (debug) {
                    System.err.println("read array");
                }
                i = this.readArray(objectRef, i, objData, raw, isEncryptionObject, textFields);
                continue;
            }
            if (!(raw[i] != 60 & raw[i] != 62)) continue;
            if (preserveTextString) {
                if (raw[i - 1] == 92 && raw[i - 2] == 92) {
                    rawStringAsBytes.write(raw[i]);
                } else if (!((raw[i] == 40 | raw[i] == 41) & raw[i - 1] != 92)) {
                    rawStringAsBytes.write(raw[i]);
                }
            }
            if (raw[i] == 10 | raw[i] == 13 | raw[i] == 32) {
                if (remainder.length() > 0) {
                    remainder.append(' ');
                }
                remainderLastChar = ' ';
                continue;
            }
            if (raw[i] == 47 && remainderLastChar != ' ') {
                remainder.append(' ');
            }
            remainderLastChar = (char)raw[i];
            remainder.append(remainderLastChar);
        }
        if (remainder.length() > 0 && (ii = remainder.toString().indexOf(37)) > -1) {
            remainder.setLength(ii);
        }
        if (remainder.length() > 0) {
            String rawString = remainder.toString().trim();
            if (preserveTextString && rawString.startsWith("(")) {
                try {
                    rawStringAsBytes.close();
                    byte[] streamData = rawStringAsBytes.toByteArray();
                    streamData = this.decrypt(streamData, objectRef, false, null, false, false);
                    objData.put("rawValue", streamData);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception " + e + " writing out text string");
                }
            } else {
                if (debug) {
                    System.err.println("Remainder value=" + remainder + "<<");
                }
                objData.put("rawValue", rawString);
            }
        }
        if (stream != null) {
            objData.put("Stream", stream);
        }
        if (debug) {
            System.err.println(objData);
        }
        try {
            rawStringAsBytes.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int readArray(String objectRef, int i, Map objData, byte[] raw, boolean isEncryptionObject, Map textFields) {
        boolean debug = false;
        int start = 0;
        int end = 0;
        boolean maybeKey = false;
        boolean isSeparation = false;
        StringBuffer rawValue = new StringBuffer();
        StringBuffer possKey = new StringBuffer();
        boolean containsIndexKeyword = false;
        boolean convertToHex = false;
        while (true) {
            if (maybeKey) {
                int j = i;
                while (raw[j] == 13 | raw[j] == 10 | raw[j] == 32) {
                    ++j;
                }
                if (raw[j] == 60 && raw[j + 1] == 60) {
                    i = j;
                    if (isSeparation) {
                        rawValue.append(possKey);
                        rawValue.append(' ');
                        i = this.readDictionary(objectRef, 1, objData, i, raw, isEncryptionObject, textFields, -1);
                    } else {
                        HashMap subDictionary = new HashMap();
                        objData.put(possKey.substring(1), subDictionary);
                        i = this.readDictionary(objectRef, 1, subDictionary, i, raw, isEncryptionObject, textFields, -1);
                    }
                    if (raw[i] == 62) {
                        ++i;
                    }
                    possKey = new StringBuffer();
                } else {
                    if (rawValue.charAt(rawValue.length() - 1) != ' ') {
                        rawValue.append(' ');
                    }
                    rawValue.append(possKey);
                    rawValue.append(' ');
                    possKey = new StringBuffer();
                    maybeKey = false;
                    --i;
                }
            } else if (!convertToHex && raw[i] == 47) {
                maybeKey = true;
                do {
                    possKey.append((char)raw[i]);
                } while (raw[++i] != 47 && raw[i] != 13 && raw[i] != 10 && raw[i] != 32 && raw[i] != 60 && raw[i] != 91 && raw[i] != 93);
                if (raw[i] == 47 || raw[i] == 91 || raw[i] == 93 || raw[i] == 60) {
                    --i;
                }
                if (possKey.toString().equals("/Separation")) {
                    isSeparation = true;
                } else if (possKey.toString().equals("/Indexed")) {
                    containsIndexKeyword = true;
                }
            } else if (raw[i] == 40 && raw[i - 1] != 92 && containsIndexKeyword) {
                convertToHex = true;
                rawValue.append(" <");
            } else if (convertToHex) {
                if (raw[i] == 41 && raw[i - 1] != 92) {
                    rawValue.append('>');
                    convertToHex = false;
                } else {
                    String hex_value = null;
                    if (raw[i] == 92 && raw[i + 1] != 13 && raw[i + 1] != 10 && raw[i + 1] != 114) {
                        StringBuffer octal = new StringBuffer(3);
                        int count = 0;
                        int ii = 1;
                        while (ii < 4) {
                            char c = (char)raw[i + 1];
                            if (c < '0' || c > '9') break;
                            octal.append(c);
                            ++count;
                            ++i;
                            ++ii;
                        }
                        if (count > 0) {
                            hex_value = Integer.toHexString(Integer.parseInt(octal.toString(), 8));
                        }
                    }
                    if (hex_value == null) {
                        hex_value = Integer.toHexString(raw[i] & 0xFF);
                    }
                    if (hex_value.length() < 2) {
                        rawValue.append('0');
                    }
                    rawValue.append(hex_value);
                }
            } else {
                if (i > 0 && raw[i - 1] == 47) {
                    rawValue.append('/');
                }
                if (raw[i] == 13 || raw[i] == 10) {
                    rawValue.append(' ');
                } else {
                    if (raw[i] == 60 && raw[i - 1] != 32 && raw[i - 1] != 60) {
                        rawValue.append(' ');
                    }
                    if (i > 0 && raw[i - 1] == 93) {
                        rawValue.append(' ');
                    }
                    rawValue.append((char)raw[i]);
                }
                if (i == 0 || i > 0 && raw[i - 1] != 92) {
                    if (raw[i] == 91) {
                        ++start;
                    } else if (raw[i] == 93) {
                        ++end;
                    }
                }
            }
            if (raw[i] == 93 & start == end) break;
            ++i;
        }
        objData.put("rawValue", rawValue.toString().trim());
        return i;
    }

    public final Map readFDF() throws PdfException {
        int eof = -1;
        int start = -1;
        int end = -1;
        Map objData = new HashMap();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("F", "x");
        fields.put("T", "x");
        fields.put("V", "x");
        try {
            eof = (int)this.pdf_datafile.length();
            this.pdf_datafile.readLine();
            start = (int)this.pdf_datafile.getFilePointer();
            byte[] fileData = new byte[eof -= start];
            this.pdf_datafile.read(fileData);
            this.convertObjectBytesToMap(objData, "1 0 R", false, fields, false, true, fileData, fileData, false);
            objData = (Map)objData.get("FDF");
        }
        catch (Exception e) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception " + e + " closing file");
            }
            throw new PdfException("Exception " + e + " reading trailer");
        }
        return objData;
    }

    public int getPDFflag(Integer flag) {
        if (flag.equals(PDFflags.USER_ACCESS_PERMISSIONS)) {
            return this.P;
        }
        if (flag == PDFflags.VALID_PASSWORD_SUPPLIED) {
            return this.passwordStatus;
        }
        return -1;
    }

    public boolean containsJBIG() {
        return this.containsJBIG;
    }

    public final String readReferenceTable() throws PdfException {
        int pointer = this.readFirstStartRef();
        int eof = -1;
        this.xref.addElement(pointer);
        try {
            eof = (int)this.pdf_datafile.length();
        }
        catch (Exception e) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception " + e + " closing file");
            }
            throw new PdfException("Exception " + e + " reading trailer");
        }
        if (pointer >= eof) {
            LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            this.refTableInvalid = true;
            return this.findOffsets();
        }
        if (this.isCompressedStream(pointer, eof)) {
            return this.readCompressedStream(pointer, eof);
        }
        return this.readLegacyReferenceTable(pointer, eof);
    }

    private final int getWord(byte[] content, int index, int size) {
        int result = 0;
        int i = 0;
        while (i < size) {
            result = (result << 8) + (content[index + i] & 0xFF);
            ++i;
        }
        return result;
    }

    private String readCompressedStream(int pointer, int eof) throws PdfException {
        String rootObject = "";
        String encryptValue = null;
        while (pointer != -1) {
            int numbEntries;
            int current;
            if (this.interruptRefReading) {
                return null;
            }
            HashMap obj_values = this.readObject(pointer);
            String ref = (String)obj_values.get("Reference");
            String value = (String)obj_values.get("Index");
            if (value == null) {
                current = 0;
                numbEntries = Integer.parseInt((String)obj_values.get("Size"));
            } else {
                String Index = Strip.removeArrayDeleminators(value);
                StringTokenizer values = new StringTokenizer(Index);
                current = Integer.parseInt(values.nextToken());
                numbEntries = Integer.parseInt(values.nextToken());
            }
            value = (String)obj_values.get("W");
            int[] fieldSizes = new int[3];
            StringTokenizer values = new StringTokenizer(Strip.removeArrayDeleminators(value));
            int i = 0;
            while (i < 3) {
                fieldSizes[i] = Integer.parseInt(values.nextToken());
                ++i;
            }
            byte[] xrefs = this.readStream(obj_values, ref, true, true, false, false, true);
            int pntr = 0;
            int[] nArray = new int[3];
            nArray[0] = 1;
            int[] defaultValue = nArray;
            int i2 = 0;
            while (i2 < numbEntries) {
                int[] nextValue = new int[3];
                int ii = 0;
                while (ii < 3) {
                    if (fieldSizes[ii] == 0) {
                        nextValue[ii] = defaultValue[ii];
                    } else {
                        nextValue[ii] = this.getWord(xrefs, pntr, fieldSizes[ii]);
                        pntr += fieldSizes[ii];
                    }
                    ++ii;
                }
                int id = 0;
                switch (nextValue[0]) {
                    case 0: {
                        ++current;
                        break;
                    }
                    case 1: {
                        id = nextValue[1];
                        int gen = nextValue[2];
                        this.storeObjectOffset(current, id, gen, false);
                        ++current;
                        break;
                    }
                    case 2: {
                        id = nextValue[1];
                        int gen = nextValue[2];
                        this.storeObjectOffset(current, id, gen, true);
                        ++current;
                        break;
                    }
                    default: {
                        throw new PdfException("Exception Unsupported Compression mode with value " + nextValue[0]);
                    }
                }
                ++i2;
            }
            if (rootObject.length() == 0) {
                value = (String)obj_values.get("Root");
                if (value != null) {
                    rootObject = value;
                }
                if ((encryptValue = (String)obj_values.get("Encrypt")) != null) {
                    this.ID = (String)obj_values.get("ID");
                    if (this.ID == null) {
                        this.ID = "";
                    } else {
                        this.ID = Strip.removeArrayDeleminators(this.ID);
                        if (this.ID.startsWith("<")) {
                            this.ID = this.ID.substring(1, this.ID.indexOf(62));
                        }
                    }
                }
                this.infoObject = (value = (String)obj_values.get("Info")) != null && !this.isEncrypted | this.isPasswordSupplied ? value : null;
            }
            if ((value = (String)obj_values.get("Prev")) != null) {
                obj_values = new HashMap();
                pointer = Integer.parseInt(value);
                continue;
            }
            pointer = -1;
        }
        if (!this.interruptRefReading) {
            if (encryptValue != null) {
                this.readEncryptionObject(encryptValue);
            }
            this.calculateObjectLength();
        }
        return rootObject;
    }

    private boolean isCompressedStream(int pointer, int eof) throws PdfException {
        boolean isCompressed = false;
        int bufSize = 50;
        int charReached = 0;
        int UNSET = -1;
        boolean COMPRESSED = true;
        int LEGACY = 2;
        int type = -1;
        byte[] newPattern = pattern.getBytes();
        byte[] oldPattern = "ref".getBytes();
        block6: do {
            if (pointer + bufSize > eof) {
                bufSize = eof - pointer;
            }
            if (bufSize < 0) {
                bufSize = 50;
            }
            byte[] buffer = new byte[bufSize];
            this.movePointer(pointer);
            try {
                this.pdf_datafile.read(buffer);
            }
            catch (Exception e) {
                try {
                    this.pdf_datafile.close();
                }
                catch (IOException e1) {
                    LogWriter.writeLog("Exception " + e + " closing file");
                }
                throw new PdfException("Exception " + e + " scanning trailer for ref or obj");
            }
            int i = 0;
            while (i < bufSize) {
                byte currentByte = buffer[i];
                if (currentByte == oldPattern[charReached] && type != 1) {
                    ++charReached;
                    type = 2;
                } else if (currentByte == newPattern[charReached] && type != 2) {
                    ++charReached;
                    type = 1;
                } else {
                    charReached = 0;
                    type = -1;
                }
                pointer += bufSize;
                if (charReached == 2) continue block6;
                ++i;
            }
        } while (charReached != 2);
        if (type == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception 1 closing file");
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return type == 1;
    }

    private final String readLegacyReferenceTable(int pointer, int eof) throws PdfException {
        String rootObject = "";
        String value = "";
        String encryptValue = null;
        int current = 0;
        byte[] Bytes = null;
        int bufSize = 1024;
        int charReached = 0;
        int endTable = 0;
        byte[] pattern = new byte[]{37, 37, 69, 79, 70};
        HashMap obj_values = new HashMap();
        do {
            if (this.interruptRefReading) {
                return null;
            }
            try {
                Bytes = this.readTrailer(bufSize, charReached, pattern, pointer, eof);
            }
            catch (Exception e) {
                Bytes = null;
                try {
                    this.pdf_datafile.close();
                }
                catch (IOException e1) {
                    LogWriter.writeLog("Exception " + e + " closing file");
                }
                throw new PdfException("Exception " + e + " reading trailer");
            }
            if (Bytes == null) break;
            int i = 0;
            StringBuffer startRef = new StringBuffer();
            StringBuffer key = new StringBuffer();
            StringBuffer operand = new StringBuffer();
            int maxLen = Bytes.length;
            while (i < maxLen) {
                if (Bytes[i] == 116 & Bytes[i + 1] == 114 & Bytes[i + 2] == 97 & Bytes[i + 3] == 105 & Bytes[i + 4] == 108 & Bytes[i + 5] == 101 & Bytes[i + 6] == 114) break;
                ++i;
            }
            endTable = i;
            while (Bytes[i] != 60 && Bytes[i + 1] != 60) {
                ++i;
            }
            i = this.readRef2(Bytes, obj_values, i, key, operand);
            value = (String)obj_values.get("XRefStm");
            if (value != null) {
                pointer = Integer.parseInt(value);
            } else {
                boolean hasRef = true;
                while (Bytes[i] != 116 && Bytes[i + 1] != 120 && Bytes[i + 2] != 114 && Bytes[i + 3] != 101 && Bytes[i + 4] != 102) {
                    if (Bytes[i] == 111 && Bytes[i + 1] == 98 && Bytes[i + 2] == 106) {
                        hasRef = false;
                        break;
                    }
                    ++i;
                }
                if (hasRef) {
                    i += 8;
                    while (i < maxLen && Bytes[i] == 10 | Bytes[i] == 32 | Bytes[i] == 13) {
                        ++i;
                    }
                    while (i < maxLen && Bytes[i] != 10 && Bytes[i] != 32 && Bytes[i] != 13) {
                        startRef.append((char)Bytes[i]);
                        ++i;
                    }
                    if (startRef.length() > 0) {
                        pointer = Integer.parseInt(startRef.toString());
                    }
                }
            }
            if (pointer == -1) {
                LogWriter.writeLog("No startRef");
                continue;
            }
            if (Bytes[0] == 120 & Bytes[1] == 114 & Bytes[2] == 101 & Bytes[3] == 102) {
                i = 5;
                while (Bytes[i] == 10 | Bytes[i] == 32 | Bytes[i] == 13) {
                    ++i;
                }
                current = this.readXRefs(current, Bytes, endTable, i);
                i = endTable;
                if (rootObject.length() == 0) {
                    value = (String)obj_values.get("Root");
                    if (value != null) {
                        rootObject = value;
                    }
                    if ((encryptValue = (String)obj_values.get("Encrypt")) != null) {
                        this.ID = (String)obj_values.get("ID");
                        if (this.ID == null) {
                            this.ID = "";
                        } else {
                            this.ID = Strip.removeArrayDeleminators(this.ID);
                            if (this.ID.startsWith("<")) {
                                this.ID = this.ID.substring(1, this.ID.indexOf(62));
                            }
                        }
                    }
                    this.infoObject = (value = (String)obj_values.get("Info")) != null && !this.isEncrypted | this.isPasswordSupplied ? value : null;
                }
                if ((value = (String)obj_values.get("Prev")) != null) {
                    bufSize = 1024;
                    charReached = 0;
                    obj_values = new HashMap();
                    pointer = Integer.parseInt(value);
                    this.xref.addElement(pointer);
                    continue;
                }
                pointer = -1;
                continue;
            }
            pointer = -1;
            rootObject = this.findOffsets();
            this.refTableInvalid = true;
        } while (pointer != -1);
        if (!this.interruptRefReading) {
            if (encryptValue != null) {
                this.readEncryptionObject(encryptValue);
            }
            if (!this.refTableInvalid) {
                this.calculateObjectLength();
            }
        }
        return rootObject;
    }

    private void calculateObjectLength() {
        try {
            this.xref.addElement((int)this.pdf_datafile.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] xrefs = this.xref.get();
        int xrefCount = xrefs.length;
        int[] xrefID = new int[xrefCount];
        int i = 0;
        while (i < xrefCount) {
            xrefID[i] = i;
            ++i;
        }
        xrefID = Sorts.quicksort(xrefs, xrefID);
        int objectCount = this.offset.getCapacity();
        this.ObjLengthTable = new int[objectCount];
        int[] id = new int[objectCount];
        int[] offsets = new int[objectCount];
        int[] off = this.offset.get();
        boolean[] isComp = this.isCompressed.get();
        int i2 = 0;
        while (i2 < objectCount) {
            if (!isComp[i2]) {
                offsets[i2] = off[i2];
                id[i2] = i2;
            }
            ++i2;
        }
        id = Sorts.quicksort(offsets, id);
        i2 = 0;
        while (true) {
            try {
                while (offsets[id[i2]] == 0) {
                    ++i2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
        int start = offsets[id[i2]];
        int j = 0;
        while (xrefs[xrefID[j]] < start + 1) {
            ++j;
        }
        while (i2 < objectCount - 1) {
            int end = offsets[id[i2 + 1]];
            int objLength = end - start - 1;
            if (xrefs[xrefID[j]] < end) {
                objLength = xrefs[xrefID[j]] - start - 1;
                while (xrefs[xrefID[j]] < end + 1) {
                    ++j;
                }
            }
            this.ObjLengthTable[id[i2]] = objLength;
            start = end;
            while (xrefs[xrefID[j]] < start + 1) {
                ++j;
            }
            ++i2;
        }
        this.ObjLengthTable[id[i2]] = xrefs[xrefID[j]] - start - 1;
    }

    private int readXRefs(int current, byte[] Bytes, int endTable, int i) {
        int flag = 99;
        int id = 0;
        int tokenCount = 0;
        int generation = 0;
        int lineLen = 0;
        boolean skipNext = false;
        int[] breaks = new int[5];
        int[] starts = new int[5];
        while (i < endTable) {
            int startLine = i;
            int endLine = -1;
            while (Bytes[i] != 10 & Bytes[i] != 13) {
                if (endLine == -1 && Bytes[i] == 37) {
                    endLine = i - 1;
                }
                ++i;
            }
            if (endLine == -1) {
                endLine = i - 1;
            }
            while (Bytes[startLine] == 32) {
                ++startLine;
            }
            while (Bytes[endLine] == 32) {
                --endLine;
            }
            ++i;
            tokenCount = 0;
            lineLen = endLine - startLine + 1;
            if (lineLen <= 0) continue;
            int lastChar = 1;
            int j = 1;
            while (j < lineLen) {
                int currentChar = Bytes[startLine + j];
                if (currentChar == 32 && lastChar != 32) {
                    breaks[tokenCount] = j;
                    ++tokenCount;
                } else if (currentChar != 32 && lastChar == 32) {
                    starts[tokenCount] = j;
                }
                lastChar = currentChar;
                ++j;
            }
            breaks[tokenCount] = lineLen;
            if (++tokenCount == 1) {
                if (skipNext) {
                    skipNext = false;
                    continue;
                }
                current = this.parseInt(startLine, startLine + breaks[0], Bytes);
                skipNext = true;
                continue;
            }
            if (tokenCount == 2) {
                current = this.parseInt(startLine, startLine + breaks[0], Bytes);
                continue;
            }
            id = this.parseInt(startLine, startLine + breaks[0], Bytes);
            generation = this.parseInt(startLine + starts[1], startLine + breaks[1], Bytes);
            flag = (char)Bytes[startLine + starts[2]];
            if (flag == 110) {
                boolean isValid = false;
                int bufSize = 20;
                if ((long)(id + bufSize) > this.eof) {
                    bufSize = (int)(this.eof - (long)id);
                }
                if (bufSize > 0) {
                    byte[] buffer = new byte[bufSize];
                    this.movePointer(id);
                    try {
                        this.pdf_datafile.read(buffer);
                        int ii = 4;
                        while (ii < bufSize) {
                            if (buffer[ii - 3] == 32 && buffer[ii - 2] == 111 && buffer[ii - 1] == 98 && buffer[ii] == 106) {
                                isValid = true;
                                ii = bufSize;
                            }
                            ++ii;
                        }
                        if (isValid) {
                            this.storeObjectOffset(current, id, generation, false);
                            this.xref.addElement(id);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++current;
        }
        return current;
    }

    private int parseInt(int i, int j, byte[] bytes) {
        int finalValue = 0;
        int power = 0;
        --i;
        int current = j - 1;
        while (current > i) {
            finalValue += (bytes[current] - 48) * powers[power];
            ++power;
            --current;
        }
        return finalValue;
    }

    private int readRef2(byte[] Bytes, Map obj_values, int i, StringBuffer key, StringBuffer operand) {
        while (Bytes[++i] != 62 || Bytes[i + 1] != 62) {
            if (Bytes[i] == 47) {
                String finalValue;
                ++i;
                while (!(Bytes[i] == 32 | Bytes[i] == 91 | Bytes[i] == 10 | Bytes[i] == 13 | Bytes[i] == 60)) {
                    key.append((char)Bytes[i]);
                    ++i;
                }
                boolean notID = key.length() != 2 || key.charAt(0) != 'I' || key.charAt(1) != 'D';
                if (Bytes[i] != 91) {
                    while (Bytes[i] == 32) {
                        ++i;
                    }
                }
                int Oplen = 0;
                int brackets = 0;
                int dictCount = 0;
                while (true) {
                    char c = (char)Bytes[i];
                    if (Bytes[i - 1] == 60 && Bytes[i] == 60) {
                        ++dictCount;
                    }
                    if (c == '(' && i > 0 && Bytes[i - 1] != 92 | (i > 1 && Bytes[i - 1] == 92 && Bytes[i - 2] != 92)) {
                        ++brackets;
                    } else if (c == ')' && i > 0 && Bytes[i - 1] != 92 | (i > 1 && Bytes[i - 1] == 92 && Bytes[i - 2] != 92)) {
                        ++brackets;
                    }
                    if (c == '/' & notID && dictCount == 0) {
                        --i;
                    }
                    if (!notID && c == ']' && Bytes[i + 1] == 47 || !notID && c == ']' && brackets == 0 || dictCount == 0 && c == '\n' | c == '\r' | (c == '/' && notID) && Oplen > 0) break;
                    if (Bytes[i] == 62 && Bytes[i + 1] == 62) {
                        if (dictCount == 0) break;
                        --dictCount;
                    }
                    if (c == '\\') {
                        c = (char)Bytes[++i];
                    }
                    if (Bytes[i] != 10 && Bytes[i] != 13 && Bytes[i] != 32 || Oplen != 0) {
                        operand.append((char)Bytes[i]);
                        ++Oplen;
                    }
                    ++i;
                }
                if (!(finalValue = (operand = this.removeTrailingSpaces(operand)).toString()).equals("null")) {
                    int p = finalValue.indexOf(37);
                    if (p != -1 & finalValue.indexOf("\\%") != p - 1) {
                        finalValue = finalValue.substring(0, p).trim();
                    }
                    obj_values.put(key.toString(), finalValue);
                }
                key = new StringBuffer();
                operand = new StringBuffer();
            }
            if (Bytes[i] != 62 || Bytes[i + 1] != 62) continue;
        }
        return i;
    }

    private byte[] readTrailer(int bufSize, int charReached, byte[] pattern, int pointer, int eof) throws IOException {
        ByteArrayOutputStream bis = new ByteArrayOutputStream();
        do {
            if (pointer + bufSize > eof) {
                bufSize = eof - pointer;
            }
            byte[] buffer = new byte[bufSize];
            this.movePointer(pointer);
            this.pdf_datafile.read(buffer);
            boolean endFound = false;
            int i = 0;
            while (i < bufSize) {
                byte currentByte = buffer[i];
                charReached = currentByte == pattern[charReached] ? ++charReached : 0;
                if (charReached == 5) {
                    int j = 0;
                    while (j < i + 1) {
                        bis.write(buffer[j]);
                        ++j;
                    }
                    i = bufSize;
                    endFound = true;
                }
                ++i;
            }
            if (!endFound) {
                bis.write(buffer);
            }
            pointer += bufSize;
        } while (charReached != 5);
        bis.close();
        return bis.toByteArray();
    }

    public final PdfFileInformation readPdfFileMetadata(String ref) {
        if (this.infoObject != null && !this.isEncrypted | this.isPasswordSupplied) {
            this.readInformationObject(this.infoObject);
        }
        if (ref != null) {
            byte[] stream = this.readStream(this.readObject(ref, false, null), ref, true, true, false, true, false);
            this.currentFileInformation.setFileXMLMetaData(this.convertStreamToXML(ref).toString(), stream);
        }
        return this.currentFileInformation;
    }

    public StringBuffer convertStreamToXML(String ref) {
        StringBuffer XMLObject = null;
        if (ref != null) {
            XMLObject = new StringBuffer();
            String line = "";
            BufferedReader mappingStream = null;
            ByteArrayInputStream bis = null;
            try {
                Map currentValues = this.readObject(ref, false, null);
                byte[] stream = this.readStream(currentValues, ref, true, true, false, true, false);
                bis = new ByteArrayInputStream(stream);
                mappingStream = new BufferedReader(new InputStreamReader(bis));
                if (mappingStream != null) {
                    while ((line = mappingStream.readLine()) != null) {
                        if (Strip.isEmptyLine(line)) continue;
                        XMLObject.append(line);
                        XMLObject.append('\n');
                    }
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading XML object " + ref);
            }
            if (mappingStream != null) {
                try {
                    mappingStream.close();
                    bis.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return XMLObject;
    }

    public final String getValue(String value) {
        if (value != null && value.endsWith(" R")) {
            Map indirectObject = this.readObject(value, false, null);
            value = (String)indirectObject.get("rawValue");
        }
        if (value != null && value.equals("null")) {
            value = null;
        }
        return value;
    }

    private Object getObjectValue(Object value) {
        Object stringValue;
        Map indirectObject = this.readObject((String)value, false, this.fields);
        int keyCount = indirectObject.size();
        value = keyCount == 1 ? ((stringValue = indirectObject.get("rawValue")) != null ? (stringValue instanceof String ? stringValue : this.getTextString((byte[])stringValue)) : indirectObject) : indirectObject;
        return value;
    }

    public final byte[] getByteTextStringValue(Object rawValue, Map fields) {
        if (rawValue instanceof String) {
            String value = (String)rawValue;
            if (value != null && value.endsWith(" R")) {
                Map indirectObject = this.readObject(value, false, fields);
                rawValue = indirectObject.get("rawValue");
            } else {
                return value.getBytes();
            }
        }
        return (byte[])rawValue;
    }

    public final Map getSubDictionary(Object value) {
        if (value instanceof String) {
            return this.readObject((String)value, false, null);
        }
        return (Map)value;
    }

    private StringBuffer removeTrailingSpaces(StringBuffer operand) {
        int l = operand.length();
        int ii = l - 1;
        while (ii > -1) {
            if (operand.charAt(ii) == ' ') {
                operand.deleteCharAt(ii);
            } else {
                ii = -2;
            }
            --ii;
        }
        return operand;
    }

    public static String convertToString(byte[] byteStream) {
        StringBuffer operand = new StringBuffer();
        int l = byteStream.length;
        int ii = 0;
        while (ii < l) {
            operand.append((char)byteStream[ii]);
            ++ii;
        }
        return operand.toString();
    }

    public final boolean isEncrypted() {
        return this.isEncrypted;
    }

    public final boolean isPasswordSupplied() {
        return this.isPasswordSupplied;
    }

    public final boolean isExtractionAllowed() {
        return this.extractionIsAllowed;
    }

    public boolean isFileViewable() {
        return this.isFileViewable;
    }

    private final byte[] decrypt(byte[] data, String ref, boolean isEncryption, String cacheName, boolean alwaysUseRC4, boolean isString) throws PdfSecurityException {
        boolean debug = false;
        if (this.isEncrypted || isEncryption) {
            BufferedOutputStream streamCache = null;
            BufferedInputStream bis = null;
            int streamLength = 0;
            boolean isAES = false;
            if (cacheName != null) {
                try {
                    streamLength = (int)new File(cacheName).length();
                    File tempFile2 = File.createTempFile("jpedal", ".raw");
                    this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
                    ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
                    File rawFile = new File(cacheName);
                    rawFile.delete();
                    streamCache = new BufferedOutputStream(new FileOutputStream(cacheName));
                    bis = new BufferedInputStream(new FileInputStream(tempFile2));
                }
                catch (IOException e1) {
                    LogWriter.writeLog("Exception " + e1 + " in decrypt");
                }
            }
            int keyLength = this.keyLength;
            String algorithm = "RC4";
            String keyType = "RC4";
            IvParameterSpec ivSpec = null;
            Map AESmap = null;
            String AESname = null;
            if (!isString) {
                AESmap = this.StmF;
                AESname = this.StrFname;
            } else {
                AESmap = this.StrF;
                AESname = this.StmFname;
            }
            if (!alwaysUseRC4 && AESmap == null && AESname != null && AESname.equals("Identity")) {
                return data;
            }
            if (AESmap != null) {
                String crypt;
                String lenKey = (String)AESmap.get("Length");
                if (lenKey != null) {
                    keyLength = Integer.parseInt(lenKey);
                }
                if ((crypt = (String)AESmap.get("CFM")) != null && crypt.equals("/AESV2") && !alwaysUseRC4) {
                    this.cipher = null;
                    algorithm = "AES/CBC/PKCS5Padding";
                    keyType = "AES";
                    isAES = true;
                    byte[] iv = new byte[16];
                    System.arraycopy(data, 0, iv, 0, 16);
                    ivSpec = new IvParameterSpec(iv);
                    int origLen = data.length;
                    int newLen = origLen - 16;
                    byte[] newData = new byte[newLen];
                    System.arraycopy(data, 16, newData, 0, newLen);
                    data = newData;
                    int diff = data.length & 0xF;
                    int newLength = data.length;
                    if (diff > 0) {
                        newLength = newLength + 16 - diff;
                        newData = new byte[newLength];
                        System.arraycopy(data, 0, newData, 0, data.length);
                        data = newData;
                    }
                }
            }
            byte[] currentKey = new byte[keyLength];
            if (ref.length() > 0) {
                currentKey = new byte[keyLength + 5];
            }
            System.arraycopy(this.encryptionKey, 0, currentKey, 0, keyLength);
            try {
                if (ref.length() > 0) {
                    int pointer = ref.indexOf(32);
                    int pointer2 = ref.indexOf(32, pointer + 1);
                    int obj = Integer.parseInt(ref.substring(0, pointer));
                    int gen = Integer.parseInt(ref.substring(pointer + 1, pointer2));
                    currentKey[keyLength] = (byte)(obj & 0xFF);
                    currentKey[keyLength + 1] = (byte)(obj >> 8 & 0xFF);
                    currentKey[keyLength + 2] = (byte)(obj >> 16 & 0xFF);
                    currentKey[keyLength + 3] = (byte)(gen & 0xFF);
                    currentKey[keyLength + 4] = (byte)(gen >> 8 & 0xFF);
                }
                byte[] finalKey = new byte[Math.min(currentKey.length, 16)];
                if (ref.length() > 0) {
                    MessageDigest currentDigest = MessageDigest.getInstance("MD5");
                    currentDigest.update(currentKey);
                    if (isAES && keyLength >= 16) {
                        byte[] salt = new byte[]{115, 65, 108, 84};
                        currentDigest.update(salt);
                    }
                    System.arraycopy(currentDigest.digest(), 0, finalKey, 0, finalKey.length);
                } else {
                    System.arraycopy(currentKey, 0, finalKey, 0, finalKey.length);
                }
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance(algorithm);
                }
                SecretKeySpec testKey = new SecretKeySpec(finalKey, keyType);
                if (isEncryption) {
                    this.cipher.init(1, testKey);
                } else if (ivSpec == null) {
                    this.cipher.init(2, testKey);
                } else {
                    this.cipher.init(2, (Key)testKey, ivSpec);
                }
                if (data == null) {
                    int nextByte;
                    CipherInputStream cis = new CipherInputStream(bis, this.cipher);
                    while ((nextByte = cis.read()) != -1) {
                        streamCache.write(nextByte);
                    }
                    cis.close();
                    streamCache.close();
                    bis.close();
                }
                if (data != null) {
                    data = this.cipher.doFinal(data);
                }
            }
            catch (Exception e) {
                throw new PdfSecurityException("Exception " + e + " decrypting content");
            }
        }
        if (alwaysReinitCipher) {
            this.cipher = null;
        }
        return data;
    }

    private byte[] getPaddedKey(byte[] password) {
        byte[] key = new byte[32];
        int passwordLength = password.length;
        if (passwordLength > 32) {
            passwordLength = 32;
        }
        System.arraycopy(this.encryptionPassword, 0, key, 0, passwordLength);
        int ii = passwordLength;
        while (ii < 32) {
            key[ii] = (byte)Integer.parseInt(this.padding[ii - passwordLength], 16);
            ++ii;
        }
        return key;
    }

    private boolean testPassword() throws PdfSecurityException {
        int count = 32;
        byte[] rawValue = new byte[32];
        byte[] keyValue = new byte[32];
        int i = 0;
        while (i < 32) {
            rawValue[i] = (byte)Integer.parseInt(this.padding[i], 16);
            ++i;
        }
        byte[] encrypted = (byte[])rawValue.clone();
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            encrypted = this.decrypt(encrypted, "", true, null, false, false);
        } else if (this.rev >= 3) {
            String lenKey;
            int keyLength = this.keyLength;
            if (this.rev == 4 && this.StmF != null && (lenKey = (String)this.StmF.get("Length")) != null) {
                keyLength = Integer.parseInt(lenKey);
            }
            count = 16;
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byte[] originalKey = (byte[])this.encryptionKey.clone();
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " with digest");
            }
            md.update(encrypted);
            byte[] documentID = new byte[this.ID.length() / 2];
            int ii = 0;
            while (ii < this.ID.length()) {
                String nextValue = this.ID.substring(ii, ii + 2);
                documentID[ii / 2] = (byte)Integer.parseInt(nextValue, 16);
                ii += 2;
            }
            keyValue = md.digest(documentID);
            keyValue = this.decrypt(keyValue, "", true, null, true, false);
            byte[] nextKey = new byte[keyLength];
            int i2 = 1;
            while (i2 <= 19) {
                int j = 0;
                while (j < keyLength) {
                    nextKey[j] = (byte)(originalKey[j] ^ i2);
                    ++j;
                }
                this.encryptionKey = nextKey;
                keyValue = this.decrypt(keyValue, "", true, null, true, false);
                ++i2;
            }
            this.encryptionKey = originalKey;
            encrypted = new byte[32];
            System.arraycopy(keyValue, 0, encrypted, 0, 16);
            System.arraycopy(rawValue, 0, encrypted, 16, 16);
        }
        boolean isMatch = true;
        int i3 = 0;
        while (i3 < count) {
            if (this.U[i3] != encrypted[i3]) {
                isMatch = false;
                i3 = this.U.length;
            }
            ++i3;
        }
        return isMatch;
    }

    private void computeEncryptionKey() throws PdfSecurityException {
        int ii;
        MessageDigest md = null;
        String str = "";
        if (this.debugAES) {
            System.out.println("Compute encryption key");
        }
        byte[] key = this.getPaddedKey(this.encryptionPassword);
        if (this.debugAES) {
            str = "raw before 50 times   ---- ";
            ii = 0;
            while (ii < key.length) {
                str = String.valueOf(str) + key[ii] + ' ';
                ++ii;
            }
            System.out.println(str);
        }
        try {
            md = MessageDigest.getInstance("MD5");
            this.encryptionKey = md.digest(key);
            if (this.debugAES) {
                str = "encryptionKey before 50 times   ---- ";
                ii = 0;
                while (ii < key.length) {
                    str = String.valueOf(str) + key[ii] + ' ';
                    ++ii;
                }
                System.out.println(str);
            }
            if (this.rev >= 3) {
                ii = 0;
                while (ii < 50) {
                    this.encryptionKey = md.digest(this.encryptionKey);
                    ++ii;
                }
            }
        }
        catch (Exception e) {
            throw new PdfSecurityException("Exception " + e + " generating encryption key");
        }
        if (this.debugAES) {
            str = "returned encryptionKey   ---- ";
            ii = 0;
            while (ii < this.encryptionKey.length) {
                str = String.valueOf(str) + this.encryptionKey[ii] + ' ';
                ++ii;
            }
            System.out.println(str);
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        String str = "";
        if (this.debugAES) {
            System.out.println("testOwnerPassword " + this.encryptionPassword.length);
        }
        byte[] originalPassword = this.encryptionPassword;
        byte[] userPasswd = new byte[this.keyLength];
        byte[] inputValue = (byte[])this.O.clone();
        if (this.debugAES) {
            str = "originalPassword   ---- ";
            int ii = 0;
            while (ii < originalPassword.length) {
                str = String.valueOf(str) + originalPassword[ii] + ' ';
                ++ii;
            }
            System.out.println(str);
        }
        this.computeEncryptionKey();
        byte[] originalKey = (byte[])this.encryptionKey.clone();
        if (this.rev == 2) {
            userPasswd = this.decrypt((byte[])this.O.clone(), "", false, null, false, false);
        } else if (this.rev >= 3) {
            String lenKey;
            int keyLength = this.keyLength;
            if (this.rev == 4 && this.StmF != null && (lenKey = (String)this.StmF.get("Length")) != null) {
                keyLength = Integer.parseInt(lenKey);
            }
            if (this.debugAES) {
                System.out.println("Decrypt 20 times");
            }
            userPasswd = inputValue;
            byte[] nextKey = new byte[keyLength];
            int i = 19;
            while (i >= 0) {
                int j = 0;
                while (j < keyLength) {
                    nextKey[j] = (byte)(originalKey[j] ^ i);
                    ++j;
                }
                this.encryptionKey = nextKey;
                userPasswd = this.decrypt(userPasswd, "", false, null, true, false);
                --i;
            }
        }
        this.encryptionPassword = userPasswd;
        this.computeEncryptionKey();
        boolean isMatch = this.testPassword();
        if (this.debugAES && !isMatch) {
            System.out.println("Match failed on owner key");
            System.exit(1);
        }
        if (!isMatch) {
            this.encryptionPassword = originalPassword;
            this.computeEncryptionKey();
        }
        return isMatch;
    }

    private final String findOffsets() throws PdfSecurityException {
        String root_id;
        block7: {
            LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
            root_id = "";
            try {
                this.movePointer(0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while (true) {
                String line = null;
                int i = (int)this.getPointer();
                try {
                    line = this.pdf_datafile.readLine();
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception " + e + " reading line");
                }
                if (line == null) break block7;
                if (line.indexOf(" obj") != -1) {
                    int pointer = line.indexOf(32);
                    if (pointer <= -1) continue;
                    int current_number = Integer.parseInt(line.substring(0, pointer));
                    this.storeObjectOffset(current_number, i, 1, false);
                    continue;
                }
                if (line.indexOf("Root") != -1) {
                    int start = line.indexOf("Root") + 4;
                    int pointer = line.indexOf(82, start);
                    if (pointer <= -1) continue;
                    root_id = line.substring(start, pointer + 1).trim();
                    continue;
                }
                if (line.indexOf("/Encrypt") != -1) break;
            }
            throw new PdfSecurityException("Corrupted, encrypted file");
        }
        return root_id;
    }

    public final void readEncryptionObject(String ref) throws PdfSecurityException {
        this.stringsEncoded = false;
        this.isMetaDataEncypted = true;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        Map encryptionValues = this.readObject(ref, true, null);
        if (this.debugAES) {
            System.out.println(encryptionValues);
        }
        String filter = (String)encryptionValues.get("Filter");
        int v = 1;
        String value = (String)encryptionValues.get("V");
        if (value != null) {
            v = Integer.parseInt(value);
        }
        if ((value = (String)encryptionValues.get("Length")) != null) {
            this.keyLength = Integer.parseInt(value) / 8;
        }
        if (v == 3) {
            throw new PdfSecurityException("Unsupported Custom Adobe Encryption method " + encryptionValues);
        }
        if (v > 4 && filter.indexOf("Standard") == -1) {
            throw new PdfSecurityException("Unsupported Encryption method " + encryptionValues);
        }
        this.rev = Integer.parseInt((String)encryptionValues.get("R"));
        this.P = Integer.parseInt((String)encryptionValues.get("P"));
        Object OValue = encryptionValues.get("O");
        if (OValue instanceof String) {
            String hexString = (String)OValue;
            int keyLength = hexString.length() / 2;
            this.O = new byte[keyLength];
            int ii = 0;
            while (ii < keyLength) {
                int p = ii * 2;
                this.O[ii] = (byte)Integer.parseInt(hexString.substring(p, p + 2), 16);
                ++ii;
            }
        } else {
            this.O = (byte[])OValue;
        }
        Object UValue = encryptionValues.get("U");
        if (UValue instanceof String) {
            String hexString = (String)UValue;
            int keyLength = hexString.length() / 2;
            this.U = new byte[keyLength];
            int ii = 0;
            while (ii < keyLength) {
                int p = ii * 2;
                this.U[ii] = (byte)Integer.parseInt(hexString.substring(p, p + 2), 16);
                ++ii;
            }
        } else {
            this.U = (byte[])UValue;
        }
        if (v == 4) {
            String key;
            Map CF = (Map)encryptionValues.get("CF");
            this.EFF = (String)encryptionValues.get("EFF");
            this.CFM = (String)encryptionValues.get("CFM");
            Object encryptionSetting = encryptionValues.get("EncryptMetadata");
            if (encryptionSetting != null && ((String)encryptionSetting).toLowerCase().equals("false")) {
                this.isMetaDataEncypted = false;
            }
            if ((key = (String)encryptionValues.get("StrF")) != null) {
                this.StrFname = key = key.substring(1);
                this.StrF = (Map)CF.get(key);
                this.stringsEncoded = true;
            } else {
                this.StrF = null;
            }
            key = (String)encryptionValues.get("StmF");
            if (key != null) {
                this.StmFname = key = key.substring(1);
                this.StmF = (Map)CF.get(key);
            } else {
                this.StmF = null;
            }
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        LogWriter.writeLog("File has encryption settings");
        try {
            this.verifyAccess();
        }
        catch (PdfSecurityException e) {
            LogWriter.writeLog("File requires password");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        this.isPasswordSupplied = false;
        this.extractionIsAllowed = false;
        this.passwordStatus = 0;
        boolean isOwnerPassword = this.testOwnerPassword();
        if (!isOwnerPassword) {
            boolean isUserPassword = this.testPassword();
            if (!isUserPassword) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword.length > 0) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) == 16) {
                this.extractionIsAllowed = true;
            }
            this.passwordStatus = 1;
            return;
        } else {
            LogWriter.writeLog("Correct owner password supplied");
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
            this.passwordStatus = 2;
        }
    }

    private byte[] calculateKey(byte[] O, int P, String ID) throws PdfSecurityException {
        if (this.debugAES) {
            System.out.println("calculate key");
        }
        String str = "";
        MessageDigest md = null;
        byte[] keyValue = null;
        byte[] key = this.getPaddedKey(this.encryptionPassword);
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(key);
            md.update(O);
            byte[] PValue = new byte[]{(byte)(P & 0xFF), (byte)(P >> 8 & 0xFF), (byte)(P >> 16 & 0xFF), (byte)(P >> 24 & 0xFF)};
            md.update(PValue);
            str = "documentID   ---- ";
            byte[] IDbytes = new byte[ID.length() / 2];
            int ii = 0;
            while (ii < ID.length()) {
                String nextValue = ID.substring(ii, ii + 2);
                IDbytes[ii / 2] = (byte)Integer.parseInt(nextValue, 16);
                str = String.valueOf(str) + IDbytes[ii / 2] + ' ';
                ii += 2;
            }
            md.update(IDbytes);
            if (this.debugAES) {
                System.out.println(String.valueOf(str) + " \n" + ID);
            }
            byte[] metadataPad = new byte[]{-1, -1, -1, -1};
            if (this.rev == 4 && !this.isMetaDataEncypted) {
                md.update(metadataPad);
            }
            byte[] digest = new byte[this.keyLength];
            System.arraycopy(md.digest(), 0, digest, 0, this.keyLength);
            if (this.rev >= 3) {
                int i = 0;
                while (i < 50) {
                    System.arraycopy(md.digest(digest), 0, digest, 0, this.keyLength);
                    ++i;
                }
            }
            keyValue = new byte[this.keyLength];
            System.arraycopy(digest, 0, keyValue, 0, this.keyLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PdfSecurityException("Exception " + e + " generating encryption key");
        }
        byte[] returnKey = new byte[this.keyLength];
        System.arraycopy(keyValue, 0, returnKey, 0, this.keyLength);
        return returnKey;
    }

    private final void readInformationObject(String value) {
        try {
            HashMap<String, String> fields = new HashMap<String, String>();
            String[] names = this.currentFileInformation.getFieldNames();
            int ii = 0;
            while (ii < names.length) {
                fields.put(names[ii], "z");
                ++ii;
            }
            Map info_values = this.readObject(value, false, fields);
            int i = 0;
            while (i < names.length) {
                Object nextValue = info_values.get(names[i]);
                if (nextValue != null) {
                    if (nextValue instanceof byte[]) {
                        String textValue = this.getTextString((byte[])nextValue);
                        this.currentFileInformation.setFieldValue(i, textValue);
                    } else if (nextValue instanceof String) {
                        String stringValue = (String)nextValue;
                        if (stringValue.indexOf("False") != -1) {
                            this.currentFileInformation.setFieldValue(i, "False");
                        } else if (stringValue.indexOf("False") != -1) {
                            this.currentFileInformation.setFieldValue(i, "True");
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(" problem with info");
            LogWriter.writeLog("Exception " + e + " reading information object " + value);
        }
    }

    public byte[] getPdfBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    /*
     * Unable to fully structure code
     */
    public String getTextString(byte[] rawText) {
        block8: {
            returnText = "";
            StandardFonts.checkLoaded(6);
            text = "";
            debug = false;
            chars = null;
            if (rawText != null) {
                chars = new char[rawText.length];
            }
            ii = 0;
            convertedText = null;
            rawChars = new TextTokens(rawText);
            if (!rawChars.isUnicode()) ** GOTO lbl41
            while (rawChars.hasMoreTokens()) {
                nextChar = rawChars.nextUnicodeToken();
                if (nextChar == '\t') {
                    chars[ii] = 32;
                    ++ii;
                    continue;
                }
                if (nextChar <= '\u001f') continue;
                chars[ii] = nextChar;
                ++ii;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                nextChar = rawChars.nextToken();
                if (nextChar == '\t') {
                    chars[ii] = 32;
                    ++ii;
                    continue;
                }
                if (nextChar <= '\u001f') continue;
                c = StandardFonts.getEncodedChar(6, nextChar);
                len = c.length();
                if (ii + len >= chars.length) {
                    tmp = new char[len + ii + 10];
                    System.arraycopy(chars, 0, tmp, 0, chars.length);
                    chars = tmp;
                }
                i = 0;
                while (i < len) {
                    chars[ii] = c.charAt(i);
                    ++ii;
                    ++i;
                }
lbl41:
                // 4 sources

                ** while (rawChars.hasMoreTokens())
            }
        }
        if (chars != null) {
            returnText = String.copyValueOf(chars, 0, ii);
        }
        return returnText;
    }

    /*
     * Unable to fully structure code
     */
    public void readJavascriptNames(Object nameObj, Javascript javascript) {
        block31: {
            block33: {
                block32: {
                    values = null;
                    values = nameObj instanceof String != false ? this.readObject((String)nameObj, false, null) : (Map)nameObj;
                    names = this.getValue((String)values.get("Names"));
                    if (names == null) break block31;
                    nameList = Strip.removeArrayDeleminators(names);
                    if (!nameList.startsWith("<feff")) break block32;
                    keyValues = new StringTokenizer(nameList);
                    while (keyValues.hasMoreTokens()) {
                        nextKey = keyValues.nextToken();
                        nextKey = nextKey.substring(1, nextKey.length() - 1);
                        var8_10 = String.valueOf(keyValues.nextToken()) + ' ' + keyValues.nextToken() + ' ' + keyValues.nextToken();
                    }
                    break block31;
                }
                if (nameList.indexOf(40) == -1) break block33;
                raw = this.readObjectAsByteArray((String)nameObj, false);
                dataLen = raw.length;
                i = 0;
                while (raw[i] != 47 || raw[i + 1] != 78 || raw[i + 2] != 97 || raw[i + 3] != 109 || raw[i + 4] != 101 || raw[i + 5] != 115) {
                    ++i;
                }
                i += 5;
                ** GOTO lbl107
                {
                    ++i;
                    do {
                        if (raw[i] != 40) continue block4;
                        bis = new ByteArrayOutputStream();
                        try {
                            if (raw[i + 1] != 41) {
                                while (true) {
                                    isOctal = false;
                                    if (raw[++i] == 92 && (raw[i - 1] != 92 || raw[i - 1] == 92 && raw[i - 2] == 92)) {
                                        if (raw[++i] == 98) {
                                            raw[i] = 8;
                                        } else if (raw[i] == 110) {
                                            raw[i] = 10;
                                        } else if (raw[i] == 116) {
                                            raw[i] = 9;
                                        } else if (raw[i] == 114) {
                                            raw[i] = 13;
                                        } else if (raw[i] == 102) {
                                            raw[i] = 12;
                                        } else if (raw[i] == 92) {
                                            raw[i] = 92;
                                        } else if (Character.isDigit((char)raw[i])) {
                                            octal = new StringBuffer(3);
                                            ii = 0;
                                            while (ii < 3) {
                                                octal.append((char)raw[i]);
                                                ++i;
                                                ++ii;
                                            }
                                            isOctal = true;
                                            raw[--i] = (byte)Integer.parseInt(octal.toString(), 8);
                                        }
                                    }
                                    if (!isOctal && raw[i] == 41 && (raw[i - 1] != 92 || raw[i - 1] == 92 && raw[i - 2] == 92)) break;
                                    bis.write(raw[i]);
                                }
                            }
                            bis.close();
                            streamData = bis.toByteArray();
                            streamData = this.decrypt(streamData, (String)nameObj, false, null, false, false);
                            objectName = new StringBuffer();
                            ++i;
                            while (raw[i] == 32 | raw[i] == 10 | raw[i] == 13) {
                                ++i;
                            }
                            end = i;
                            while (raw[end] == 32) {
                                ++end;
                            }
                            isEmbedded = false;
                            while (raw[end] != 40 & end + 1 < dataLen) {
                                if (raw[end] == 91) {
                                    isEmbedded = true;
                                }
                                if (raw[end] == 93) break;
                                ++end;
                            }
                            if (isEmbedded) {
                                end += 2;
                            }
                            nextStart = end;
                            if (!isEmbedded && raw[end] == 93) {
                                nextStart = dataLen;
                            }
                            while (raw[end] == 32) {
                                --end;
                            }
                            charLength = end - i;
                            objectName = new StringBuffer(charLength);
                            ii = 0;
                            while (ii < charLength) {
                                objectName.append((char)raw[ii + i]);
                                if ((isEmbedded == false && raw[ii + i] == 82) | raw[ii + i] == 93) break;
                                ++ii;
                            }
                            code = this.readObject(objectName.toString(), false, null);
                            type = (String)code.get("S");
                            i = nextStart;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
lbl107:
                        // 3 sources

                    } while (i < dataLen);
                }
                break block31;
            }
            LogWriter.writeLog("Javascript format not supported");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void readNames(Object nameObj, Javascript javascript) {
        block36: {
            block38: {
                block34: {
                    block37: {
                        block35: {
                            values = null;
                            values = nameObj instanceof String != false ? this.readObject((String)nameObj, false, null) : (Map)nameObj;
                            dests = values.get("Dests");
                            names = this.getValue((String)values.get("Names"));
                            javaScriptRef = (String)values.get("JavaScript");
                            if (names == null) break block34;
                            nameList = Strip.removeArrayDeleminators(names);
                            if (!nameList.startsWith("<feff")) break block35;
                            keyValues = new StringTokenizer(nameList);
                            while (keyValues.hasMoreTokens()) {
                                nextKey = keyValues.nextToken();
                                nextKey = nextKey.substring(1, nextKey.length() - 1);
                                value = String.valueOf(keyValues.nextToken()) + ' ' + keyValues.nextToken() + ' ' + keyValues.nextToken();
                                this.nameLookup.put(nextKey, value);
                            }
                            break block36;
                        }
                        if (nameList.indexOf(40) == -1) break block37;
                        raw = this.readObjectAsByteArray((String)nameObj, false);
                        dataLen = raw.length;
                        i = 0;
                        while (raw[i] != 47 || raw[i + 1] != 78 || raw[i + 2] != 97 || raw[i + 3] != 109 || raw[i + 4] != 101 || raw[i + 5] != 115) {
                            ++i;
                        }
                        i += 5;
                        ** GOTO lbl111
                        {
                            ++i;
                            do {
                                if (raw[i] != 40) continue block4;
                                bis = new ByteArrayOutputStream();
                                try {
                                    if (raw[i + 1] != 41) {
                                        while (true) {
                                            isOctal = false;
                                            if (raw[++i] == 92 && (raw[i - 1] != 92 || raw[i - 1] == 92 && raw[i - 2] == 92)) {
                                                if (raw[++i] == 98) {
                                                    raw[i] = 8;
                                                } else if (raw[i] == 110) {
                                                    raw[i] = 10;
                                                } else if (raw[i] == 116) {
                                                    raw[i] = 9;
                                                } else if (raw[i] == 114) {
                                                    raw[i] = 13;
                                                } else if (raw[i] == 102) {
                                                    raw[i] = 12;
                                                } else if (raw[i] == 92) {
                                                    raw[i] = 92;
                                                } else if (Character.isDigit((char)raw[i])) {
                                                    octal = new StringBuffer(3);
                                                    ii = 0;
                                                    while (ii < 3) {
                                                        octal.append((char)raw[i]);
                                                        ++i;
                                                        ++ii;
                                                    }
                                                    isOctal = true;
                                                    raw[--i] = (byte)Integer.parseInt(octal.toString(), 8);
                                                }
                                            }
                                            if (!isOctal && raw[i] == 41 && (raw[i - 1] != 92 || raw[i - 1] == 92 && raw[i - 2] == 92)) break;
                                            bis.write(raw[i]);
                                        }
                                    }
                                    bis.close();
                                    streamData = bis.toByteArray();
                                    streamData = this.decrypt(streamData, (String)nameObj, false, null, false, false);
                                    objectName = new StringBuffer();
                                    ++i;
                                    while (raw[i] == 32 | raw[i] == 10 | raw[i] == 13) {
                                        ++i;
                                    }
                                    end = i;
                                    while (raw[end] == 32) {
                                        ++end;
                                    }
                                    isEmbedded = false;
                                    while (raw[end] != 40 & end + 1 < dataLen) {
                                        if (raw[end] == 91) {
                                            isEmbedded = true;
                                        }
                                        if (raw[end] == 93) break;
                                        ++end;
                                    }
                                    if (isEmbedded) {
                                        end += 2;
                                    }
                                    nextStart = end;
                                    if (!isEmbedded && raw[end] == 93) {
                                        nextStart = dataLen;
                                    }
                                    while (raw[end] == 32) {
                                        --end;
                                    }
                                    charLength = end - i;
                                    objectName = new StringBuffer(charLength);
                                    ii = 0;
                                    while (ii < charLength) {
                                        objectName.append((char)raw[ii + i]);
                                        if ((isEmbedded == false && raw[ii + i] == 82) | raw[ii + i] == 93) break;
                                        ++ii;
                                    }
                                    this.nameLookup.put(this.getTextString(streamData), objectName.toString());
                                    i = nextStart;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
lbl111:
                                // 3 sources

                            } while (i < dataLen);
                        }
                        break block36;
                    }
                    LogWriter.writeLog("Name list format not supported");
                    break block36;
                }
                if (dests == null) break block38;
                destValues = null;
                destValues = dests instanceof String != false ? this.readObject((String)dests, false, null) : (Map)dests;
                kidsObj = (String)destValues.get("Kids");
                if (kidsObj == null || (kids = Strip.removeArrayDeleminators(this.getValue((String)destValues.get("Kids")))).length() <= 0) break block36;
                initialValues = new StringTokenizer(kids, "R");
                while (initialValues.hasMoreTokens()) {
                    this.readNames(String.valueOf(initialValues.nextToken().trim()) + " R", javascript);
                }
                break block36;
            }
            if (javaScriptRef == null && (kidsObj = (String)values.get("Kids")) != null && (kids = Strip.removeArrayDeleminators(this.getValue((String)values.get("Kids")))).length() > 0) {
                initialValues = new StringTokenizer(kids, "R");
                while (initialValues.hasMoreTokens()) {
                    this.readNames(String.valueOf(initialValues.nextToken().trim()) + " R", javascript);
                }
            }
        }
    }

    public String convertNameToRef(String value) {
        return (String)this.nameLookup.get(value);
    }

    public void flattenValuesInObject(boolean addPage, boolean keepKids, Map formData, Map newValues, Map fields, PageLookup pageLookup, String formObject) {
        boolean debug = false;
        if (addPage) {
            newValues.put("PageNumber", "1");
        }
        for (String currentKey : formData.keySet()) {
            byte[] fieldBytes;
            HashMap stringValue;
            String kidsList;
            Object currentValue = null;
            if (currentKey.equals("P")) {
                try {
                    Object rawValue = formData.get("P");
                    if (rawValue != null && pageLookup != null && rawValue instanceof String) {
                        int page = pageLookup.convertObjectToPageNumber((String)rawValue);
                        newValues.put("PageNumber", String.valueOf(page));
                    }
                }
                catch (Exception rawValue) {}
            } else if (currentKey.equals("Stream")) {
                byte[] objectData = this.readStream(formData, formObject, false, true, false, false, false);
                newValues.put("DecodedStream", objectData);
            } else if (!currentKey.equals("Kids") && !currentKey.equals("Parent")) {
                currentValue = formData.get(currentKey);
            } else if (keepKids && currentKey.equals("Kids") && (kidsList = (String)formData.get("Kids")) != null) {
                HashMap formObjects = new HashMap();
                if (kidsList.startsWith("[")) {
                    kidsList = kidsList.substring(1, kidsList.length() - 1).trim();
                }
                StringTokenizer kidObjects = new StringTokenizer(kidsList, "R");
                while (kidObjects.hasMoreTokens()) {
                    String next_value = String.valueOf(kidObjects.nextToken().trim()) + " R";
                    stringValue = new HashMap();
                    this.flattenValuesInObject(true, keepKids, this.readObject(next_value, false, fields), stringValue, fields, pageLookup, formObject);
                    formObjects.put(next_value, stringValue);
                }
                newValues.put("Kids", formObjects);
            }
            if (currentValue == null) continue;
            if (currentKey.equals("rawValue")) {
                if (currentValue instanceof byte[] && (fieldBytes = this.getByteTextStringValue(currentValue, fields)) != null) {
                    currentValue = this.getTextString(fieldBytes);
                }
            } else if (fields != null && fields.get(currentKey) != null && currentValue instanceof byte[] && (fieldBytes = this.getByteTextStringValue(currentValue, fields)) != null) {
                currentValue = this.getTextString(fieldBytes);
            }
            if (currentValue instanceof String) {
                String keyString = currentValue.toString();
                StringTokenizer tokens = new StringTokenizer(keyString);
                if (tokens.countTokens() == 3) {
                    int i1 = keyString.indexOf(" R");
                    int i2 = keyString.indexOf(" R", i1 + 1);
                    if (i2 == -1 && keyString.endsWith("]") && keyString.indexOf(" R") != -1) {
                        formObject = keyString = Strip.removeArrayDeleminators(keyString);
                        stringValue = new HashMap();
                        this.flattenValuesInObject(addPage, keepKids, this.readObject(keyString, false, fields), stringValue, fields, pageLookup, formObject);
                        newValues.put(currentKey, stringValue);
                        continue;
                    }
                    if (i2 == -1 && keyString.endsWith(" R")) {
                        stringValue = new HashMap();
                        formObject = keyString;
                        this.flattenValuesInObject(addPage, keepKids, this.readObject(keyString, false, fields), stringValue, fields, pageLookup, formObject);
                        newValues.put(currentKey, stringValue);
                        continue;
                    }
                    newValues.put(currentKey, currentValue);
                    continue;
                }
                newValues.put(currentKey, currentValue);
                continue;
            }
            if (currentValue instanceof Map) {
                Map valueMap = (Map)currentValue;
                HashMap updatedValue = new HashMap();
                this.flattenValuesInObject(addPage, keepKids, valueMap, updatedValue, fields, pageLookup, formObject);
                newValues.put(currentKey, updatedValue);
                continue;
            }
            newValues.put(currentKey, currentValue);
        }
    }

    public void setCacheSize(int miniumumCacheSize) {
        this.miniumumCacheSize = miniumumCacheSize;
    }

    public byte[] readStreamFromPDF(int start, int end) {
        byte[] bytes = new byte[end - start + 1];
        try {
            this.movePointer(start);
            this.pdf_datafile.read(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public void setInterruptRefReading(boolean value) {
        this.interruptRefReading = value;
    }

    public void readStreamIntoMemory(Map downField) {
        String cachedStream = (String)downField.get("CachedStream");
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(cachedStream));
            int streamLength = (int)new File(cachedStream).length();
            byte[] bytes = new byte[streamLength];
            bis.read(bytes);
            bis.close();
            downField.put("DecodedStream", bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

