/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.TiffDecoder;
import org.jpedal.sun.LZWDecoder;
import org.jpedal.sun.LZWDecoder2;
import org.jpedal.sun.TIFFFaxDecoder;
import org.jpedal.sun.TIFFLZWDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class PdfFilteredReader
extends PdfFileReader {
    static final boolean debugCaching = false;
    BufferedOutputStream streamCache = null;
    BufferedInputStream bis = null;
    private String filter_type;
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};
    boolean containsJBIG;

    public final byte[] decodeFilters(byte[] data, String filter_list, Map objData, int width, int height, boolean useNewCCITT, String cacheName) throws Exception {
        Object rawParams;
        boolean isCached;
        this.streamCache = null;
        this.bis = null;
        boolean debug = false;
        Map decodeParams = new HashMap();
        boolean bl = isCached = cacheName != null && data == null;
        if (objData != null && (rawParams = objData.get("DecodeParms")) != null) {
            if (rawParams instanceof String) {
                this.convertStringToMap(decodeParams, rawParams);
            } else {
                decodeParams = (Map)rawParams;
            }
        }
        if (filter_list.startsWith("[")) {
            filter_list = filter_list.endsWith("]") ? filter_list.substring(1, filter_list.length() - 1) : filter_list.substring(1);
        } else if (filter_list.endsWith("]")) {
            filter_list = filter_list.substring(0, filter_list.length() - 1);
        }
        if (filter_list.length() > 0) {
            StringTokenizer filters_to_decode = new StringTokenizer(filter_list);
            boolean isIgnored = false;
            while (filters_to_decode.hasMoreTokens()) {
                boolean isDCT;
                this.filter_type = filters_to_decode.nextToken();
                boolean bl2 = isDCT = this.filter_type.indexOf("/DCTDecode") != -1 || this.filter_type.indexOf("/JPXDecode") != -1;
                if (isCached && !isDCT && cacheName != null) {
                    this.setupCachedObjectForDecoding(data, cacheName, false, this.filter_type);
                }
                if (!this.filter_type.startsWith("/")) continue;
                isIgnored = false;
                if (this.filter_type.indexOf("/FlateDecode") != -1 || this.filter_type.indexOf("/Fl") != -1) {
                    data = this.flateDecode(data, decodeParams, cacheName);
                } else if (this.filter_type.indexOf("/ASCII85Decode") != -1 || this.filter_type.indexOf("/A85") != -1) {
                    if (data != null) {
                        data = this.ascii85DecodeNEW(data);
                    }
                    if (this.bis != null) {
                        this.ascii85Decode(this.bis, this.streamCache);
                    }
                } else if (this.isCCITTEncoded(this.filter_type)) {
                    JAIHelper.confirmJAIOnClasspath();
                    if (isCached) {
                        int size = this.bis.available();
                        data = new byte[size];
                        this.bis.read(data);
                    }
                    boolean EncodedByteAligned = false;
                    String value = (String)decodeParams.get("EncodedByteAlign");
                    if (value != null) {
                        EncodedByteAligned = Boolean.valueOf(value);
                    }
                    byte[] newData = null;
                    if (!EncodedByteAligned && useNewCCITT && JAIHelper.isJAIused() && data != null) {
                        TiffDecoder decode = new TiffDecoder(width, height, decodeParams, data);
                        newData = decode.getRawBytes();
                    }
                    data = newData == null ? this.ccittDecode(data, decodeParams, width, height) : newData;
                    if (isCached) {
                        this.streamCache.write(data);
                    }
                } else if (this.filter_type.indexOf("/LZW") != -1) {
                    data = this.lzwDecode(this.bis, this.streamCache, data, decodeParams, width, height, cacheName);
                } else if (this.filter_type.indexOf("/RunLengthDecode") != -1 | this.filter_type.indexOf("/RL") != -1) {
                    data = this.runLengthDecode(data, this.bis, this.streamCache);
                } else if (this.filter_type.indexOf("/ASCIIHexDecode") != -1 | this.filter_type.indexOf("/AHx") != -1) {
                    if (data != null) {
                        data = this.asciiHexDecode(data);
                    }
                    if (this.bis != null) {
                        this.asciiHexDecode(this.bis, this.streamCache);
                    }
                } else if (this.filter_type.indexOf("/Crypt") == -1) {
                    if (isDCT) {
                        isIgnored = true;
                    } else {
                        LogWriter.writeLog("[PDF] Unsupported decompression stream " + this.filter_type);
                        data = null;
                    }
                }
                if (!isCached) continue;
                if (this.bis != null) {
                    this.bis.close();
                }
                if (this.streamCache == null) continue;
                this.streamCache.flush();
                this.streamCache.close();
            }
        }
        return data;
    }

    private void setupCachedObjectForDecoding(byte[] data, String cacheName, boolean debug, String filter_type) throws IOException {
        File tempFile2 = File.createTempFile("jpedal", ".raw");
        this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
        ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
        File rawFile = new File(cacheName);
        rawFile.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(cacheName));
        if (debug) {
            System.out.println("cache size=" + tempFile2.length());
        }
        this.bis = new BufferedInputStream(new FileInputStream(tempFile2));
    }

    public void convertStringToMap(Map decodeParams, Object rawParams) {
        StringTokenizer paraValues = new StringTokenizer(Strip.removeArrayDeleminators((String)rawParams));
        while (paraValues.hasMoreTokens()) {
            String value = paraValues.nextToken();
            if (value.startsWith("<<")) {
                value = value.substring(2).trim();
            }
            if (!value.startsWith("/")) continue;
            String key = value.substring(1);
            value = paraValues.nextToken();
            if (value.endsWith(">>")) {
                value = value.substring(0, value.length() - 2).trim();
            }
            decodeParams.put(key, value);
        }
    }

    private byte[] runLengthDecode(byte[] data, BufferedInputStream bis, BufferedOutputStream streamCache) throws Exception {
        ByteArrayOutputStream bos = null;
        int count = 0;
        int len = 0;
        int nextLen = 0;
        byte value = 0;
        int value2 = 0;
        if (data != null) {
            count = data.length;
            bos = new ByteArrayOutputStream(count);
        }
        if (bis != null) {
            count = bis.available();
        }
        if (data != null && bis != null && data.length != bis.available()) {
            System.out.println("Different lengths in RunLengthDecode");
            System.out.println(String.valueOf(data.length) + " " + bis.available());
            System.exit(1);
        }
        int i = 0;
        while (i < count) {
            int j;
            if (data != null) {
                len = data[i];
            }
            if (bis != null) {
                nextLen = bis.read();
                if (nextLen >= 128) {
                    nextLen -= 256;
                }
                if (data != null && len != nextLen) {
                    System.out.println("Len wrong =" + len + ' ' + nextLen);
                    System.exit(1);
                }
                len = nextLen;
            }
            if (len < 0) {
                len += 256;
            }
            if (len == 128) {
                i = count;
            } else if (len > 128) {
                ++i;
                len = 257 - len;
                if (data != null) {
                    value = data[i];
                }
                if (streamCache != null && (value2 = bis.read()) >= 128) {
                    value2 -= 256;
                }
                if (data != null && bis != null && value != value2) {
                    System.out.println("Different values in RunLengthDecode");
                    System.out.println(String.valueOf(value) + " " + value2 + ' ' + streamCache);
                    System.exit(1);
                }
                j = 0;
                while (j < len) {
                    if (data != null) {
                        bos.write(value);
                    }
                    if (streamCache != null) {
                        streamCache.write(value2);
                    }
                    ++j;
                }
            } else {
                ++i;
                ++len;
                j = 0;
                while (j < len) {
                    if (data != null) {
                        value = data[i + j];
                        bos.write(value);
                    }
                    if (streamCache != null) {
                        value2 = bis.read();
                        if (value2 >= 128) {
                            value2 -= 256;
                        }
                        streamCache.write(value2);
                    }
                    if (data != null && bis != null && value != value2) {
                        System.out.println("2Different values in RunLengthDecode");
                        System.out.println(String.valueOf(value) + " " + value2);
                        System.exit(1);
                    }
                    ++j;
                }
                i = i + len - 1;
            }
            ++i;
        }
        if (data != null) {
            bos.close();
            data = bos.toByteArray();
        }
        return data;
    }

    private final byte[] lzwDecode(BufferedInputStream bis, BufferedOutputStream streamCache, byte[] data, Map values, int width, int height, String cacheName) throws Exception {
        int predictor = 1;
        int BitsPerComponent = 8;
        int rows = height;
        int columns = width;
        String value = (String)values.get("Predictor");
        if (value != null) {
            predictor = Integer.parseInt(value);
        }
        if ((value = (String)values.get("Rows")) != null) {
            rows = Integer.parseInt(value);
        }
        if ((value = (String)values.get("Columns")) != null) {
            columns = Integer.parseInt(value);
        }
        if ((value = (String)values.get("EarlyChange")) != null) {
            int n = Integer.parseInt(value);
        }
        if ((value = (String)values.get("BitsPerComponent")) != null) {
            BitsPerComponent = Integer.parseInt(value);
        }
        byte[] processedData = null;
        if (rows * columns == 1) {
            if (data != null) {
                byte[] processed_data = new byte[BitsPerComponent * rows * (columns + 7 >> 3)];
                TIFFLZWDecoder lzw_decode = new TIFFLZWDecoder(columns, predictor, BitsPerComponent);
                lzw_decode.decode(data, processed_data, rows);
                return this.applyPredictor(predictor, values, processed_data);
            }
            return null;
        }
        if (bis != null) {
            LZWDecoder2 lzw2 = new LZWDecoder2();
            lzw2.decode(data, streamCache, bis);
        }
        if (data != null) {
            ByteArrayOutputStream processed = new ByteArrayOutputStream();
            LZWDecoder lzw = new LZWDecoder();
            lzw.decode(data, processed);
            processed.close();
            data = processed.toByteArray();
        }
        if (predictor != 1 && predictor != 10) {
            streamCache.flush();
            streamCache.close();
            if (cacheName != null) {
                this.setupCachedObjectForDecoding(data, cacheName, false, this.filter_type);
            }
        }
        data = this.applyPredictor(predictor, values, data);
        return data;
    }

    private byte[] ccittDecode(byte[] data, Map values, int width, int height) throws Exception {
        boolean isBlack = false;
        int columns = 1728;
        int rows = height;
        int k = 0;
        boolean isByteAligned = false;
        String value = (String)values.get("K");
        if (value != null) {
            k = Integer.parseInt(value);
        }
        if ((value = (String)values.get("EncodedByteAlign")) != null) {
            isByteAligned = Boolean.valueOf(value);
        }
        if ((value = (String)values.get("BlackIs1")) != null) {
            isBlack = Boolean.valueOf(value);
        }
        if ((value = (String)values.get("Rows")) != null) {
            rows = Integer.parseInt(value);
        }
        if ((value = (String)values.get("Columns")) != null) {
            columns = Integer.parseInt(value);
        }
        byte[] processed_data = new byte[rows * (columns + 7 >> 3)];
        try {
            TIFFFaxDecoder tiff_decode = new TIFFFaxDecoder(1, columns, rows);
            if (k == 0) {
                tiff_decode.decode1D(processed_data, data, 0, rows);
            } else if (k > 0) {
                tiff_decode.decode2D(processed_data, data, 0, rows, 0L);
            } else if (k < 0) {
                tiff_decode.decodeT6(processed_data, data, 0, rows, 0L, isByteAligned);
            }
            if (!isBlack) {
                int i = 0;
                while (i < processed_data.length) {
                    processed_data[i] = (byte)(255 - processed_data[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing CCITT filter " + e);
        }
        return processed_data;
    }

    private final byte[] ascii85DecodeNEW(byte[] valuesRead) {
        int special_cases = 0;
        int returns = 0;
        String line = "";
        int data_size = valuesRead.length;
        int i = 0;
        while (i < data_size) {
            if (valuesRead[i] == 122) {
                ++special_cases;
            }
            if (valuesRead[i] == 10 || valuesRead[i] == 10) {
                ++returns;
            }
            ++i;
        }
        int output_pointer = 0;
        long value = 0L;
        byte[] temp_data = new byte[data_size - returns + 1 + special_cases * 3];
        int ii = 0;
        int i2 = 0;
        while (i2 < data_size) {
            value = 0L;
            byte next = valuesRead[i2];
            while (next == 10 || next == 13) {
                next = ++i2 == data_size ? (byte)0 : valuesRead[i2];
            }
            if (next == 122) {
                int i3 = 0;
                while (i3 < 4) {
                    temp_data[output_pointer] = 0;
                    ++output_pointer;
                    ++i3;
                }
            } else if (data_size - i2 > 4 && next > 32 && next < 118) {
                String list = "";
                ii = 0;
                while (ii < 5) {
                    next = valuesRead[i2];
                    list = String.valueOf(list) + next + ' ';
                    while (next == 10 || next == 13) {
                        next = ++i2 == data_size ? (byte)0 : valuesRead[i2];
                    }
                    ++i2;
                    if (next > 32 && next < 118 || next == 126) {
                        value += (long)(next - 33) * base_85_indices[ii];
                    }
                    ++ii;
                }
                int i3 = 0;
                while (i3 < 4) {
                    temp_data[output_pointer] = (byte)(value / hex_indices[i3] & 0xFFL);
                    ++output_pointer;
                    ++i3;
                }
                --i2;
            }
            ++i2;
        }
        byte[] processed_data = new byte[output_pointer];
        System.arraycopy(temp_data, 0, processed_data, 0, output_pointer);
        return processed_data;
    }

    private final void ascii85Decode(BufferedInputStream bis, BufferedOutputStream streamCache) {
        long value = 0L;
        int nextValue = 0;
        try {
            int data_size = bis.available();
            int lastValue = 0;
            boolean ignoreLastItem = false;
            while (bis.available() > 0) {
                value = 0L;
                nextValue = this.read(bis);
                if (nextValue == 122) {
                    int i3 = 0;
                    while (i3 < 4) {
                        streamCache.write(0);
                        ++i3;
                    }
                    continue;
                }
                if (bis.available() < 4 || nextValue <= 32 || nextValue >= 118) continue;
                lastValue = nextValue;
                value += (long)(nextValue - 33) * base_85_indices[0];
                String list = "";
                int ii = 1;
                while (ii < 5) {
                    nextValue = this.read(bis);
                    list = String.valueOf(list) + nextValue + ' ';
                    if (nextValue == -1) {
                        nextValue = 0;
                    }
                    if (nextValue == -1) {
                        ignoreLastItem = true;
                    }
                    lastValue = nextValue;
                    if (nextValue > 32 && nextValue < 118 || nextValue == 126) {
                        value += (long)(nextValue - 33) * base_85_indices[ii];
                    }
                    ++ii;
                }
                if (ignoreLastItem) continue;
                int i3 = 0;
                while (i3 < 4) {
                    byte b = (byte)(value / hex_indices[i3] & 0xFFL);
                    streamCache.write(b);
                    ++i3;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int read(BufferedInputStream bis) throws IOException {
        int nextValue = bis.read();
        while (nextValue == 13 || nextValue == 10) {
            nextValue = bis.read();
        }
        return nextValue;
    }

    private final byte[] asciiHexDecode(byte[] data) throws IOException {
        String line = "";
        StringBuffer value = new StringBuffer();
        StringBuffer valuesRead = new StringBuffer();
        BufferedReader mappingStream = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(data);
            mappingStream = new BufferedReader(new InputStreamReader(bis));
            if (mappingStream != null) {
                while ((line = mappingStream.readLine()) != null) {
                    valuesRead.append(line);
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading ASCII stream ");
        }
        if (mappingStream != null) {
            try {
                mappingStream.close();
                bis.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        int data_size = valuesRead.length();
        int i = 0;
        int count = 0;
        char current = ' ';
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        do {
            if (!((current = (char)valuesRead.charAt(i)) >= '0' & current <= '9' | current >= 'a' & current <= 'f' | current >= 'A' & current <= 'F')) continue;
            value.append(current);
            if (count == 1) {
                bos.write(Integer.valueOf(value.toString(), 16));
                count = 0;
                value = new StringBuffer();
                continue;
            }
            ++count;
        } while (current != '>' && ++i != data_size);
        if (count == 1) {
            value.append('0');
            bos.write(Integer.valueOf(value.toString(), 16));
        }
        bos.close();
        return bos.toByteArray();
    }

    private final void asciiHexDecode(BufferedInputStream bis, BufferedOutputStream streamCache) throws IOException {
        StringBuffer value = new StringBuffer();
        char current = ' ';
        int count = bis.available();
        int i = 0;
        while (i < count) {
            current = (char)bis.read();
            while (current == '\n') {
                current = (char)bis.read();
            }
            if (current >= '0' & current <= '9' | current >= 'a' & current <= 'f' | current >= 'A' & current <= 'F') {
                value.append(current);
                if (count == 1) {
                    streamCache.write(Integer.valueOf(value.toString(), 16));
                    count = 0;
                    value = new StringBuffer();
                } else {
                    ++count;
                }
            }
            if (current == '>') break;
            ++i;
        }
        if (count == 1) {
            value.append('0');
            streamCache.write(Integer.valueOf(value.toString(), 16));
        }
    }

    private final byte[] flateDecode(byte[] data, Map params, String cacheName) throws Exception {
        Object inf;
        byte[] returnData = null;
        int predictor = 1;
        String value = (String)params.get("Predictor");
        if (value != null) {
            predictor = Integer.parseInt(value);
        }
        if (data != null) {
            inf = new Inflater();
            ((Inflater)inf).setInput(data);
            int size = data.length;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
            int bufSize = 512000;
            if (size < bufSize) {
                bufSize = size;
            }
            byte[] buf = new byte[bufSize];
            int debug = 20;
            while (!((Inflater)inf).finished()) {
                int count = ((Inflater)inf).inflate(buf);
                bos.write(buf, 0, count);
                if (((Inflater)inf).getRemaining() == 0) break;
            }
            data = bos.toByteArray();
        }
        if (this.bis != null) {
            try {
                inf = new InflaterInputStream(this.bis);
                int i = 0;
                while (true) {
                    int b = ((InputStream)inf).read();
                    if (returnData != null && b != (returnData[i] & 0xFF)) {
                        System.out.println("Different in flate at " + i);
                        System.exit(1);
                    }
                    if (((InputStream)inf).available() == 0 || b == -1) break;
                    this.streamCache.write(b);
                    ++i;
                }
                if (predictor != 1 && predictor != 10) {
                    this.streamCache.flush();
                    this.streamCache.close();
                    if (cacheName != null) {
                        this.setupCachedObjectForDecoding(data, cacheName, false, this.filter_type);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        returnData = this.applyPredictor(predictor, params, data);
        return returnData;
    }

    private void applyPredictorFunction(int mainPred, Map params, BufferedInputStream bis, OutputStream bos) throws Exception {
        int predictor = mainPred;
        int bytesAvaiable = bis.available();
        int colors = 1;
        int bitsPerComponent = 8;
        int columns = 1;
        boolean earlyChange = true;
        String value = (String)params.get("Colors");
        if (value != null) {
            colors = Integer.parseInt(value);
        }
        if ((value = (String)params.get("BitsPerComponent")) != null) {
            bitsPerComponent = Integer.parseInt(value);
        }
        if ((value = (String)params.get("Columns")) != null) {
            columns = Integer.parseInt(value);
        }
        int bpp = (colors * bitsPerComponent + 7) / 8;
        int rowLength = (columns * colors * bitsPerComponent + 7) / 8 + bpp;
        byte[] thisLine = new byte[rowLength];
        byte[] lastLine = new byte[rowLength];
        try {
            int byteCount = 0;
            while (bytesAvaiable > byteCount) {
                predictor = mainPred;
                if (predictor == 15) {
                    predictor = bis.read();
                    if (predictor == -1) break;
                    predictor += 10;
                } else if (predictor >= 10) {
                    bis.read();
                }
                int i = 0;
                int offset = bpp;
                int bytesToRead = rowLength;
                while (offset < bytesToRead) {
                    i = bis.read(thisLine, offset, bytesToRead - offset);
                    if (i == -1) break;
                    offset += i;
                    byteCount += i;
                }
                if (i == -1) break;
                switch (predictor) {
                    case 2: {
                        int raw;
                        int sub;
                        int i1 = bpp;
                        while (i1 < rowLength) {
                            sub = thisLine[i1] & 0xFF;
                            raw = lastLine[i1 - bpp] & 0xFF;
                            thisLine[i1] = (byte)(sub + raw & 0xFF);
                            bos.write(thisLine[i1]);
                            ++i1;
                        }
                        break;
                    }
                    case 10: {
                        int i1 = bpp;
                        while (i1 < rowLength) {
                            bos.write(thisLine[i1]);
                            ++i1;
                        }
                        break;
                    }
                    case 11: {
                        int raw;
                        int sub;
                        int i1 = bpp;
                        while (i1 < rowLength) {
                            sub = thisLine[i1] & 0xFF;
                            raw = thisLine[i1 - bpp] & 0xFF;
                            thisLine[i1] = (byte)(sub + raw);
                            bos.write(thisLine[i1]);
                            ++i1;
                        }
                        break;
                    }
                    case 12: {
                        int i1 = bpp;
                        while (i1 < rowLength) {
                            int up = thisLine[i1] & 0xFF;
                            int prior = lastLine[i1] & 0xFF;
                            thisLine[i1] = (byte)(up + prior & 0xFF);
                            bos.write(thisLine[i1]);
                            ++i1;
                        }
                        break;
                    }
                    case 13: {
                        int i1 = bpp;
                        while (i1 < rowLength) {
                            int av = thisLine[i1] & 0xFF;
                            int floor = (thisLine[i1 - bpp] & 0xFF) + (lastLine[i1] & 0xFF) >> 1;
                            thisLine[i1] = (byte)(av + floor);
                            bos.write(thisLine[i1]);
                            ++i1;
                        }
                        break;
                    }
                    case 14: {
                        int i1 = bpp;
                        while (i1 < rowLength) {
                            int a = thisLine[i1 - bpp] & 0xFF;
                            int b = lastLine[i1] & 0xFF;
                            int c = lastLine[i1 - bpp] & 0xFF;
                            int p = a + b - c;
                            int pa = p - a;
                            int pb = p - b;
                            int pc = p - c;
                            if (pa < 0) {
                                pa = -pa;
                            }
                            if (pb < 0) {
                                pb = -pb;
                            }
                            if (pc < 0) {
                                pc = -pc;
                            }
                            thisLine[i1] = pa <= pb && pa <= pc ? (byte)(thisLine[i1] + a) : (pb <= pc ? (byte)(thisLine[i1] + b) : (byte)(thisLine[i1] + c));
                            bos.write(thisLine[i1]);
                            ++i1;
                        }
                        break;
                    }
                    case 15: {
                        break;
                    }
                }
                System.arraycopy(thisLine, 0, lastLine, 0, lastLine.length);
            }
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private byte[] applyPredictor(int predictor, Map params, byte[] data) throws Exception {
        boolean isCached;
        if (predictor == 1 || predictor == 10) {
            return data;
        }
        boolean bl = isCached = data == null;
        if (isCached) {
            this.applyPredictorFunction(predictor, params, this.bis, this.streamCache);
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(data));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.applyPredictorFunction(predictor, params, bis, bos);
        return bos.toByteArray();
    }

    private boolean isCCITTEncoded(String filter) {
        if (filter == null) {
            return false;
        }
        return filter.startsWith("/CCITT") | filter.startsWith("/CCF");
    }
}

