/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ObjectStore {
    private static final boolean debugCache = false;
    private static final String separator = System.getProperty("file.separator");
    private String currentFilename = "";
    public static String temp_dir = "";
    private String cmyk_dir = String.valueOf(temp_dir) + "cmyk" + separator;
    private String key = "jpedal" + Math.random() + '_';
    private Map image_type = new Hashtable();
    private Map tempFileNames = new HashMap();
    public String fullFileName;
    private static Map pagesOnDisk = new HashMap();
    private static Map pagesOnDiskAsBytes = new HashMap();

    public ObjectStore() {
        try {
            File f;
            if (temp_dir.length() == 0) {
                temp_dir = String.valueOf(System.getProperty("java.io.tmpdir")) + separator + "jpedal" + separator;
            }
            if (!(f = new File(temp_dir)).exists()) {
                f.mkdirs();
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to create temp dir at " + temp_dir);
        }
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public final void storeFileName(String name) {
        this.fullFileName = name;
        int temp_pointer = name.indexOf(92);
        if (temp_pointer == -1) {
            temp_pointer = name.indexOf(47);
        }
        while (temp_pointer != -1) {
            if ((temp_pointer = (name = name.substring(temp_pointer + 1)).indexOf(92)) != -1) continue;
            temp_pointer = name.indexOf(47);
        }
        int pointer = name.lastIndexOf(46);
        if (pointer != -1) {
            name = name.substring(0, pointer);
        }
        name = Strip.stripAllSpaces(name);
        this.currentFilename = name.toLowerCase();
    }

    public boolean saveRawCMYKImage(byte[] image_data, String name) {
        boolean isSuccessful = true;
        File cmyk_d = new File(this.cmyk_dir);
        if (!cmyk_d.exists()) {
            cmyk_d.mkdirs();
        }
        try {
            FileOutputStream a = new FileOutputStream(String.valueOf(this.cmyk_dir) + name + ".jpg");
            this.tempFileNames.put(String.valueOf(this.cmyk_dir) + name + ".jpg", "#");
            a.write(image_data);
            a.flush();
            a.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to save CMYK jpeg " + name);
            isSuccessful = false;
        }
        return isSuccessful;
    }

    public final synchronized boolean saveStoredImage(String current_image, BufferedImage image, boolean file_name_is_path, boolean save_unclipped, String type) {
        boolean was_error = false;
        int type_id = image.getType();
        File checkDir = new File(temp_dir);
        if (!checkDir.exists()) {
            checkDir.mkdirs();
        }
        if (type.indexOf("tif") != -1) {
            if (type_id == 1 | type_id == 2 && current_image.indexOf("HIRES_") == -1) {
                image = ColorSpaceConvertor.convertColorspace(image, 5);
            }
            if (!file_name_is_path) {
                this.image_type.put(current_image, "tif");
            }
            was_error = this.saveStoredImage("TIFF", ".tif", ".tiff", current_image, image, file_name_is_path, save_unclipped);
        } else if (type.indexOf("jpg") != -1) {
            if (!file_name_is_path) {
                this.image_type.put(current_image, "jpg");
            }
            was_error = this.saveStoredJPEGImage(current_image, image, file_name_is_path, save_unclipped);
        } else if (type.indexOf("png") != -1) {
            if (!file_name_is_path) {
                this.image_type.put(current_image, "png");
            }
            was_error = this.saveStoredImage("PNG", ".png", ".png", current_image, image, file_name_is_path, save_unclipped);
        }
        image = null;
        return was_error;
    }

    public final String getImageType(String current_image) {
        return (String)this.image_type.get(current_image);
    }

    public final void init(String current_key) {
        this.key = String.valueOf(current_key) + System.currentTimeMillis();
        File f = new File(temp_dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public final synchronized BufferedImage loadStoredImage(String current_image) {
        String flag = (String)this.image_type.get(current_image);
        BufferedImage image = null;
        if (flag == null) {
            return null;
        }
        if (flag.equals("tif")) {
            image = this.loadStoredImage(current_image, ".tif");
        } else if (flag.equals("jpg")) {
            image = this.loadStoredJPEGImage(current_image);
        } else if (flag.equals("png")) {
            image = this.loadStoredImage(current_image, ".png");
        }
        return image;
    }

    public final synchronized boolean isImageCached(String current_image) {
        String flag = (String)this.image_type.get(current_image);
        Object image = null;
        if (flag == null) {
            return false;
        }
        String file_name = String.valueOf(temp_dir) + this.key + current_image + '.' + flag;
        File imgFile = new File(file_name);
        return imgFile.exists();
    }

    public final void flush() {
        File cmyk_d;
        if (temp_dir.length() > 2) {
            File temp_files = new File(temp_dir);
            String[] file_list = temp_files.list();
            File[] to_be_del = temp_files.listFiles();
            if (file_list != null) {
                int ii = 0;
                while (ii < file_list.length) {
                    if (file_list[ii].indexOf(this.key) != -1) {
                        File delete_file = new File(String.valueOf(temp_dir) + file_list[ii]);
                        delete_file.delete();
                    }
                    boolean delOldFiles = true;
                    long time = 14400000L;
                    if (delOldFiles && System.currentTimeMillis() - to_be_del[ii].lastModified() >= time) {
                        to_be_del[ii].delete();
                    }
                    ++ii;
                }
            }
        }
        if ((cmyk_d = new File(this.cmyk_dir)).exists()) {
            cmyk_d.delete();
            cmyk_d = null;
        }
    }

    public void copyCMYKimages(String target_dir) {
        File cmyk_d = new File(this.cmyk_dir);
        if (cmyk_d.exists()) {
            String[] file_list = cmyk_d.list();
            if (file_list.length > 0) {
                File test_d;
                if (!target_dir.endsWith(separator)) {
                    target_dir = String.valueOf(target_dir) + separator;
                }
                if (!(test_d = new File(target_dir)).exists()) {
                    test_d.mkdirs();
                }
                test_d = null;
            }
            int ii = 0;
            while (ii < file_list.length) {
                File source = new File(String.valueOf(this.cmyk_dir) + file_list[ii]);
                File dest = new File(String.valueOf(target_dir) + file_list[ii]);
                source.renameTo(dest);
                ++ii;
            }
        }
        cmyk_d = null;
    }

    private final synchronized boolean saveStoredJPEGImage(String current_image, BufferedImage image, boolean file_name_is_path, boolean save_unclipped) {
        JPEGImageEncoder as_jpeg;
        BufferedOutputStream out;
        boolean was_error = false;
        boolean image_written = false;
        String file_name = current_image;
        String unclipped_file_name = "";
        if (!file_name_is_path) {
            file_name = String.valueOf(temp_dir) + this.key + current_image;
            unclipped_file_name = String.valueOf(temp_dir) + this.key + 'R' + current_image;
            this.image_type.put(String.valueOf('R') + current_image, this.image_type.get(current_image));
        }
        if (!file_name.toLowerCase().endsWith(".jpg") & !file_name.toLowerCase().endsWith(".jpeg")) {
            file_name = String.valueOf(file_name) + ".jpg";
            unclipped_file_name = String.valueOf(unclipped_file_name) + ".jpg";
        }
        try {
            out = new BufferedOutputStream(new FileOutputStream(new File(file_name)));
            as_jpeg = JPEGCodec.createJPEGEncoder((OutputStream)out);
            as_jpeg.encode(image);
            this.tempFileNames.put(file_name, "#");
            out.close();
            image_written = true;
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " writing image " + image + " as " + file_name);
        }
        if (!image_written) {
            try {
                out = new BufferedOutputStream(new FileOutputStream(new File(file_name)));
                as_jpeg = JPEGCodec.createJPEGEncoder((OutputStream)out);
                as_jpeg.encode(image);
                this.tempFileNames.put(file_name, "#");
                out.close();
            }
            catch (Exception e) {
                was_error = true;
                LogWriter.writeLog("Exception " + e + " writing image " + image);
            }
        }
        if (save_unclipped) {
            this.saveCopy(file_name, unclipped_file_name);
            this.tempFileNames.put(unclipped_file_name, "#");
        }
        return was_error;
    }

    public String getFileForCachedImage(String current_image) {
        return String.valueOf(temp_dir) + this.key + current_image + '.' + this.image_type.get(current_image);
    }

    private final synchronized BufferedImage loadStoredImage(String current_image, String ending) {
        String file_name = String.valueOf(temp_dir) + this.key + current_image + ending;
        BufferedImage image = null;
        if (JAIHelper.isJAIused()) {
            try {
                JAIHelper.confirmJAIOnClasspath();
                image = JAI.create((String)"fileload", (Object)file_name).getAsBufferedImage();
            }
            catch (Exception exception) {}
        } else {
            try {
                image = ImageIO.read(new File(file_name));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    private final void saveCopy(String source, String destination) {
        BufferedInputStream from = null;
        FilterOutputStream to = null;
        try {
            int bytes_read;
            from = new BufferedInputStream(new FileInputStream(source));
            to = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                ((BufferedOutputStream)to).write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        try {
            to.close();
            from.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing files");
        }
        to = null;
        from = null;
    }

    public final void saveAsCopy(String current_image, String destination) {
        BufferedInputStream from = null;
        FilterOutputStream to = null;
        String source = String.valueOf(temp_dir) + this.key + current_image;
        try {
            int bytes_read;
            from = new BufferedInputStream(new FileInputStream(source));
            to = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                ((BufferedOutputStream)to).write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        try {
            to.close();
            from.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing files");
        }
    }

    public static final void copy(String source, String destination) {
        BufferedInputStream from = null;
        FilterOutputStream to = null;
        try {
            int bytes_read;
            from = new BufferedInputStream(new FileInputStream(source));
            to = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                ((BufferedOutputStream)to).write(buffer, 0, bytes_read);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        try {
            to.close();
            from.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing files");
        }
    }

    private final synchronized BufferedImage loadStoredJPEGImage(String current_image) {
        String file_name = String.valueOf(temp_dir) + this.key + current_image + ".jpg";
        BufferedImage image = null;
        File a = new File(file_name);
        if (a.exists()) {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file_name));
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
                image = decoder.decodeAsBufferedImage();
                in.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " loading " + current_image);
            }
        } else {
            image = new BufferedImage(100, 100, 1);
        }
        return image;
    }

    private final synchronized boolean saveStoredImage(String format, String ending1, String ending2, String current_image, BufferedImage image, boolean file_name_is_path, boolean save_unclipped) {
        boolean was_error = false;
        String file_name = current_image;
        String unclipped_file_name = "";
        if (!file_name_is_path) {
            file_name = String.valueOf(temp_dir) + this.key + current_image;
            unclipped_file_name = String.valueOf(temp_dir) + this.key + 'R' + current_image;
            this.image_type.put(String.valueOf('R') + current_image, this.image_type.get(current_image));
        }
        if (!file_name.toLowerCase().endsWith(ending1) & !file_name.toLowerCase().endsWith(ending2)) {
            file_name = String.valueOf(file_name) + ending1;
            unclipped_file_name = String.valueOf(unclipped_file_name) + ending1;
        }
        try {
            if (JAIHelper.isJAIused()) {
                JAIHelper.confirmJAIOnClasspath();
                JAI.create((String)"filestore", (RenderedImage)image, (Object)file_name, (Object)format);
            } else {
                ImageIO.setUseCache(false);
                FileOutputStream fos = new FileOutputStream(file_name);
                if (format.equals("TIFF")) {
                    ImageIO.write((RenderedImage)image, "png", fos);
                } else {
                    ImageIO.write((RenderedImage)image, format, fos);
                }
                fos.flush();
                fos.close();
            }
            this.tempFileNames.put(file_name, "#");
        }
        catch (Exception e) {
            e.printStackTrace();
            LogWriter.writeLog(" Exception " + e + " writing image " + image + " with type " + image.getType());
            was_error = true;
        }
        catch (Error ee) {
            LogWriter.writeLog("Error " + ee + " writing image " + image + " with type " + image.getType());
            was_error = true;
            image = null;
        }
        if (save_unclipped) {
            this.saveCopy(file_name, unclipped_file_name);
            this.tempFileNames.put(unclipped_file_name, "#");
        }
        return was_error;
    }

    public static void flushPages() {
        File delete_file;
        for (Object file : pagesOnDisk.keySet()) {
            if (file == null) continue;
            delete_file = new File((String)pagesOnDisk.get(file));
            delete_file.delete();
        }
        pagesOnDisk.clear();
        for (Object file : pagesOnDiskAsBytes.keySet()) {
            if (file == null) continue;
            delete_file = new File((String)pagesOnDiskAsBytes.get(file));
            delete_file.delete();
        }
        pagesOnDiskAsBytes.clear();
    }

    public static DynamicVectorRenderer getCachedPage(Integer key) {
        DynamicVectorRenderer currentDisplay = null;
        Object cachedFile = pagesOnDisk.get(key);
        if (cachedFile != null) {
            BufferedInputStream from = null;
            try {
                File fis = new File((String)cachedFile);
                from = new BufferedInputStream(new FileInputStream(fis));
                byte[] data = new byte[(int)fis.length()];
                from.read(data);
                from.close();
                currentDisplay = new DynamicVectorRenderer(data, new HashMap());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return currentDisplay;
    }

    public static void cachePage(Integer key, DynamicVectorRenderer currentDisplay) {
        try {
            File ff = File.createTempFile("page", ".bin");
            BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(ff));
            to.write(currentDisplay.serializeToByteArray(null));
            to.flush();
            to.close();
            pagesOnDisk.put(key, ff.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] getCachedPageAsBytes(String key) {
        byte[] data = null;
        Object cachedFile = pagesOnDiskAsBytes.get(key);
        if (cachedFile != null) {
            BufferedInputStream from = null;
            try {
                File fis = new File((String)cachedFile);
                from = new BufferedInputStream(new FileInputStream(fis));
                data = new byte[(int)fis.length()];
                from.read(data);
                from.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static void cachePageAsBytes(String key, byte[] bytes) {
        try {
            File ff = File.createTempFile("bytes", ".bin");
            BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(ff));
            to.write(bytes);
            to.flush();
            to.close();
            pagesOnDiskAsBytes.put(key, ff.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception " + e);
        }
    }
}

