/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.Messages;

public class JAIHelper {
    private static boolean JAI_TESTED;
    private static boolean useJAI;

    static {
        useJAI = false;
        String JAIflag = System.getProperty("org.jpedal.jai");
        if (JAIflag != null && JAIflag.toLowerCase().equals("true")) {
            useJAI = true;
        }
    }

    public static void confirmJAIOnClasspath() {
        block5: {
            if (JAI_TESTED) {
                return;
            }
            JAI_TESTED = true;
            if (useJAI) {
                try {
                    Class.forName("javax.media.jai.JAI");
                }
                catch (ClassNotFoundException e) {
                    if (!PdfDecoder.showErrorMessages) break block5;
                    String message = String.valueOf(Messages.getMessage("PdfViewer.JAINotOnClasspathWarning")) + Messages.getMessage("PdfViewer.JAINotOnClasspathWarning1") + Messages.getMessage("PdfViewer.JAINotOnClasspathWarning2");
                    if (message.indexOf("PdfViewer") != -1) {
                        message = "We recommend you add JAI to classpath";
                    }
                    JEditorPane p = new JEditorPane("text/html", message);
                    p.setEditable(false);
                    p.setOpaque(false);
                    p.addHyperlinkListener(new HyperlinkListener(){

                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                try {
                                    BrowserLauncher.openURL("http://java.sun.com/products/java-media/jai/current.html");
                                }
                                catch (IOException e1) {
                                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewer.ErrorWebsite"));
                                }
                            }
                        }
                    });
                    JOptionPane.showMessageDialog(null, p);
                }
            }
        }
    }

    public static boolean isJAIused() {
        return useJAI;
    }

    public static void useJAI(boolean use) {
        useJAI = use;
        JAI_TESTED = false;
    }
}

