/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;

public class ImageTransformer {
    private int image_type;
    private boolean isDraft;
    private BufferedImage current_image;
    private float[][] Trm;
    private float[][] CTM;
    private int i_x = 0;
    private int i_y = 0;
    private int i_w = 0;
    private int i_h = 0;
    private float scale = 1.0f;

    public ImageTransformer(int dpi, GraphicsState current_graphics_state, BufferedImage new_image, boolean scaleImage, boolean isDraft) {
        this.scale = dpi / 72;
        this.isDraft = isDraft;
        this.current_image = new_image;
        int w = this.current_image.getWidth();
        int h = this.current_image.getHeight();
        this.CTM = current_graphics_state.CTM;
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)w;
        this.Trm[0][1] = -(this.CTM[0][1] / (float)w);
        this.Trm[0][2] = 0.0f;
        this.Trm[1][0] = -(this.CTM[1][0] / (float)h);
        this.Trm[1][1] = this.CTM[1][1] / (float)h;
        this.Trm[1][2] = 0.0f;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        int y = 0;
        while (y < 3) {
            int x = 0;
            while (x < 3) {
                if ((double)this.Trm[x][y] > 0.99 & this.Trm[x][y] < 1.0f) {
                    this.Trm[x][y] = 1.0f;
                }
                ++x;
            }
            ++y;
        }
        this.scale(scaleImage, w, h, dpi);
        this.completeImage();
    }

    public void scale(boolean scaleImage, int w, int h, int dpi) {
        if ((double)this.Trm[0][0] != 1.0 | (double)this.Trm[1][1] != 1.0 | (double)this.Trm[0][1] != 0.0 | (double)this.Trm[1][0] != 0.0 | dpi != 72) {
            AffineTransformOp invert;
            AffineTransform image_at = new AffineTransform(this.Trm[0][0] * this.scale, this.Trm[0][1] * this.scale, this.Trm[1][0] * this.scale, this.Trm[1][1] * this.scale, 0.0f, 0.0f);
            Area r = new Area(new Rectangle(0, 0, w, h));
            r.transform(image_at);
            double ny = r.getBounds2D().getY();
            double nx = r.getBounds2D().getX();
            image_at = new AffineTransform((double)(this.Trm[0][0] * this.scale), (double)(this.Trm[0][1] * this.scale), (double)(this.Trm[1][0] * this.scale), (double)(this.Trm[1][1] * this.scale), -nx, -ny);
            if (w > 1 & h > 1) {
                invert = new AffineTransformOp(image_at, ColorSpaces.hints);
            } else {
                boolean isSolid = true;
                if (h == 1) {
                    WritableRaster ras = this.current_image.getRaster();
                    int bands = ras.getNumBands();
                    int width = ras.getWidth();
                    int[] elements = new int[width * bands + 1];
                    ras.getPixels(0, 0, width, 1, elements);
                    int j = 0;
                    while (j < bands) {
                        int first = elements[0];
                        int i = 1;
                        while (i < width) {
                            if (elements[i * j] != first) {
                                isSolid = false;
                                i = width;
                                j = bands;
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
                invert = isSolid ? new AffineTransformOp(image_at, null) : new AffineTransformOp(image_at, ColorSpaces.hints);
            }
            if (this.CTM[1][0] != 0.0f | this.CTM[0][1] != 0.0f) {
                this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
            }
            if (scaleImage) {
                if (this.isDraft || this.CTM[1][0] != 0.0f | this.CTM[0][1] != 0.0f) {
                    boolean imageProcessed;
                    if (h > 1 && !(imageProcessed = false)) {
                        long start = System.currentTimeMillis();
                        this.current_image = invert.filter(this.current_image, null);
                    }
                } else {
                    int dx = 1;
                    int dy = 1;
                    w = (int)this.CTM[0][0];
                    if (w == 0) {
                        w = (int)this.CTM[0][1];
                    }
                    if ((h = (int)this.CTM[1][1]) == 0) {
                        h = (int)this.CTM[1][0];
                    }
                    if (w < 0) {
                        w = -w;
                        dx = -1;
                    }
                    if (h < 0) {
                        h = -h;
                        dy = -1;
                    }
                    if (dx == -1 | dy == -1) {
                        image_at = new AffineTransform();
                        image_at.scale(dx, dy);
                        if (dx == -1) {
                            image_at.translate(-this.current_image.getWidth(), 0.0);
                        }
                        if (dy == -1) {
                            image_at.translate(0.0, -this.current_image.getHeight());
                        }
                        invert = new AffineTransformOp(image_at, ColorSpaces.hints);
                        this.current_image = invert.filter(this.current_image, null);
                    }
                    Image scaledImage = this.current_image.getScaledInstance(w, h, 4);
                    int type = this.current_image.getType();
                    if (type == 0 | type == 2) {
                        type = 1;
                    }
                    this.current_image = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), type);
                    Graphics2D g2 = this.current_image.createGraphics();
                    g2.drawImage(scaledImage, 0, 0, null);
                }
            }
        }
    }

    private void completeImage() {
        this.calcCoordinates();
    }

    private final void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f & this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f & this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else if (this.CTM[1][0] > 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    public final void clipImage(Area current_shape) {
        Area final_clip = (Area)current_shape.clone();
        if (this.scale != 1.0f) {
            AffineTransform af = AffineTransform.getScaleInstance(this.scale, this.scale);
            final_clip.transform(af);
        }
        int image_w = this.current_image.getWidth();
        int image_h = this.current_image.getHeight();
        double shape_x = final_clip.getBounds2D().getX();
        double shape_y = final_clip.getBounds2D().getY();
        double shape_h = final_clip.getBounds2D().getHeight();
        double d_y = (double)image_h - shape_h;
        AffineTransform upside_down = new AffineTransform();
        upside_down.translate(-shape_x, -shape_y);
        upside_down.scale(1.0, -1.0);
        upside_down.translate(shape_x, -(shape_y + shape_h));
        final_clip.transform(upside_down);
        AffineTransform align_clip = new AffineTransform();
        align_clip.translate((float)(-this.i_x) * this.scale, (double)((float)this.i_y * this.scale) + d_y);
        final_clip.transform(align_clip);
        double x = final_clip.getBounds2D().getX();
        double y = final_clip.getBounds2D().getY();
        double w = final_clip.getBounds2D().getWidth();
        double h = final_clip.getBounds2D().getHeight();
        this.image_type = this.current_image.getType();
        if (this.image_type == 0) {
            this.image_type = 2;
        } else if (this.image_type == 1) {
            this.image_type = 2;
        }
        BufferedImage offscreen = new BufferedImage(image_w, image_h, this.image_type);
        Graphics2D image_g2 = offscreen.createGraphics();
        if (!offscreen.getColorModel().hasAlpha()) {
            image_g2.setBackground(Color.white);
            image_g2.fill(new Rectangle(0, 0, image_w, image_h));
        }
        image_g2.setClip(final_clip);
        try {
            image_g2.drawImage(this.current_image, null, 0, 0);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " plotting clipping image");
        }
        if (y < 0.0) {
            h += y;
            y = 0.0;
        }
        if (x < 0.0) {
            w += x;
            x = 0.0;
        }
        if (w > (double)image_w) {
            w = image_w;
        }
        if (h > (double)image_h) {
            h = image_h;
        }
        if (y + h > (double)image_h) {
            h = (double)image_h - y;
        }
        if (x + w > (double)image_w) {
            w = (double)image_w - x;
        }
        try {
            this.current_image = offscreen.getSubimage((int)x, (int)y, (int)w, (int)h);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " extracting clipped image with values x=" + x + " y=" + y + " w=" + w + " h=" + h + " from image ");
        }
        double x1 = (double)this.i_x > shape_x ? (double)this.i_x : shape_x;
        double y1 = (double)this.i_y > shape_y ? (double)this.i_y : shape_y;
        this.i_x = (int)(x1 / (double)this.scale);
        this.i_y = (int)(y1 / (double)this.scale);
        this.i_w = (int)w;
        this.i_h = (int)h;
    }
}

