/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.SearchListener;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.StoryData;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_String;

public class PdfGroupingAlgorithms {
    private boolean[] isUsed;
    private float[] f_x1;
    private float[] f_x2;
    private float[] f_y1;
    private float[] f_y2;
    private boolean[] hadSpace;
    private String[] f_colorTag;
    private int[] writingMode;
    private int[] moveType;
    private int[] fontSize;
    private float[] spaceWidth;
    private StringBuffer[] content;
    private int[] textLength;
    private String hyphen_values = "";
    private PdfData pdf_data;
    private boolean isXHTML = true;
    private int nextSlot;
    private Vector_Int lineBreaks = new Vector_Int();
    private Vector_Object lines;
    private Vector_Int lineY2;
    private static final String MARKER = StoryData.marker;
    public static char MARKER2 = MARKER.charAt(0);
    private int max_rows = 0;
    private int master = 0;
    private boolean colorExtracted = false;
    private int[] line_order;
    private static final int increment = 100;
    private boolean IS_LEGACY = true;
    public static boolean oldTextExtraction = false;
    public static boolean useUnrotatedCoords;
    private float[] endPoints;
    private boolean includeTease;
    private String[] teasers;
    private StringBuffer tease;
    private float endX;

    public PdfGroupingAlgorithms() {
    }

    public PdfGroupingAlgorithms(PdfData pdf_data) {
        this.pdf_data = pdf_data;
        this.colorExtracted = pdf_data.isColorExtracted();
    }

    private final String getLineDownSeparator(int l, int c, StringBuffer rawLine1, StringBuffer rawLine2) {
        StringBuffer line2;
        StringBuffer line1;
        String returnValue = " ";
        boolean hasUnderline = false;
        if (PdfDecoder.isXMLExtraction()) {
            line1 = Strip.stripXML(rawLine1);
            line2 = Strip.stripXML(rawLine2);
        } else {
            line1 = Strip.trim(rawLine1);
            line2 = Strip.trim(rawLine2);
        }
        int line1Len = line1.length();
        int line2Len = line2.length();
        if (line1Len > 1 && line2Len > 1) {
            char line1Char2 = line1.charAt(line1Len - 1);
            char line1Char1 = line1.charAt(line1Len - 2);
            char line2Char1 = line2.charAt(0);
            char line2Char2 = line2.charAt(1);
            if (this.hyphen_values.indexOf(line1Char2) != -1) {
                returnValue = "";
                if (line1Char1 == ':') {
                    returnValue = "\n";
                }
                if (line1Char2 == ' ') {
                    returnValue = " ";
                }
            } else if ((line1Char1 == '.' | line1Char2 == '.') & (Character.isUpperCase(line2Char1) | line2Char1 == '&' | Character.isUpperCase(line2Char2) | line2Char2 == '&')) {
                returnValue = PdfDecoder.isXMLExtraction() ? "<p></p>\n" : "\n";
            }
        }
        if (hasUnderline) {
            returnValue = PdfDecoder.isXMLExtraction() ? String.valueOf(returnValue) + "<p></p>\n" : String.valueOf(returnValue) + '\n';
        }
        return returnValue;
    }

    private final void cleanupShadowsAndDrownedObjects(boolean avoidSpaces) {
        int[] items = this.getUnusedFragments();
        int count = items.length;
        String separator = "";
        int p = 0;
        while (p < count) {
            int c = items[p];
            if (!this.isUsed[c]) {
                float midX = (this.f_x1[c] + this.f_x2[c]) / 2.0f;
                float midY = (this.f_y1[c] + this.f_y2[c]) / 2.0f;
                int p2 = p + 1;
                while (p2 < count) {
                    int n = items[p2];
                    if (!this.isUsed[n] & !this.isUsed[c]) {
                        float fontDiff = this.fontSize[n] - this.fontSize[c];
                        if (fontDiff < 0.0f) {
                            fontDiff = -fontDiff;
                        }
                        if (fontDiff == 0.0f && midX > this.f_x1[n] && midX < this.f_x2[n] && Math.abs(this.f_x2[n] - this.f_x1[n] - (this.f_x2[c] - this.f_x1[c])) < 10.0f && midY < this.f_y1[n] && midY > this.f_y2[n]) {
                            this.isUsed[n] = true;
                        } else {
                            boolean b_in_a;
                            boolean a_in_b = this.f_x1[n] > this.f_x1[c] && this.f_x2[n] < this.f_x2[c] && this.f_y1[n] < this.f_y1[c] && this.f_y2[n] > this.f_y2[c];
                            boolean bl = b_in_a = this.f_x1[c] > this.f_x1[n] && this.f_x2[c] < this.f_x2[n] && this.f_y1[c] < this.f_y1[n] && this.f_y2[c] > this.f_y2[n];
                            if (a_in_b | b_in_a) {
                                if (this.f_y2[c] > this.f_y2[n]) {
                                    separator = this.getLineDownSeparator(n, c, this.content[c], this.content[n]);
                                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                                        this.merge(c, n, separator, true);
                                    }
                                } else {
                                    separator = this.getLineDownSeparator(n, c, this.content[n], this.content[c]);
                                    if (!avoidSpaces || separator.indexOf(32) == -1) {
                                        this.merge(n, c, separator, true);
                                    }
                                }
                                midX = (this.f_x1[c] + this.f_x2[c]) / 2.0f;
                                midY = (this.f_y1[c] + this.f_y2[c]) / 2.0f;
                            }
                        }
                    }
                    ++p2;
                }
            }
            ++p;
        }
    }

    private final String isGapASpace(int c, int l, float actualGap, boolean addMultiplespaceXMLTag, int writingMode) {
        String sep = "";
        float gapA = this.spaceWidth[c] * (float)this.fontSize[c];
        float gapB = this.spaceWidth[l] * (float)this.fontSize[l];
        float gap = gapA > gapB ? gapB : gapA;
        int spaceCount = 0;
        if (PdfStreamDecoder.runningStoryPad) {
            spaceCount = (int)(actualGap / (gap / 1000.0f));
        } else {
            if ((gap = actualGap / (gap / 1000.0f)) > 0.6f && gap < 1.0f) {
                gap = 1.0f;
            }
            spaceCount = (int)gap;
        }
        if (spaceCount > 0) {
            sep = " ";
        }
        if (spaceCount > 1 && addMultiplespaceXMLTag && writingMode == 0 | oldTextExtraction) {
            sep = " <SpaceCount space=\"" + spaceCount + "\" />";
        }
        return sep;
    }

    public final void cleanupText(PdfData pdf_data) {
        this.pdf_data = pdf_data;
        this.copyToArrays();
        this.removeEncoding();
        this.writeFromArrays();
    }

    private final void merge(int m, int c, String separator, boolean moveFont) {
        if (this.f_x1[m] > this.f_x1[c]) {
            this.f_x1[m] = this.f_x1[c];
        }
        if (this.f_y1[m] < this.f_y1[c]) {
            this.f_y1[m] = this.f_y1[c];
        }
        if (this.f_x2[m] < this.f_x2[c]) {
            this.f_x2[m] = this.f_x2[c];
        }
        if (this.f_y2[m] > this.f_y2[c]) {
            this.f_y2[m] = this.f_y2[c];
        }
        if (PdfDecoder.isXMLExtraction()) {
            String test = Fonts.fe;
            if (this.colorExtracted) {
                test = String.valueOf(Fonts.fe) + "</color>";
            }
            if (moveFont && this.content[m].toString().endsWith(test)) {
                this.content[m] = new StringBuffer(this.content[m].substring(0, this.content[m].length() - test.length()));
                this.content[m].append(separator);
                this.content[m].append(test);
            } else {
                this.content[m].append(separator);
            }
        }
        this.fontSize[m] = this.fontSize[c];
        this.content[m] = this.content[m].append(this.content[c]);
        this.textLength[m] = this.textLength[m] + this.textLength[c];
        this.isUsed[c] = true;
        this.content[c] = null;
    }

    private final void writeFromArrays() {
        int count = 1;
        int[] items = this.getUnusedFragments();
        count = items.length;
        Vector updatedData = new Vector();
        int pointer = 0;
        while (pointer < count) {
            int i = items[pointer];
            StringBuffer processedValue = this.content[i];
            int y1 = (int)this.f_y1[i];
            int y2 = (int)this.f_y2[i];
            if (y1 < y2) {
                int temp = y1;
                y1 = y2;
                y2 = temp;
            }
            if (processedValue.toString().trim().length() > 0) {
                Hashtable<String, CharSequence> new_value = new Hashtable<String, CharSequence>();
                if (PdfDecoder.isXMLExtraction()) {
                    processedValue = new StringBuffer(Fonts.cleanupTokens(processedValue.toString()));
                }
                new_value.put("content", processedValue);
                new_value.put("x1", String.valueOf(this.f_x1[i]));
                new_value.put("x2", String.valueOf(this.f_x2[i]));
                new_value.put("y1", String.valueOf(this.f_y1[i]));
                new_value.put("y2", String.valueOf(this.f_y2[i]));
                if (this.colorExtracted) {
                    new_value.put("color", this.f_colorTag[i]);
                }
                updatedData.add(new_value);
            }
            ++pointer;
        }
        this.pdf_data.resetTextList(updatedData);
    }

    private final void removeEncoding() {
        int[] items = this.getUnusedFragments();
        int count = items.length;
        int p = 0;
        while (p < count) {
            int current = items[p];
            if (!this.isUsed[current]) {
                this.content[current] = this.removeHiddenMarkers(current);
            }
            ++p;
        }
    }

    private final void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int count = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[count];
        this.fontSize = new int[count];
        this.writingMode = new int[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuffer[count];
        this.textLength = new int[count];
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        this.moveType = new int[count];
        int i = 0;
        while (i < count) {
            this.content[i] = new StringBuffer(this.pdf_data.contents[i]);
            this.fontSize[i] = this.pdf_data.f_end_font_size[i];
            this.writingMode[i] = this.pdf_data.f_writingMode[i];
            this.f_x1[i] = this.pdf_data.f_x1[i];
            this.f_colorTag[i] = this.pdf_data.colorTag[i];
            this.f_x2[i] = this.pdf_data.f_x2[i];
            this.f_y1[i] = this.pdf_data.f_y1[i];
            this.f_y2[i] = this.pdf_data.f_y2[i];
            this.moveType[i] = this.pdf_data.move_command[i];
            this.spaceWidth[i] = this.pdf_data.space_width[i];
            this.textLength[i] = this.pdf_data.text_length[i];
            ++i;
        }
    }

    private int[] getUnusedFragments() {
        int total_fragments = this.isUsed.length;
        int ii = 0;
        int[] temp_index = new int[total_fragments];
        int i = 0;
        while (i < total_fragments) {
            if (!this.isUsed[i]) {
                temp_index[ii] = i;
                ++ii;
            }
            ++i;
        }
        int[] items = new int[ii];
        System.arraycopy(temp_index, 0, items, 0, ii);
        return items;
    }

    private StringBuffer removeHiddenMarkers(int c) {
        if (this.content[c].indexOf(MARKER) == -1) {
            return this.content[c];
        }
        StringTokenizer tokens = new StringTokenizer(this.content[c].toString(), MARKER, true);
        StringBuffer processedData = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String temp = tokens.nextToken();
            if (temp.equals(MARKER)) {
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                processedData = processedData.append(tokens.nextToken());
                continue;
            }
            processedData = processedData.append(temp);
        }
        return processedData;
    }

    /*
     * Unable to fully structure code
     */
    private float scanLineForValue(StringBuffer[] rawContents, StringBuffer line, String value, int x1, boolean isCaseSensitive) {
        block20: {
            block19: {
                lastWord = null;
                pointer = 0;
                end = line.length();
                chars = line.toString().toCharArray();
                if (this.includeTease) {
                    this.tease = new StringBuffer();
                    lastWord = new StringBuffer();
                }
                x = -1.0f;
                finalX = -1.0f;
                currentX = 0.0f;
                processed_data = new StringBuffer();
                if (isCaseSensitive) break block19;
                value = value.toLowerCase();
                break block19;
                while (chars[pointer] != PdfGroupingAlgorithms.MARKER2) {
                    ++pointer;
lbl17:
                    // 2 sources

                    ** while (pointer >= end)
lbl18:
                    // 1 sources

                }
lbl19:
                // 2 sources

                if (chars[pointer] != PdfGroupingAlgorithms.MARKER2) break block19;
                startPointer = ++pointer;
                while (pointer < end) {
                    if (chars[pointer] == PdfGroupingAlgorithms.MARKER2) break;
                    ++pointer;
                }
                currentX = Float.parseFloat(line.substring(startPointer, pointer));
                startPointer = ++pointer;
                while (pointer < end) {
                    if (chars[pointer] == PdfGroupingAlgorithms.MARKER2) break;
                    ++pointer;
                }
                width = line.substring(startPointer, pointer);
                startPointer = ++pointer;
                while (pointer < end) {
                    if (chars[pointer] == PdfGroupingAlgorithms.MARKER2) break;
                    ++pointer;
                }
                text = line.substring(startPointer, pointer);
                if (currentX < (float)x1) break block19;
                hasToken = false;
                if (PdfDecoder.isXMLExtraction() && (p = text.indexOf(60)) != -1) {
                    if (text.indexOf("<link:") != -1) {
                        hasToken = true;
                    }
                    text = text.substring(0, p);
                }
                if (this.includeTease) {
                    i = lastWord.lastIndexOf(" ");
                    if (i != -1 && text.indexOf(32) != -1) {
                        lastWord = new StringBuffer(lastWord.substring(i + 1, lastWord.length()));
                    }
                    lastWord.append(text);
                    if (hasToken) {
                        lastWord.append(' ');
                    }
                }
                processed_data.append(text);
                test = processed_data.toString();
                if (!isCaseSensitive) {
                    test = test.toLowerCase();
                }
                if (x == -1.0f | test.length() == 0) {
                    x = currentX;
                }
                if (test.indexOf(value) != -1) {
                    finalX = x;
                    this.endX = currentX + Float.parseFloat(width);
                    if (this.includeTease) {
                        this.tease.append(Strip.stripXML(lastWord));
                        if (lastWord.toString().endsWith(" ")) {
                            this.tease.append(' ');
                        }
                        this.createTease(rawContents, line, pointer, end);
                    }
                } else if (!value.startsWith(test)) {
                    processed_data = new StringBuffer();
                    x = -1.0f;
                    if (text.equals(" ")) {
                        lastWord = new StringBuffer();
                    }
                }
                if (finalX >= 0.0f) break block20;
            }
            if (pointer < end) ** GOTO lbl17
        }
        return finalX;
    }

    /*
     * Unable to fully structure code
     */
    private void createTease(StringBuffer[] rawContent, StringBuffer line, int pointer, int end) {
        block11: {
            startPointer = 0;
            wordCount = 3;
            teaseLine = line;
            text = "";
            match = false;
            break block11;
            while (teaseLine.charAt(pointer) != PdfGroupingAlgorithms.MARKER2) {
                ++pointer;
lbl9:
                // 2 sources

                ** while (pointer >= end)
lbl10:
                // 1 sources

            }
lbl11:
            // 2 sources

            hasLink = false;
            if (teaseLine.charAt(pointer) == PdfGroupingAlgorithms.MARKER2 | pointer == 0) {
                ++pointer;
                j = 0;
                while (j < 3) {
                    startPointer = pointer;
                    while (pointer < end) {
                        if (teaseLine.charAt(pointer) == PdfGroupingAlgorithms.MARKER2) break;
                        ++pointer;
                    }
                    ++pointer;
                    ++j;
                }
                text = teaseLine.substring(startPointer, --pointer);
                if (PdfDecoder.isXMLExtraction()) {
                    p = text.indexOf("<link:");
                    if (p != -1) {
                        end1 = text.indexOf(62, p);
                        id = Integer.parseInt(text.substring(p + 6, end1));
                        pointer = 0;
                        teaseLine = rawContent[id];
                        end = teaseLine.length();
                        hasLink = true;
                    }
                    if ((p = text.indexOf(60)) != -1) {
                        text = text.substring(0, p);
                    }
                }
            }
            if (text.equals(" ")) {
                --wordCount;
            }
            this.tease.append(Strip.stripXML(text));
            if (text.endsWith(" ")) {
                this.tease.append(' ');
            }
            if (hasLink && (lastChar = text.charAt(text.length() - 1)) != '-' && lastChar != ' ') {
                this.tease.append(' ');
            }
        }
        if (pointer < end && wordCount > 0) ** GOTO lbl9
    }

    public static String removeHiddenMarkers(String contents) {
        if (contents == null) {
            return null;
        }
        if (contents.indexOf(MARKER) == -1) {
            return contents;
        }
        StringTokenizer tokens = new StringTokenizer(contents, MARKER, true);
        StringBuffer processed_data = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String temp_token = tokens.nextToken();
            if (temp_token.equals(MARKER)) {
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                tokens.nextToken();
                processed_data = processed_data.append(tokens.nextToken());
                continue;
            }
            processed_data = processed_data.append(temp_token);
        }
        return processed_data.toString();
    }

    private void findVerticalLines(float minX, float minY, float maxX, float maxY, int currentWritingMode) throws PdfException {
        HashMap<Integer, Integer> xLines = new HashMap<Integer, Integer>();
        int most_frequent = 0;
        int count = this.pdf_data.getRawTextElementCount();
        String raw = "";
        int i = 0;
        while (i < count) {
            float y2;
            float y1;
            float x2;
            float x1;
            float currentX = 0.0f;
            float lastX = 0.0f;
            raw = this.pdf_data.contents[i];
            if (oldTextExtraction | currentWritingMode == 0) {
                x1 = this.f_x1[i];
                x2 = this.f_x2[i];
                y1 = this.f_y1[i];
                y2 = this.f_y2[i];
            } else if (currentWritingMode == 1) {
                x2 = this.f_x1[i];
                x1 = this.f_x2[i];
                y1 = this.f_y1[i];
                y2 = this.f_y2[i];
            } else if (currentWritingMode == 3) {
                x1 = this.f_y1[i];
                x2 = this.f_y2[i];
                y1 = this.f_x2[i];
                y2 = this.f_x1[i];
            } else if (currentWritingMode == 2) {
                x1 = this.f_y2[i];
                x2 = this.f_y1[i];
                y2 = this.f_x1[i];
                y1 = this.f_x2[i];
            } else {
                throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
            }
            if ((double)x1 > (double)minX - 0.5 && (double)x2 < (double)maxX + 0.5 && (double)y2 > (double)minY - 0.5 && (double)y1 < (double)maxY + 0.5) {
                StringTokenizer tokens = new StringTokenizer(raw, MARKER, true);
                String value = "";
                String lastValue = "";
                Object currentValue = null;
                while (tokens.hasMoreTokens()) {
                    value = tokens.nextToken();
                    if (!value.equals(MARKER)) continue;
                    value = tokens.nextToken();
                    if (value.length() > 0) {
                        lastX = currentX;
                        currentX = Float.parseFloat(value);
                        try {
                            if (lastValue.length() == 0 || lastValue.indexOf(32) != -1) {
                                Integer intX = new Integer((int)currentX);
                                currentValue = xLines.get(intX);
                                if (currentValue == null) {
                                    xLines.put(intX, new Integer(1));
                                } else {
                                    int countReached = currentValue;
                                    if (++countReached > most_frequent) {
                                        most_frequent = countReached;
                                    }
                                    xLines.put(intX, new Integer(countReached));
                                }
                                int middle = (int)(lastX + (currentX - lastX) / 2.0f);
                                if (lastX != 0.0f) {
                                    intX = new Integer(middle);
                                    currentValue = xLines.get(intX);
                                    if (currentValue == null) {
                                        xLines.put(intX, new Integer(1));
                                    } else {
                                        int count_reached = currentValue;
                                        if (++count_reached > most_frequent) {
                                            most_frequent = count_reached;
                                        }
                                        xLines.put(intX, new Integer(count_reached));
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception " + e + " stripping x values");
                        }
                    }
                    String marker = tokens.nextToken();
                    marker = tokens.nextToken();
                    marker = tokens.nextToken();
                    lastValue = value = tokens.nextToken();
                }
            }
            ++i;
        }
        Iterator keys = xLines.keySet().iterator();
        int minimum_needed = most_frequent / 2;
        while (keys.hasNext()) {
            Integer current_key = (Integer)keys.next();
            int current_count = (Integer)xLines.get(current_key);
            if (current_count <= minimum_needed) continue;
            this.lineBreaks.addElement(current_key);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void copyToArrays(float minX, float minY, float maxX, float maxY, boolean keepFont, boolean breakOnSpace, boolean findLines, String punctuation, boolean isWordlist) throws PdfException {
        debugSplit = false;
        count = this.pdf_data.getRawTextElementCount() + 100;
        this.f_x1 = new float[count];
        this.f_colorTag = new String[count];
        this.hadSpace = new boolean[count];
        this.f_x2 = new float[count];
        this.f_y1 = new float[count];
        this.f_y2 = new float[count];
        this.spaceWidth = new float[count];
        this.content = new StringBuffer[count];
        this.fontSize = new int[count];
        this.textLength = new int[count];
        this.writingMode = new int[count];
        this.isUsed = new boolean[count];
        this.moveType = new int[count];
        linesScanned = false;
        count -= 100;
        linePos = -1.0f;
        character_spacing = 0.0f;
        raw = "";
        char_width = "";
        currentColor = "";
        text = new StringBuffer();
        i = 0;
        while (i < count) {
            block83: {
                character_spacing = this.pdf_data.f_character_spacing[i];
                raw = this.pdf_data.contents[i];
                x1 = this.pdf_data.f_x1[i];
                currentColor = this.pdf_data.colorTag[i];
                x2 = this.pdf_data.f_x2[i];
                y1 = this.pdf_data.f_y1[i];
                y2 = this.pdf_data.f_y2[i];
                text_length = this.pdf_data.text_length[i];
                mode = this.pdf_data.f_writingMode[i];
                moveType = this.pdf_data.move_command[i];
                accepted = false;
                if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0 | mode == 1 && y2 > minY && y1 < maxY && x1 < maxX && x2 > minX) {
                    accepted = true;
                } else if (!PdfGroupingAlgorithms.oldTextExtraction && mode == 3 | mode == 2 && x1 > minX && x2 < maxX && y1 > minY && y2 < maxY) {
                    accepted = true;
                }
                if (!accepted) break block83;
                if (!linesScanned && findLines) {
                    this.findVerticalLines(minX, minY, maxX, maxY, mode);
                    linesScanned = true;
                }
                if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0 | mode == 1) {
                    space = (x2 - x1) / (float)text_length;
                    pt = x1;
                    last_pt = x1;
                    min = minX;
                    max = maxX;
                } else {
                    space = (y1 - y2) / (float)text_length;
                    pt = y2;
                    last_pt = y2;
                    min = minY;
                    max = maxY;
                }
                linePos = -1.0f;
                line = raw.toCharArray();
                end = line.length;
                pointer = 0;
                value = "";
                textValue = "";
                pt_reached = "";
                resetPointer = false;
                if (raw.indexOf(PdfGroupingAlgorithms.MARKER) == -1) {
                    text = new StringBuffer(raw);
                }
                isFirstValue = true;
                while (pointer < end) {
                    do {
                        block84: {
                            if (line[pointer] == PdfGroupingAlgorithms.MARKER2) ** GOTO lbl79
                            startPointer = pointer;
                            while (pointer < end && line[pointer] != PdfGroupingAlgorithms.MARKER2) {
                                ++pointer;
                            }
                            value = raw.substring(startPointer, pointer);
                            break block84;
lbl-1000:
                            // 1 sources

                            {
                                ++pointer;
lbl79:
                                // 2 sources

                                ** while (pointer < end && line[pointer] != PdfGroupingAlgorithms.MARKER2)
                            }
lbl80:
                            // 1 sources

                            startPointer = ++pointer;
                            while (pointer < end && line[pointer] != PdfGroupingAlgorithms.MARKER2) {
                                ++pointer;
                            }
                            pt_reached = raw.substring(startPointer, pointer);
                            startPointer = ++pointer;
                            while (pointer < end && line[pointer] != PdfGroupingAlgorithms.MARKER2) {
                                ++pointer;
                            }
                            char_width = raw.substring(startPointer, pointer);
                            startPointer = ++pointer;
                            while (pointer < end && line[pointer] != PdfGroupingAlgorithms.MARKER2) {
                                ++pointer;
                            }
                            textValue = value = raw.substring(startPointer, pointer);
                            if (pt_reached.length() > 0) {
                                last_pt = pt;
                                pt = Float.parseFloat(pt_reached);
                            }
                            if (PdfDecoder.isXMLExtraction() && last_pt < min && pt > min && !value.startsWith(Fonts.fb)) {
                                value = String.valueOf(Fonts.getActiveFontTag(raw, "")) + value;
                            }
                        }
                        if (pt > min & pt < max) break;
                        value = "";
                        textValue = "";
                    } while (pointer < end);
                    if (isFirstValue) {
                        isFirstValue = false;
                        if (PdfDecoder.isXMLExtraction() && keepFont && !value.startsWith(Fonts.fb) && !value.startsWith("<color ")) {
                            text.append(Fonts.getActiveFontTag(text.toString(), raw));
                        }
                    }
                    if (resetPointer) {
                        resetPointer = false;
                        if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0) {
                            x1 = pt;
                        } else if (mode == 1) {
                            x2 = pt;
                        } else if (mode == 3) {
                            y2 = pt;
                        } else if (mode == 2) {
                            y1 = pt;
                        }
                    }
                    is_broken = false;
                    if (findLines && character_spacing > 0.0f && text.toString().endsWith(" ")) {
                        counts = this.lineBreaks.size();
                        jj = 0;
                        while (jj < counts) {
                            test_x = this.lineBreaks.elementAt(jj);
                            if (last_pt < (float)test_x & pt > (float)test_x) {
                                jj = counts;
                                is_broken = true;
                            }
                            ++jj;
                        }
                    }
                    endsWithPunctuation = this.checkForPunctuation(textValue, punctuation);
                    if (is_broken) {
                        Nx1 = x1;
                        Nx2 = x2;
                        Ny1 = y1;
                        Ny2 = y2;
                        if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0) {
                            Nx2 = last_pt + Float.parseFloat(char_width);
                        } else if (mode == 1) {
                            Nx1 = last_pt + Float.parseFloat(char_width);
                        } else if (mode == 3) {
                            Ny1 = last_pt + Float.parseFloat(char_width);
                        } else if (mode == 2) {
                            Ny2 = last_pt + Float.parseFloat(char_width);
                        }
                        this.addFragment(moveType, i, text, Nx1, Nx2, Ny1, Ny2, text_length, keepFont, currentColor, isWordlist);
                        text = new StringBuffer(Fonts.getActiveFontTag(text.toString(), raw));
                        text.append(value);
                        if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0) {
                            x1 = pt;
                            continue;
                        }
                        if (mode == 1) {
                            x2 = pt;
                            continue;
                        }
                        if (mode == 3) {
                            y2 = pt;
                            continue;
                        }
                        if (mode != 2) continue;
                        y1 = pt;
                        continue;
                    }
                    if (endsWithPunctuation | (breakOnSpace != false && (textValue.indexOf(32) != -1 || value.endsWith(" ") != false)) | textValue.indexOf("   ") != -1) {
                        if (!endsWithPunctuation) {
                            text.append(value.trim());
                        }
                        if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0) {
                            this.addFragment(moveType, i, text, x1, pt, y1, y2, text_length, keepFont, currentColor, isWordlist);
                        } else if (mode == 1) {
                            this.addFragment(moveType, i, text, pt, x2, y1, y2, text_length, keepFont, currentColor, isWordlist);
                        } else if (mode == 3) {
                            this.addFragment(moveType, i, text, x1, x2, pt, y2, text_length, keepFont, currentColor, isWordlist);
                        } else if (mode == 2) {
                            this.addFragment(moveType, i, text, x1, x2, y1, pt, text_length, keepFont, currentColor, isWordlist);
                        }
                        if (char_width.length() > 0) {
                            pt += Float.parseFloat(char_width);
                        }
                        if (breakOnSpace & this.nextSlot > 0) {
                            this.hadSpace[this.nextSlot - 1] = true;
                        }
                        text = new StringBuffer(Fonts.getActiveFontTag(text.toString(), raw));
                        if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0) {
                            x1 = pt;
                            continue;
                        }
                        if (mode == 1) {
                            x2 = pt;
                            continue;
                        }
                        if (mode == 3) {
                            y2 = pt;
                            continue;
                        }
                        if (mode != 2) continue;
                        y1 = pt;
                        continue;
                    }
                    if (linePos != -1.0f & pt > linePos) {
                        if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0) {
                            this.addFragment(moveType, i, text, x1, linePos, y1, y2, text_length, keepFont, currentColor, isWordlist);
                        } else if (mode == 1) {
                            this.addFragment(moveType, i, text, linePos, x2, y1, y2, text_length, keepFont, currentColor, isWordlist);
                        } else if (mode == 3) {
                            this.addFragment(moveType, i, text, x1, x2, linePos, y2, text_length, keepFont, currentColor, isWordlist);
                        } else if (mode == 2) {
                            this.addFragment(moveType, i, text, x1, x2, y1, linePos, text_length, keepFont, currentColor, isWordlist);
                        }
                        text = new StringBuffer(Fonts.getActiveFontTag(text.toString(), raw));
                        text.append(value);
                        if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0) {
                            x1 = linePos;
                        } else if (mode == 1) {
                            x2 = linePos;
                        } else if (mode == 3) {
                            y2 = linePos;
                        } else if (mode == 2) {
                            y1 = linePos;
                        }
                        linePos = -1.0f;
                        continue;
                    }
                    if (PdfDecoder.isXMLExtraction() && value.endsWith(String.valueOf(' ') + Fonts.fe)) {
                        value = Fonts.fe;
                        textValue = "";
                        if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0) {
                            x2 = last_pt;
                        } else if (mode == 1) {
                            x1 = last_pt;
                        } else if (mode == 3) {
                            y1 = last_pt;
                        } else if (mode == 2) {
                            y2 = last_pt;
                        }
                    }
                    text.append(value);
                }
                if (keepFont && PdfDecoder.isXMLExtraction() && !text.toString().endsWith(Fonts.fe) && !text.toString().endsWith("</color>")) {
                    text.append(Fonts.fe);
                }
                if (PdfGroupingAlgorithms.oldTextExtraction | mode == 0 | mode == 1) {
                    if (x1 < x2) {
                        this.addFragment(moveType, i, text, x1, x2, y1, y2, text_length, keepFont, currentColor, isWordlist);
                    }
                } else if (PdfGroupingAlgorithms.oldTextExtraction | mode == 3 | mode == 2 && y1 > y2) {
                    this.addFragment(moveType, i, text, x1, x2, y1, y2, text_length, keepFont, currentColor, isWordlist);
                }
                text = new StringBuffer();
            }
            ++i;
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private boolean checkForPunctuation(String textValue, String punctuation) {
        if (punctuation == null) {
            return false;
        }
        boolean endsWithPunctuation = false;
        int textLength = textValue.length();
        int ii = textLength - 1;
        if (textLength > 0) {
            char testChar = textValue.charAt(ii);
            boolean inTag = testChar == '>';
            while ((inTag | testChar == ' ') & ii > 0) {
                if (testChar == '<') {
                    inTag = false;
                }
                if ((testChar = textValue.charAt(--ii)) != '>') continue;
                inTag = true;
            }
            if (testChar == ';') {
                endsWithPunctuation = true;
                --ii;
                while (ii > -1) {
                    testChar = textValue.charAt(ii);
                    if (testChar == '&' || testChar == '#') {
                        endsWithPunctuation = false;
                        ii = 0;
                    }
                    if (ii != 0 && testChar != ' ' && Character.isJavaLetterOrDigit(testChar)) {
                        --ii;
                        continue;
                    }
                    break;
                }
            } else if (punctuation.indexOf(testChar) != -1) {
                endsWithPunctuation = true;
            }
        }
        return endsWithPunctuation;
    }

    private void addFragment(int moveType, int index, StringBuffer contentss, float x1, float x2, float y1, float y2, int text_len, boolean keepFontTokens, String currentColorTag, boolean isWordlist) {
        StringBuffer current_text = contentss;
        String str = current_text.toString();
        if (isWordlist) {
            if (str.indexOf("&#") != -1) {
                current_text = Strip.stripAmpHash(current_text);
            }
            if (PdfDecoder.isXMLExtraction() && (str.indexOf("&lt;") != -1 || str.indexOf("&gt;") != -1)) {
                current_text = Strip.stripXMLArrows(current_text);
            } else if (!(PdfDecoder.isXMLExtraction() || str.indexOf(60) == -1 && str.indexOf(62) == -1)) {
                current_text = Strip.stripArrows(current_text);
            }
        }
        if (this.getFirstChar(current_text) != -1) {
            if (!keepFontTokens) {
                current_text = Strip.stripXML(current_text);
            } else if (PdfDecoder.isXMLExtraction()) {
                if (this.pdf_data.isColorExtracted() && !current_text.toString().endsWith("</color>")) {
                    if (!current_text.toString().endsWith(Fonts.fe)) {
                        current_text = current_text.append(Fonts.fe);
                    }
                    current_text = current_text.append("</color>");
                } else if (!this.pdf_data.isColorExtracted() && !current_text.toString().endsWith(Fonts.fe)) {
                    current_text = current_text.append(Fonts.fe);
                }
            }
            int count = this.f_x1.length;
            if (this.nextSlot < count) {
                this.f_x1[this.nextSlot] = x1;
                this.f_colorTag[this.nextSlot] = currentColorTag;
                this.f_x2[this.nextSlot] = x2;
                this.f_y1[this.nextSlot] = y1;
                this.f_y2[this.nextSlot] = y2;
                this.moveType[this.nextSlot] = moveType;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
                this.textLength[this.nextSlot] = text_len;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
                this.content[this.nextSlot] = current_text;
                ++this.nextSlot;
            } else {
                float[] t_x1 = new float[count += 100];
                String[] t_colorTag = new String[count];
                float[] t_x2 = new float[count];
                float[] t_y1 = new float[count];
                float[] t_y2 = new float[count];
                float[] t_spaceWidth = new float[count];
                StringBuffer[] t_content = new StringBuffer[count];
                int[] t_font_size = new int[count];
                int[] t_text_len = new int[count];
                int[] t_writingMode = new int[count];
                int[] t_moveType = new int[count];
                boolean[] t_isUsed = new boolean[count];
                boolean[] t_hadSpace = new boolean[count];
                int i = 0;
                while (i < count - 100) {
                    t_x1[i] = this.f_x1[i];
                    t_colorTag[i] = this.f_colorTag[i];
                    t_x2[i] = this.f_x2[i];
                    t_y1[i] = this.f_y1[i];
                    t_y2[i] = this.f_y2[i];
                    t_hadSpace[i] = this.hadSpace[i];
                    t_spaceWidth[i] = this.spaceWidth[i];
                    t_content[i] = this.content[i];
                    t_font_size[i] = this.fontSize[i];
                    t_writingMode[i] = this.writingMode[i];
                    t_text_len[i] = this.textLength[i];
                    t_isUsed[i] = this.isUsed[i];
                    t_moveType[i] = this.moveType[i];
                    ++i;
                }
                this.f_x1 = t_x1;
                this.f_colorTag = t_colorTag;
                this.hadSpace = t_hadSpace;
                this.f_x2 = t_x2;
                this.f_y1 = t_y1;
                this.f_y2 = t_y2;
                this.isUsed = t_isUsed;
                this.fontSize = t_font_size;
                this.writingMode = t_writingMode;
                this.textLength = t_text_len;
                this.spaceWidth = t_spaceWidth;
                this.content = t_content;
                this.moveType = t_moveType;
                this.f_x1[this.nextSlot] = x1;
                this.f_colorTag[this.nextSlot] = currentColorTag;
                this.f_x2[this.nextSlot] = x2;
                this.f_y1[this.nextSlot] = y1;
                this.f_y2[this.nextSlot] = y2;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[index];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[index];
                t_text_len[this.nextSlot] = text_len;
                this.content[this.nextSlot] = current_text;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[index];
                this.moveType[this.nextSlot] = moveType;
                ++this.nextSlot;
            }
        }
    }

    private void mergeTableRows(int border_width) {
        String separator = "\n";
        separator = "</tr>\n<tr>";
        if (!this.isXHTML) {
            separator = "\n";
        }
        this.master = ((Vector_Int)this.lines.elementAt(this.line_order[0])).elementAt(0);
        int rr = 1;
        while (rr < this.max_rows) {
            int item = ((Vector_Int)this.lines.elementAt(this.line_order[rr])).elementAt(0);
            if (this.content[this.master] == null) {
                this.master = item;
            } else if (this.content[item] != null) {
                this.merge(this.master, item, separator, false);
            }
            ++rr;
        }
        if (this.isXHTML) {
            if (border_width == 0) {
                this.content[this.master].insert(0, "<TABLE>\n<tr>");
                this.content[this.master].append("</tr>\n</TABLE>\n");
            } else {
                StringBuffer startTag = new StringBuffer("<TABLE border='");
                startTag.append(String.valueOf(border_width));
                startTag.append("'>\n<tr>");
                startTag.append(this.content[this.master]);
                this.content[this.master] = startTag;
                this.content[this.master].append("</tr>\n</TABLE>\n");
            }
        }
    }

    private final int[] getsortedUnusedFragments(boolean sortOnX, boolean use_y1) {
        int total_fragments = this.isUsed.length;
        int ii = 0;
        int[] sorted_temp_index = new int[total_fragments];
        int i = 0;
        while (i < total_fragments) {
            if (!this.isUsed[i]) {
                sorted_temp_index[ii] = i;
                ++ii;
            }
            ++i;
        }
        int[] unsorted_items = new int[ii];
        int[] sorted_items = null;
        int[] sorted_temp_x1 = new int[ii];
        int[] sorted_temp_y1 = new int[ii];
        int[] sorted_temp_y2 = new int[ii];
        int pointer = 0;
        while (pointer < ii) {
            int i2;
            unsorted_items[pointer] = i2 = sorted_temp_index[pointer];
            sorted_temp_x1[pointer] = (int)this.f_x1[i2];
            sorted_temp_y1[pointer] = (int)this.f_y1[i2];
            sorted_temp_y2[pointer] = (int)this.f_y2[i2];
            ++pointer;
        }
        sorted_items = !sortOnX ? (use_y1 ? Sorts.quicksort(sorted_temp_y1, sorted_temp_x1, unsorted_items) : Sorts.quicksort(sorted_temp_y2, sorted_temp_x1, unsorted_items)) : Sorts.quicksort(sorted_temp_x1, sorted_temp_y1, unsorted_items);
        return sorted_items;
    }

    private void createTableRows(boolean keep_alignment_information, boolean keep_width_information, int currentWritingMode) throws PdfException {
        int item;
        boolean all_done;
        float[] f_x1 = null;
        float[] f_x2 = null;
        float[] f_y1 = null;
        float[] f_y2 = null;
        if (oldTextExtraction | currentWritingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (currentWritingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (currentWritingMode == 3) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (currentWritingMode == 2) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
            int maxX = 0;
            int ii = 0;
            while (ii < f_x1.length) {
                if ((float)maxX < f_x1[ii]) {
                    maxX = (int)f_x1[ii];
                }
                ++ii;
            }
            ++maxX;
            ii = 0;
            while (ii < f_x2.length) {
                f_x1[ii] = (float)maxX - f_x1[ii];
                f_x2[ii] = (float)maxX - f_x2[ii];
                ++ii;
            }
        } else {
            throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
        }
        int current_col = -1;
        int itemsInTable = 0;
        int items_added = 0;
        int[] currentItem = new int[this.max_rows];
        Vector_Int[] rowContents = new Vector_Int[this.max_rows];
        Vector_String alignments = new Vector_String();
        Vector_Float widths = new Vector_Float();
        Vector_Float cell_x1 = new Vector_Float();
        String separator = "";
        String empty_cell = "&nbsp;";
        if (!this.isXHTML) {
            separator = "\",\"";
            empty_cell = "";
        }
        int[] itemCount = new int[this.max_rows];
        int i = 0;
        while (i < this.max_rows) {
            itemCount[i] = ((Vector_Int)this.lines.elementAt(i)).size() - 1;
            itemsInTable += itemCount[i];
            currentItem[i] = 0;
            rowContents[i] = new Vector_Int(20);
            ++i;
        }
        do {
            float x1 = 9999.0f;
            float min_x2 = 9999.0f;
            float x2 = 9999.0f;
            float current_x1 = 0.0f;
            float current_x2 = 0.0f;
            float c_x1 = 0.0f;
            float next_x1 = 9999.0f;
            float c_x2 = 0.0f;
            float items_in_column = 0.0f;
            ++current_col;
            all_done = true;
            float total_x1 = 0.0f;
            float total_x2 = 0.0f;
            float left_gap = 0.0f;
            float right_gap = 0.0f;
            String alignment = "center";
            if (items_added >= itemsInTable) continue;
            i = 0;
            while (i < this.max_rows) {
                if (itemCount[i] > currentItem[i]) {
                    item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                    current_x1 = f_x1[item];
                    current_x2 = f_x2[item];
                    if (current_x1 < x1) {
                        x1 = current_x1;
                    }
                    if (current_x2 < min_x2) {
                        min_x2 = current_x2;
                    }
                }
                ++i;
            }
            cell_x1.addElement(x1);
            x2 = min_x2;
            i = 0;
            while (i < this.max_rows) {
                item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                c_x1 = f_x1[item];
                if (c_x1 >= x1 & c_x1 < min_x2 & (c_x2 = f_x2[item]) > x2) {
                    x2 = c_x2;
                }
                if (currentItem[i] < itemCount[i] && (current_x1 = f_x1[item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i] + 1)]) > min_x2 & current_x1 < next_x1) {
                    next_x1 = current_x1;
                }
                ++i;
            }
            if (next_x1 == 9999.0f) {
                next_x1 = x2;
            }
            i = 0;
            while (i < this.max_rows) {
                item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                c_x1 = f_x1[item];
                if (c_x1 >= x1 & c_x1 < min_x2 & (c_x2 = f_x2[item]) <= next_x1) {
                    total_x1 += c_x1;
                    total_x2 += c_x2;
                    items_in_column += 1.0f;
                }
                ++i;
            }
            if (i == 0) {
                left_gap = x1;
            }
            right_gap = next_x1 == -1.0f ? 0.0f : (float)((int)((next_x1 - x2) / 2.0f));
            int width = (int)(x2 - x1 + right_gap + left_gap);
            left_gap = right_gap;
            widths.addElement(width);
            float x1_diff = total_x1 / items_in_column - x1;
            float x2_diff = x2 - total_x2 / items_in_column;
            if (x1_diff < 1.0f) {
                alignment = "left";
            } else if (x2_diff < 1.0f) {
                alignment = "right";
            }
            alignments.addElement(alignment);
            i = 0;
            while (i < this.max_rows) {
                this.master = ((Vector_Int)this.lines.elementAt(i)).elementAt(0);
                if (itemCount[i] > currentItem[i]) {
                    item = ((Vector_Int)this.lines.elementAt(i)).elementAt(currentItem[i]);
                    c_x1 = f_x1[item];
                    c_x2 = f_x2[item];
                    all_done = false;
                } else {
                    item = -1;
                    c_x1 = -1.0f;
                    c_x2 = -1.0f;
                }
                if (item == -1 & items_added <= itemsInTable) {
                    rowContents[i].addElement(-1);
                } else if (c_x1 >= x1 & c_x1 < x2) {
                    rowContents[i].addElement(item);
                    int n = i;
                    currentItem[n] = currentItem[n] + 1;
                    ++items_added;
                } else if (c_x1 > x2) {
                    rowContents[i].addElement(-1);
                }
                ++i;
            }
        } while (!all_done);
        int row = 0;
        while (row < this.max_rows) {
            StringBuffer line_content = new StringBuffer();
            int count = rowContents[row].size() - 1;
            this.master = ((Vector_Int)this.lines.elementAt(row)).elementAt(0);
            i = 0;
            while (i < count) {
                item = rowContents[row].elementAt(i);
                if (this.isXHTML) {
                    float current_width = widths.elementAt(i);
                    String current_alignment = alignments.elementAt(i);
                    int test = -1;
                    int colspan = 1;
                    int pointer = i + 1;
                    if (item != -1) {
                        while (!((test = rowContents[row].elementAt(i + 1)) != -1 | count == i + 1) && !(itemCount[row] > 1 & cell_x1.elementAt(i + 1) > f_x2[item])) {
                            --count;
                            rowContents[row].removeElementAt(i + 1);
                            ++colspan;
                            current_width += widths.elementAt(pointer);
                            ++pointer;
                        }
                    }
                    line_content.append("<td");
                    if (keep_alignment_information) {
                        line_content.append(" align='");
                        line_content.append(current_alignment);
                        line_content.append('\'');
                        if (colspan > 1) {
                            line_content.append(" colspan='").append(colspan).append('\'');
                        }
                    }
                    if (keep_width_information) {
                        line_content.append(" width='").append((int)current_width).append('\'');
                    }
                    line_content.append(" nowrap>");
                    if (item == -1) {
                        line_content.append(empty_cell);
                    } else {
                        line_content.append(this.content[item]);
                    }
                    line_content.append("</td>");
                } else if (item == -1) {
                    line_content.append("\"\",");
                } else {
                    line_content.append('\"');
                    line_content.append(this.content[item]);
                    line_content.append("\",");
                }
                if (item != -1 && this.master != item) {
                    this.merge(this.master, item, separator, false);
                }
                ++i;
            }
            this.content[this.master] = line_content;
            ++row;
        }
    }

    private Vector_Object createLinesInTable(int itemCount, int[] items, boolean addSpaceXMLTag, int mode) throws PdfException {
        float[] f_x1 = null;
        float[] f_x2 = null;
        float[] f_y1 = null;
        float[] f_y2 = null;
        if (!oldTextExtraction && mode == 1) {
            items = this.reverse(items);
        }
        if (oldTextExtraction | mode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 3) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (mode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
            items = this.getsortedUnusedFragments(false, true);
            items = this.reverse(items);
        } else {
            throw new PdfException("Illegal value " + mode + "for currentWritingMode");
        }
        Vector_Int current_line = new Vector_Int(20);
        String separator = "";
        int current_cols = 0;
        int j = 0;
        while (j < itemCount) {
            int c = items[j];
            int id = -1;
            int last = c;
            float smallest_gap = -1.0f;
            if (!this.isUsed[c] && this.writingMode[c] == mode | oldTextExtraction) {
                current_line = new Vector_Int(20);
                current_line.addElement(c);
                this.lineY2.addElement((int)f_y2[c]);
                while (true) {
                    int ii = 0;
                    while (ii < itemCount) {
                        int i = items[ii];
                        if (!this.isUsed[i] && i != c && this.writingMode[c] == mode | oldTextExtraction && (f_x1[i] > f_x1[c] && mode != 2 | oldTextExtraction) | (f_x1[i] < f_x1[c] && !oldTextExtraction && mode == 2)) {
                            float yMidPt;
                            float gap = f_x1[i] - f_x2[c];
                            if (!oldTextExtraction && mode == 1 | mode == 2) {
                                gap = -gap;
                            }
                            if (gap < 0.0f & gap > -2.0f) {
                                gap = 0.0f;
                            }
                            if ((yMidPt = (f_y1[i] + f_y2[i]) / 2.0f) < f_y1[c] && yMidPt > f_y2[c] && smallest_gap < 0.0f | gap < smallest_gap) {
                                smallest_gap = gap;
                                id = i;
                            }
                        }
                        ++ii;
                    }
                    if (id == -1) break;
                    float t = f_x1[id] - f_x2[last];
                    float possSpace = f_x1[id] - f_x2[c];
                    float average_char1 = 1.5f * ((f_x2[id] - f_x1[id]) / (float)this.textLength[id]);
                    float average_char2 = 1.5f * ((f_x2[last] - f_x1[last]) / (float)this.textLength[last]);
                    if (!oldTextExtraction && mode == 1 | mode == 2) {
                        possSpace = -possSpace;
                        t = -t;
                        average_char1 = -average_char1;
                        average_char2 = -average_char2;
                    }
                    if (t < average_char1 & t < average_char2) {
                        separator = this.isGapASpace(id, last, possSpace, addSpaceXMLTag, mode);
                        this.merge(last, id, separator, true);
                    } else {
                        current_line.addElement(id);
                        last = id;
                    }
                    this.isUsed[id] = true;
                    id = -1;
                    smallest_gap = 1000000.0f;
                    ++current_cols;
                }
                this.lines.addElement(current_line);
                current_line = new Vector_Int(20);
                ++this.max_rows;
            }
            ++j;
        }
        return this.lines;
    }

    public final Map extractTextAsTable(int x1, int y1, int x2, int y2, int pageNumber, boolean isCSV, boolean keepFontInfo, boolean keepWidthInfo, boolean keepAlignmentInfo, int borderWidth, boolean AddCustomTags) throws PdfException {
        this.validateCoordinates(x1, y1, x2, y2);
        Hashtable<String, String> table_content = new Hashtable<String, String>();
        LogWriter.writeLog("extracting Text As Table");
        this.isXHTML = !isCSV;
        this.lines = new Vector_Object(20);
        this.lineY2 = new Vector_Int(20);
        this.max_rows = 0;
        this.copyToArrays(x1, y2, x2, y1, keepFontInfo, false, true, null, false);
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int item_count = items.length;
        if (item_count == 0) {
            return table_content;
        }
        int writingMode = this.getWritingMode(items, item_count);
        String message = "Table Merging algorithm being applied " + item_count + " items";
        LogWriter.writeLog(message);
        if (item_count > 1) {
            this.createLinesInTable(item_count, items, this.isXHTML, writingMode);
            int dx = 1;
            if (oldTextExtraction | writingMode == 0 | writingMode == 2) {
                dx = -1;
            }
            this.line_order = new int[this.max_rows];
            int[] line_y = new int[this.max_rows];
            int i = 0;
            while (i < this.max_rows) {
                line_y[i] = dx * this.lineY2.elementAt(i);
                this.line_order[i] = i;
                ++i;
            }
            this.line_order = Sorts.quicksort(line_y, this.line_order);
            this.createTableRows(keepAlignmentInfo, keepWidthInfo, writingMode);
            this.mergeTableRows(borderWidth);
        }
        this.content[this.master] = this.cleanup(this.content[this.master]);
        String processed_value = this.content[this.master].toString();
        if (processed_value != null) {
            if (!isCSV) {
                processed_value = Fonts.cleanupTokens(processed_value);
            }
            table_content.put("content", processed_value);
            table_content.put("x1", String.valueOf(x1));
            table_content.put("x2", String.valueOf(x2));
            table_content.put("y1", String.valueOf(y1));
            table_content.put("y2", String.valueOf(y2));
        }
        return table_content;
    }

    private void validateCoordinates(int x1, int y1, int x2, int y2) throws PdfException {
        if (x1 > x2 | y1 < y2) {
            String errorMessage = "Invalid parameters for text rectangle. ";
            if (x1 > x2) {
                errorMessage = String.valueOf(errorMessage) + "x1 value (" + x1 + ") must be LESS than x2 (" + x2 + "). ";
            }
            if (y1 < y2) {
                errorMessage = String.valueOf(errorMessage) + "y1 value (" + y1 + ") must be MORE than y2 (" + y2 + "). ";
            }
            throw new PdfException(errorMessage);
        }
    }

    public final Vector extractTextAsWordlist(int x1, int y1, int x2, int y2, int page_number, boolean estimateParagraphs, boolean breakFragments, String punctuation) throws PdfException {
        this.validateCoordinates(x1, y1, x2, y2);
        if (breakFragments) {
            this.copyToArrays(x1, y2, x2, y1, true, true, false, punctuation, true);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(true);
        int[] items = this.getsortedUnusedFragments(true, false);
        int count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int writingMode = this.getWritingMode(items, count);
        this.createLines(count, items, writingMode, true, false, false);
        float[] f_x1 = null;
        float[] f_x2 = null;
        float[] f_y1 = null;
        float[] f_y2 = null;
        if (useUnrotatedCoords | oldTextExtraction | writingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (writingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (writingMode == 3) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (writingMode == 2) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
        }
        Vector<String> values = new Vector<String>();
        int i = 0;
        while (i < this.content.length) {
            if (this.content[i] != null) {
                if (this.colorExtracted && PdfDecoder.isXMLExtraction()) {
                    if (!this.content[i].toString().toLowerCase().startsWith("<color ")) {
                        this.content[i].insert(0, this.f_colorTag[this.master]);
                    }
                    if (!this.content[i].toString().toLowerCase().endsWith("</color>")) {
                        this.content[i].append("</color>");
                    }
                }
                if (PdfDecoder.isXMLExtraction()) {
                    values.add(this.content[i].toString());
                } else {
                    values.add(Strip.convertToText(this.content[i].toString()));
                }
                if (!useUnrotatedCoords && writingMode == 2) {
                    values.add(String.valueOf(this.pdf_data.maxY - f_x1[i]));
                    values.add(String.valueOf(f_y1[i]));
                    values.add(String.valueOf(this.pdf_data.maxY - f_x2[i]));
                    values.add(String.valueOf(f_y2[i]));
                } else if (!useUnrotatedCoords && writingMode == 3) {
                    values.add(String.valueOf(f_x1[i]));
                    values.add(String.valueOf(this.pdf_data.maxX - f_y2[i]));
                    values.add(String.valueOf(f_x2[i]));
                    values.add(String.valueOf(this.pdf_data.maxX - f_y1[i]));
                } else {
                    values.add(String.valueOf(f_x1[i]));
                    values.add(String.valueOf(f_y1[i]));
                    values.add(String.valueOf(f_x2[i]));
                    values.add(String.valueOf(f_y2[i]));
                }
            }
            ++i;
        }
        LogWriter.writeLog("Text extraction as wordlist completed");
        return values;
    }

    private void reset() {
        this.isXHTML = true;
        this.nextSlot = 0;
        this.lineBreaks = new Vector_Int();
        this.max_rows = 0;
        this.master = 0;
        this.colorExtracted = false;
        this.tease = null;
        this.endX = 0.0f;
    }

    public final String extractTextInRectangle(int x1, int y1, int x2, int y2, int page_number, boolean estimateParagraphs, boolean breakFragments) throws PdfException {
        this.reset();
        if (breakFragments && !this.pdf_data.IsEmbedded()) {
            throw new PdfException("[PDF] Request to breakfragments and width not added. Please add call to init(true) of PdfDecoder to your code.");
        }
        this.validateCoordinates(x1, y1, x2, y2);
        String separator = "";
        int master = 0;
        int count = 0;
        if (breakFragments) {
            this.copyToArrays(x1, y2, x2, y1, PdfDecoder.isXMLExtraction(), false, false, null, false);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int writingMode = this.getWritingMode(items, count);
        this.createLines(count, items, writingMode, false, true, false);
        master = this.mergeLinesTogether(writingMode, estimateParagraphs, x1, x2, y1, y2);
        if (PdfDecoder.isXMLExtraction()) {
            this.content[master] = new StringBuffer(Fonts.cleanupTokens(this.content[master].toString()));
            this.content[master].insert(0, "<p>");
            this.content[master].append("</p>");
        }
        LogWriter.writeLog("Text extraction completed");
        return this.cleanup(this.content[master]).toString();
    }

    private StringBuffer cleanup(StringBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        return buffer;
    }

    private int getWritingMode(int[] items, int count) {
        int orientation = this.writingMode[items[0]];
        if (orientation == 0 | orientation == 1) {
            return orientation;
        }
        int j = 1;
        while (j < count) {
            int c = items[j];
            if (!this.isUsed[c] && this.writingMode[c] == 0 | this.writingMode[c] == 1) {
                orientation = this.writingMode[c];
                j = count;
                LogWriter.writeLog("Text of multiple orientations found. Only horizontal text used.");
            }
            ++j;
        }
        return orientation;
    }

    private int mergeLinesTogether(int currentWritingMode, boolean estimateParagraphs, int x1, int x2, int y1, int y2) throws PdfException {
        int middlePage;
        int[] indices;
        boolean orderIsCorrect = false;
        float[] f_x1 = null;
        float[] f_x2 = null;
        float[] f_y1 = null;
        float[] f_y2 = null;
        if (oldTextExtraction | currentWritingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
            indices = this.getsortedUnusedFragments(false, true);
            middlePage = (x1 + x2) / 2;
        } else if (currentWritingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
            indices = this.getsortedUnusedFragments(false, true);
            middlePage = (x1 + x2) / 2;
        } else if (currentWritingMode == 3) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
            indices = this.getsortedUnusedFragments(true, true);
            indices = this.reverse(indices);
            middlePage = (y1 + y2) / 2;
        } else if (currentWritingMode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x2;
            f_y1 = this.f_x1;
            indices = this.getsortedUnusedFragments(true, true);
            middlePage = (y1 + y2) / 2;
        } else {
            throw new PdfException("Illegal value " + currentWritingMode + "for currentWritingMode");
        }
        int quarter = middlePage / 2;
        int count = indices.length;
        int master = indices[count - 1];
        Object child_textX = null;
        Object master_textX = null;
        boolean debug = false;
        int i = count - 2;
        while (i > -1) {
            int child = indices[i];
            String separator = "";
            int ClastChar = this.getLastChar(this.content[child]);
            if (ClastChar != -1) {
                this.addAlignmentFormatting(estimateParagraphs, middlePage, f_x1, f_x2, quarter, child);
                String lineSpace = "</p>\n<p>";
                if (PdfDecoder.isXMLExtraction()) {
                    lineSpace = "\n";
                }
                float gap = f_y2[master] - f_y1[child];
                float line_height = f_y1[child] - f_y2[child];
                if (!oldTextExtraction && currentWritingMode == 3) {
                    gap = -gap;
                    line_height = -line_height;
                }
                if (gap > line_height & line_height > 0.0f) {
                    while (gap > line_height) {
                        separator = String.valueOf(separator) + lineSpace;
                        gap -= line_height;
                    }
                    separator = PdfDecoder.isXMLExtraction() ? String.valueOf(separator) + "</p>\n<p>" : "\n";
                } else if (estimateParagraphs) {
                    int CFirstChar = this.getFirstChar(this.content[child]);
                    int MlastChar = this.getLastChar(this.content[master]);
                    if ((MlastChar == 46 || MlastChar == 34) && CFirstChar >= 65 && CFirstChar <= 90) {
                        separator = PdfDecoder.isXMLExtraction() ? "</p>\n<p>" : "\n";
                    }
                } else if (this.IS_LEGACY) {
                    if (PdfDecoder.isXMLExtraction()) {
                        this.content[child].insert(0, "</p>\n<p>");
                    } else {
                        this.content[child].append('\n');
                    }
                } else if (PdfDecoder.isXMLExtraction()) {
                    this.content[child].insert(0, "</p>\n<p>");
                } else {
                    this.content[child].append('\n');
                }
                this.merge(master, child, separator, false);
            }
            --i;
        }
        return master;
    }

    private int getFirstChar(StringBuffer buffer) {
        int i = -1;
        boolean inTag = false;
        int count = buffer.length();
        int openChar = 32;
        int ptr = 0;
        while (ptr < count) {
            char nextChar = buffer.charAt(ptr);
            if (!inTag && (nextChar == '<' || PdfDecoder.isXMLExtraction() && nextChar == '&')) {
                inTag = true;
                openChar = nextChar;
                if (openChar == 38) {
                    if (ptr + 1 == count) {
                        i = 38;
                        ptr = count;
                    } else {
                        char c = buffer.charAt(ptr + 1);
                        if (c != '#' && c != 'g' && c != 'l') {
                            i = 38;
                            ptr = count;
                        }
                    }
                }
            }
            if (!inTag && nextChar != ' ') {
                i = nextChar;
                ptr = count;
            }
            if (inTag && openChar == 38 && nextChar == ' ') {
                i = openChar;
                ptr = count;
            } else if (inTag && (nextChar == '>' || PdfDecoder.isXMLExtraction() && openChar == 38 && nextChar == ';')) {
                if (nextChar == ';' && openChar == 38 && ptr > 2 & buffer.charAt(ptr - 1) == 't') {
                    if (buffer.charAt(ptr - 2) == 'l') {
                        i = 60;
                        ptr = count;
                    } else if (buffer.charAt(ptr - 2) == 'g') {
                        i = 62;
                        ptr = count;
                    }
                }
                inTag = false;
            }
            ++ptr;
        }
        return i;
    }

    private int getLastChar(StringBuffer buffer) {
        int i = -1;
        boolean inTag = false;
        int count = buffer.length();
        int size = count--;
        int openChar = 32;
        while (count > -1) {
            char nextChar = buffer.charAt(count);
            if (inTag && openChar == 59 && nextChar == ';') {
                i = 59;
                count = -1;
            }
            if (!inTag && (nextChar == '>' || PdfDecoder.isXMLExtraction() && nextChar == ';')) {
                inTag = true;
                openChar = nextChar;
            }
            if (!inTag && nextChar != ' ') {
                i = nextChar;
                count = -1;
            }
            if (nextChar == '<' || PdfDecoder.isXMLExtraction() && openChar == 59 && nextChar == '&') {
                inTag = false;
                if (nextChar == '&' && count + 3 < size & buffer.charAt(count + 2) == 't' && buffer.charAt(count + 3) == ';') {
                    if (buffer.charAt(count + 1) == 'l') {
                        i = 60;
                        count = -1;
                    } else if (buffer.charAt(count + 1) == 'g') {
                        i = 62;
                        count = -1;
                    }
                }
            }
            if (inTag && openChar == 59 && nextChar == ' ') {
                count = -1;
                i = 59;
            }
            --count;
        }
        return i;
    }

    private int[] reverse(int[] indices) {
        int count = indices.length;
        int[] newIndex = new int[count];
        int i = 0;
        while (i < count) {
            newIndex[i] = indices[count - i - 1];
            ++i;
        }
        return newIndex;
    }

    private void addAlignmentFormatting(boolean estimateParagraphs, int middlePage, float[] f_x1, float[] f_x2, int quarter, int child) {
        float left_gap = (float)middlePage - f_x1[child];
        float right_gap = f_x2[child] - (float)middlePage;
        if (!estimateParagraphs && PdfDecoder.isXMLExtraction() && left_gap > 0.0f && right_gap > 0.0f && f_x1[child] > (float)quarter && f_x1[child] < (float)(middlePage + quarter)) {
            float ratio = left_gap / right_gap;
            if (ratio > 1.0f) {
                ratio = 1.0f / ratio;
            }
            if ((double)ratio > 0.95) {
                this.content[child] = new StringBuffer(Fonts.cleanupTokens(this.content[child].toString()));
                this.content[child].insert(0, "<center>");
                this.content[child].append("</center>\n");
            } else if (right_gap < 10.0f & left_gap > 30.0f) {
                this.content[child] = new StringBuffer(Fonts.cleanupTokens(this.content[child].toString()));
                this.content[child].insert(0, "<right>");
                this.content[child].append("</right>\n");
            }
        }
    }

    private void createLines(int count, int[] items, int mode, boolean breakOnSpace, boolean addMultiplespaceXMLTag, boolean sameLineOnly) throws PdfException {
        float[] f_x1 = null;
        float[] f_x2 = null;
        float[] f_y1 = null;
        float[] f_y2 = null;
        if (!oldTextExtraction && mode == 1 | mode == 2) {
            items = this.reverse(items);
        }
        if (oldTextExtraction | mode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (mode == 3) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
        } else if (mode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + mode + "for currentWritingMode");
        }
        int j = 0;
        while (j < count) {
            int id = -1;
            int c = items[j];
            float smallest_gap = -1.0f;
            float gap = 0.0f;
            if (!this.isUsed[c] && this.writingMode[c] == mode | oldTextExtraction) {
                while (true) {
                    int j2 = 0;
                    while (j2 < count) {
                        int i = items[j2];
                        if (!this.isUsed[i]) {
                            int baseLineDifference = (int)(f_y2[i] - f_y2[c]);
                            if (baseLineDifference < 0) {
                                baseLineDifference = -baseLineDifference;
                            }
                            if ((!sameLineOnly || baseLineDifference <= 3) && i != c && (f_x1[i] > f_x1[c] && mode != 2 | oldTextExtraction) | (f_x1[i] < f_x1[c] && !oldTextExtraction && mode == 2) && this.writingMode[c] == mode | oldTextExtraction) {
                                float yMidPt;
                                gap = f_x1[i] - f_x2[c];
                                if (!oldTextExtraction && mode == 1 | mode == 2) {
                                    gap = -gap;
                                }
                                if (gap < 0.0f & gap > -2.0f) {
                                    gap = 0.0f;
                                }
                                if ((yMidPt = (f_y1[i] + f_y2[i]) / 2.0f) < f_y1[c] && yMidPt > f_y2[c] && smallest_gap < 0.0f | gap < smallest_gap) {
                                    smallest_gap = gap;
                                    id = i;
                                }
                            }
                        }
                        ++j2;
                    }
                    if (id == -1) break;
                    float possSpace = f_x1[id] - f_x2[c];
                    if (!oldTextExtraction && mode == 1 | mode == 2) {
                        possSpace = -possSpace;
                    }
                    String separator = this.isGapASpace(c, id, possSpace, addMultiplespaceXMLTag, mode);
                    if (breakOnSpace && this.hadSpace != null && this.hadSpace[c] | separator.startsWith(" ")) break;
                    this.merge(c, id, separator, true);
                    id = -1;
                    smallest_gap = 1000000.0f;
                }
            }
            ++j;
        }
    }

    public List findMultipleTermsInRectangle(int x1, int y1, int x2, int y2, final int rotation, int page_number, String[] terms, boolean isCaseSensitive, boolean orderResults, int searchType, SearchListener listener) throws PdfException {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        int i = 0;
        while (i < terms.length) {
            String term = terms[i];
            if (listener.isCanceled()) break;
            float[] co_ords = this.findTextInRectangle(x1, y2, x2 + x1, y1, page_number, term, isCaseSensitive, true);
            if (co_ords != null) {
                int count = co_ords.length;
                int ii = 0;
                while (ii < count) {
                    int wx1 = (int)co_ords[ii];
                    int wy1 = (int)co_ords[ii + 1];
                    int wx2 = (int)this.endPoints[ii];
                    int wy2 = (int)this.endPoints[ii + 1];
                    Rectangle rectangle = new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2);
                    list.add(rectangle);
                    ii += 2;
                }
            }
            ++i;
        }
        if (orderResults) {
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (rotation == 0 || rotation == 180) {
                        if (r1.y == r2.y) {
                            if (r1.x > r2.x) {
                                return 1;
                            }
                            return -1;
                        }
                        if (r1.y > r2.y) {
                            return -1;
                        }
                        return 1;
                    }
                    if (r1.x == r1.x) {
                        if (r1.y > r2.y) {
                            return 1;
                        }
                        return -1;
                    }
                    if (r1.x > r2.x) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        return list;
    }

    public final float[] findTextInRectangle(int x1, int y1, int x2, int y2, int page_number, String textValue) throws PdfException {
        return this.findTextInRectangle(x1, y1, x2, y2, page_number, textValue, true, false);
    }

    public final float[] findTextInRectangle(int x1, int y1, int x2, int y2, int page_number, String textValue, boolean isCaseSensitive, boolean findAll) throws PdfException {
        if (textValue == null) {
            return null;
        }
        textValue = this.removeDuplicateSpaces(textValue);
        StringBuffer[] rawContent = null;
        if (textValue.length() == 0) {
            return null;
        }
        float[] co_ords = null;
        float[] endPoints = null;
        this.validateCoordinates(x1, y1, x2, y2);
        this.copyToArrays();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] items = this.getsortedUnusedFragments(true, false);
        int count = items.length;
        if (count == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int writingMode = this.getWritingMode(items, count);
        if (this.includeTease) {
            int count2 = this.content.length;
            rawContent = new StringBuffer[count2];
            int j = 0;
            while (j < count2) {
                if (this.content[j] != null) {
                    rawContent[j] = new StringBuffer(this.content[j].toString());
                    if (this.moveType[j] == 0 | (this.moveType[j] == 2 && j < count2 - 1 && this.f_x1[j] < this.f_x2[j + 1] && this.f_x2[j] > this.f_x1[j + 1])) {
                        this.content[j].append("<link:");
                        this.content[j].append(j + 1);
                        this.content[j].append('>');
                    }
                }
                ++j;
            }
        }
        this.createLines(count, items, writingMode, true, false, true);
        float[] f_x1 = null;
        float[] f_x2 = null;
        float[] f_y1 = null;
        float[] f_y2 = null;
        boolean valuesSwapped = false;
        if (oldTextExtraction | writingMode == 0) {
            f_x1 = this.f_x1;
            f_x2 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (writingMode == 1) {
            f_x2 = this.f_x1;
            f_x1 = this.f_x2;
            f_y1 = this.f_y1;
            f_y2 = this.f_y2;
        } else if (writingMode == 3) {
            f_x1 = this.f_y1;
            f_x2 = this.f_y2;
            f_y1 = this.f_x2;
            f_y2 = this.f_x1;
            valuesSwapped = true;
        } else if (writingMode == 2) {
            f_x1 = this.f_y2;
            f_x2 = this.f_y1;
            f_y2 = this.f_x1;
            f_y1 = this.f_x2;
            valuesSwapped = true;
        } else {
            throw new PdfException("Illegal value " + writingMode + "for currentWritingMode");
        }
        int[] indices = this.getsortedUnusedFragments(false, true);
        count = indices.length;
        float x = -1.0f;
        int ptCount = 0;
        Vector_Int rawCoords = new Vector_Int(20);
        Vector_Int endCoords = new Vector_Int(20);
        Vector_String teaserString = new Vector_String(20);
        int j = count - 1;
        while (j > -1) {
            int i = indices[j];
            if (this.content[i] != null) {
                int xReached = x1;
                while (xReached < x2) {
                    x = this.scanLineForValue(rawContent, this.removeDuplicateSpaces(this.content[i]), textValue, xReached, isCaseSensitive);
                    if (x > (float)x1 && x < (float)x2 && (float)y1 > f_y1[i] && (float)y2 < f_y2[i] && x != -1.0f) {
                        String text = Strip.stripXML(PdfGroupingAlgorithms.removeHiddenMarkers(this.content[i].toString())).toString();
                        if (valuesSwapped) {
                            if (writingMode == 3) {
                                rawCoords.addElement((int)f_y2[i]);
                                rawCoords.addElement((int)this.endX);
                                endCoords.addElement((int)f_y1[i]);
                                endCoords.addElement((int)x);
                            } else {
                                rawCoords.addElement((int)f_y2[i]);
                                rawCoords.addElement((int)x);
                                endCoords.addElement((int)f_y1[i]);
                                endCoords.addElement((int)this.endX);
                            }
                        } else {
                            rawCoords.addElement((int)x);
                            rawCoords.addElement((int)f_y1[i]);
                            endCoords.addElement((int)this.endX);
                            endCoords.addElement((int)f_y2[i]);
                        }
                        if (this.includeTease) {
                            teaserString.addElement(this.tease.toString());
                        }
                        ++ptCount;
                        if (!findAll) {
                            j = count;
                            x2 = xReached;
                        }
                    }
                    if (i == count | x == -1.0f) break;
                    xReached = (int)x + 1;
                }
            }
            --j;
        }
        rawContent = null;
        if (ptCount > 0) {
            co_ords = new float[ptCount * 2];
            int i = 0;
            while (i < ptCount * 2) {
                co_ords[i] = rawCoords.elementAt(i);
                ++i;
            }
            endPoints = new float[ptCount * 2];
            i = 0;
            while (i < ptCount * 2) {
                endPoints[i] = endCoords.elementAt(i);
                ++i;
            }
            if (this.includeTease) {
                this.teasers = new String[ptCount];
                i = 0;
                while (i < ptCount) {
                    this.teasers[i] = teaserString.elementAt(i);
                    ++i;
                }
            }
        }
        LogWriter.writeLog("Text scan completed");
        this.endPoints = endPoints;
        return co_ords;
    }

    private String removeDuplicateSpaces(String textValue) {
        if (textValue.indexOf("  ") != -1) {
            StringBuffer cleanedText = this.removeDuplicateSpaces(new StringBuffer(textValue));
            textValue = cleanedText.toString();
        }
        return textValue;
    }

    private StringBuffer removeDuplicateSpaces(StringBuffer cleanedText) {
        if (cleanedText.indexOf("  ") != -1) {
            int count = cleanedText.length() - 1;
            int i = 0;
            while (i < count) {
                if (cleanedText.charAt(i) == ' ' && cleanedText.charAt(i + 1) == ' ') {
                    cleanedText.deleteCharAt(i + 1);
                    --count;
                    --i;
                }
                ++i;
            }
        }
        return cleanedText;
    }

    public float[] getEndPoints() {
        return this.endPoints;
    }

    public String[] getTeasers() {
        return this.teasers;
    }

    public void generateTeasers() {
        this.includeTease = true;
    }
}

