/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.CFF;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Head;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.Loca;
import org.jpedal.fonts.tt.Mapx;
import org.jpedal.fonts.tt.Name;
import org.jpedal.fonts.tt.Post;
import org.jpedal.fonts.tt.TTGlyph;

public class TTGlyphs
extends PdfJavaGlyphs {
    protected boolean hasGIDtoCID;
    protected int[] CIDToGIDMap;
    private CMAP currentCMAP;
    private Post currentPost;
    private Glyf currentGlyf;
    private Hmtx currentHmtx;
    private FontFile2 currentFontFile;
    private CFF currentCFF;
    int glyphCount = 0;
    private int unitsPerEm;
    private boolean hasCFF;
    private boolean isCID;

    public PdfGlyph getEmbeddedGlyph(GlyphFactory factory, String glyph, float[][] Trm, int rawInt, String displayValue, float currentWidth, String key) {
        PdfGlyph transformedGlyph2;
        int id = rawInt;
        if (this.hasGIDtoCID) {
            rawInt = this.CIDToGIDMap[rawInt];
        }
        if (this.lastTrm[0][0] != Trm[0][0] | this.lastTrm[1][0] != Trm[1][0] | this.lastTrm[0][1] != Trm[0][1] | this.lastTrm[1][1] != Trm[1][1]) {
            this.lastTrm = Trm;
            this.cachedShapes = null;
        }
        if ((transformedGlyph2 = this.getEmbeddedCachedShape(id)) == null) {
            int idx = rawInt;
            if (!this.isCID || !this.isIdentity()) {
                idx = this.currentCMAP.convertIndexToCharacterCode(glyph, rawInt, this.remapFont, this.isSubsetted);
            }
            if (idx < 1) {
                idx = this.currentPost.convertGlyphToCharacterCode(glyph);
            }
            try {
                if (this.hasCFF) {
                    transformedGlyph2 = this.currentCFF.getCFFGlyph(factory, glyph, Trm, rawInt, displayValue, currentWidth, key);
                    transformedGlyph2.setWidth(this.getUnscaledWidth(glyph, rawInt, displayValue, false));
                } else {
                    transformedGlyph2 = this.getTTGlyph(idx, glyph, rawInt, displayValue, currentWidth);
                }
            }
            catch (Exception e) {
                transformedGlyph2 = null;
            }
            this.setEmbeddedCachedShape(id, transformedGlyph2);
        }
        return transformedGlyph2;
    }

    public PdfGlyph getTTGlyph(int idx, String glyph, int rawInt, String displayValue, float currentWidth) {
        TTGlyph currentGlyph = null;
        try {
            int p;
            boolean debug = false;
            if (idx != -1 && (p = this.currentGlyf.getCharString(idx)) != -1) {
                this.currentFontFile.setPointer(p);
                currentGlyph = new TTGlyph(glyph, false, this.currentGlyf, this.currentFontFile, this.currentHmtx, idx, (float)this.unitsPerEm / 1000.0f);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return currentGlyph;
    }

    public void setEncodingToUse(boolean hasEncoding, int fontEncoding, boolean isSubstituted, boolean isCIDFont) {
        if (this.currentCMAP != null) {
            this.currentCMAP.setEncodingToUse(hasEncoding, fontEncoding, isSubstituted, isCIDFont);
        }
    }

    public int getConvertedGlyph(int idx) {
        if (this.currentCMAP == null) {
            return idx;
        }
        return this.currentCMAP.convertIndexToCharacterCode(null, idx, false, false);
    }

    public float getTTWidth(String glyph, int rawInt, String displayValue, boolean TTstreamisCID) {
        int idx = rawInt;
        float width = 0.0f;
        try {
            if (!TTstreamisCID) {
                idx = this.currentCMAP.convertIndexToCharacterCode(glyph, rawInt, this.remapFont, this.isSubsetted);
            }
            if (idx < 1) {
                idx = this.currentPost.convertGlyphToCharacterCode(glyph);
            }
            width = this.currentHmtx.getWidth(idx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return width;
    }

    private float getUnscaledWidth(String glyph, int rawInt, String displayValue, boolean TTstreamisCID) {
        int idx = rawInt;
        float width = 0.0f;
        try {
            if (!TTstreamisCID) {
                idx = this.currentCMAP.convertIndexToCharacterCode(glyph, rawInt, this.remapFont, this.isSubsetted);
            }
            if (idx < 1) {
                idx = this.currentPost.convertGlyphToCharacterCode(glyph);
            }
            width = this.currentHmtx.getUnscaledWidth(idx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return width;
    }

    public void setGIDtoCID(int[] cidToGIDMap) {
        this.hasGIDtoCID = true;
        this.CIDToGIDMap = cidToGIDMap;
    }

    public String[] readPostScriptFontNames(FontData fontData) {
        String[] postscriptNames = new String[]{};
        FontFile2 currentFontFile = new FontFile2(fontData);
        int fontType = currentFontFile.getType();
        int fontCount = currentFontFile.getFontCount();
        postscriptNames = new String[fontCount];
        int i = 0;
        while (i < fontCount) {
            currentFontFile.setSelectedFontIndex(i);
            Name currentName = new Name(currentFontFile);
            String name = currentName.getString(Name.POSTSCRIPT_NAME);
            postscriptNames[i] = name == null ? null : currentName.getString(Name.POSTSCRIPT_NAME).toLowerCase();
            ++i;
        }
        return postscriptNames;
    }

    public int readEmbeddedFont(boolean TTstreamisCID, byte[] fontDataAsArray, FontData fontData) {
        int type = 2;
        this.isCID = TTstreamisCID;
        this.currentFontFile = fontDataAsArray != null ? new FontFile2(fontDataAsArray) : new FontFile2(fontData);
        if (FontMappings.fontSubstitutionFontID == null) {
            this.currentFontFile.setPointer(0);
        } else {
            Integer fontID = (Integer)FontMappings.fontSubstitutionFontID.get(this.fontName.toLowerCase());
            if (fontID != null) {
                this.currentFontFile.setPointer(fontID);
            } else {
                this.currentFontFile.setPointer(0);
            }
        }
        Head currentHead = new Head(this.currentFontFile);
        this.currentPost = new Post(this.currentFontFile);
        Mapx currentMapx = new Mapx(this.currentFontFile);
        this.glyphCount = currentMapx.getGlyphCount();
        Loca currentLoca = new Loca(this.currentFontFile, this.glyphCount, currentHead.getFormat());
        this.currentGlyf = new Glyf(this.currentFontFile, this.glyphCount, currentLoca.getIndices());
        this.currentCFF = new CFF(this.currentFontFile);
        this.hasCFF = this.currentCFF.hasCFFData();
        if (this.hasCFF) {
            type = 6;
        }
        Hhea currentHhea = new Hhea(this.currentFontFile);
        int[] matrix = currentHead.getMatrix();
        int width = matrix[3];
        this.currentHmtx = new Hmtx(this.currentFontFile, this.glyphCount, currentHhea.getNumberOfHMetrics(), width);
        int startPointer = this.currentFontFile.selectTable(2);
        if (startPointer != 0) {
            this.currentCMAP = new CMAP(this.currentFontFile, startPointer, this.currentGlyf);
        }
        this.unitsPerEm = currentHead.getUnitsPerEm();
        return type;
    }
}

