/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Hmtx
extends Table {
    private int[] hMetrics;
    private short[] leftSideBearing;
    float scaling = 0.001f;

    public Hmtx(FontFile2 currentFontFile, int glyphCount, int metricsCount, int maxAdvance) {
        this.scaling = maxAdvance;
        LogWriter.writeMethod("{readHmtxTable}", 0);
        if (metricsCount < 0) {
            metricsCount = -metricsCount;
        }
        int startPointer = currentFontFile.selectTable(6);
        int lsbCount = glyphCount - metricsCount;
        this.hMetrics = new int[glyphCount];
        this.leftSideBearing = new short[glyphCount];
        int currentMetric = 0;
        if (startPointer == 0) {
            LogWriter.writeLog("No Htmx table found");
        } else if (lsbCount < 0) {
            LogWriter.writeLog("Invalid Htmx table found");
        } else {
            int i = 0;
            i = 0;
            while (i < metricsCount) {
                this.hMetrics[i] = currentMetric = currentFontFile.getNextUint16();
                this.leftSideBearing[i] = currentFontFile.getNextInt16();
                ++i;
            }
            int tableLength = currentFontFile.getTableSize(6);
            int lsbBytes = tableLength - i * 4;
            lsbCount = lsbBytes / 2;
            int j = i;
            while (j < lsbCount) {
                this.hMetrics[j] = currentMetric;
                this.leftSideBearing[j] = currentFontFile.getFWord();
                ++j;
            }
        }
    }

    public short getRAWLSB(int i) {
        if (this.leftSideBearing == null || i >= this.leftSideBearing.length) {
            return 0;
        }
        return this.leftSideBearing[i];
    }

    public short getLeftSideBearing(int i) {
        if (i < this.hMetrics.length) {
            return (short)(this.hMetrics[i] & 0xFFFF);
        }
        if (this.leftSideBearing == null) {
            return 0;
        }
        try {
            return this.leftSideBearing[i - this.hMetrics.length];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getAdvanceWidth(int i) {
        return (float)(this.hMetrics[i] - this.getLeftSideBearing(i)) / this.scaling;
    }

    public float getWidth(int i) {
        float w = this.hMetrics[i];
        return w / this.scaling;
    }

    public float getUnscaledWidth(int i) {
        return this.hMetrics[i];
    }
}

