/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Head
extends Table {
    private int format = 0;
    private int[] matrix = new int[4];
    private int flags;
    private int unitsPerEm = 1;

    public Head(FontFile2 currentFontFile) {
        LogWriter.writeMethod("{readHeadTable}", 0);
        int startPointer = currentFontFile.selectTable(0);
        if (startPointer == 0) {
            LogWriter.writeLog("No head table found");
        } else {
            int id = currentFontFile.getNextUint32();
            int i = 0;
            while (i < 3) {
                id = currentFontFile.getNextUint32();
                ++i;
            }
            this.flags = currentFontFile.getNextUint16();
            this.unitsPerEm = currentFontFile.getNextUint16();
            i = 0;
            while (i < 2) {
                id = currentFontFile.getNextUint64();
                ++i;
            }
            i = 0;
            while (i < 4) {
                this.matrix[i] = currentFontFile.getNextSignedInt16();
                ++i;
            }
            i = 0;
            while (i < 3) {
                id = currentFontFile.getNextUint16();
                ++i;
            }
            this.format = currentFontFile.getNextUint16();
        }
    }

    public int getFormat() {
        return this.format;
    }

    public int[] getMatrix() {
        return this.matrix;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getUnitsPerEm() {
        return this.unitsPerEm;
    }
}

