/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Glyf
extends Table {
    private Hashtable charStrings = new Hashtable();
    private Map emptyCharStrings = new HashMap();

    public Glyf(FontFile2 currentFontFile, int glyphCount, int[] glyphIndexStart) {
        LogWriter.writeMethod("{readGlyfTable}", 0);
        int startPointer = currentFontFile.selectTable(3);
        int glyf = currentFontFile.getTable(4);
        if (startPointer != 0) {
            int i = 0;
            while (i < glyphCount) {
                if (glyphIndexStart[i] == glyphIndexStart[i + 1]) {
                    this.charStrings.put(new Integer(i), new Integer(-1));
                    this.emptyCharStrings.put(new Integer(i), "x");
                } else {
                    this.charStrings.put(new Integer(i), new Integer(glyf + glyphIndexStart[i]));
                }
                ++i;
            }
        }
    }

    public boolean isPresent(int glyph) {
        Integer key = new Integer(glyph);
        Object value = this.charStrings.get(key);
        return value != null && this.emptyCharStrings.get(key) == null;
    }

    public int getCharString(int glyph) {
        Object value = this.charStrings.get(new Integer(glyph));
        if (value == null) {
            return glyph;
        }
        return (Integer)value;
    }
}

