/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.Hashtable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    private int[][] charIndexToGlyph;
    private int winScore = 0;
    private int macScore = 0;
    int segCount = 0;
    int fontMapping = 0;
    int[] endCode;
    int[] startCode;
    int[] idDelta;
    int[] idRangeOffset;
    int[] glyphIdArray;
    int[] f6glyphIdArray;
    int[] offset;
    private int[] CMAPformats;
    int[] platformID;
    private static Hashtable exceptions = new Hashtable();
    private int formatToUse;
    private int encodingToUse = 0;
    private static boolean WINchecked;

    static {
        String[] values = new String[]{"notequal", "173", "infinity", "176", "lessequal", "178", "greaterequal", "179", "partialdiff", "182", "summation", "183", "product", "184", "pi", "185", "integral", "186", "Omega", "189", "radical", "195", "approxequal", "197", "Delta", "198", "lozenge", "215", "Euro", "219", "apple", "240"};
        int i = 0;
        while (i < values.length) {
            exceptions.put(values[i], values[i + 1]);
            i += 2;
        }
    }

    public CMAP(FontFile2 currentFontFile, int startPointer, Glyf currentGlyf) {
        if (startPointer == 0) {
            LogWriter.writeLog("No CMAP table found");
        } else {
            currentFontFile.getNextUint16();
            int numberSubtables = currentFontFile.getNextUint16();
            int[] CMAPsubtables = new int[numberSubtables];
            this.platformID = new int[numberSubtables];
            int[] platformSpecificID = new int[numberSubtables];
            this.CMAPformats = new int[numberSubtables];
            this.charIndexToGlyph = new int[numberSubtables][256];
            int i = 0;
            while (i < numberSubtables) {
                this.platformID[i] = currentFontFile.getNextUint16();
                platformSpecificID[i] = currentFontFile.getNextUint16();
                CMAPsubtables[i] = currentFontFile.getNextUint32();
                ++i;
            }
            int j = 0;
            while (j < numberSubtables) {
                currentFontFile.selectTable(2);
                currentFontFile.skip(CMAPsubtables[j]);
                this.CMAPformats[j] = currentFontFile.getNextUint16();
                int length = currentFontFile.getNextUint16();
                currentFontFile.getNextUint16();
                if (this.CMAPformats[j] == 0 & length == 262) {
                    StandardFonts.checkLoaded(2);
                    StandardFonts.checkLoaded(0);
                    int glyphNum = 0;
                    while (glyphNum < 256) {
                        int index;
                        this.charIndexToGlyph[j][glyphNum] = index = currentFontFile.getNextUint8();
                        if (index > 0) {
                            if (StandardFonts.isValidMacEncoding(glyphNum)) {
                                ++this.macScore;
                            }
                            if (StandardFonts.isValidWinEncoding(glyphNum)) {
                                ++this.winScore;
                            }
                        }
                        ++glyphNum;
                    }
                } else if (this.CMAPformats[j] == 4) {
                    this.segCount = currentFontFile.getNextUint16() / 2;
                    currentFontFile.getNextUint16();
                    currentFontFile.getNextUint16();
                    currentFontFile.getNextUint16();
                    this.endCode = new int[this.segCount];
                    int i2 = 0;
                    while (i2 < this.segCount) {
                        this.endCode[i2] = currentFontFile.getNextUint16();
                        ++i2;
                    }
                    currentFontFile.getNextUint16();
                    this.startCode = new int[this.segCount];
                    i2 = 0;
                    while (i2 < this.segCount) {
                        this.startCode[i2] = currentFontFile.getNextUint16();
                        ++i2;
                    }
                    this.idDelta = new int[this.segCount];
                    i2 = 0;
                    while (i2 < this.segCount) {
                        this.idDelta[i2] = currentFontFile.getNextUint16();
                        ++i2;
                    }
                    this.idRangeOffset = new int[this.segCount];
                    i2 = 0;
                    while (i2 < this.segCount) {
                        this.idRangeOffset[i2] = currentFontFile.getNextUint16();
                        ++i2;
                    }
                    this.offset = new int[this.segCount];
                    int diff = 0;
                    int cumulative = 0;
                    int i3 = 0;
                    while (i3 < this.segCount) {
                        if (this.idDelta[i3] == 0) {
                            this.offset[i3] = cumulative;
                            diff = 1 + this.endCode[i3] - this.startCode[i3];
                            cumulative += diff;
                        }
                        ++i3;
                    }
                    int count = (length - 16 - this.segCount * 8) / 2;
                    this.glyphIdArray = new int[count];
                    int i4 = 0;
                    while (i4 < count) {
                        this.glyphIdArray[i4] = currentFontFile.getNextUint16();
                        ++i4;
                    }
                } else if (this.CMAPformats[j] == 6) {
                    int firstCode = currentFontFile.getNextUint16();
                    int entryCount = currentFontFile.getNextUint16();
                    this.f6glyphIdArray = new int[firstCode + entryCount];
                    int jj = 0;
                    while (jj < entryCount) {
                        this.f6glyphIdArray[jj + firstCode] = currentFontFile.getNextUint16();
                        ++jj;
                    }
                } else {
                    this.CMAPformats[j] = -1;
                }
                ++j;
            }
        }
    }

    public int convertIndexToCharacterCode(String glyph, int index, boolean remapFont, boolean isSubsetted) {
        int index2 = -1;
        boolean debugMapping = false;
        if ((this.fontMapping == 1 || !remapFont && this.fontMapping == 4) && glyph != null && !glyph.equals("notdef")) {
            index = StandardFonts.getAdobeMap(glyph);
        } else if (this.fontMapping == 2) {
            StandardFonts.checkLoaded(this.encodingToUse);
            if (this.encodingToUse == 0) {
                Object exception = null;
                if (glyph != null) {
                    exception = exceptions.get(glyph);
                }
                if (exception == null) {
                    if (glyph != null && !isSubsetted) {
                        index = StandardFonts.lookupCharacterIndex(glyph, this.encodingToUse);
                    }
                } else {
                    try {
                        index = Integer.parseInt(exception);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (glyph != null) {
                    if (!WINchecked) {
                        StandardFonts.checkLoaded(2);
                        WINchecked = true;
                    }
                    index2 = StandardFonts.lookupCharacterIndex(glyph, 2);
                }
            } else if (glyph != null) {
                index = StandardFonts.lookupCharacterIndex(glyph, this.encodingToUse);
            }
        }
        int value = -1;
        int format = this.CMAPformats[this.formatToUse];
        if (remapFont & format > 0 && format != 6) {
            index += 61440;
        }
        if (format == 0) {
            if (index > 255) {
                index = 0;
            }
            if ((value = this.charIndexToGlyph[this.formatToUse][index]) == 0 & index2 != -1) {
                value = this.charIndexToGlyph[this.formatToUse][index2];
            }
        } else if (format == 4) {
            int i = 0;
            while (i < this.segCount) {
                if (this.endCode[i] >= index && this.startCode[i] <= index) {
                    int idx = 0;
                    if (this.idRangeOffset[i] == 0) {
                        value = (this.idDelta[i] + index) % 65536;
                    } else {
                        idx = this.offset[i] + (index - this.startCode[i]);
                        value = this.glyphIdArray[idx];
                    }
                }
                ++i;
            }
        } else if (format == 6) {
            value = index >= this.f6glyphIdArray.length ? 0 : this.f6glyphIdArray[index];
        } else {
            System.err.println("Cmap " + format + "not supported");
            value = index;
        }
        return value;
    }

    public void setEncodingToUse(boolean hasEncoding, int fontEncoding, boolean isSubstituted, boolean isCID) {
        int i;
        boolean encodingDebug = false;
        this.formatToUse = -1;
        int count = this.platformID.length;
        if (!isSubstituted && this.macScore < 207) {
            if (count > 0 && this.winScore > this.macScore) {
                this.encodingToUse = 2;
            }
            if (this.macScore > 80 && hasEncoding && fontEncoding == 2 && this.winScore >= this.macScore) {
                this.encodingToUse = 2;
            }
        }
        int i2 = 0;
        while (i2 < count) {
            if (this.platformID[i2] == 3 && this.CMAPformats[i2] == 1) {
                this.formatToUse = i2;
                this.fontMapping = 1;
                i2 = count;
            }
            ++i2;
        }
        if (this.formatToUse == -1 && !isCID && !isSubstituted) {
            i2 = 0;
            while (i2 < count) {
                if (this.platformID[i2] == 1 && this.CMAPformats[i2] == 0) {
                    this.formatToUse = i2;
                    this.fontMapping = hasEncoding ? 2 : (fontEncoding == 2 ? 2 : 3);
                    i2 = count;
                }
                ++i2;
            }
        }
        boolean wasCase3 = false;
        if (this.formatToUse == -1) {
            i = 0;
            while (i < count) {
                if (this.CMAPformats[i] == 6) {
                    this.formatToUse = i;
                    if (!hasEncoding && fontEncoding == 2) {
                        this.fontMapping = 2;
                        StandardFonts.checkLoaded(0);
                    } else {
                        this.fontMapping = 6;
                    }
                    wasCase3 = true;
                    i = count;
                }
                ++i;
            }
        }
        if (this.formatToUse == -1 || wasCase3) {
            i = 0;
            while (i < count) {
                if (this.CMAPformats[i] == 4) {
                    this.formatToUse = i;
                    this.fontMapping = 4;
                    i = count;
                }
                ++i;
            }
        }
        if (fontEncoding == 5) {
            this.fontMapping = 2;
        }
    }
}

