/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.render.DynamicVectorRenderer;

public class T3Glyph
implements PdfGlyph {
    private boolean lockColours = false;
    DynamicVectorRenderer glyphDisplay;
    private int maxWidth;
    private int maxHeight;
    String stringName = "";

    public T3Glyph() {
    }

    public String getGlyphName() {
        return this.stringName;
    }

    public void setStringName(String stringName) {
        this.stringName = stringName;
    }

    public T3Glyph(DynamicVectorRenderer glyphDisplay, int x, int y, boolean lockColours, String pKey) {
        this.glyphDisplay = glyphDisplay;
        this.maxWidth = x;
        this.maxHeight = y;
        this.lockColours = lockColours;
        this.stringName = pKey;
    }

    public Area getShape() {
        return null;
    }

    public void render(int type, Graphics2D g2, boolean debug, float scaling) {
        this.glyphDisplay.setScalingValues(0.0, 0.0, scaling);
        this.glyphDisplay.paint(g2, null, null, null, false, false);
    }

    public float getmaxWidth() {
        return this.maxWidth;
    }

    public int getmaxHeight() {
        return this.maxHeight;
    }

    public void lockColors(PdfPaint strokeColor, PdfPaint nonstrokeColor) {
        this.glyphDisplay.lockColors(strokeColor, nonstrokeColor);
    }

    public boolean ignoreColors() {
        return this.lockColours;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        byte[] dvr = this.glyphDisplay.serializeToByteArray(null);
        int size = dvr.length;
        os.writeObject(dvr);
        os.writeInt(this.maxWidth);
        os.writeInt(this.maxHeight);
        os.writeBoolean(this.lockColours);
    }

    public T3Glyph(ObjectInput os) {
        try {
            byte[] dvr = (byte[])os.readObject();
            this.glyphDisplay = new DynamicVectorRenderer(dvr, null);
            this.maxWidth = os.readInt();
            this.maxHeight = os.readInt();
            this.lockColours = os.readBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flushArea() {
    }

    public void setDisplacement(short rawlsb, float width) {
    }

    public void setWidth(float width) {
    }
}

