/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.objects.FontData;

public class PdfJavaGlyphs
implements PdfGlyphs,
Serializable {
    public Area[] cachedShapes = null;
    boolean isFontInstalled = false;
    public String defaultFont = "Lucida Sans";
    public String fontName = "default";
    Map chars = new HashMap();
    Map displayValues = new HashMap();
    Map embeddedChars = new HashMap();
    private boolean isIdentity = false;
    public String baseFontName = "";
    public boolean isSubsetted;
    public float[][] lastTrm = new float[3][3];
    private Font unscaledFont = null;
    boolean isArialInstalledLocally;
    private int maxCharCount = 255;
    private boolean isCIDFont;
    public boolean remapFont = false;
    public String font_family_name;
    public int style;
    private static FontRenderContext frc = new FontRenderContext(null, true, true);
    public static String[] fontList;
    protected PdfGlyph[] cachedEmbeddedShapes = null;
    protected int localBias = 0;
    protected int globalBias = 0;

    public String getBaseFontName() {
        return this.baseFontName;
    }

    public void setBaseFontName(String baseFontName) {
        this.baseFontName = baseFontName;
    }

    public Area getStandardGlyph(float[][] Trm, int rawInt, String displayValue, float currentWidth) {
        if (this.lastTrm[0][0] != Trm[0][0] | this.lastTrm[1][0] != Trm[1][0] | this.lastTrm[0][1] != Trm[0][1] | this.lastTrm[1][1] != Trm[1][1]) {
            this.lastTrm = Trm;
            this.cachedShapes = null;
        }
        Area transformedGlyph2 = this.getCachedShape(rawInt);
        double dY = -1.0;
        double dX = 1.0;
        if (Trm[1][0] < 0.0f & Trm[0][1] >= 0.0f | Trm[0][1] < 0.0f & Trm[1][0] >= 0.0f) {
            dX = 1.0;
            dY = -1.0;
        }
        if (transformedGlyph2 == null) {
            transformedGlyph2 = this.getGlyph(rawInt, displayValue, currentWidth);
            if (transformedGlyph2 != null) {
                double y = 0.0;
                if (rawInt == 146 && this.isArialInstalledLocally) {
                    y = dY * (double)Trm[1][1] / 2.0;
                    y = -(transformedGlyph2.getBounds().height - transformedGlyph2.getBounds().y);
                }
                AffineTransform at = new AffineTransform(dX * (double)Trm[0][0], dX * (double)Trm[0][1], dY * (double)Trm[1][0], dY * (double)Trm[1][1], 0.0, y);
                transformedGlyph2.transform(at);
            }
            this.setCachedShape(rawInt, transformedGlyph2);
        }
        return transformedGlyph2;
    }

    public Area getApproximateGlyph(float[][] Trm, int rawInt, String displayValue, float currentWidth) {
        if (this.lastTrm[0][0] != Trm[0][0] | this.lastTrm[1][0] != Trm[1][0] | this.lastTrm[0][1] != Trm[0][1] | this.lastTrm[1][1] != Trm[1][1]) {
            this.lastTrm = Trm;
            this.cachedShapes = null;
        }
        Area transformedGlyph2 = this.getCachedShape(rawInt);
        double dY = -1.0;
        double dX = 1.0;
        if (Trm[1][0] < 0.0f & Trm[0][1] >= 0.0f | Trm[0][1] < 0.0f & Trm[1][0] >= 0.0f) {
            dX = 1.0;
            dY = -1.0;
        }
        if (transformedGlyph2 == null) {
            String xx = displayValue;
            if (this.remapFont && !this.getUnscaledFont().canDisplay(xx.charAt(0))) {
                xx = String.valueOf((char)(rawInt + 61440));
            }
            GlyphVector gv1 = null;
            if (!this.isCIDFont || this.isFontInstalled) {
                gv1 = this.getUnscaledFont().createGlyphVector(frc, xx);
            }
            if (gv1 != null) {
                double glyphWidth;
                double scaleFactor;
                AffineTransform at;
                transformedGlyph2 = new Area(gv1.getOutline());
                double glyphX = gv1.getOutline().getBounds2D().getX();
                if (glyphX < 0.0) {
                    glyphX = -glyphX;
                    at = AffineTransform.getTranslateInstance(glyphX * 2.0, 0.0);
                    transformedGlyph2.transform(at);
                }
                if ((scaleFactor = (double)currentWidth / (glyphWidth = gv1.getVisualBounds().getWidth() + glyphX * 2.0)) < 1.0) {
                    at = AffineTransform.getScaleInstance(scaleFactor, 1.0);
                    transformedGlyph2.transform(at);
                }
                at = new AffineTransform(dX * (double)Trm[0][0], dX * (double)Trm[0][1], dY * (double)Trm[1][0], dY * (double)Trm[1][1], 0.0, 0.0);
                transformedGlyph2.transform(at);
                this.setCachedShape(rawInt, transformedGlyph2);
            }
        }
        return transformedGlyph2;
    }

    protected Area getGlyph(int rawInt, String displayValue, float currentWidth) {
        boolean fontMatched = true;
        GlyphVector gv1 = null;
        String xx = displayValue;
        if (this.remapFont && !this.getUnscaledFont().canDisplay(xx.charAt(0))) {
            xx = String.valueOf((char)(rawInt + 61440));
        }
        if (!this.getUnscaledFont().canDisplay(xx.charAt(0))) {
            xx = displayValue;
            fontMatched = false;
        }
        if (this.isCIDFont && fontMatched) {
            gv1 = null;
        } else if (fontMatched) {
            gv1 = this.getUnscaledFont().createGlyphVector(frc, xx);
        } else {
            Font tempFont = new Font(this.defaultFont, 0, 1);
            if (!tempFont.canDisplay(xx.charAt(0))) {
                tempFont = new Font("lucida", 0, 1);
            }
            if (tempFont.canDisplay(xx.charAt(0))) {
                gv1 = tempFont.createGlyphVector(frc, xx);
            }
        }
        Area transformedGlyph2 = null;
        if (gv1 != null) {
            double scaleFactor;
            AffineTransform at;
            transformedGlyph2 = new Area(gv1.getOutline());
            double glyphX = gv1.getOutline().getBounds2D().getX();
            if (glyphX < 0.0) {
                glyphX = -glyphX;
                at = AffineTransform.getTranslateInstance(glyphX, 0.0);
                transformedGlyph2.transform(at);
            }
            if ((scaleFactor = (double)currentWidth / transformedGlyph2.getBounds2D().getWidth()) < 1.0) {
                at = AffineTransform.getScaleInstance(scaleFactor, 1.0);
                transformedGlyph2.transform(at);
            }
        }
        return transformedGlyph2;
    }

    protected final void setCachedShape(int idx, Area shape) {
        Area[] cache = this.cachedShapes;
        if (cache == null) {
            this.cachedShapes = cache = new Area[this.maxCharCount];
        }
        if (shape == null) {
            cache[idx] = null;
            cache[idx] = null;
        } else {
            cache[idx] = (Area)shape.clone();
        }
    }

    protected final Area getCachedShape(int idx) {
        Area[] cache = this.cachedShapes;
        if (cache == null) {
            return null;
        }
        Area currentShape = cache[idx];
        if (currentShape == null) {
            return null;
        }
        return (Area)currentShape.clone();
    }

    public void init(int maxCharCount, boolean isCIDFont) {
        this.maxCharCount = maxCharCount;
        this.isCIDFont = isCIDFont;
    }

    public final Font setFont(String name, int size) {
        int pointer;
        if (name.equals("Helv")) {
            name = "Helvetica";
        } else if (name.equals("HeBo")) {
            name = "Helvetica-BOLD";
        } else if (name.equals("ZaDb")) {
            name = "ZapfDingbats";
        }
        this.font_family_name = name;
        this.style = 0;
        String weight = null;
        String mappedName = null;
        if (this.font_family_name == null) {
            this.font_family_name = this.fontName;
        }
        String testFont = this.font_family_name;
        if (this.font_family_name != null) {
            testFont = this.font_family_name.toLowerCase();
        }
        if ((pointer = this.font_family_name.indexOf(44)) == -1) {
            pointer = this.font_family_name.indexOf(45);
        }
        if (pointer != -1) {
            mappedName = (String)FontMappings.fontSubstitutionAliasTable.get(testFont);
            weight = testFont.substring(pointer + 1, testFont.length());
            this.style = this.getWeight(weight);
            this.font_family_name = this.font_family_name.substring(0, pointer).toLowerCase();
            testFont = this.font_family_name;
            if (testFont.endsWith("mt")) {
                testFont = testFont.substring(0, testFont.length() - 2);
            }
        }
        if (mappedName == null) {
            mappedName = (String)FontMappings.fontSubstitutionAliasTable.get(testFont);
        }
        if (mappedName != null && mappedName.equals("arialbd")) {
            mappedName = "arial-bold";
        }
        if (mappedName != null) {
            this.font_family_name = mappedName;
            pointer = this.font_family_name.indexOf(45);
            if (pointer != -1) {
                this.font_family_name = this.font_family_name.toLowerCase();
                weight = this.font_family_name.substring(pointer + 1, this.font_family_name.length());
                this.style = this.getWeight(weight);
                this.font_family_name = this.font_family_name.substring(0, pointer);
            }
            if ((testFont = this.font_family_name.toLowerCase()).endsWith("mt")) {
                testFont = testFont.substring(0, testFont.length() - 2);
            }
        }
        if (fontList != null) {
            int count = fontList.length;
            int i = 0;
            while (i < count) {
                if (fontList[i].equals(testFont) || weight == null && testFont.startsWith(fontList[i])) {
                    this.isFontInstalled = true;
                    this.font_family_name = fontList[i];
                    i = count;
                }
                ++i;
            }
            if (this.isFontInstalled && this.font_family_name.equals("arial")) {
                this.isArialInstalledLocally = true;
            }
        }
        if (!this.isFontInstalled) {
            if (weight == null) {
                String test = this.font_family_name.toLowerCase();
                this.style = this.getWeight(test);
            }
            this.font_family_name = this.defaultFont;
        }
        this.unscaledFont = new Font(this.font_family_name, this.style, size);
        return this.unscaledFont;
    }

    private int getWeight(String weight) {
        int style = 0;
        if (weight.endsWith("mt")) {
            weight = weight.substring(0, weight.length() - 2);
        }
        if (weight.indexOf("heavy") != -1) {
            style = 1;
        } else if (weight.indexOf("bold") != -1) {
            style = 1;
        } else if (weight.indexOf("roman") != -1) {
            style = 0;
        }
        if (weight.indexOf("italic") != -1) {
            style += 2;
        } else if (weight.indexOf("oblique") != -1) {
            style += 2;
        }
        return style;
    }

    public final Font getUnscaledFont() {
        if (this.unscaledFont == null) {
            this.unscaledFont = new Font(this.defaultFont, 0, 1);
        }
        return this.unscaledFont;
    }

    public final void setEmbeddedCachedShape(int idx, PdfGlyph shape) {
        PdfGlyph[] cache = this.cachedEmbeddedShapes;
        if (cache == null) {
            this.cachedEmbeddedShapes = cache = new PdfGlyph[this.maxCharCount];
        }
        cache[idx] = shape;
    }

    public final PdfGlyph getEmbeddedCachedShape(int idx) {
        PdfGlyph[] cache = this.cachedEmbeddedShapes;
        if (cache == null) {
            return null;
        }
        PdfGlyph currentShape = cache[idx];
        if (currentShape == null) {
            return null;
        }
        return currentShape;
    }

    public PdfGlyph getEmbeddedGlyph(GlyphFactory factory, String glyph, float[][] trm, int rawInt, String displayValue, float currentWidth, String key) {
        return null;
    }

    public void setGIDtoCID(int[] cidToGIDMap) {
    }

    public void setEncodingToUse(boolean hasEncoding, int fontEncoding, boolean b, boolean isCIDFont) {
    }

    public int readEmbeddedFont(boolean TTstreamisCID, byte[] fontDataAsArray, FontData fontData) {
        return 0;
    }

    public void setIsSubsetted(boolean b) {
        this.isSubsetted = b;
    }

    public void setT3Glyph(String pKey, PdfGlyph glyph) {
    }

    public void setCharString(String s, byte[] bytes) {
    }

    public int getNumber(FontData fontData, int p, double[] op, int i, boolean b) {
        return 0;
    }

    public int getNumber(byte[] fontDataAsArray, int p, double[] op, int i, boolean b) {
        return 0;
    }

    public boolean is1C() {
        return false;
    }

    public void setis1C(boolean b) {
    }

    public void setValuesForGlyph(int rawInt, String charGlyph, String displayValue, String embeddedChar) {
        Integer key = new Integer(rawInt);
        this.chars.put(key, charGlyph);
        this.displayValues.put(key, displayValue);
        this.embeddedChars.put(key, embeddedChar);
    }

    public String getDisplayValue(Integer key) {
        return (String)this.displayValues.get(key);
    }

    public String getCharGlyph(Integer key) {
        return (String)this.chars.get(key);
    }

    public String getEmbeddedEnc(Integer key) {
        return (String)this.embeddedChars.get(key);
    }

    public Map getDisplayValues() {
        return this.displayValues;
    }

    public Map getCharGlyphs() {
        return this.chars;
    }

    public Map getEmbeddedEncs() {
        return this.embeddedChars;
    }

    public void setDisplayValues(Map displayValues) {
        this.displayValues = displayValues;
    }

    public void setCharGlyphs(Map chars) {
        this.chars = chars;
    }

    public void setEmbeddedEncs(Map embeddedChars) {
        this.embeddedChars = embeddedChars;
    }

    public void setLocalBias(int i) {
        this.localBias = i;
    }

    public void setGlobalBias(int i) {
        this.globalBias = i;
    }

    public float getTTWidth(String charGlyph, int rawInt, String displayValue, boolean b) {
        System.out.println("wrong!");
        System.exit(1);
        return 0.0f;
    }

    public String getPostName(int rawInt) {
        return "notdef";
    }

    public int getConvertedGlyph(int rawInt) {
        return -1;
    }

    public void setIsIdentity(boolean isIdentity) {
        this.isIdentity = isIdentity;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }
}

