/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.Hashtable;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.glyph.T3Glyphs;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class Type3
extends PdfFont {
    private GraphicsState currentGraphicsState;

    public Type3(PdfObjectReader current_pdf_file, GraphicsState currentGraphicsState) {
        this.glyphs = new T3Glyphs();
        this.init(current_pdf_file);
        this.currentGraphicsState = currentGraphicsState;
    }

    public final Map createFont(Map values, String fontID, boolean renderPage, Map descFontValues, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readType3Font}" + values, 0);
        this.fontTypes = 3;
        Map fontDescriptor = super.createFont(values, fontID, renderPage, descFontValues, objectStore);
        this.readWidths(values);
        this.readEmbeddedFont(values, objectStore);
        if (renderPage) {
            this.setFont(this.getBaseFontName(), 1);
        }
        return fontDescriptor;
    }

    private void readEmbeddedFont(Map values, ObjectStore objectStore) {
        boolean hires = false;
        Object procs = values.get("CharProcs");
        if (procs != null) {
            Map procValues = procs instanceof String ? this.currentPdfFile.readObject((String)procs, false, null) : (Map)procs;
            for (String pKey : procValues.keySet()) {
                Map resValue;
                String objectRef = (String)procValues.get(pKey);
                pKey = StandardFonts.convertNumberToGlyph(pKey);
                if (objectRef == null || !this.renderPage) continue;
                PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(this.currentPdfFile, hires, true);
                glyphDecoder.setStore(objectStore);
                Object res = values.get("Resources");
                if (res != null && (resValue = res instanceof Map ? (Map)res : this.currentPdfFile.getSubDictionary(res)) != null) {
                    try {
                        glyphDecoder.readResources(false, resValue, false);
                    }
                    catch (PdfException e2) {
                        e2.printStackTrace();
                    }
                }
                DynamicVectorRenderer glyphDisplay = new DynamicVectorRenderer(0, false, 20, objectStore);
                glyphDisplay.setHiResImageForDisplayMode(hires);
                glyphDisplay.setType3Glyph(pKey);
                try {
                    glyphDecoder.init(false, true, 7, 0, new PdfPageData(), 0, glyphDisplay, this.currentPdfFile, new Hashtable(), new Hashtable());
                    glyphDecoder.setDefaultColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                }
                catch (Exception e) {
                    LogWriter.writeLog("Font exception " + e);
                }
                int renderX = 0;
                int renderY = 0;
                try {
                    T3Size t3 = glyphDecoder.decodePageContent(objectRef, 0, 0, null);
                    renderX = t3.x;
                    renderY = t3.y;
                }
                catch (PdfException e1) {
                    e1.printStackTrace();
                }
                boolean ignoreColors = glyphDecoder.ignoreColors;
                T3Glyph glyph = new T3Glyph(glyphDisplay, renderX, renderY, ignoreColors, pKey);
                this.glyphs.setT3Glyph(pKey, glyph);
            }
            this.isFontEmbedded = true;
        }
    }
}

