/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;

public class Type1C
extends Type1 {
    static final boolean debugFont = false;
    static final boolean debugDictionary = false;
    int ROS = -1;
    int CIDFontVersion = 0;
    int CIDFontRevision = 0;
    int CIDFontType = 0;
    int CIDcount = 0;
    int UIDBase = -1;
    int FDArray = -1;
    int FDSelect = -1;
    final String[] OneByteCCFDict = new String[]{"version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBlues", "StdHW", "StdVW", "Escape", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "shortint", "longint", "BCD", "-reserved-"};
    final String[] TwoByteCCFDict = new String[]{"Copyright", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "PaintType", "CharstringType", "FontMatrix", "StrokeWidth", "BlueScale", "BlueShift", "BlueFuzz", "StemSnapH", "StemSnapV", "ForceBold", "-reserved-", "-reserved-", "LanguageGroup", "ExpansionFactor", "initialRandomSeed", "SyntheticBase", "PostScript", "BaseFontName", "BaseFontBlend", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName"};
    private int top = 0;
    private int charset = 0;
    private int enc = 0;
    private int charstrings = 0;
    private int stringIdx;
    private int stringStart;
    private int stringOffSize;
    private int privateDict = -1;
    private int privateDictOffset = -1;
    private static final int[] ExpertSubCharset;
    private static final String[] type1CStdStrings;
    private static final int[] ISOAdobeCharset;
    private static final int[] ExpertCharset;

    static {
        int[] nArray = new int[87];
        nArray[1] = 1;
        nArray[2] = 231;
        nArray[3] = 232;
        nArray[4] = 235;
        nArray[5] = 236;
        nArray[6] = 237;
        nArray[7] = 238;
        nArray[8] = 13;
        nArray[9] = 14;
        nArray[10] = 15;
        nArray[11] = 99;
        nArray[12] = 239;
        nArray[13] = 240;
        nArray[14] = 241;
        nArray[15] = 242;
        nArray[16] = 243;
        nArray[17] = 244;
        nArray[18] = 245;
        nArray[19] = 246;
        nArray[20] = 247;
        nArray[21] = 248;
        nArray[22] = 27;
        nArray[23] = 28;
        nArray[24] = 249;
        nArray[25] = 250;
        nArray[26] = 251;
        nArray[27] = 253;
        nArray[28] = 254;
        nArray[29] = 255;
        nArray[30] = 256;
        nArray[31] = 257;
        nArray[32] = 258;
        nArray[33] = 259;
        nArray[34] = 260;
        nArray[35] = 261;
        nArray[36] = 262;
        nArray[37] = 263;
        nArray[38] = 264;
        nArray[39] = 265;
        nArray[40] = 266;
        nArray[41] = 109;
        nArray[42] = 110;
        nArray[43] = 267;
        nArray[44] = 268;
        nArray[45] = 269;
        nArray[46] = 270;
        nArray[47] = 272;
        nArray[48] = 300;
        nArray[49] = 301;
        nArray[50] = 302;
        nArray[51] = 305;
        nArray[52] = 314;
        nArray[53] = 315;
        nArray[54] = 158;
        nArray[55] = 155;
        nArray[56] = 163;
        nArray[57] = 320;
        nArray[58] = 321;
        nArray[59] = 322;
        nArray[60] = 323;
        nArray[61] = 324;
        nArray[62] = 325;
        nArray[63] = 326;
        nArray[64] = 150;
        nArray[65] = 164;
        nArray[66] = 169;
        nArray[67] = 327;
        nArray[68] = 328;
        nArray[69] = 329;
        nArray[70] = 330;
        nArray[71] = 331;
        nArray[72] = 332;
        nArray[73] = 333;
        nArray[74] = 334;
        nArray[75] = 335;
        nArray[76] = 336;
        nArray[77] = 337;
        nArray[78] = 338;
        nArray[79] = 339;
        nArray[80] = 340;
        nArray[81] = 341;
        nArray[82] = 342;
        nArray[83] = 343;
        nArray[84] = 344;
        nArray[85] = 345;
        nArray[86] = 346;
        ExpertSubCharset = nArray;
        type1CStdStrings = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
        int[] nArray2 = new int[229];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        nArray2[8] = 8;
        nArray2[9] = 9;
        nArray2[10] = 10;
        nArray2[11] = 11;
        nArray2[12] = 12;
        nArray2[13] = 13;
        nArray2[14] = 14;
        nArray2[15] = 15;
        nArray2[16] = 16;
        nArray2[17] = 17;
        nArray2[18] = 18;
        nArray2[19] = 19;
        nArray2[20] = 20;
        nArray2[21] = 21;
        nArray2[22] = 22;
        nArray2[23] = 23;
        nArray2[24] = 24;
        nArray2[25] = 25;
        nArray2[26] = 26;
        nArray2[27] = 27;
        nArray2[28] = 28;
        nArray2[29] = 29;
        nArray2[30] = 30;
        nArray2[31] = 31;
        nArray2[32] = 32;
        nArray2[33] = 33;
        nArray2[34] = 34;
        nArray2[35] = 35;
        nArray2[36] = 36;
        nArray2[37] = 37;
        nArray2[38] = 38;
        nArray2[39] = 39;
        nArray2[40] = 40;
        nArray2[41] = 41;
        nArray2[42] = 42;
        nArray2[43] = 43;
        nArray2[44] = 44;
        nArray2[45] = 45;
        nArray2[46] = 46;
        nArray2[47] = 47;
        nArray2[48] = 48;
        nArray2[49] = 49;
        nArray2[50] = 50;
        nArray2[51] = 51;
        nArray2[52] = 52;
        nArray2[53] = 53;
        nArray2[54] = 54;
        nArray2[55] = 55;
        nArray2[56] = 56;
        nArray2[57] = 57;
        nArray2[58] = 58;
        nArray2[59] = 59;
        nArray2[60] = 60;
        nArray2[61] = 61;
        nArray2[62] = 62;
        nArray2[63] = 63;
        nArray2[64] = 64;
        nArray2[65] = 65;
        nArray2[66] = 66;
        nArray2[67] = 67;
        nArray2[68] = 68;
        nArray2[69] = 69;
        nArray2[70] = 70;
        nArray2[71] = 71;
        nArray2[72] = 72;
        nArray2[73] = 73;
        nArray2[74] = 74;
        nArray2[75] = 75;
        nArray2[76] = 76;
        nArray2[77] = 77;
        nArray2[78] = 78;
        nArray2[79] = 79;
        nArray2[80] = 80;
        nArray2[81] = 81;
        nArray2[82] = 82;
        nArray2[83] = 83;
        nArray2[84] = 84;
        nArray2[85] = 85;
        nArray2[86] = 86;
        nArray2[87] = 87;
        nArray2[88] = 88;
        nArray2[89] = 89;
        nArray2[90] = 90;
        nArray2[91] = 91;
        nArray2[92] = 92;
        nArray2[93] = 93;
        nArray2[94] = 94;
        nArray2[95] = 95;
        nArray2[96] = 96;
        nArray2[97] = 97;
        nArray2[98] = 98;
        nArray2[99] = 99;
        nArray2[100] = 100;
        nArray2[101] = 101;
        nArray2[102] = 102;
        nArray2[103] = 103;
        nArray2[104] = 104;
        nArray2[105] = 105;
        nArray2[106] = 106;
        nArray2[107] = 107;
        nArray2[108] = 108;
        nArray2[109] = 109;
        nArray2[110] = 110;
        nArray2[111] = 111;
        nArray2[112] = 112;
        nArray2[113] = 113;
        nArray2[114] = 114;
        nArray2[115] = 115;
        nArray2[116] = 116;
        nArray2[117] = 117;
        nArray2[118] = 118;
        nArray2[119] = 119;
        nArray2[120] = 120;
        nArray2[121] = 121;
        nArray2[122] = 122;
        nArray2[123] = 123;
        nArray2[124] = 124;
        nArray2[125] = 125;
        nArray2[126] = 126;
        nArray2[127] = 127;
        nArray2[128] = 128;
        nArray2[129] = 129;
        nArray2[130] = 130;
        nArray2[131] = 131;
        nArray2[132] = 132;
        nArray2[133] = 133;
        nArray2[134] = 134;
        nArray2[135] = 135;
        nArray2[136] = 136;
        nArray2[137] = 137;
        nArray2[138] = 138;
        nArray2[139] = 139;
        nArray2[140] = 140;
        nArray2[141] = 141;
        nArray2[142] = 142;
        nArray2[143] = 143;
        nArray2[144] = 144;
        nArray2[145] = 145;
        nArray2[146] = 146;
        nArray2[147] = 147;
        nArray2[148] = 148;
        nArray2[149] = 149;
        nArray2[150] = 150;
        nArray2[151] = 151;
        nArray2[152] = 152;
        nArray2[153] = 153;
        nArray2[154] = 154;
        nArray2[155] = 155;
        nArray2[156] = 156;
        nArray2[157] = 157;
        nArray2[158] = 158;
        nArray2[159] = 159;
        nArray2[160] = 160;
        nArray2[161] = 161;
        nArray2[162] = 162;
        nArray2[163] = 163;
        nArray2[164] = 164;
        nArray2[165] = 165;
        nArray2[166] = 166;
        nArray2[167] = 167;
        nArray2[168] = 168;
        nArray2[169] = 169;
        nArray2[170] = 170;
        nArray2[171] = 171;
        nArray2[172] = 172;
        nArray2[173] = 173;
        nArray2[174] = 174;
        nArray2[175] = 175;
        nArray2[176] = 176;
        nArray2[177] = 177;
        nArray2[178] = 178;
        nArray2[179] = 179;
        nArray2[180] = 180;
        nArray2[181] = 181;
        nArray2[182] = 182;
        nArray2[183] = 183;
        nArray2[184] = 184;
        nArray2[185] = 185;
        nArray2[186] = 186;
        nArray2[187] = 187;
        nArray2[188] = 188;
        nArray2[189] = 189;
        nArray2[190] = 190;
        nArray2[191] = 191;
        nArray2[192] = 192;
        nArray2[193] = 193;
        nArray2[194] = 194;
        nArray2[195] = 195;
        nArray2[196] = 196;
        nArray2[197] = 197;
        nArray2[198] = 198;
        nArray2[199] = 199;
        nArray2[200] = 200;
        nArray2[201] = 201;
        nArray2[202] = 202;
        nArray2[203] = 203;
        nArray2[204] = 204;
        nArray2[205] = 205;
        nArray2[206] = 206;
        nArray2[207] = 207;
        nArray2[208] = 208;
        nArray2[209] = 209;
        nArray2[210] = 210;
        nArray2[211] = 211;
        nArray2[212] = 212;
        nArray2[213] = 213;
        nArray2[214] = 214;
        nArray2[215] = 215;
        nArray2[216] = 216;
        nArray2[217] = 217;
        nArray2[218] = 218;
        nArray2[219] = 219;
        nArray2[220] = 220;
        nArray2[221] = 221;
        nArray2[222] = 222;
        nArray2[223] = 223;
        nArray2[224] = 224;
        nArray2[225] = 225;
        nArray2[226] = 226;
        nArray2[227] = 227;
        nArray2[228] = 228;
        ISOAdobeCharset = nArray2;
        int[] nArray3 = new int[166];
        nArray3[1] = 1;
        nArray3[2] = 229;
        nArray3[3] = 230;
        nArray3[4] = 231;
        nArray3[5] = 232;
        nArray3[6] = 233;
        nArray3[7] = 234;
        nArray3[8] = 235;
        nArray3[9] = 236;
        nArray3[10] = 237;
        nArray3[11] = 238;
        nArray3[12] = 13;
        nArray3[13] = 14;
        nArray3[14] = 15;
        nArray3[15] = 99;
        nArray3[16] = 239;
        nArray3[17] = 240;
        nArray3[18] = 241;
        nArray3[19] = 242;
        nArray3[20] = 243;
        nArray3[21] = 244;
        nArray3[22] = 245;
        nArray3[23] = 246;
        nArray3[24] = 247;
        nArray3[25] = 248;
        nArray3[26] = 27;
        nArray3[27] = 28;
        nArray3[28] = 249;
        nArray3[29] = 250;
        nArray3[30] = 251;
        nArray3[31] = 252;
        nArray3[32] = 253;
        nArray3[33] = 254;
        nArray3[34] = 255;
        nArray3[35] = 256;
        nArray3[36] = 257;
        nArray3[37] = 258;
        nArray3[38] = 259;
        nArray3[39] = 260;
        nArray3[40] = 261;
        nArray3[41] = 262;
        nArray3[42] = 263;
        nArray3[43] = 264;
        nArray3[44] = 265;
        nArray3[45] = 266;
        nArray3[46] = 109;
        nArray3[47] = 110;
        nArray3[48] = 267;
        nArray3[49] = 268;
        nArray3[50] = 269;
        nArray3[51] = 270;
        nArray3[52] = 271;
        nArray3[53] = 272;
        nArray3[54] = 273;
        nArray3[55] = 274;
        nArray3[56] = 275;
        nArray3[57] = 276;
        nArray3[58] = 277;
        nArray3[59] = 278;
        nArray3[60] = 279;
        nArray3[61] = 280;
        nArray3[62] = 281;
        nArray3[63] = 282;
        nArray3[64] = 283;
        nArray3[65] = 284;
        nArray3[66] = 285;
        nArray3[67] = 286;
        nArray3[68] = 287;
        nArray3[69] = 288;
        nArray3[70] = 289;
        nArray3[71] = 290;
        nArray3[72] = 291;
        nArray3[73] = 292;
        nArray3[74] = 293;
        nArray3[75] = 294;
        nArray3[76] = 295;
        nArray3[77] = 296;
        nArray3[78] = 297;
        nArray3[79] = 298;
        nArray3[80] = 299;
        nArray3[81] = 300;
        nArray3[82] = 301;
        nArray3[83] = 302;
        nArray3[84] = 303;
        nArray3[85] = 304;
        nArray3[86] = 305;
        nArray3[87] = 306;
        nArray3[88] = 307;
        nArray3[89] = 308;
        nArray3[90] = 309;
        nArray3[91] = 310;
        nArray3[92] = 311;
        nArray3[93] = 312;
        nArray3[94] = 313;
        nArray3[95] = 314;
        nArray3[96] = 315;
        nArray3[97] = 316;
        nArray3[98] = 317;
        nArray3[99] = 318;
        nArray3[100] = 158;
        nArray3[101] = 155;
        nArray3[102] = 163;
        nArray3[103] = 319;
        nArray3[104] = 320;
        nArray3[105] = 321;
        nArray3[106] = 322;
        nArray3[107] = 323;
        nArray3[108] = 324;
        nArray3[109] = 325;
        nArray3[110] = 326;
        nArray3[111] = 150;
        nArray3[112] = 164;
        nArray3[113] = 169;
        nArray3[114] = 327;
        nArray3[115] = 328;
        nArray3[116] = 329;
        nArray3[117] = 330;
        nArray3[118] = 331;
        nArray3[119] = 332;
        nArray3[120] = 333;
        nArray3[121] = 334;
        nArray3[122] = 335;
        nArray3[123] = 336;
        nArray3[124] = 337;
        nArray3[125] = 338;
        nArray3[126] = 339;
        nArray3[127] = 340;
        nArray3[128] = 341;
        nArray3[129] = 342;
        nArray3[130] = 343;
        nArray3[131] = 344;
        nArray3[132] = 345;
        nArray3[133] = 346;
        nArray3[134] = 347;
        nArray3[135] = 348;
        nArray3[136] = 349;
        nArray3[137] = 350;
        nArray3[138] = 351;
        nArray3[139] = 352;
        nArray3[140] = 353;
        nArray3[141] = 354;
        nArray3[142] = 355;
        nArray3[143] = 356;
        nArray3[144] = 357;
        nArray3[145] = 358;
        nArray3[146] = 359;
        nArray3[147] = 360;
        nArray3[148] = 361;
        nArray3[149] = 362;
        nArray3[150] = 363;
        nArray3[151] = 364;
        nArray3[152] = 365;
        nArray3[153] = 366;
        nArray3[154] = 367;
        nArray3[155] = 368;
        nArray3[156] = 369;
        nArray3[157] = 370;
        nArray3[158] = 371;
        nArray3[159] = 372;
        nArray3[160] = 373;
        nArray3[161] = 374;
        nArray3[162] = 375;
        nArray3[163] = 376;
        nArray3[164] = 377;
        nArray3[165] = 378;
        ExpertCharset = nArray3;
    }

    public Type1C() {
    }

    public Type1C(PdfObjectReader current_pdf_file, String substiuteFont) {
        this.glyphs = new T1Glyphs(false);
        this.init(current_pdf_file);
        this.substituteFont = substiuteFont;
    }

    protected void readEmbeddedFont(Map values, Map fontDescriptor) throws Exception {
        if (this.substituteFont != null) {
            int bytes_read;
            this.isFontSubstituted = true;
            ByteArrayOutputStream to = new ByteArrayOutputStream();
            InputStream jarFile = this.loader.getResourceAsStream(this.substituteFont);
            BufferedInputStream from = jarFile == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(jarFile);
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
            to.close();
            from.close();
            FontData fontData = null;
            try {
                if (this.substituteFont.indexOf(".afm") != -1) {
                    this.readType1FontFile(to.toByteArray());
                } else {
                    this.readType1CFontFile(to.toByteArray(), fontData);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogWriter.writeLog("[PDF]Substitute font=" + this.substituteFont + "Type 1 exception=" + e);
            }
            if (this.isFontSubstituted && this.glyphs.remapFont) {
                this.glyphs.remapFont = false;
            }
        } else if (fontDescriptor != null) {
            String fontFileRef = (String)fontDescriptor.get("FontFile");
            if (fontFileRef != null) {
                try {
                    byte[] stream = this.currentPdfFile.readStream(fontFileRef, true);
                    if (stream != null) {
                        this.readType1FontFile(stream);
                    }
                }
                catch (Exception e) {
                    System.out.println("Type 1 exception=" + e);
                }
            } else {
                Object objectFontFileRef = fontDescriptor.get("FontFile3");
                try {
                    if (objectFontFileRef != null) {
                        byte[] stream = objectFontFileRef instanceof String ? this.currentPdfFile.readStream((String)objectFontFileRef, true) : (byte[])((Map)objectFontFileRef).get("DecodedStream");
                        FontData fontData = null;
                        if (stream != null && (stream.length <= 3 || stream[0] != 719 || stream[1] != 84 || stream[2] != 84 || stream[3] != 79)) {
                            this.readType1CFontFile(stream, fontData);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public Map createFont(Map values, String fontID, boolean renderPage, Map descFontValues, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readType1Font}" + values, 0);
        this.fontTypes = 1;
        Map fontDescriptor = super.createFont(values, fontID, renderPage, descFontValues, objectStore);
        this.readEmbeddedFont(values, fontDescriptor);
        this.readWidths(values);
        if (this.embeddedFontName != null && this.is1C() && (this.cleanupFonts || PdfStreamDecoder.runningStoryPad)) {
            this.embeddedFontName = this.cleanupFontName(this.embeddedFontName);
            this.setBaseFontName(this.embeddedFontName);
            this.setFontName(this.embeddedFontName);
        }
        if (renderPage) {
            this.setFont(this.getBaseFontName(), 1);
        }
        return fontDescriptor;
    }

    public Type1C(byte[] fontDataAsArray, FontData fontData, PdfJavaGlyphs glyphs) throws Exception {
        this.glyphs = glyphs;
        this.readType1CFontFile(fontDataAsArray, fontData);
    }

    private final void readType1CFontFile(byte[] fontDataAsArray, FontData fontDataAsObject) throws Exception {
        int dicEnd;
        int dicStart;
        byte offsize;
        int count;
        byte minor;
        byte major;
        LogWriter.writeMethod("{readType1CFontFile}", 0);
        LogWriter.writeLog("Embedded Type1C font used");
        this.glyphs.setis1C(true);
        boolean isByteArray = fontDataAsArray != null;
        int size = 2;
        if (isByteArray) {
            major = fontDataAsArray[0];
            minor = fontDataAsArray[1];
        } else {
            major = fontDataAsObject.getByte(0);
            minor = fontDataAsObject.getByte(1);
        }
        if (major != 1 || minor != 0) {
            LogWriter.writeLog("1C  format " + major + ':' + minor + " not fully supported");
        }
        this.top = isByteArray ? fontDataAsArray[2] : (int)fontDataAsObject.getByte(2);
        if (isByteArray) {
            count = this.getWord(fontDataAsArray, this.top, size);
            offsize = fontDataAsArray[this.top + size];
        } else {
            count = this.getWord(fontDataAsObject, this.top, size);
            offsize = fontDataAsObject.getByte(this.top + size);
        }
        this.top += size + 1;
        int start = this.top + (count + 1) * offsize - 1;
        this.top = isByteArray ? start + this.getWord(fontDataAsArray, this.top + count * offsize, (int)offsize) : start + this.getWord(fontDataAsObject, this.top + count * offsize, (int)offsize);
        if (isByteArray) {
            count = this.getWord(fontDataAsArray, this.top, size);
            offsize = fontDataAsArray[this.top + size];
        } else {
            count = this.getWord(fontDataAsObject, this.top, size);
            offsize = fontDataAsObject.getByte(this.top + size);
        }
        this.top += size + 1;
        start = this.top + (count + 1) * offsize - 1;
        if (isByteArray) {
            dicStart = start + this.getWord(fontDataAsArray, this.top, (int)offsize);
            dicEnd = start + this.getWord(fontDataAsArray, this.top + offsize, (int)offsize);
        } else {
            dicStart = start + this.getWord(fontDataAsObject, this.top, (int)offsize);
            dicEnd = start + this.getWord(fontDataAsObject, this.top + offsize, (int)offsize);
        }
        String[] strings = this.readStringIndex(fontDataAsArray, fontDataAsObject, start, offsize, count);
        this.readGlobalSubRoutines(fontDataAsArray, fontDataAsObject);
        this.decodeDictionary(fontDataAsArray, fontDataAsObject, dicStart, dicEnd, strings);
        if (this.FDSelect != -1) {
            try {
                int nextDic = this.FDArray;
                if (isByteArray) {
                    count = this.getWord(fontDataAsArray, nextDic, size);
                    offsize = fontDataAsArray[nextDic + size];
                } else {
                    count = this.getWord(fontDataAsObject, nextDic, size);
                    offsize = fontDataAsObject.getByte(nextDic + size);
                }
                start = (nextDic += size + 1) + (count + 1) * offsize - 1;
                if (isByteArray) {
                    dicStart = start + this.getWord(fontDataAsArray, nextDic, (int)offsize);
                    dicEnd = start + this.getWord(fontDataAsArray, nextDic + offsize, (int)offsize);
                } else {
                    dicStart = start + this.getWord(fontDataAsObject, nextDic, (int)offsize);
                    dicEnd = start + this.getWord(fontDataAsObject, nextDic + offsize, (int)offsize);
                }
                this.decodeDictionary(fontDataAsArray, fontDataAsObject, dicStart, dicEnd, strings);
            }
            catch (Exception ee) {
                ee.printStackTrace();
                System.exit(1);
            }
        }
        this.top = this.charstrings;
        int nGlyphs = isByteArray ? this.getWord(fontDataAsArray, this.top, size) : this.getWord(fontDataAsObject, this.top, size);
        int[] names = this.readCharset(this.charset, nGlyphs, this.charstrings, fontDataAsObject, fontDataAsArray);
        this.setEncoding(fontDataAsArray, fontDataAsObject, nGlyphs, names);
        this.top = this.charstrings;
        this.readGlyphs(fontDataAsArray, fontDataAsObject, nGlyphs, names);
        if (this.privateDict != -1) {
            try {
                int nSubrs;
                this.top = this.privateDict + this.privateDictOffset;
                int len = isByteArray ? fontDataAsArray.length : fontDataAsObject.length();
                if (this.top + 2 < len && (nSubrs = isByteArray ? this.getWord(fontDataAsArray, this.top, size) : this.getWord(fontDataAsObject, this.top, size)) > 0) {
                    this.readSubrs(fontDataAsArray, fontDataAsObject, nSubrs);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        this.isFontEmbedded = true;
    }

    private final void setEncoding(byte[] fontDataAsArray, FontData fontDataAsObject, int nGlyphs, int[] names) {
        boolean isByteArray;
        LogWriter.writeMethod("{setEncoding}", 0);
        boolean bl = isByteArray = fontDataAsArray != null;
        if (this.enc == 0) {
            this.embeddedEnc = 1;
            if (this.fontEnc == -1) {
                this.putFontEncoding(1);
            }
        } else if (this.enc == 1) {
            this.embeddedEnc = 3;
            if (this.fontEnc == -1) {
                this.putFontEncoding(3);
            }
        } else {
            String name;
            int c;
            int i;
            this.top = this.enc;
            int encFormat = isByteArray ? fontDataAsArray[this.top++] & 0xFF : fontDataAsObject.getByte(this.top++) & 0xFF;
            if ((encFormat & 0x7F) == 0) {
                int nCodes = isByteArray ? 1 + (fontDataAsArray[this.top++] & 0xFF) : 1 + (fontDataAsObject.getByte(this.top++) & 0xFF);
                if (nCodes > nGlyphs) {
                    nCodes = nGlyphs;
                }
                i = 1;
                while (i < nCodes) {
                    if (isByteArray) {
                        c = fontDataAsArray[this.top++] & 0xFF;
                        name = this.getString(fontDataAsArray, names[i], this.stringIdx, this.stringStart, this.stringOffSize);
                    } else {
                        c = fontDataAsObject.getByte(this.top++) & 0xFF;
                        name = this.getString(fontDataAsObject, names[i], this.stringIdx, this.stringStart, this.stringOffSize);
                    }
                    this.putChar(c, name);
                    ++i;
                }
            } else if ((encFormat & 0x7F) == 1) {
                int nRanges = isByteArray ? fontDataAsArray[this.top++] & 0xFF : fontDataAsObject.getByte(this.top++) & 0xFF;
                int nCodes = 1;
                int i2 = 0;
                while (i2 < nRanges) {
                    int nLeft;
                    if (isByteArray) {
                        c = fontDataAsArray[this.top++] & 0xFF;
                        nLeft = fontDataAsArray[this.top++] & 0xFF;
                    } else {
                        c = fontDataAsObject.getByte(this.top++) & 0xFF;
                        nLeft = fontDataAsObject.getByte(this.top++) & 0xFF;
                    }
                    int j = 0;
                    while (j <= nLeft && nCodes < nGlyphs) {
                        name = isByteArray ? this.getString(fontDataAsArray, names[nCodes], this.stringIdx, this.stringStart, this.stringOffSize) : this.getString(fontDataAsObject, names[nCodes], this.stringIdx, this.stringStart, this.stringOffSize);
                        this.putChar(c, name);
                        ++nCodes;
                        ++c;
                        ++j;
                    }
                    ++i2;
                }
            }
            if ((encFormat & 0x80) != 0) {
                int nSups = isByteArray ? fontDataAsArray[this.top++] & 0xFF : fontDataAsObject.getByte(this.top++) & 0xFF;
                i = 0;
                while (i < nSups) {
                    c = isByteArray ? fontDataAsArray[this.top++] & 0xFF : fontDataAsObject.getByte(this.top++) & 0xFF;
                    int sid = isByteArray ? this.getWord(fontDataAsArray, this.top, 2) : this.getWord(fontDataAsObject, this.top, 2);
                    this.top += 2;
                    name = isByteArray ? this.getString(fontDataAsArray, sid, this.stringIdx, this.stringStart, this.stringOffSize) : this.getString(fontDataAsObject, sid, this.stringIdx, this.stringStart, this.stringOffSize);
                    this.putChar(c, name);
                    ++i;
                }
            }
        }
    }

    private final void readSubrs(byte[] fontDataAsArray, FontData fontDataAsObject, int nSubrs) throws Exception {
        boolean isByteArray = fontDataAsArray != null;
        byte subrOffSize = isByteArray ? fontDataAsArray[this.top + 2] : fontDataAsObject.getByte(this.top + 2);
        this.top += 3;
        int subrIdx = this.top;
        int subrStart = this.top + (nSubrs + 1) * subrOffSize - 1;
        int nextTablePtr = this.top + nSubrs * subrOffSize;
        this.top = isByteArray ? (nextTablePtr < fontDataAsArray.length ? subrStart + this.getWord(fontDataAsArray, nextTablePtr, (int)subrOffSize) : fontDataAsArray.length - 1) : (nextTablePtr < fontDataAsArray.length ? subrStart + this.getWord(fontDataAsObject, nextTablePtr, (int)subrOffSize) : fontDataAsObject.length() - 1);
        int[] subrOffset = new int[nSubrs + 2];
        int ii = subrIdx;
        int jj = 0;
        while (jj < nSubrs + 1) {
            if (isByteArray) {
                if (ii + subrOffSize < fontDataAsArray.length) {
                    subrOffset[jj] = subrStart + this.getWord(fontDataAsArray, ii, (int)subrOffSize);
                }
            } else if (ii + subrOffSize < fontDataAsObject.length()) {
                subrOffset[jj] = subrStart + this.getWord(fontDataAsObject, ii, (int)subrOffSize);
            }
            ii += subrOffSize;
            ++jj;
        }
        subrOffset[nSubrs + 1] = this.top;
        this.glyphs.setLocalBias(this.calculateSubroutineBias(nSubrs));
        int current = subrOffset[0];
        int jj2 = 1;
        while (jj2 < nSubrs + 1) {
            if (current != 0 && subrOffset[jj2] <= fontDataAsArray.length && subrOffset[jj2] >= 0 && subrOffset[jj2] != 0) {
                ByteArrayOutputStream nextSubr = new ByteArrayOutputStream();
                int c = current;
                while (c < subrOffset[jj2]) {
                    if (!isByteArray && c < fontDataAsObject.length()) {
                        nextSubr.write(fontDataAsObject.getByte(c));
                    }
                    ++c;
                }
                if (isByteArray) {
                    int length = subrOffset[jj2] - current;
                    if (length > 0) {
                        byte[] nextSub = new byte[length];
                        System.arraycopy(fontDataAsArray, current, nextSub, 0, length);
                        this.glyphs.setCharString("subrs" + (jj2 - 1), nextSub);
                    }
                } else {
                    nextSubr.close();
                    this.glyphs.setCharString("subrs" + (jj2 - 1), nextSubr.toByteArray());
                }
                current = subrOffset[jj2];
            }
            ++jj2;
        }
    }

    private final void readGlyphs(byte[] fontDataAsArray, FontData fontDataAsObject, int nGlyphs, int[] names) throws Exception {
        LogWriter.writeMethod("{readGlyphs}" + nGlyphs, 0);
        boolean isByteArray = fontDataAsArray != null;
        try {
            byte glyphOffSize = isByteArray ? fontDataAsArray[this.top + 2] : fontDataAsObject.getByte(this.top + 2);
            this.top += 3;
            int glyphIdx = this.top;
            int glyphStart = this.top + (nGlyphs + 1) * glyphOffSize - 1;
            this.top = isByteArray ? glyphStart + this.getWord(fontDataAsArray, this.top + nGlyphs * glyphOffSize, (int)glyphOffSize) : glyphStart + this.getWord(fontDataAsObject, this.top + nGlyphs * glyphOffSize, (int)glyphOffSize);
            int[] glyphoffset = new int[nGlyphs + 2];
            int ii = glyphIdx;
            int jj = 0;
            while (jj < nGlyphs + 1) {
                glyphoffset[jj] = isByteArray ? glyphStart + this.getWord(fontDataAsArray, ii, (int)glyphOffSize) : glyphStart + this.getWord(fontDataAsObject, ii, (int)glyphOffSize);
                ii += glyphOffSize;
                ++jj;
            }
            glyphoffset[nGlyphs + 1] = this.top;
            int current = glyphoffset[0];
            int jj2 = 1;
            while (jj2 < nGlyphs + 1) {
                byte[] nextGlyph = new byte[glyphoffset[jj2] - current];
                int c = current;
                while (c < glyphoffset[jj2]) {
                    nextGlyph[c - current] = isByteArray ? fontDataAsArray[c] : fontDataAsObject.getByte(c);
                    ++c;
                }
                if (this.isCID) {
                    this.glyphs.setCharString(String.valueOf(names[jj2 - 1]), nextGlyph);
                } else {
                    String name = isByteArray ? this.getString(fontDataAsArray, names[jj2 - 1], this.stringIdx, this.stringStart, this.stringOffSize) : this.getString(fontDataAsObject, names[jj2 - 1], this.stringIdx, this.stringStart, this.stringOffSize);
                    this.glyphs.setCharString(name, nextGlyph);
                }
                current = glyphoffset[jj2];
                ++jj2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final int calculateSubroutineBias(int subroutineCount) {
        int bias = subroutineCount < 1240 ? 107 : (subroutineCount < 33900 ? 1131 : 32768);
        return bias;
    }

    private final void readGlobalSubRoutines(byte[] fontDataAsArray, FontData fontDataAsObject) throws Exception {
        int count;
        int subOffSize;
        boolean isByteArray;
        LogWriter.writeMethod("{readGlobalSubRoutines}", 0);
        boolean bl = isByteArray = fontDataAsArray != null;
        if (isByteArray) {
            subOffSize = fontDataAsArray[this.top + 2] & 0xFF;
            count = this.getWord(fontDataAsArray, this.top, 2);
        } else {
            subOffSize = fontDataAsObject.getByte(this.top + 2) & 0xFF;
            count = this.getWord(fontDataAsObject, this.top, 2);
        }
        this.top += 3;
        if (count > 0) {
            int idx = this.top;
            int start = this.top + (count + 1) * subOffSize - 1;
            this.top = isByteArray ? start + this.getWord(fontDataAsArray, this.top + count * subOffSize, subOffSize) : start + this.getWord(fontDataAsObject, this.top + count * subOffSize, subOffSize);
            int[] offset = new int[count + 2];
            int ii = idx;
            int jj = 0;
            while (jj < count + 1) {
                offset[jj] = isByteArray ? start + this.getWord(fontDataAsArray, ii, subOffSize) : start + this.getWord(fontDataAsObject, ii, subOffSize);
                ii += subOffSize;
                ++jj;
            }
            offset[count + 1] = this.top;
            this.glyphs.setGlobalBias(this.calculateSubroutineBias(count));
            int current = offset[0];
            int jj2 = 1;
            while (jj2 < count + 1) {
                ByteArrayOutputStream nextStream = new ByteArrayOutputStream();
                int c = current;
                while (c < offset[jj2]) {
                    if (isByteArray) {
                        nextStream.write(fontDataAsArray[c]);
                    } else {
                        nextStream.write(fontDataAsObject.getByte(c));
                    }
                    ++c;
                }
                nextStream.close();
                this.glyphs.setCharString("global" + (jj2 - 1), nextStream.toByteArray());
                current = offset[jj2];
                ++jj2;
            }
        }
    }

    private void decodeDictionary(byte[] fontDataAsArray, FontData fontDataAsObject, int dicStart, int dicEnd, String[] strings) {
        boolean fdReset = false;
        LogWriter.writeMethod("{decodeDictionary}", 0);
        boolean isByteArray = fontDataAsArray != null;
        int p = dicStart;
        int i = 0;
        double[] op = new double[48];
        while (p < dicEnd) {
            int nextVal = isByteArray ? fontDataAsArray[p] & 0xFF : fontDataAsObject.getByte(p) & 0xFF;
            if (nextVal <= 27 || nextVal == 31) {
                int id;
                int key = nextVal;
                ++p;
                if (key == 12) {
                    key = isByteArray ? fontDataAsArray[p] & 0xFF : fontDataAsObject.getByte(p) & 0xFF;
                    ++p;
                    if (key == 36 || key == 37 || this.FDSelect == -1) {
                        if (key == 2) {
                            this.italicAngle = (int)op[0];
                        } else if (key == 7) {
                            System.arraycopy(op, 0, this.FontMatrix, 0, 6);
                        } else if (key == 30) {
                            this.ROS = (int)op[0];
                            this.isCID = true;
                        } else if (key == 31) {
                            this.CIDFontVersion = (int)op[0];
                        } else if (key == 32) {
                            this.CIDFontRevision = (int)op[0];
                        } else if (key == 33) {
                            this.CIDFontType = (int)op[0];
                        } else if (key == 34) {
                            this.CIDcount = (int)op[0];
                        } else if (key == 35) {
                            this.UIDBase = (int)op[0];
                        } else if (key == 36) {
                            this.FDArray = (int)op[0];
                        } else if (key == 37) {
                            this.FDSelect = (int)op[0];
                            fdReset = true;
                        } else if (key == 0) {
                            id = (int)op[0];
                            if (id > 390) {
                                id -= 390;
                            }
                            this.copyright = strings[id];
                        } else if (key != 21 && key != 22 && key == 38) {
                            // empty if block
                        }
                    }
                } else if (key == 2) {
                    id = (int)op[0];
                    if (id > 390) {
                        id -= 390;
                    }
                    this.embeddedFontName = strings[id];
                } else if (key != 3 && key != 5) {
                    if (key == 15) {
                        this.charset = (int)op[0];
                    } else if (key == 16) {
                        this.enc = (int)op[0];
                    } else if (key == 17) {
                        this.charstrings = (int)op[0];
                    } else if (key == 18 && this.glyphs.is1C()) {
                        this.privateDict = (int)op[1];
                        this.privateDictOffset = (int)op[0];
                    }
                }
                i = 0;
                continue;
            }
            p = isByteArray ? this.glyphs.getNumber(fontDataAsArray, p, op, i, false) : this.glyphs.getNumber(fontDataAsObject, p, op, i, false);
            ++i;
        }
        if (!fdReset) {
            this.FDSelect = -1;
        }
    }

    private String[] readStringIndex(byte[] fontDataAsArray, FontData fontDataAsObject, int start, int offsize, int count) {
        int nStrings;
        boolean isByteArray;
        LogWriter.writeMethod("{readStringIndex}", 0);
        boolean bl = isByteArray = fontDataAsArray != null;
        if (isByteArray) {
            this.top = start + this.getWord(fontDataAsArray, this.top + count * offsize, offsize);
            nStrings = this.getWord(fontDataAsArray, this.top, 2);
            this.stringOffSize = fontDataAsArray[this.top + 2];
        } else {
            this.top = start + this.getWord(fontDataAsObject, this.top + count * offsize, offsize);
            nStrings = this.getWord(fontDataAsObject, this.top, 2);
            this.stringOffSize = fontDataAsObject.getByte(this.top + 2);
        }
        this.top += 3;
        this.stringIdx = this.top;
        this.stringStart = this.top + (nStrings + 1) * this.stringOffSize - 1;
        this.top = isByteArray ? this.stringStart + this.getWord(fontDataAsArray, this.top + nStrings * this.stringOffSize, this.stringOffSize) : this.stringStart + this.getWord(fontDataAsObject, this.top + nStrings * this.stringOffSize, this.stringOffSize);
        int[] offsets = new int[nStrings + 2];
        String[] strings = new String[nStrings + 2];
        int ii = this.stringIdx;
        int jj = 0;
        while (jj < nStrings + 1) {
            offsets[jj] = isByteArray ? this.getWord(fontDataAsArray, ii, this.stringOffSize) : this.getWord(fontDataAsObject, ii, this.stringOffSize);
            ii += this.stringOffSize;
            ++jj;
        }
        offsets[nStrings + 1] = this.top - this.stringStart;
        int current = 0;
        int jj2 = 0;
        while (jj2 < nStrings + 1) {
            StringBuffer nextString = new StringBuffer();
            int c = current;
            while (c < offsets[jj2]) {
                if (isByteArray) {
                    nextString.append((char)fontDataAsArray[this.stringStart + c]);
                } else {
                    nextString.append((char)fontDataAsObject.getByte(this.stringStart + c));
                }
                ++c;
            }
            strings[jj2] = nextString.toString();
            current = offsets[jj2];
            ++jj2;
        }
        return strings;
    }

    private final String getString(FontData fontDataAsObject, int sid, int idx, int start, int offsize) {
        String result = null;
        if (sid < 391) {
            result = type1CStdStrings[sid];
        } else {
            int idx0 = start + this.getWord(fontDataAsObject, idx + (sid -= 391) * offsize, offsize);
            int idxPtr1 = start + this.getWord(fontDataAsObject, idx + (sid + 1) * offsize, offsize);
            int len = idxPtr1 - idx0;
            if (len > 255) {
                len = 255;
            }
            result = new String(fontDataAsObject.getBytes(idx0, len));
        }
        return result;
    }

    private final String getString(byte[] fontDataAsArray, int sid, int idx, int start, int offsize) {
        String result = null;
        if (sid < 391) {
            result = type1CStdStrings[sid];
        } else {
            int idx0 = start + this.getWord(fontDataAsArray, idx + (sid -= 391) * offsize, offsize);
            int idxPtr1 = start + this.getWord(fontDataAsArray, idx + (sid + 1) * offsize, offsize);
            int len = idxPtr1 - idx0;
            if (len > 255) {
                len = 255;
            }
            result = new String(fontDataAsArray, idx0, len);
        }
        return result;
    }

    private final int[] readCharset(int charset, int nGlyphs, int top, FontData fontDataAsObject, byte[] fontDataAsArray) {
        int[] glyphNames;
        block6: {
            int charsetFormat;
            boolean isByteArray;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                LogWriter.writeMethod("{get1CCharset}+" + charset + " glyphs=" + nGlyphs, 0);
                                isByteArray = fontDataAsArray != null;
                                glyphNames = null;
                                if (charset != 0) break block5;
                                glyphNames = ISOAdobeCharset;
                                break block6;
                            }
                            if (charset != 1) break block7;
                            glyphNames = ExpertCharset;
                            break block6;
                        }
                        if (charset != 2) break block8;
                        glyphNames = ExpertSubCharset;
                        break block6;
                    }
                    glyphNames = new int[nGlyphs + 1];
                    glyphNames[0] = 0;
                    top = charset;
                    charsetFormat = isByteArray ? fontDataAsArray[top++] & 0xFF : fontDataAsObject.getByte(top++) & 0xFF;
                    if (charsetFormat != 0) break block9;
                    int i = 1;
                    while (i < nGlyphs) {
                        glyphNames[i] = isByteArray ? this.getWord(fontDataAsArray, top, 2) : this.getWord(fontDataAsObject, top, 2);
                        top += 2;
                        ++i;
                    }
                    break block6;
                }
                if (charsetFormat != 1) break block10;
                int i = 1;
                while (i < nGlyphs) {
                    int c = isByteArray ? this.getWord(fontDataAsArray, top, 2) : this.getWord(fontDataAsObject, top, 2);
                    top += 2;
                    int nLeft = isByteArray ? fontDataAsArray[top++] & 0xFF : fontDataAsObject.getByte(top++) & 0xFF;
                    int j = 0;
                    while (j <= nLeft) {
                        glyphNames[i++] = c++;
                        ++j;
                    }
                }
                break block6;
            }
            if (charsetFormat != 2) break block6;
            int i = 1;
            while (i < nGlyphs) {
                int c = isByteArray ? this.getWord(fontDataAsArray, top, 2) : this.getWord(fontDataAsObject, top, 2);
                int nLeft = isByteArray ? this.getWord(fontDataAsArray, top, 2) : this.getWord(fontDataAsObject, top += 2, 2);
                top += 2;
                int j = 0;
                while (j <= nLeft) {
                    glyphNames[i++] = c++;
                    ++j;
                }
            }
        }
        return glyphNames;
    }

    private final int getWord(FontData fontDataAsObject, int index, int size) {
        int result = 0;
        int i = 0;
        while (i < size) {
            result = (result << 8) + (fontDataAsObject.getByte(index + i) & 0xFF);
            ++i;
        }
        return result;
    }

    private final int getWord(byte[] fontDataAsArray, int index, int size) {
        int result = 0;
        int i = 0;
        while (i < size) {
            result = (result << 8) + (fontDataAsArray[index + i] & 0xFF);
            ++i;
        }
        return result;
    }
}

