/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class Type1
extends PdfFont {
    protected boolean isCID = false;
    private static final int c1 = 52845;
    private static final int c2 = 22719;
    public static final String[] T1CcharCodes1Byte = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "closePathT1", "callsubr", "return", "escape", "hsbwT1", "endchar", "-Reserved-", "blend", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "intint", "callgsubr", "vhcurveto", "hvcurveto"};
    public static final String[] T1C = new String[]{"dotSection", "vstem3", "hstem3", "and", "or", "not", "seacT1", "swbT1", "store", "abs", "add", "sub", "div", "load", "neg", "eq", "callothersubT1", "pop", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "setcurrentpointT1", "hflex", "flex", "hflex1", "flex1"};

    public Type1(PdfObjectReader current_pdf_file, String substiuteFont) {
        this.init(current_pdf_file);
        this.substituteFont = substiuteFont;
    }

    public Type1() {
    }

    protected final void readType1FontFile(byte[] content) throws Exception {
        String line;
        LogWriter.writeLog("Embedded Type1 font used");
        BufferedReader br = new BufferedReader(new StringReader(new String(content)));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("/Encoding 256 array")) {
                this.readDiffEncoding(br);
                continue;
            }
            if (line.indexOf("/FontMatrix") == -1) continue;
            int startP = line.indexOf(91);
            int endP = line.indexOf(93);
            String values = line.substring(startP + 1, endP);
            StringTokenizer matrixValues = new StringTokenizer(values);
            int i = 0;
            while (i < 6) {
                this.FontMatrix[i] = Double.parseDouble(matrixValues.nextToken());
                ++i;
            }
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " closing stream");
            }
        }
        if (this.renderPage) {
            this.readEncodedContent(content);
        }
        this.isFontEmbedded = true;
    }

    private void readDiffEncoding(BufferedReader br) throws Exception {
        String line = "";
        while ((line = br.readLine()) != null) {
            StringTokenizer info;
            if ((line = line.trim()).startsWith("readonly")) break;
            if (!line.startsWith("dup") || (info = new StringTokenizer(line, " /")).countTokens() < 3) continue;
            info.nextToken();
            int code = Integer.parseInt(info.nextToken());
            String name = info.nextToken();
            this.putChar(code, name);
            char c = name.charAt(0);
            if (!(c == 'B' | c == 'C' | c == 'c' | c == 'G')) continue;
            int i = 1;
            int l = name.length();
            while (!this.isHex && i < l) {
                this.isHex = Character.isLetter(name.charAt(i++));
            }
        }
    }

    protected final void putChar(int charInt, String mappedChar) {
        if (this.diffs == null) {
            this.diffs = new String[this.maxCharCount];
        }
        this.diffs[charInt] = mappedChar;
        if (!this.hasEncoding && !this.isCID && StandardFonts.getUnicodeName(mappedChar) != null) {
            this.putMappedChar(charInt, mappedChar);
        }
    }

    private void readEncodedContent(byte[] cont) throws Exception {
        String line = "";
        String rd = "rd";
        String nd = "nd";
        int size = cont.length;
        int start = -1;
        int end = -1;
        int cipher = 0;
        int i = 4;
        while (i < size) {
            if (cont[i - 3] == 101 && cont[i - 2] == 120 && cont[i - 1] == 101 && cont[i] == 99) {
                start = i + 1;
                while (cont[start] == 10 | cont[start] == 13) {
                    ++start;
                }
                i = size;
            }
            ++i;
        }
        if (start != -1) {
            i = start;
            while (i < size - 10) {
                if (cont[i] == 99 && cont[i + 1] == 108 && cont[i + 2] == 101 && cont[i + 3] == 97 && cont[i + 4] == 114 && cont[i + 5] == 116 && cont[i + 6] == 111 && cont[i + 7] == 109 && cont[i + 8] == 97 && cont[i + 9] == 114 && cont[i + 10] == 107) {
                    end = i - 1;
                    while (cont[end] == 10 | cont[end] == 13) {
                        --end;
                    }
                    i = size;
                }
                ++i;
            }
        }
        if (end == -1) {
            end = size;
        }
        int r = 55665;
        int n = 4;
        boolean isAscii = true;
        i = 0;
        while (i < n * 2) {
            char c = (char)cont[i];
            if (!(c >= '0' & c <= '9' | c >= 'A' & c <= 'F' | c >= 'a' & c <= 'f')) {
                isAscii = false;
                i = n * 2;
            }
            ++i;
        }
        if (start != -1) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(end - start);
            i = start;
            while (i < end) {
                if (!isAscii) {
                    cipher = cont[i] & 0xFF;
                } else {
                    int chars = 0;
                    StringBuffer tmp = new StringBuffer();
                    while (chars < 2) {
                        cipher = cont[i] & 0xFF;
                        ++i;
                        if (!(cipher != 10 & cipher != 13 & cipher != 9 & cipher != 32)) continue;
                        tmp.append(cipher);
                        ++chars;
                    }
                    cipher = Integer.parseInt(tmp.toString(), 16);
                }
                int plain = cipher ^ r >> 8;
                r = (cipher + r) * 52845 + 22719 & 0xFFFF;
                if (i > start + n) {
                    bos.write(plain);
                }
                ++i;
            }
            bos.close();
            cont = bos.toByteArray();
        }
        n = 4;
        int skipBytes = 4;
        BufferedReader br = new BufferedReader(new StringReader(new String(cont)));
        while ((line = br.readLine()) != null) {
            if (!line.startsWith("/lenIV")) continue;
            StringTokenizer vals = new StringTokenizer(line);
            vals.nextToken();
            skipBytes = Integer.parseInt(vals.nextToken());
        }
        br.close();
        int l = cont.length;
        int p = 0;
        int subStart = -1;
        start = -1;
        while (p < l) {
            if (cont[p] == 47 && cont[p + 1] == 67 && cont[p + 2] == 104 && cont[p + 3] == 97 && cont[p + 4] == 114 && cont[p + 5] == 83 && cont[p + 6] == 116 && cont[p + 7] == 114 && cont[p + 8] == 105 && cont[p + 9] == 110 && cont[p + 10] == 103 && cont[p + 11] == 115) {
                start = p + 11;
            } else if (cont[p] == 47 && cont[p + 1] == 83 && cont[p + 2] == 117 && cont[p + 3] == 98 && cont[p + 4] == 114 && cont[p + 5] == 115) {
                subStart = p + 6;
            }
            if (subStart > -1 && start > -1) break;
            ++p;
        }
        if (start == -1) {
            this.isFontSubstituted = false;
            LogWriter.writeLog("No glyph data found");
        } else {
            this.extractFontData(skipBytes, cont, start, rd, l, nd);
        }
        if (subStart > -1) {
            this.extractSubroutineData(skipBytes, cont, subStart, start, rd, l, nd);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extractSubroutineData(int skipBytes, byte[] cont, int start, int charStart, String rd, int l, String nd) throws IOException {
        block8: {
            block9: {
                count = 0;
                while (cont[start] == 32 | cont[start] == 10 | cont[start] == 13) {
                    ++start;
                }
                tmp = new StringBuffer();
                while ((c = (char)cont[start]) != ' ') {
                    tmp.append(c);
                    ++start;
                }
                count = Integer.parseInt(tmp.toString());
                i = 0;
                break block8;
                while (!((cont[start - 2] == 100 && cont[start - 1] == 117 && cont[start] == 112) | start == charStart)) {
                    ++start;
lbl16:
                    // 2 sources

                    ** while (start >= l)
lbl17:
                    // 1 sources

                }
lbl18:
                // 2 sources

                if (start != charStart) ** GOTO lbl22
                i = count;
                break block9;
lbl-1000:
                // 1 sources

                {
                    ++start;
lbl22:
                    // 2 sources

                    ** while (cont[start + 1] == 32)
                }
lbl23:
                // 1 sources

                glyph = new StringBuffer("subrs");
                while ((c = (char)cont[++start]) != ' ') {
                    glyph.append(c);
                }
                tmp = new StringBuffer();
                while ((c = (char)cont[++start]) != ' ') {
                    tmp.append(c);
                }
                byteCount = Integer.parseInt(tmp.toString());
                while (cont[start] == 32) {
                    ++start;
                }
                start = start + rd.length() + 1;
                stream = this.getStream(skipBytes, start, byteCount, cont);
                this.glyphs.setCharString(glyph.toString(), stream);
                start = start + byteCount + nd.length();
            }
            ++i;
        }
        if (i < count) ** GOTO lbl16
    }

    private void extractFontData(int skipBytes, byte[] cont, int start, String rd, int l, String nd) throws IOException {
        while (cont[start] != 47) {
            ++start;
        }
        int end = start;
        boolean inCommand = false;
        while (start < l) {
            if (cont[end] == 32 || cont[end] == 10) {
                inCommand = false;
            } else if (cont[end] == 47) {
                inCommand = true;
            }
            if (!inCommand && cont[end - 1] != 47 && cont[end] == 101 && cont[end + 1] == 110 && cont[end + 2] == 100) break;
            ++end;
        }
        while (start < end) {
            char c;
            char c2;
            StringBuffer glyph = new StringBuffer(20);
            while ((c2 = (char)cont[++start]) != ' ') {
                glyph.append(c2);
            }
            ++start;
            StringBuffer tmp = new StringBuffer();
            while ((c = (char)cont[start]) != ' ') {
                tmp.append(c);
                ++start;
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            start = start + rd.length() + 1;
            byte[] stream = this.getStream(skipBytes, start, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream);
            start = start + byteCount + nd.length();
            while (start <= end && cont[start] != 47) {
                ++start;
            }
        }
    }

    private final byte[] getStream(int skipBytes, int start, int byteCount, byte[] cont) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int r = 4330;
        int i = 0;
        while (i < byteCount) {
            int cipher = cont[start + i] & 0xFF;
            int plain = cipher ^ r >> 8;
            r = (cipher + r) * 52845 + 22719 & 0xFFFF;
            if (i >= skipBytes) {
                bos.write(plain);
            }
            ++i;
        }
        bos.close();
        return bos.toByteArray();
    }
}

