/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class TrueType
extends PdfFont {
    public TrueType() {
    }

    public void readFontData(byte[] fontDataAsArray, FontData fontData) {
        LogWriter.writeMethod("{readFontData}", 0);
        this.fontTypes = this.glyphs.readEmbeddedFont(this.TTstreamisCID, fontDataAsArray, fontData);
    }

    protected void substituteFontUsed(String substituteFontFile, String substituteFontName) throws PdfFontException {
        InputStream from = null;
        try {
            from = this.loader.getResourceAsStream("org/jpedal/res/fonts/" + substituteFontFile);
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " reading " + substituteFontFile + " Check cid  jar installed");
            LogWriter.writeLog("Exception " + e + " reading " + substituteFontFile + " Check cid  jar installed");
        }
        if (from == null) {
            throw new PdfFontException("Unable to load font " + substituteFontFile);
        }
        try {
            int bytes_read;
            ByteArrayOutputStream to = new ByteArrayOutputStream();
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
            to.close();
            from.close();
            FontData fontData = null;
            this.readFontData(to.toByteArray(), fontData);
            this.glyphs.setEncodingToUse(this.hasEncoding, this.getFontEncoding(false), true, this.isCIDFont);
            this.isFontEmbedded = true;
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " reading " + substituteFontFile + " Check cid  jar installed");
            LogWriter.writeLog("Exception " + e + " reading " + substituteFontFile + " Check cid  jar installed");
        }
    }

    public TrueType(String substituteFont) {
        this.glyphs = new TTGlyphs();
        this.init(null);
        this.substituteFont = substituteFont;
    }

    public TrueType(PdfObjectReader current_pdf_file, String substituteFont) {
        this.glyphs = new TTGlyphs();
        this.init(current_pdf_file);
        this.substituteFont = substituteFont;
    }

    public Map createFont(Map values, String fontID, boolean renderPage, Map descFontValues, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readTrueTypeFont}" + values, 0);
        this.fontTypes = 2;
        Map fontDescriptor = super.createFont(values, fontID, renderPage, descFontValues, objectStore);
        if (renderPage) {
            FontData fontData;
            if (fontDescriptor != null) {
                Object fontFileRef = fontDescriptor.get("FontFile2");
                try {
                    if (fontFileRef != null) {
                        byte[] stream = null;
                        fontData = null;
                        stream = fontFileRef instanceof String ? this.currentPdfFile.readStream((String)fontFileRef, true) : (byte[])((Map)fontFileRef).get("DecodedStream");
                        this.readEmbeddedFont(stream, fontData, this.hasEncoding, false);
                    }
                }
                catch (Exception stream) {
                    // empty catch block
                }
            }
            if (!this.isFontEmbedded && this.substituteFont != null) {
                if (this.glyphs.remapFont) {
                    this.glyphs.remapFont = false;
                }
                File fontFile = new File(this.substituteFont);
                int objSize = (int)fontFile.length();
                if (FontData.maxSizeAllowedInMemory >= 0 && objSize > FontData.maxSizeAllowedInMemory) {
                    fontData = new FontData(this.substituteFont);
                    this.readEmbeddedFont(null, fontData, false, true);
                } else {
                    int bytes_read;
                    InputStream jarFile = this.loader.getResourceAsStream(this.substituteFont);
                    BufferedInputStream from = jarFile == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(jarFile);
                    ByteArrayOutputStream to = new ByteArrayOutputStream();
                    byte[] buffer = new byte[65535];
                    while ((bytes_read = from.read(buffer)) != -1) {
                        to.write(buffer, 0, bytes_read);
                    }
                    to.close();
                    from.close();
                    this.readEmbeddedFont(to.toByteArray(), null, false, true);
                }
                this.isFontSubstituted = true;
            }
        }
        this.readWidths(values);
        if (renderPage) {
            this.setFont(this.glyphs.fontName, 1);
        }
        return fontDescriptor;
    }

    public void createFont(String fontName) throws Exception {
        this.fontTypes = 2;
        this.setBaseFontName(fontName);
        File fontFile = new File(this.substituteFont);
        int objSize = (int)fontFile.length();
        if (FontData.maxSizeAllowedInMemory >= 0 && objSize > FontData.maxSizeAllowedInMemory) {
            FontData fontData = new FontData(this.substituteFont);
            this.readEmbeddedFont(null, fontData, false, true);
        } else {
            int bytes_read;
            InputStream jarFile = this.loader.getResourceAsStream(this.substituteFont);
            BufferedInputStream from = jarFile == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(jarFile);
            ByteArrayOutputStream to = new ByteArrayOutputStream();
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
            to.close();
            from.close();
            this.readEmbeddedFont(to.toByteArray(), null, false, true);
        }
        this.isFontSubstituted = true;
    }

    protected final void readEmbeddedFont(byte[] fontDataAsArray, FontData fontDataAsObject, boolean hasEncoding, boolean isSubstituted) {
        LogWriter.writeMethod("{readEmbeddedFont}", 0);
        try {
            LogWriter.writeLog("Embedded TrueType font used");
            this.readFontData(fontDataAsArray, fontDataAsObject);
            this.isFontEmbedded = true;
            this.glyphs.setEncodingToUse(hasEncoding, this.getFontEncoding(false), isSubstituted, this.TTstreamisCID);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " processing TrueType font");
            e.printStackTrace();
        }
    }
}

