/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.Map;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class CIDFontType2
extends TrueType {
    public CIDFontType2(PdfObjectReader currentPdfFile) {
        this.isCIDFont = true;
        this.TTstreamisCID = true;
        this.glyphs = new TTGlyphs();
        this.init(currentPdfFile);
    }

    public CIDFontType2(PdfObjectReader currentPdfFile, boolean ttflag) {
        this.isCIDFont = true;
        this.TTstreamisCID = ttflag;
        this.glyphs = new TTGlyphs();
        this.init(currentPdfFile);
    }

    public Map createFont(Map values, String fontID, boolean renderPage, Map descFontValues, ObjectStore objectStore) throws Exception {
        String fontFileRef;
        LogWriter.writeMethod("{readFontType0 " + fontID + '}', 0);
        Map fontDescriptor = null;
        this.fontTypes = 5;
        this.fontID = fontID;
        fontDescriptor = this.createCIDFont(values, descFontValues);
        if (fontDescriptor != null && (fontFileRef = (String)fontDescriptor.get("FontFile2")) != null) {
            byte[] stream = this.currentPdfFile.readStream(fontFileRef, true);
            FontData fontData = null;
            if (renderPage) {
                this.readEmbeddedFont(stream, fontData, this.hasEncoding, false);
            }
        }
        if (renderPage && !this.isFontEmbedded && this.substituteFontFile != null) {
            this.substituteFontUsed(this.substituteFontFile, this.substituteFontName);
            this.isFontSubstituted = true;
            this.isFontEmbedded = true;
        }
        if (renderPage) {
            this.setFont(this.getBaseFontName(), 1);
        }
        if (!this.isFontEmbedded) {
            this.selectDefaultFont();
        }
        return fontDescriptor;
    }
}

