/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text.extractheadlines;

import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.text.ExtractTextInRectangle;
import org.jpedal.examples.text.extractheadlines.SectionConfiguration;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.utils.LogWriter;

public class ExtractSection
extends ExtractTextInRectangle {
    private static final boolean debug = false;
    SectionConfiguration sectionConfig;
    String[] sectionTokens;
    private int[] section_x1;
    private int[] section_x2;
    private int[] section_y1;
    private int[] section_y2;
    private String section;

    public String getSection() {
        return this.section;
    }

    private String extractSection(String extractedText) {
        String section;
        block11: {
            section = null;
            if (showMessages) {
                System.out.println(extractedText);
            }
            if (extractedText != null) break block11;
            return null;
        }
        try {
            HashMap<String, String> sections = new HashMap<String, String>();
            int sectionTokenCount = this.sectionTokens.length;
            int i = 0;
            while (i < sectionTokenCount) {
                sections.put(this.sectionTokens[i], "x");
                ++i;
            }
            Object pageNumber = null;
            section = null;
            String currentToken = null;
            StringTokenizer tokens = new StringTokenizer(extractedText, "<>");
            while (tokens.hasMoreTokens()) {
                if (section == null || pageNumber == null) {
                    currentToken = tokens.nextToken();
                    if (sections.get(currentToken) == null) continue;
                    String font = currentToken;
                    currentToken = tokens.nextToken();
                    boolean isNumber = false;
                    if (isNumber || currentToken.length() <= 2) continue;
                    StringBuffer sectionName = new StringBuffer();
                    while (tokens.hasMoreTokens() && !currentToken.equals("/font")) {
                        if (currentToken.indexOf("SpaceC") != -1) {
                            sectionName.append(' ');
                        } else {
                            sectionName.append(currentToken);
                        }
                        currentToken = tokens.nextToken();
                    }
                    section = sectionName.toString().trim();
                    if (!font.equals("font face=\"TimesClassicDisplay\" style=\"font-size:16pt\"")) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return section;
    }

    public ExtractSection(String file_name, String configDir) {
        block11: {
            this.sectionTokens = null;
            this.section = null;
            try {
                showMessages = false;
                this.initSection(configDir);
                if (file_name.toLowerCase().endsWith(".pdf")) {
                    this.decodeFile("", file_name);
                    break block11;
                }
                String[] files = null;
                File inputFiles = null;
                if (!file_name.endsWith(this.separator)) {
                    file_name = String.valueOf(file_name) + this.separator;
                }
                try {
                    inputFiles = new File(file_name);
                    if (!inputFiles.isDirectory()) {
                        System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                    }
                    files = inputFiles.list();
                }
                catch (Exception ee) {
                    LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
                }
                long fileCount = files.length;
                int i = 0;
                while ((long)i < fileCount) {
                    if (showMessages) {
                        System.out.println(String.valueOf(i) + "/ " + fileCount + ' ' + files[i]);
                    }
                    if (files[i].toLowerCase().endsWith(".pdf")) {
                        if (showMessages) {
                            System.out.println(String.valueOf(file_name) + files[i]);
                        }
                        this.decodeFile(file_name, files[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initSection(String configDir) {
        this.sectionConfig = new SectionConfiguration(configDir);
        this.section = this.sectionConfig.getValue("default_section");
        int tagCount = Integer.parseInt(this.sectionConfig.getValue("xmlCount"));
        this.sectionTokens = new String[tagCount];
        int j = 0;
        while (j < tagCount) {
            this.sectionTokens[j] = this.sectionConfig.getValue("xmlTag_" + j);
            if (showMessages) {
                System.out.println(this.sectionTokens[j]);
            }
            ++j;
        }
        tagCount = Integer.parseInt(this.sectionConfig.getValue("locationCount"));
        this.section_x1 = new int[tagCount];
        this.section_x2 = new int[tagCount];
        this.section_y1 = new int[tagCount];
        this.section_y2 = new int[tagCount];
        String key = "locTag";
        String[] coords = new String[]{"x1", "y1", "x2", "y2"};
        int i = 0;
        while (i < tagCount) {
            int coord = 0;
            while (coord < 4) {
                String currentKey = String.valueOf(key) + '_' + i + '_' + coords[coord];
                String value = this.sectionConfig.getValue(currentKey);
                int numberValue = Integer.parseInt(value);
                switch (coord) {
                    case 0: {
                        this.section_x1[i] = numberValue;
                        break;
                    }
                    case 1: {
                        this.section_y1[i] = numberValue;
                        break;
                    }
                    case 2: {
                        this.section_x2[i] = numberValue;
                        break;
                    }
                    case 3: {
                        this.section_y2[i] = numberValue;
                    }
                }
                ++coord;
            }
            ++i;
        }
    }

    protected void decodeFile(String path, String name) {
        try {
            String file_name = String.valueOf(path) + name;
            String section = null;
            try {
                this.decodePdf = new PdfDecoder(false);
                this.decodePdf.setExtractionMode(1);
                this.decodePdf.init(true);
                this.decodePdf.openPdfFile(file_name);
                if (showMessages) {
                    System.out.println("file_name=" + file_name);
                }
            }
            catch (PdfSecurityException se) {
                System.err.println("Security Exception " + se + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
            }
            catch (PdfException se) {
                System.err.println("Pdf Exception " + se + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
                e.printStackTrace();
            }
            if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied() && !this.decodePdf.isExtractionAllowed()) {
                if (showMessages) {
                    System.out.println("Encrypted settings");
                    System.out.println("Please look at SimpleViewer for code sample to handle such files");
                    System.out.println("Or get support/consultancy");
                }
            } else {
                int start = 1;
                int end = this.decodePdf.getPageCount();
                int possSetsCoordinates = this.section_x2.length;
                try {
                    int page = start;
                    while (page < end + 1) {
                        this.decodePdf.decodePage(page);
                        int coordSet = 0;
                        while (coordSet < possSetsCoordinates) {
                            PdfGroupingAlgorithms currentGrouping = new PdfGroupingAlgorithms(this.decodePdf.getPdfData());
                            int x1 = this.section_x1[coordSet];
                            int x2 = this.section_x2[coordSet];
                            int y1 = this.section_y1[coordSet];
                            int y2 = this.section_y2[coordSet];
                            if (showMessages) {
                                System.out.println("Using (" + x1 + ',' + y1 + ") (" + x2 + ',' + y2 + ')');
                            }
                            try {
                                this.text = currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
                                if (this.text != null && (section = this.extractSection(this.text)) != null) {
                                    coordSet = possSetsCoordinates;
                                }
                            }
                            catch (PdfException e) {
                                this.text = null;
                                this.decodePdf.closePdfFile();
                                System.err.println("Exception " + e.getMessage() + " in file " + this.decodePdf.getObjectStore().fullFileName);
                                e.printStackTrace();
                            }
                            ++coordSet;
                        }
                        this.decodePdf.flushObjectValues(false);
                        if (section != null) {
                            if (showMessages) {
                                System.out.println("section=" + section);
                            }
                            this.section = section;
                        }
                        if (showMessages) {
                            System.out.println("----");
                        }
                        ++page;
                    }
                }
                catch (Exception e) {
                    this.decodePdf.closePdfFile();
                    e.printStackTrace();
                    System.out.println(this.decodePdf.getObjectStore().getCurrentFilename());
                }
                this.decodePdf.flushObjectValues(true);
                if (showMessages) {
                    System.out.println("Text read");
                }
            }
            this.decodePdf.closePdfFile();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

