/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text.extractheadlines;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.storypad.Configuration;
import org.jpedal.utils.TimeNow;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DateConfiguration
extends Configuration {
    String[] sectionTokens = new String[]{"font face=\"TimesClassicDisplay\" style=\"font-size:9pt\""};
    private int[] x1 = new int[]{651};
    private int[] y1 = new int[]{963};
    private int[] x2 = new int[]{752};
    private int[] y2 = new int[]{949};

    private DateConfiguration() {
    }

    public DateConfiguration(String configDir) {
        this.sectionName = "dates";
        boolean fileExists = this.loadValues(configDir);
        if (!fileExists) {
            this.saveValues();
            this.loadValues(configDir);
        }
    }

    public boolean saveValues() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement(this.sectionName);
            Comment creation = doc.createComment("Created " + TimeNow.getShortTimeNow());
            doc.appendChild(creation);
            doc.appendChild(root);
            int count = this.sectionTokens.length;
            Element tagCount = doc.createElement("xmlCount");
            tagCount.setAttribute("value", String.valueOf(count));
            root.appendChild(tagCount);
            String key = "xmlTag";
            int i = 0;
            while (i < count) {
                String currentKey = String.valueOf(key) + '_' + i;
                Element section = doc.createElement(currentKey);
                section.setAttribute("value", this.sectionTokens[i]);
                root.appendChild(section);
                ++i;
            }
            int locCount = this.x1.length;
            Element loc = doc.createElement("locationCount");
            loc.setAttribute("value", String.valueOf(locCount));
            root.appendChild(loc);
            key = "locTag";
            String[] coords = new String[]{"x1", "y1", "x2", "y2"};
            int i2 = 0;
            while (i2 < locCount) {
                int coord = 0;
                while (coord < 4) {
                    String currentKey = String.valueOf(key) + '_' + i2 + '_' + coords[coord];
                    Element section = doc.createElement(currentKey);
                    switch (coord) {
                        case 0: {
                            section.setAttribute("value", String.valueOf(this.x1[i2]));
                            break;
                        }
                        case 1: {
                            section.setAttribute("value", String.valueOf(this.y1[i2]));
                            break;
                        }
                        case 2: {
                            section.setAttribute("value", String.valueOf(this.x2[i2]));
                            break;
                        }
                        case 3: {
                            section.setAttribute("value", String.valueOf(this.y2[i2]));
                        }
                    }
                    root.appendChild(section);
                    ++coord;
                }
                ++i2;
            }
            InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
            transformer.transform(new DOMSource(doc), new StreamResult(String.valueOf(this.configDir) + this.sectionName + ".xml"));
            System.out.println("Created " + this.configDir + this.sectionName + ".xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

