/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;

public class ExtractTextInRectangle {
    public static boolean isTest = false;
    protected String text = null;
    private static boolean useXMLExtraction = false;
    protected static boolean writeToFile = true;
    protected String user_dir = System.getProperty("user.dir");
    public static boolean showMessages = true;
    protected String separator = System.getProperty("file.separator");
    protected PdfDecoder decodePdf = null;
    protected String outputDir = "";
    protected static int defX1 = -1;
    protected static int defX2;
    protected static int defY1;
    protected static int defY2;
    private static String testFile;

    static {
        testFile = "/mnt/shared/sample.pdf";
    }

    public ExtractTextInRectangle() {
    }

    public ExtractTextInRectangle(String file_name) {
        String xmlFlag = System.getProperty("xml");
        if (xmlFlag != null) {
            useXMLExtraction = true;
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = String.valueOf(this.user_dir) + this.separator;
        }
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = String.valueOf(file_name) + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (showMessages) {
                    System.out.println(String.valueOf(i) + "/ " + fileCount + ' ' + files[i]);
                }
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(String.valueOf(file_name) + files[i]);
                    }
                    this.decodeFile(String.valueOf(file_name) + files[i]);
                }
                ++i;
            }
        }
    }

    protected void decodeFile(String file_name) {
        String name = "demo";
        int pointer = file_name.lastIndexOf(this.separator);
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        }
        this.outputDir = String.valueOf(this.user_dir) + "text" + this.separator + name + this.separator;
        try {
            this.decodePdf = new PdfDecoder(false);
            if (!isTest && !useXMLExtraction) {
                PdfDecoder.useTextExtraction();
            }
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            if (showMessages) {
                System.out.println("Opening file :" + file_name);
            }
            this.decodePdf.openPdfFile(file_name);
        }
        catch (PdfSecurityException se) {
            System.err.println("Security Exception " + se + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (PdfException se) {
            System.err.println("Pdf Exception " + se + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
            e.printStackTrace();
        }
        if (!this.decodePdf.isExtractionAllowed()) {
            if (showMessages) {
                System.out.println("Text extraction not allowed");
            }
        } else if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied()) {
            if (showMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                System.out.println("Or get support/consultancy");
            }
        } else {
            int start = 1;
            int end = this.decodePdf.getPageCount();
            if (end > 10 && isTest) {
                end = 10;
            }
            try {
                int page = start;
                while (page < end + 1) {
                    int y1;
                    int y2;
                    int x2;
                    int x1;
                    this.decodePdf.decodePage(page);
                    PdfGroupingAlgorithms currentGrouping = this.decodePdf.getGroupingObject();
                    PdfPageData currentPageData = this.decodePdf.getPdfPageData();
                    if (defX1 == -1) {
                        x1 = currentPageData.getMediaBoxX(page);
                        x2 = currentPageData.getMediaBoxWidth(page) + x1;
                        y2 = currentPageData.getMediaBoxY(page);
                        y1 = currentPageData.getMediaBoxHeight(page) + y2;
                    } else {
                        x1 = defX1;
                        y1 = defY1;
                        x2 = defX2;
                        y2 = defY2;
                    }
                    if (showMessages) {
                        System.out.println("Extracting text from rectangle (" + x1 + ',' + y1 + ' ' + x2 + ',' + y2 + ')');
                    }
                    this.text = null;
                    try {
                        this.text = currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
                    }
                    catch (PdfException e) {
                        this.decodePdf.closePdfFile();
                        System.err.println("Exception " + e.getMessage() + " in file " + this.decodePdf.getObjectStore().fullFileName);
                        e.printStackTrace();
                    }
                    if (this.text == null) {
                        if (showMessages) {
                            System.out.println("No text found");
                        }
                    } else if (writeToFile) {
                        File page_path = new File(String.valueOf(this.outputDir) + this.separator);
                        if (!page_path.exists()) {
                            page_path.mkdirs();
                        }
                        String prefix = ".txt";
                        String encoding = System.getProperty("file.encoding");
                        if (useXMLExtraction) {
                            prefix = ".xml";
                            encoding = "UTF-8";
                        }
                        if (isTest) {
                            prefix = ".xml";
                        }
                        if (showMessages) {
                            System.out.println("Writing to " + this.outputDir + page + prefix);
                        }
                        OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(this.outputDir) + page + prefix), encoding);
                        if (useXMLExtraction | isTest) {
                            output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
                            output_stream.write("<!-- Pixel Location of text x1,y1,x2,y2\n");
                            output_stream.write("(x1,y1 is top left corner)\n");
                            output_stream.write("(x1,y1 is bottom right corner)\n");
                            output_stream.write("(origin is bottom left corner)  -->\n");
                            output_stream.write("\n\n<ARTICLE>\n");
                            output_stream.write("<LOCATION x1=\"" + x1 + "\" " + "y1=\"" + y1 + "\" " + "x2=\"" + x2 + "\" " + "y2=\"" + y2 + "\" />\n");
                            output_stream.write("\n\n<TEXT>\n");
                            output_stream.write(this.text);
                            output_stream.write("\n\n</TEXT>\n");
                            output_stream.write("\n\n</ARTICLE>\n");
                        } else {
                            output_stream.write(this.text);
                        }
                        output_stream.close();
                    }
                    this.decodePdf.flushObjectValues(false);
                    ++page;
                }
            }
            catch (Exception e) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
                e.printStackTrace();
                System.out.println(this.decodePdf.getObjectStore().getCurrentFilename());
            }
            this.decodePdf.flushObjectValues(true);
            if (showMessages) {
                System.out.println("Text read");
            }
        }
        this.decodePdf.closePdfFile();
    }

    public static void main(String[] args) {
        if (showMessages) {
            System.out.println("Simple demo to extract text objects");
        }
        String file_name = testFile;
        if (args.length == 1) {
            file_name = args[0];
            System.out.println("File :" + file_name);
        } else if (args.length == 5) {
            file_name = args[0];
            System.out.println("File :" + file_name);
            System.out.println("User coordinates supplied");
            defX1 = Integer.parseInt(args[1]);
            defY1 = Integer.parseInt(args[2]);
            defX2 = Integer.parseInt(args[3]);
            defY2 = Integer.parseInt(args[4]);
        } else {
            System.out.println("Please call with either ");
            System.out.println("FileName");
            System.out.println("or");
            System.out.println("FileName x1 y1 x2 y2");
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            System.out.println("File " + file_name + " not found");
        }
        long now = System.currentTimeMillis();
        ExtractTextInRectangle text1 = new ExtractTextInRectangle(file_name);
        long finished = System.currentTimeMillis();
        if (!isTest) {
            System.out.println("Time taken=" + (finished - now) / 1000L);
        }
    }

    public String getExtractedText() {
        return this.text;
    }
}

