/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class ExtractStructuredText {
    public static boolean isTest = false;
    public static final boolean debug = true;
    protected static String output = String.valueOf(System.getProperty("user.dir")) + "xml";
    public static boolean showMessages = true;
    protected String separator = System.getProperty("file.separator");
    protected PdfDecoder decodePdf = null;
    protected String outputFile = "";
    private static String testFile = "/PDFdata/sample_pdfs/acroforms/myform.pdf";

    public ExtractStructuredText() {
    }

    public ExtractStructuredText(String root, String outputDir) {
        File output_path;
        output = outputDir;
        if (!output.endsWith(this.separator)) {
            output = String.valueOf(output) + this.separator;
        }
        if (!(output_path = new File(output)).exists()) {
            output_path.mkdirs();
        }
        if (root.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(root);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!root.endsWith(this.separator)) {
                root = String.valueOf(root) + this.separator;
            }
            try {
                inputFiles = new File(root);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(root) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (showMessages) {
                    System.out.println(String.valueOf(i) + "/ " + fileCount + ' ' + files[i]);
                }
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(String.valueOf(root) + files[i]);
                    }
                    this.decodeFile(String.valueOf(root) + files[i]);
                }
                ++i;
            }
        }
    }

    protected void decodeFile(String file_name) {
        String name = "demo";
        int pointer = file_name.lastIndexOf(this.separator);
        name = file_name.substring(pointer + 1, file_name.length() - 4);
        this.outputFile = String.valueOf(output) + this.separator + name + ".xml";
        try {
            this.decodePdf = new PdfDecoder(false);
            if (showMessages) {
                System.out.println("\n----------------------------");
            }
            if (showMessages) {
                System.out.println("Opening file :" + file_name);
            }
            this.decodePdf.openPdfFile(file_name);
        }
        catch (PdfSecurityException se) {
            System.err.println("Security Exception " + se + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (PdfException se) {
            System.err.println("Pdf Exception " + se + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied() && !this.decodePdf.isExtractionAllowed()) {
            if (showMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                System.out.println("Or get support/consultancy");
            }
        } else {
            try {
                Document tree = this.decodePdf.getMarkedContent();
                if (tree == null) {
                    if (showMessages) {
                        System.out.println("No text found");
                    }
                } else {
                    InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/text/xmlstyle.xslt");
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    try {
                        Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
                        transformer.transform(new DOMSource(tree), new StreamResult(this.outputFile));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (showMessages) {
                        System.out.println("Writing to " + this.outputFile);
                    }
                }
                if (showMessages) {
                    System.out.println("\n----------done--------------");
                }
                this.decodePdf.flushObjectValues(false);
            }
            catch (Exception e) {
                this.decodePdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
                e.printStackTrace();
                System.out.println(this.decodePdf.getObjectStore().getCurrentFilename());
            }
            this.decodePdf.flushObjectValues(true);
            if (showMessages) {
                System.out.println("Text read");
            }
            this.decodePdf.closePdfFile();
        }
    }

    public static void main(String[] args) {
        if (showMessages) {
            System.out.println("Simple demo to extract text objects");
        }
        String file_name = testFile;
        if (args.length == 2) {
            file_name = args[0];
            output = args[1];
            System.out.println("File :" + file_name);
        } else {
            System.out.println("Please call with parameters :-");
            System.out.println("FileName");
            System.out.println("outputDir");
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            System.out.println("File " + file_name + " not found");
        }
        long now = System.currentTimeMillis();
        ExtractStructuredText text1 = new ExtractStructuredText(file_name, output);
        long finished = System.currentTimeMillis();
        if (!isTest) {
            System.out.println("Time taken=" + (finished - now) / 1000L);
        }
    }
}

