/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.ProgressMonitor;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.popups.SaveBitmap;
import org.jpedal.examples.simpleviewer.gui.popups.SaveImage;
import org.jpedal.examples.simpleviewer.gui.popups.SaveText;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.SwingWorker;

public class Exporter {
    public static final int RECTANGLE = 1;
    public static final int WORDLIST = 2;
    public static final int TABLE = 3;
    private final String separator = System.getProperty("file.separator");
    private String fileName = "";
    private GUIFactory currentGUI;
    private PdfDecoder dPDF;
    private String selectedFile;

    public Exporter(SwingGUI currentGUI, String selectedFile, PdfDecoder decode_pdf) {
        int index;
        String fileName = new File(selectedFile).getName();
        if (fileName.lastIndexOf(46) != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        StringBuffer fileNameBuffer = new StringBuffer(fileName);
        while ((index = fileNameBuffer.toString().indexOf("%20")) != -1) {
            fileNameBuffer.replace(index, index + 3, " ");
        }
        this.fileName = fileNameBuffer.toString();
        this.currentGUI = currentGUI;
        this.selectedFile = selectedFile;
        this.dPDF = decode_pdf;
    }

    public void extractPagesAsImages(SaveBitmap current_selection) {
        final int startPage = current_selection.getStartPage();
        final int endPage = current_selection.getEndPage();
        if (startPage < 1 || endPage < 1) {
            return;
        }
        final String format = current_selection.getPrefix();
        final int scaling = current_selection.getScaling();
        final String output_dir = String.valueOf(current_selection.getRootDir()) + this.separator + this.fileName + this.separator + "thumbnails" + this.separator;
        File testDirExists = new File(output_dir);
        if (!testDirExists.exists()) {
            testDirExists.mkdirs();
        }
        final ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.GeneratingBitmaps"), "", startPage, endPage);
        SwingWorker worker = new SwingWorker(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object construct() {
                int count = 0;
                boolean yesToAll = false;
                int page = startPage;
                while (page < endPage + 1) {
                    block11: {
                        block7: {
                            BufferedImage image_to_save;
                            block8: {
                                File fileToSave;
                                block9: {
                                    int n;
                                    block10: {
                                        if (status.isCanceled()) {
                                            Exporter.this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                                            return null;
                                        }
                                        image_to_save = null;
                                        try {
                                            image_to_save = Exporter.this.dPDF.getPageAsImage(page);
                                        }
                                        catch (PdfException e1) {
                                            e1.printStackTrace();
                                        }
                                        if (image_to_save == null) break block7;
                                        if (scaling != 100) {
                                            int newWidth = image_to_save.getWidth() * scaling / 100;
                                            Image scaledImage = image_to_save.getScaledInstance(newWidth, -1, 4);
                                            image_to_save = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 1);
                                            Graphics2D g2 = image_to_save.createGraphics();
                                            g2.drawImage(scaledImage, 0, 0, null);
                                        }
                                        if (!(fileToSave = new File(String.valueOf(output_dir) + page + '.' + format)).exists() || yesToAll) break block8;
                                        if (endPage - startPage <= 1) break block9;
                                        n = Exporter.this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                        if (n == 0) break block8;
                                        if (n != 1) break block10;
                                        yesToAll = true;
                                        break block8;
                                    }
                                    if (n != 2) {
                                        Exporter.this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                        status.close();
                                        return null;
                                    }
                                    status.setProgress(page);
                                    break block11;
                                }
                                int n = Exporter.this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                                if (n != 0) {
                                    return null;
                                }
                            }
                            boolean bl = Exporter.this.dPDF.getObjectStore().saveStoredImage(String.valueOf(output_dir) + page, image_to_save, true, false, format);
                        }
                        ++count;
                        status.setProgress(page + 1);
                    }
                    ++page;
                }
                Exporter.this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerTitle.PagesSavedAsImages")) + ' ' + output_dir);
                return null;
            }
        };
        worker.start();
    }

    private void saveImage(BufferedImage image_to_save, String fileName, String prefix) {
        if (JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
        }
        if (prefix.indexOf("tif") != -1 && JAIHelper.isJAIused()) {
            try {
                FileOutputStream os = new FileOutputStream(fileName);
                JAI.create((String)"encode", (RenderedImage)image_to_save, (Object)os, (Object)"TIFF", null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            try {
                ImageIO.write((RenderedImage)image_to_save, prefix, new File(fileName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void decodeHires(int start, int end, String imageType, String output_dir) {
        decode_pdf = null;
        target = "";
        try {
            decode_pdf = new PdfDecoder(false);
            decode_pdf.setExtractionMode(36, 72, 1.0f);
            decode_pdf.openPdfFile(this.selectedFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
            return;
        }
        status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractFormMetadata"), "", start, end);
        try {
            count = 0;
            yesToAll = false;
            page = start;
            while (page < end + 1) {
                if (status.isCanceled()) {
                    this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                    return;
                }
                decode_pdf.decodePage(page);
                pdf_images = decode_pdf.getPdfImageData();
                image_count = pdf_images.getImageCount();
                if (image_count > 0 && !(targetExists = new File(target = String.valueOf(output_dir) + page + this.separator)).exists()) {
                    targetExists.mkdir();
                }
                i = 0;
                while (i < image_count) {
                    image_name = pdf_images.getImageName(i);
                    x1 = pdf_images.getImageXCoord(i);
                    y1 = pdf_images.getImageYCoord(i);
                    w = pdf_images.getImageWidth(i);
                    h = pdf_images.getImageHeight(i);
                    try {
                        block14: {
                            image_to_save = decode_pdf.getObjectStore().loadStoredImage("CLIP_" + image_name);
                            if (image_to_save == null) ** GOTO lbl52
                            if (imageType.toLowerCase().startsWith("jp")) {
                                image_to_save = ColorSpaceConvertor.convertToRGB(image_to_save);
                            }
                            if (!(fileToSave = new File(String.valueOf(target) + image_name + '.' + imageType)).exists() || yesToAll || (n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true)) == 0) ** GOTO lbl50
                            if (n != 1) break block14;
                            yesToAll = true;
                            ** GOTO lbl50
                        }
                        if (n == 2) {
                            status.setProgress(page);
                        } else {
                            this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                            status.close();
                            return;
lbl50:
                            // 2 sources

                            this.saveImage(image_to_save, String.valueOf(target) + image_name + '.' + imageType, imageType);
                            ++count;
lbl52:
                            // 2 sources

                            output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(target) + image_name + ".xml"), "UTF-8");
                            output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                            output_stream.write("<!-- Pixel Location of image x1,y1,x2,y2\n");
                            output_stream.write("(x1,y1 is top left corner)\n");
                            output_stream.write("(origin is bottom left corner)  -->\n");
                            output_stream.write("\n\n<META>\n");
                            output_stream.write("<PAGELOCATION x1=\"" + x1 + "\" " + "y1=\"" + (y1 + h) + "\" " + "x2=\"" + (x1 + w) + "\" " + "y2=\"" + y1 + "\" />\n");
                            output_stream.write("<FILE>" + this.fileName + "</FILE>\n");
                            output_stream.write("</META>\n");
                            output_stream.close();
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        LogWriter.writeLog("Exception " + ee + " in extracting images");
                    }
                    ++i;
                }
                decode_pdf.flushObjectValues(true);
                status.setProgress(page + 1);
                ++page;
            }
            status.close();
            this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerMessage.ImagesSavedTo")) + ' ' + output_dir);
        }
        catch (Exception e) {
            decode_pdf.closePdfFile();
            LogWriter.writeLog("Exception " + e.getMessage());
        }
        decode_pdf.closePdfFile();
    }

    public void extractImagesOnPages(SaveImage current_selection) {
        final int startPage = current_selection.getStartPage();
        final int endPage = current_selection.getEndPage();
        if (startPage < 1 || endPage < 1) {
            return;
        }
        final int type = current_selection.getImageType();
        final String format = current_selection.getPrefix();
        final String output_dir = String.valueOf(current_selection.getRootDir()) + this.separator + this.fileName + this.separator + "images" + this.separator;
        File testDirExists = new File(output_dir);
        if (!testDirExists.exists()) {
            testDirExists.mkdirs();
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                switch (type) {
                    case 32: {
                        Exporter.this.decodeHires(startPage, endPage, format, output_dir);
                        break;
                    }
                    case 2: {
                        Exporter.this.decodeImages(startPage, endPage, format, output_dir, false);
                        break;
                    }
                    case 4: {
                        Exporter.this.decodeImages(startPage, endPage, format, output_dir, true);
                        break;
                    }
                    default: {
                        System.out.println("Unknown setting");
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    /*
     * Unable to fully structure code
     */
    private void decodeImages(int start, int end, String prefix, String output_dir, boolean downsampled) {
        decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            decode_pdf.setExtractionMode(6, 72, 1.0f);
            decode_pdf.openPdfFile(this.selectedFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isPasswordSupplied() && !decode_pdf.isExtractionAllowed()) {
            return;
        }
        status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractFormMetadata"), "", start, end);
        try {
            count = 0;
            yesToAll = false;
            page = start;
            while (page < end + 1) {
                if (status.isCanceled()) {
                    this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                    return;
                }
                decode_pdf.decodePage(page);
                pdf_images = decode_pdf.getPdfImageData();
                image_count = pdf_images.getImageCount();
                target = String.valueOf(output_dir) + this.separator;
                target = downsampled != false ? String.valueOf(target) + "downsampled" + this.separator + page + this.separator : String.valueOf(target) + "normal" + this.separator + page + this.separator;
                if (image_count > 0) {
                    page_path = new File(target);
                    if (!page_path.exists()) {
                        page_path.mkdirs();
                    }
                    if (!(page_path = new File(target)).exists()) {
                        page_path.mkdirs();
                    }
                }
                i = 0;
                while (i < image_count) {
                    image_name = pdf_images.getImageName(i);
                    try {
                        block19: {
                            if (downsampled) {
                                image_to_save = decode_pdf.getObjectStore().loadStoredImage(image_name);
                                if (prefix.toLowerCase().startsWith("jp")) {
                                    image_to_save = ColorSpaceConvertor.convertToRGB(image_to_save);
                                }
                            } else {
                                image_to_save = decode_pdf.getObjectStore().loadStoredImage(image_name);
                                if (prefix.toLowerCase().startsWith("jp")) {
                                    image_to_save = ColorSpaceConvertor.convertToRGB(image_to_save);
                                }
                            }
                            if (!(fileToSave = new File(String.valueOf(target) + image_name + '.' + prefix)).exists() || yesToAll || (n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true)) == 0) ** GOTO lbl56
                            if (n != 1) break block19;
                            yesToAll = true;
                            ** GOTO lbl56
                        }
                        if (n == 2) {
                            status.setProgress(page);
                        } else {
                            this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfImagesExported"));
                            status.close();
                            return;
lbl56:
                            // 2 sources

                            this.saveImage(image_to_save, String.valueOf(target) + image_name + '.' + prefix, prefix);
                            ++count;
                        }
                    }
                    catch (Exception ee) {
                        System.err.println("Exception " + ee + " in extracting images");
                    }
                    ++i;
                }
                decode_pdf.flushObjectValues(true);
                status.setProgress(page + 1);
                ++page;
            }
            this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerMessage.ImagesSavedTo")) + ' ' + output_dir);
            status.close();
        }
        catch (Exception e) {
            decode_pdf.closePdfFile();
            LogWriter.writeLog("Exception " + e.getMessage());
        }
        decode_pdf.closePdfFile();
    }

    public void extractTextOnPages(SaveText current_selection) {
        final int startPage = current_selection.getStartPage();
        final int endPage = current_selection.getEndPage();
        if (startPage < 1 || endPage < 1) {
            return;
        }
        final int type = current_selection.getTextType();
        final boolean useXMLExtraction = current_selection.isXMLExtaction();
        final String output_dir = String.valueOf(current_selection.getRootDir()) + this.separator + this.fileName + this.separator + "text" + this.separator;
        File testDirExists = new File(output_dir);
        if (!testDirExists.exists()) {
            testDirExists.mkdirs();
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                switch (type) {
                    case 1: {
                        Exporter.this.decodeTextRectangle(startPage, endPage, output_dir, useXMLExtraction);
                        break;
                    }
                    case 2: {
                        Exporter.this.decodeTextWordlist(startPage, endPage, output_dir, useXMLExtraction);
                        break;
                    }
                    case 3: {
                        Exporter.this.decodeTextTable(startPage, endPage, output_dir, useXMLExtraction);
                        break;
                    }
                    default: {
                        System.out.println("Unknown setting");
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextTable(int startPage, int endPage, String output_dir, boolean useXMLExtraction) {
        PdfDecoder decode_pdf;
        block19: {
            block18: {
                decode_pdf = null;
                try {
                    decode_pdf = new PdfDecoder(false);
                    decode_pdf.setExtractionMode(1);
                    decode_pdf.init(true);
                    decode_pdf.openPdfFile(this.selectedFile);
                }
                catch (Exception e) {
                    System.err.println("Exception " + e + " in pdf code");
                }
                if (!decode_pdf.isEncrypted() || decode_pdf.isPasswordSupplied() || decode_pdf.isExtractionAllowed()) break block18;
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                break block19;
            }
            ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", startPage, endPage);
            try {
                int count = 0;
                boolean yesToAll = false;
                int page = startPage;
                while (true) {
                    block25: {
                        block21: {
                            String target;
                            String tableText;
                            String ending;
                            block22: {
                                int n;
                                File fileToSave;
                                block23: {
                                    block24: {
                                        block20: {
                                            if (page >= endPage + 1) {
                                                status.close();
                                                this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerMessage.TextSavedTo")) + ' ' + output_dir);
                                                break;
                                            }
                                            if (status.isCanceled()) {
                                                this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                                return;
                                            }
                                            decode_pdf.decodePage(page);
                                            PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
                                            PdfPageData currentPageData = decode_pdf.getPdfPageData();
                                            int x1 = currentPageData.getMediaBoxX(page);
                                            int x2 = currentPageData.getMediaBoxWidth(page) + x1;
                                            int y2 = currentPageData.getMediaBoxY(page);
                                            int y1 = currentPageData.getMediaBoxHeight(page) + y2;
                                            ending = "_text.csv";
                                            if (useXMLExtraction) {
                                                ending = "_xml.txt";
                                            }
                                            Map tableContent = null;
                                            tableText = null;
                                            try {
                                                tableContent = currentGrouping.extractTextAsTable(x1, y1, x2, y2, page, !useXMLExtraction, false, false, false, 0, false);
                                                tableText = (String)tableContent.get("content");
                                            }
                                            catch (PdfException e) {
                                                decode_pdf.closePdfFile();
                                                System.err.println("Exception " + e.getMessage() + " with table extraction");
                                            }
                                            catch (Error e) {
                                                e.printStackTrace();
                                            }
                                            if (tableText != null) break block20;
                                            System.out.println("No text found");
                                            break block21;
                                        }
                                        target = String.valueOf(output_dir) + this.separator + "table" + this.separator;
                                        File output_path = new File(target);
                                        if (!output_path.exists()) {
                                            output_path.mkdirs();
                                        }
                                        if (!(fileToSave = new File(String.valueOf(target) + this.fileName + '_' + page + ending)).exists() || yesToAll) break block22;
                                        if (endPage - startPage <= 1) break block23;
                                        n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                        if (n == 0) break block22;
                                        if (n != 1) break block24;
                                        yesToAll = true;
                                        break block22;
                                    }
                                    if (n != 2) {
                                        this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                        status.close();
                                        return;
                                    }
                                    status.setProgress(page);
                                    break block25;
                                }
                                n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                                if (n != 0) {
                                    return;
                                }
                            }
                            OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(target) + this.fileName + '_' + page + ending), "UTF-8");
                            if (useXMLExtraction) {
                                output_stream.write("<xml><BODY>\n\n");
                            }
                            output_stream.write(tableText);
                            if (useXMLExtraction) {
                                output_stream.write("\n</body></xml>");
                            }
                            output_stream.close();
                        }
                        ++count;
                        status.setProgress(page + 1);
                        decode_pdf.flushObjectValues(false);
                    }
                    ++page;
                }
            }
            catch (Exception e) {
                decode_pdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
                e.printStackTrace();
            }
            catch (Error e) {
                System.out.println("h34343");
                e.printStackTrace();
            }
            decode_pdf.flushObjectValues(true);
        }
        decode_pdf.closePdfFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextWordlist(int startPage, int endPage, String output_dir, boolean useXMLExtraction) {
        PdfDecoder decode_pdf;
        block20: {
            block21: {
                decode_pdf = null;
                try {
                    decode_pdf = new PdfDecoder(false);
                    decode_pdf.setExtractionMode(1);
                    decode_pdf.init(true);
                    PdfGroupingAlgorithms.useUnrotatedCoords = false;
                    decode_pdf.openPdfFile(this.selectedFile);
                }
                catch (PdfSecurityException e) {
                    System.err.println("Exception " + e + " in pdf code for wordlist" + this.selectedFile);
                }
                catch (PdfException e) {
                    System.err.println("Exception " + e + " in pdf code for wordlist" + this.selectedFile);
                }
                catch (Exception e) {
                    System.err.println("Exception " + e + " in pdf code for wordlist" + this.selectedFile);
                    e.printStackTrace();
                }
                if (!decode_pdf.isEncrypted() || decode_pdf.isPasswordSupplied() || decode_pdf.isExtractionAllowed()) break block21;
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                break block20;
            }
            int start = startPage;
            int end = endPage;
            int wordsExtracted = 0;
            ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", startPage, endPage);
            try {
                int count = 0;
                boolean yesToAll = false;
                int page = start;
                while (true) {
                    block27: {
                        block23: {
                            String encoding;
                            String prefix;
                            String target;
                            Vector words;
                            block24: {
                                int n;
                                File fileToSave;
                                block25: {
                                    block26: {
                                        block22: {
                                            if (page >= end + 1) {
                                                status.close();
                                                this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerMessage.TextSavedTo")) + ' ' + output_dir);
                                                break;
                                            }
                                            if (status.isCanceled()) {
                                                this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                                return;
                                            }
                                            decode_pdf.decodePage(page);
                                            PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
                                            PdfPageData currentPageData = decode_pdf.getPdfPageData();
                                            int x1 = currentPageData.getMediaBoxX(page);
                                            int x2 = currentPageData.getMediaBoxWidth(page) + x1;
                                            int y2 = currentPageData.getMediaBoxX(page);
                                            int y1 = currentPageData.getMediaBoxHeight(page) - y2;
                                            words = null;
                                            try {
                                                words = currentGrouping.extractTextAsWordlist(x1, y1, x2, y2, page, false, true, "&:=()!;.,\\/\"\"''");
                                            }
                                            catch (PdfException e) {
                                                decode_pdf.closePdfFile();
                                                System.err.println("Exception= " + e + " in " + this.selectedFile);
                                                e.printStackTrace();
                                            }
                                            catch (Error e) {
                                                e.printStackTrace();
                                            }
                                            if (words != null) break block22;
                                            System.out.println("No text found");
                                            break block23;
                                        }
                                        target = String.valueOf(output_dir) + this.separator + "wordlist" + this.separator;
                                        File output_path = new File(target);
                                        if (!output_path.exists()) {
                                            output_path.mkdirs();
                                        }
                                        prefix = "_text.txt";
                                        encoding = System.getProperty("file.encoding");
                                        if (useXMLExtraction) {
                                            prefix = "_xml.txt";
                                            encoding = "UTF-8";
                                        }
                                        int wordCount = words.size() / 5;
                                        wordsExtracted += wordCount;
                                        fileToSave = new File(String.valueOf(target) + this.fileName + '_' + page + prefix);
                                        if (!fileToSave.exists() || yesToAll) break block24;
                                        if (endPage - startPage <= 1) break block25;
                                        n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                        if (n == 0) break block24;
                                        if (n != 1) break block26;
                                        yesToAll = true;
                                        break block24;
                                    }
                                    if (n != 2) {
                                        this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                        status.close();
                                        return;
                                    }
                                    status.setProgress(page);
                                    break block27;
                                }
                                n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                                if (n != 0) {
                                    return;
                                }
                            }
                            OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(target) + this.fileName + '_' + page + prefix), encoding);
                            Iterator wordIterator = words.iterator();
                            while (true) {
                                if (!wordIterator.hasNext()) {
                                    output_stream.close();
                                    break;
                                }
                                String currentWord = (String)wordIterator.next();
                                if (!useXMLExtraction) {
                                    currentWord = Strip.convertToText(currentWord);
                                }
                                int wx1 = (int)Float.parseFloat((String)wordIterator.next());
                                int wy1 = (int)Float.parseFloat((String)wordIterator.next());
                                int wx2 = (int)Float.parseFloat((String)wordIterator.next());
                                int wy2 = (int)Float.parseFloat((String)wordIterator.next());
                                output_stream.write(String.valueOf(currentWord) + ',' + wx1 + ',' + wy1 + ',' + wx2 + ',' + wy2 + '\n');
                            }
                        }
                        ++count;
                        status.setProgress(page + 1);
                        decode_pdf.flushObjectValues(false);
                    }
                    ++page;
                }
            }
            catch (Exception e) {
                decode_pdf.closePdfFile();
                System.err.println("Exception " + e + " in " + this.selectedFile);
                e.printStackTrace();
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        decode_pdf.closePdfFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeTextRectangle(int startPage, int endPage, String output_dir, boolean useXMLExtraction) {
        PdfDecoder decode_pdf;
        boolean isXMLExtractionAtStart;
        block20: {
            block21: {
                isXMLExtractionAtStart = PdfDecoder.isXMLExtraction();
                decode_pdf = null;
                try {
                    decode_pdf = new PdfDecoder(false);
                    if (!useXMLExtraction) {
                        PdfDecoder.useTextExtraction();
                    }
                    decode_pdf.setExtractionMode(1);
                    decode_pdf.init(true);
                    decode_pdf.openPdfFile(this.selectedFile);
                }
                catch (PdfSecurityException se) {
                    System.err.println("Security Exception " + se + " in pdf code for text extraction on file ");
                }
                catch (PdfException se) {
                    System.err.println("Pdf Exception " + se + " in pdf code for text extraction on file ");
                }
                catch (Exception e) {
                    System.err.println("Exception " + e + " in pdf code for text extraction on file ");
                    e.printStackTrace();
                }
                if (!decode_pdf.isEncrypted() || decode_pdf.isPasswordSupplied() || decode_pdf.isExtractionAllowed()) break block21;
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                break block20;
            }
            ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.ExtractText"), "", startPage, endPage);
            try {
                int count = 0;
                boolean yesToAll = false;
                int page = startPage;
                while (true) {
                    block22: {
                        String encoding;
                        String prefix;
                        String target;
                        String text;
                        int y1;
                        int y2;
                        int x2;
                        int x1;
                        block23: {
                            int n;
                            File fileToSave;
                            block24: {
                                block25: {
                                    if (page >= endPage + 1) {
                                        status.close();
                                        this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerMessage.TextSavedTo")) + ' ' + output_dir);
                                        break;
                                    }
                                    if (status.isCanceled()) {
                                        this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                        return;
                                    }
                                    decode_pdf.decodePage(page);
                                    PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
                                    PdfPageData currentPageData = decode_pdf.getPdfPageData();
                                    x1 = currentPageData.getMediaBoxX(page);
                                    x2 = currentPageData.getMediaBoxWidth(page) + x1;
                                    y2 = currentPageData.getMediaBoxY(page);
                                    y1 = currentPageData.getMediaBoxHeight(page) + y2;
                                    text = null;
                                    try {
                                        text = currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
                                    }
                                    catch (PdfException e) {
                                        decode_pdf.closePdfFile();
                                        System.err.println("Exception " + e.getMessage() + " in file " + decode_pdf.getObjectStore().fullFileName);
                                        e.printStackTrace();
                                    }
                                    if (text == null) break block22;
                                    target = String.valueOf(output_dir) + this.separator + "rectangle" + this.separator;
                                    File page_path = new File(target);
                                    if (!page_path.exists()) {
                                        page_path.mkdirs();
                                    }
                                    prefix = "_text.txt";
                                    encoding = System.getProperty("file.encoding");
                                    if (useXMLExtraction) {
                                        prefix = "_xml.txt";
                                        encoding = "UTF-8";
                                    }
                                    if (!(fileToSave = new File(String.valueOf(target) + this.fileName + '_' + page + prefix)).exists() || yesToAll) break block23;
                                    if (endPage - startPage <= 1) break block24;
                                    n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                    if (n == 0) break block23;
                                    if (n != 1) break block25;
                                    yesToAll = true;
                                    break block23;
                                }
                                if (n != 2) {
                                    this.currentGUI.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.UserStoppedExport")) + count + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                    status.close();
                                    return;
                                }
                                status.setProgress(page);
                                break block22;
                            }
                            n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                            if (n != 0) {
                                return;
                            }
                        }
                        OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(target) + this.fileName + '_' + page + prefix), encoding);
                        if (useXMLExtraction) {
                            output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
                            output_stream.write("<!-- Pixel Location of text x1,y1,x2,y2\n");
                            output_stream.write("(x1,y1 is top left corner)\n");
                            output_stream.write("(x1,y1 is bottom right corner)\n");
                            output_stream.write("(origin is bottom left corner)  -->\n");
                            output_stream.write("\n\n<ARTICLE>\n");
                            output_stream.write("<LOCATION x1=\"" + x1 + "\" " + "y1=\"" + y1 + "\" " + "x2=\"" + x2 + "\" " + "y2=\"" + y2 + "\" />\n");
                            output_stream.write("\n\n<TEXT>\n");
                            output_stream.write(text);
                            output_stream.write("\n\n</TEXT>\n");
                            output_stream.write("\n\n</ARTICLE>\n");
                        } else {
                            output_stream.write(text);
                        }
                        ++count;
                        output_stream.close();
                        status.setProgress(page + 1);
                        decode_pdf.flushObjectValues(true);
                    }
                    ++page;
                }
            }
            catch (Exception e) {
                decode_pdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
                e.printStackTrace();
                System.out.println(decode_pdf.getObjectStore().getCurrentFilename());
            }
        }
        if (isXMLExtractionAtStart) {
            PdfDecoder.useXMLExtraction();
        } else {
            PdfDecoder.useTextExtraction();
        }
        decode_pdf.closePdfFile();
    }
}

