/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.PdfDecoder;
import org.jpedal.ThumbnailDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Object;

public class SwingThumbnailPanel
extends JScrollPane
implements GUIThumbnailPanel {
    static final boolean debugThumbnails = false;
    SwingWorker worker = null;
    JPanel panel = new JPanel();
    private ThumbPainter painter = new ThumbPainter();
    private boolean showThumbnailsdefault;
    private boolean showThumbnails = this.showThumbnailsdefault = true;
    public boolean interrupt = false;
    public boolean drawing;
    public ThumbnailDecoder thumbDecoder;
    private JButton[] pageButton;
    private boolean[] buttonDrawn;
    private boolean[] isLandscape;
    private int[] pageHeight;
    private static final int thumbH = 100;
    private static final int thumbW = 70;
    Values commonValues;
    final PdfDecoder decode_pdf;
    boolean isExtractor = false;
    private int lastPage = -1;

    public SwingThumbnailPanel(Values commonValues, PdfDecoder decode_pdf) {
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.commonValues = commonValues;
        this.decode_pdf = decode_pdf;
        this.thumbDecoder = new ThumbnailDecoder(decode_pdf);
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                if (!SwingThumbnailPanel.this.isExtractor) {
                    if (SwingThumbnailPanel.this.drawing) {
                        SwingThumbnailPanel.this.terminateDrawing();
                    }
                    SwingThumbnailPanel.this.drawThumbnails();
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void generateOtherThumbnails(String[] imageFiles, Vector_Object thumbnailsStored) {
        this.drawing = true;
        this.getViewport().removeAll();
        this.panel.removeAll();
        int pages = imageFiles.length;
        this.getViewport().add(this.panel);
        this.panel.setLayout(new GridLayout(pages, 1, 0, 10));
        int i = 0;
        while (i < pages) {
            BufferedImage page = null;
            try {
                if (imageFiles[i] != null) {
                    Object cachedThumbnail = thumbnailsStored.elementAt(i);
                    this.decode_pdf.waitForRenderingToFinish();
                    if (cachedThumbnail == null) {
                        page = ImageIO.read(new File(imageFiles[i]));
                        thumbnailsStored.addElement(page);
                    } else {
                        page = (BufferedImage)cachedThumbnail;
                    }
                    if (page != null) {
                        int w = page.getWidth();
                        int h = page.getHeight();
                        Graphics2D g2 = (Graphics2D)page.getGraphics();
                        g2.setColor(Color.black);
                        g2.draw(new Rectangle(0, 0, w - 1, h - 1));
                        ImageIcon pageIcon = h > w ? new ImageIcon(page.getScaledInstance(-1, 100, 2)) : new ImageIcon(page.getScaledInstance(100, -1, 2));
                        this.pageButton[i].setIcon(pageIcon);
                        this.pageButton[i].setVisible(true);
                        this.buttonDrawn[i] = true;
                        this.panel.add(this.pageButton[i]);
                    }
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " loading " + imageFiles[i]);
            }
            ++i;
        }
        this.drawing = false;
        this.panel.setVisible(true);
    }

    public void generateOtherVisibleThumbnails(final int currentPage) {
        Rectangle rect;
        if (currentPage == -1 || currentPage == this.lastPage) {
            return;
        }
        this.lastPage = currentPage;
        int count = this.decode_pdf.getPageCount();
        int i1 = 0;
        while (i1 < count) {
            if (i1 != currentPage - 1) {
                this.pageButton[i1].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            ++i1;
        }
        if (count > 1 && currentPage > 0) {
            this.pageButton[currentPage - 1].setBorder(BorderFactory.createLineBorder(Color.red));
        }
        if (!(rect = this.panel.getVisibleRect()).contains(this.pageButton[currentPage - 1].getLocation())) {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    Rectangle vis = new Rectangle(this.pageButton[currentPage - 1].getLocation().x, this.pageButton[currentPage - 1].getLocation().y, this.pageButton[currentPage - 1].getBounds().width, this.pageButton[currentPage - 1].getBounds().height);
                    this.panel.scrollRectToVisible(vis);
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            Rectangle vis = new Rectangle(((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[currentPage - 1].getLocation().x, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[currentPage - 1].getLocation().y, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[currentPage - 1].getBounds().width, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[currentPage - 1].getBounds().height);
                            SwingThumbnailPanel.this.panel.scrollRectToVisible(vis);
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        this.drawThumbnails();
    }

    public void drawThumbnails() {
        if (this.drawing) {
            this.terminateDrawing();
        }
        this.worker = new SwingWorker(){

            public Object construct() {
                SwingThumbnailPanel.this.drawing = true;
                try {
                    Rectangle rect = SwingThumbnailPanel.this.panel.getVisibleRect();
                    int pages = SwingThumbnailPanel.this.decode_pdf.getPageCount();
                    int i = 0;
                    while (i < pages) {
                        SwingThumbnailPanel.this.decode_pdf.waitForRenderingToFinish();
                        if (SwingThumbnailPanel.this.interrupt) {
                            i = pages;
                        } else if (SwingThumbnailPanel.this.buttonDrawn != null && rect != null && !SwingThumbnailPanel.this.buttonDrawn[i] && SwingThumbnailPanel.this.pageButton[i] != null && rect.intersects(SwingThumbnailPanel.this.pageButton[i].getBounds())) {
                            SwingThumbnailPanel.this.decode_pdf.setThumbnailsDrawing(true);
                            int h = 100;
                            if (SwingThumbnailPanel.this.isLandscape[i]) {
                                h = 70;
                            }
                            BufferedImage page = SwingThumbnailPanel.this.thumbDecoder.getPageAsThumbnail(i + 1, h);
                            if (!SwingThumbnailPanel.this.interrupt) {
                                SwingThumbnailPanel.this.createThumbnail(page, i + 1, false);
                            }
                            SwingThumbnailPanel.this.decode_pdf.setThumbnailsDrawing(false);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingThumbnailPanel.this.decode_pdf.setThumbnailsDrawing(false);
                SwingThumbnailPanel.this.interrupt = false;
                SwingThumbnailPanel.this.drawing = false;
                return null;
            }
        };
        this.worker.start();
    }

    public void addDisplayedPageAsThumbnail(int currentPage, DynamicVectorRenderer currentDisplay) {
        Rectangle rect = this.panel.getVisibleRect();
        if (!this.buttonDrawn[currentPage - 1] && rect.intersects(this.pageButton[currentPage - 1].getBounds())) {
            int h = 100;
            if (this.isLandscape[currentPage - 1]) {
                h = 70;
            }
            BufferedImage page = this.decode_pdf.getPageAsThumbnail(h, currentDisplay);
            this.createThumbnail(page, currentPage, true);
        }
    }

    private BufferedImage createBlankThumbnail(int w, int h) {
        BufferedImage blank = new BufferedImage(w + 1, h + 1, 1);
        Graphics2D g2 = (Graphics2D)blank.getGraphics();
        g2.setColor(Color.white);
        g2.fill(new Rectangle(0, 0, w, h));
        g2.setColor(Color.black);
        g2.draw(new Rectangle(0, 0, w, h));
        g2.drawLine(0, 0, w, h);
        g2.drawLine(0, h, w, 0);
        return blank;
    }

    private void createThumbnail(BufferedImage page, int i, boolean highLightThumbnail) {
        --i;
        if (page != null) {
            Graphics2D g2 = (Graphics2D)page.getGraphics();
            g2.setColor(Color.black);
            g2.draw(new Rectangle(0, 0, page.getWidth() - 1, page.getHeight() - 1));
            ImageIcon pageIcon = new ImageIcon(page);
            this.pageButton[i].setIcon(pageIcon);
            this.buttonDrawn[i] = true;
        }
    }

    public void setupThumbnails(int pages, int[] pageUsed, int pageCount) {
        this.isExtractor = true;
        this.lastPage = -1;
        Font textFont = new Font("Serif", 0, 12);
        this.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage blankPortrait = this.createBlankThumbnail(70, 100);
        ImageIcon portrait = new ImageIcon(blankPortrait.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[pages];
        this.pageHeight = new int[pages];
        this.pageButton = new JButton[pages];
        this.buttonDrawn = new boolean[pages];
        int i = 0;
        while (i < pages) {
            int page = i + 1;
            this.pageButton[i] = pageCount < 2 ? new JButton(String.valueOf(page), portrait) : new JButton(String.valueOf(String.valueOf(page)) + " ( Page " + pageUsed[i] + " )", portrait);
            this.isLandscape[i] = false;
            this.pageHeight[i] = 100;
            this.pageButton[i].setVerticalTextPosition(3);
            this.pageButton[i].setHorizontalTextPosition(0);
            if (i == 0 && pages > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i].setFont(textFont);
            ++i;
        }
    }

    public void resetHighlightedThumbnail(int item) {
        if (this.pageButton != null) {
            int pages = this.pageButton.length;
            int i = 0;
            while (i < pages) {
                if (i == item) {
                    this.pageButton[i].setBorder(BorderFactory.createLineBorder(Color.red));
                } else {
                    this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                }
                ++i;
            }
        }
    }

    public void setupThumbnails(int pages, Font textFont, String message, PdfPageData pageData) {
        this.lastPage = -1;
        this.getViewport().removeAll();
        this.panel.removeAll();
        this.getViewport().add(this.panel);
        this.panel.setLayout(new GridLayout(pages, 1, 0, 10));
        this.panel.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage blankPortrait = this.createBlankThumbnail(70, 100);
        BufferedImage blankLandscape = this.createBlankThumbnail(100, 70);
        ImageIcon landscape = new ImageIcon(blankLandscape.getScaledInstance(-1, 70, 4));
        ImageIcon portrait = new ImageIcon(blankPortrait.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[pages];
        this.pageHeight = new int[pages];
        this.pageButton = new JButton[pages];
        this.buttonDrawn = new boolean[pages];
        int i = 0;
        while (i < pages) {
            ImageIcon usedPortrait;
            ImageIcon usedLandscape;
            int pw;
            int ph;
            int page = i + 1;
            int cropWidth = pageData.getCropBoxWidth(page);
            int cropHeight = pageData.getCropBoxHeight(page);
            int rotation = pageData.getRotation(page);
            if (rotation == 0 | rotation == 180) {
                ph = pageData.getMediaBoxHeight(page);
                pw = pageData.getMediaBoxWidth(page);
                usedLandscape = landscape;
                usedPortrait = portrait;
            } else {
                ph = pageData.getMediaBoxWidth(page);
                pw = pageData.getMediaBoxHeight(page);
                usedLandscape = portrait;
                usedPortrait = landscape;
            }
            if (cropWidth > cropHeight) {
                this.pageButton[i] = new JButton(String.valueOf(message) + ' ' + page, usedLandscape);
                this.isLandscape[i] = true;
                this.pageHeight[i] = ph;
            } else {
                this.pageButton[i] = new JButton(String.valueOf(message) + ' ' + page, usedPortrait);
                this.isLandscape[i] = false;
                this.pageHeight[i] = ph;
            }
            this.pageButton[i].setVerticalTextPosition(3);
            this.pageButton[i].setHorizontalTextPosition(0);
            if (i == 0 && pages > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i].setFont(textFont);
            this.panel.add((Component)this.pageButton[i], "Center");
            ++i;
        }
    }

    public Object[] getButtons() {
        return this.pageButton;
    }

    public void setThumbnailsEnabled() {
        this.showThumbnailsdefault = true;
        this.showThumbnails = true;
    }

    public void setThumbnailsEnabled(boolean newValue) {
        this.showThumbnailsdefault = newValue;
        this.showThumbnails = newValue;
    }

    public boolean isShownOnscreen() {
        return this.showThumbnails;
    }

    public void resetToDefault() {
        this.showThumbnails = this.showThumbnailsdefault;
    }

    public void setIsDisplayedOnscreen(boolean b) {
        this.showThumbnails = b;
    }

    public void addComponentListener() {
        this.panel.addComponentListener(this.painter);
    }

    public void removeAllListeners() {
        this.panel.removeComponentListener(this.painter);
        Object[] buttons = this.getButtons();
        if (buttons != null) {
            int i = 0;
            while (i < buttons.length) {
                ActionListener[] l = ((JButton)buttons[i]).getActionListeners();
                int j = 0;
                while (j < l.length) {
                    ((JButton)buttons[i]).removeActionListener(l[j]);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void terminateDrawing() {
        if (this.drawing) {
            if (this.thumbDecoder != null) {
                this.thumbDecoder.terminateDecoding();
            }
            this.interrupt = true;
            while (this.drawing) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.interrupt = false;
        }
    }

    public void refreshDisplay() {
        this.validate();
    }

    private class ThumbPainter
    extends ComponentAdapter {
        boolean requestMade = false;
        Timer trapMultipleMoves = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!ThumbPainter.this.requestMade) {
                    ThumbPainter.this.requestMade = true;
                    if (!((ThumbPainter)ThumbPainter.this).SwingThumbnailPanel.this.commonValues.isProcessing()) {
                        if (((ThumbPainter)ThumbPainter.this).SwingThumbnailPanel.this.drawing) {
                            SwingThumbnailPanel.this.terminateDrawing();
                        }
                        ThumbPainter.this.requestMade = false;
                        SwingThumbnailPanel.this.drawThumbnails();
                    }
                }
            }
        });

        private ThumbPainter() {
        }

        public void componentMoved(ComponentEvent e) {
            if (this.trapMultipleMoves.isRunning()) {
                this.trapMultipleMoves.stop();
            }
            this.trapMultipleMoves.setRepeats(false);
            this.trapMultipleMoves.start();
        }
    }
}

