/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.utils.Messages;

public class SwingMouseHandler
implements GUIMouseHandler {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    private AutoScrollThread scrollThread = new AutoScrollThread();
    private boolean dragged = false;
    private static boolean firstImageSelected = true;
    private String message = "";
    private Rectangle[] boxes = new Rectangle[8];
    private int handlesGap = 5;
    private int oldX = -1;
    private int oldY = -1;
    private boolean dragAltering = false;
    private int boxContained = -1;
    private boolean drawingCursorBox = false;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    private int cx;
    private int cy;

    public SwingMouseHandler(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
        this.scrollThread.init();
    }

    public void checkLinks(boolean mouseClicked) {
        this.message = "";
        Rectangle[] hotSpots = this.decode_pdf.getPageHotspots();
        if (hotSpots != null) {
            int count = hotSpots.length;
            int matchFound = -1;
            int i = 0;
            while (i < count) {
                if (hotSpots[i] != null && hotSpots[i].contains(this.cx, this.cy)) {
                    matchFound = i;
                    i = count;
                }
                ++i;
            }
            if (matchFound != -1) {
                if (mouseClicked) {
                    PdfAnnots pageAnnotations = this.commonValues.getPageAnnotations();
                    Map rawAnnotDetails = pageAnnotations.getAnnotRawData(matchFound);
                    Map annotAction = this.decode_pdf.resolveToMapOrString("A", rawAnnotDetails);
                    String subtype = pageAnnotations.getAnnotSubType(matchFound);
                    if (subtype.equals("Link") && annotAction != null) {
                        Iterator keys = annotAction.keySet().iterator();
                        JPanel details = new JPanel();
                        details.setLayout(new BoxLayout(details, 1));
                        while (keys.hasNext()) {
                            String nextKey = (String)keys.next();
                            details.add(new JLabel(String.valueOf(nextKey) + " : " + this.decode_pdf.resolveToMapOrString(nextKey, rawAnnotDetails)));
                        }
                        JOptionPane.showMessageDialog(this.currentGUI.getFrame(), details, Messages.getMessage("PdfViewerTitle.annots"), -1);
                    } else if (subtype.equals("Text")) {
                        String contents;
                        String title = pageAnnotations.getField(matchFound, "T");
                        if (title == null) {
                            title = Messages.getMessage("PdfViewerAnnots.notitle");
                        }
                        if ((contents = pageAnnotations.getField(matchFound, "Contents")) == null) {
                            contents = Messages.getMessage("PdfViewerAnnots.nocont");
                        }
                        JOptionPane.showMessageDialog(this.currentGUI.getFrame(), new TextArea(contents), title, -1);
                    } else if (subtype.equals("FileAttachment")) {
                        Map fileDetails = this.decode_pdf.resolveToMapOrString("FS", rawAnnotDetails);
                        if (fileDetails != null) {
                            fileDetails = (Map)fileDetails.get("EF");
                        }
                        if (fileDetails != null) {
                            fileDetails = (Map)fileDetails.get("F");
                        }
                        if (fileDetails != null) {
                            byte[] file = (byte[])fileDetails.get("DecodedStream");
                            String cachedName = (String)fileDetails.get("CachedStream");
                            if (file == null && cachedName == null) {
                                JOptionPane.showMessageDialog(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerAnnots.nofile"));
                            } else {
                                JFileChooser chooser = new JFileChooser(this.commonValues.getInputDir());
                                chooser.setFileSelectionMode(0);
                                int state = chooser.showSaveDialog(this.currentGUI.getFrame());
                                if (state == 0) {
                                    File fileTarget = chooser.getSelectedFile();
                                    if (file != null) {
                                        try {
                                            FileOutputStream fos = new FileOutputStream(fileTarget);
                                            fos.write(file);
                                            fos.close();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    } else if (cachedName != null) {
                                        ObjectStore.copy(cachedName, fileTarget.toString());
                                    }
                                }
                            }
                        }
                    } else {
                        JPanel details = new JPanel();
                        details.setLayout(new BoxLayout(details, 1));
                        for (String nextKey : rawAnnotDetails.keySet()) {
                            details.add(new JLabel(String.valueOf(nextKey) + " : " + this.decode_pdf.resolveToMapOrString(nextKey, rawAnnotDetails)));
                        }
                        this.currentGUI.showMessageDialog(details, String.valueOf(Messages.getMessage("PdfViewerAnnots.nosubtype")) + ' ' + subtype, -1);
                    }
                } else {
                    this.message = String.valueOf(Messages.getMessage("PdfViewerAnnots.entered")) + ' ' + matchFound;
                }
            }
        }
    }

    public void setupExtractor() {
        this.decode_pdf.addMouseMotionListener(new Extractor_mouse_mover());
        this.decode_pdf.addMouseListener(new Extractor_mouse_clicker());
    }

    protected void scrollAndUpdateCoords(MouseEvent event) {
        int interval = this.decode_pdf.getScrollInterval();
        Rectangle visible_test = new Rectangle(this.currentGUI.AdjustForAlignment(event.getX()), event.getY(), interval, interval);
        if (this.currentGUI.allowScrolling() && !this.decode_pdf.getVisibleRect().contains(visible_test)) {
            this.decode_pdf.scrollRectToVisible(visible_test);
        }
        this.updateCords(event);
    }

    public void updateCords(MouseEvent event) {
        int tmp;
        float scaling = this.currentGUI.getScaling();
        int inset = this.currentGUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int ex = this.currentGUI.AdjustForAlignment(event.getX()) - inset;
        int ey = event.getY() - inset;
        if (this.commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            ey = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)ey / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        this.cx = (int)((float)ex / scaling);
        this.cy = (int)((float)ey / scaling);
        if (this.decode_pdf.getDisplayView() != 1) {
            this.cx = 0;
            this.cy = 0;
        } else if (rotation == 90) {
            tmp = this.cx + this.currentGUI.cropY;
            this.cx = this.cy + this.currentGUI.cropX;
            this.cy = tmp;
        } else if (rotation == 180) {
            this.cx = this.currentGUI.cropW + this.currentGUI.cropX - this.cx;
            this.cy += this.currentGUI.cropY;
        } else if (rotation == 270) {
            tmp = this.currentGUI.cropH + this.currentGUI.cropY - this.cx;
            this.cx = this.currentGUI.cropW + this.currentGUI.cropX - this.cy;
            this.cy = tmp;
        } else {
            this.cx += this.currentGUI.cropX;
            this.cy = this.currentGUI.cropH + this.currentGUI.cropY - this.cy;
        }
        if (this.commonValues.isProcessing() | this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else {
            this.currentGUI.setCoordText("  X: " + this.cx + " Y: " + this.cy + ' ' + ' ' + this.message);
        }
        if (this.currentGUI.allowScrolling() && !event.isShiftDown()) {
            int interval = this.decode_pdf.getScrollInterval() * 2;
            Rectangle visible_test = new Rectangle(this.currentGUI.AdjustForAlignment(event.getX()) - interval, event.getY() - interval, interval * 2, interval * 2);
            if (!this.decode_pdf.getVisibleRect().contains(visible_test)) {
                this.scrollThread.setAutoScroll(true, event.getX(), event.getY(), interval);
            } else {
                this.scrollThread.setAutoScroll(false, 0, 0, 0);
            }
        }
    }

    public void updateRectangle() {
        Rectangle newRect;
        Rectangle currentRectangle = this.currentGUI.getRectangle();
        if (currentRectangle != null && (newRect = this.decode_pdf.getCombinedAreas(currentRectangle, false)) != null) {
            this.commonValues.m_x1 = newRect.x;
            this.commonValues.m_y2 = newRect.y;
            this.commonValues.m_x2 = newRect.x + newRect.width;
            this.commonValues.m_y1 = newRect.y + newRect.height;
            currentRectangle = newRect;
            this.decode_pdf.updateCursorBoxOnScreen(currentRectangle, Color.blue);
            this.decode_pdf.repaint();
        }
    }

    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(new mouse_mover());
        this.decode_pdf.addMouseListener(new mouse_clicker());
    }

    protected int[] updateXY(MouseEvent event) {
        float scaling = this.currentGUI.getScaling();
        int inset = this.currentGUI.getPDFDisplayInset();
        int rotation = this.currentGUI.getRotation();
        int x = (int)((float)(this.currentGUI.AdjustForAlignment(event.getX()) - inset) / scaling);
        int y = (int)((float)(event.getY() - inset) / scaling);
        if (this.commonValues.maxViewY != 0) {
            x = (int)((double)((float)x - (float)this.commonValues.dx * scaling) / this.commonValues.viewportScale);
            y = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)y / scaling - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)scaling);
        }
        int[] ret = new int[2];
        if (rotation == 90) {
            ret[1] = x + this.currentGUI.cropY;
            ret[0] = y + this.currentGUI.cropX;
        } else if (rotation == 180) {
            ret[0] = this.currentGUI.mediaW - (x + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            ret[1] = y + this.currentGUI.cropY;
        } else if (rotation == 270) {
            ret[1] = this.currentGUI.mediaH - (x + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            ret[0] = this.currentGUI.mediaW - (y + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
        } else {
            ret[0] = x + this.currentGUI.cropX;
            ret[1] = this.currentGUI.mediaH - (y + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
        }
        return ret;
    }

    class AutoScrollThread
    implements Runnable {
        Thread scroll = new Thread(this);
        boolean autoScroll = false;
        int x = 0;
        int y = 0;
        int interval = 0;

        public void setAutoScroll(boolean autoScroll, int x, int y, int interval) {
            this.autoScroll = autoScroll;
            this.x = SwingMouseHandler.this.currentGUI.AdjustForAlignment(x);
            this.y = y;
            this.interval = interval;
        }

        public void init() {
            this.scroll.start();
        }

        public void run() {
            while (Thread.currentThread() == this.scroll) {
                if (this.autoScroll) {
                    Rectangle visible_test = new Rectangle(this.x - this.interval, this.y - this.interval, this.interval * 2, this.interval * 2);
                    SwingMouseHandler.this.decode_pdf.scrollRectToVisible(visible_test);
                    if (this.x - this.interval * 2 < ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getVisibleRect().x) {
                        this.x -= this.interval;
                    } else if (this.x + this.interval * 2 > ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getVisibleRect().x + ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getVisibleRect().width) {
                        this.x += this.interval;
                    }
                    if (this.y - this.interval * 2 < ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getVisibleRect().y) {
                        this.y -= this.interval;
                    } else if (this.y + this.interval * 2 > ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getVisibleRect().y + ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getVisibleRect().height) {
                        this.y += this.interval;
                    }
                    SwingMouseHandler.this.decode_pdf.repaint();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    protected class Extractor_mouse_clicker
    extends mouse_clicker {
        protected Extractor_mouse_clicker() {
        }

        public void mousePressed(MouseEvent event) {
            Rectangle currentRectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            if (currentRectangle == null) {
                super.mousePressed(event);
                SwingMouseHandler.this.drawingCursorBox = true;
            } else {
                int[] values = SwingMouseHandler.this.updateXY(event);
                SwingMouseHandler.this.oldX = values[0];
                SwingMouseHandler.this.oldY = values[1];
            }
        }

        public void mouseReleased(MouseEvent event) {
            int tmp;
            SwingMouseHandler.this.drawingCursorBox = false;
            SwingMouseHandler.this.old_m_x2 = -1;
            SwingMouseHandler.this.old_m_y2 = -1;
            SwingMouseHandler.this.updateCords(event);
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                tmp = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = tmp;
            }
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 < ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2) {
                tmp = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = tmp;
            }
            SwingMouseHandler.this.decode_pdf.repaint();
            SwingMouseHandler.this.dragAltering = false;
            SwingMouseHandler.this.dragged = false;
        }
    }

    protected class Extractor_mouse_mover
    extends mouse_mover {
        private boolean inRect;
        private boolean handleChange;

        protected Extractor_mouse_mover() {
            this.inRect = false;
            this.handleChange = false;
        }

        public void mouseDragged(MouseEvent event) {
            SwingMouseHandler.this.dragged = true;
            Rectangle currentRectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            if (currentRectangle == null || SwingMouseHandler.this.drawingCursorBox) {
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                super.mouseDragged(event);
                SwingMouseHandler.this.boxContained = -1;
                return;
            }
            int[] values = SwingMouseHandler.this.updateXY(event);
            SwingMouseHandler.this.boxes = this.createNewRectangles(currentRectangle);
            if (SwingMouseHandler.this.boxContained == -1) {
                int i = 0;
                while (i < SwingMouseHandler.this.boxes.length) {
                    if (SwingMouseHandler.this.boxes[i].contains(SwingMouseHandler.this.oldX, SwingMouseHandler.this.oldY)) {
                        SwingMouseHandler.this.boxContained = i;
                        break;
                    }
                    ++i;
                }
            }
            if (SwingMouseHandler.this.boxContained != -1 || SwingMouseHandler.this.dragAltering) {
                SwingMouseHandler.this.drawingCursorBox = false;
                int highlightBox = SwingMouseHandler.this.boxContained;
                int boxCenterX = (int)SwingMouseHandler.this.boxes[SwingMouseHandler.this.boxContained].getCenterX();
                int boxCenterY = (int)SwingMouseHandler.this.boxes[SwingMouseHandler.this.boxContained].getCenterY();
                if (currentRectangle.x == boxCenterX) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = values[0];
                } else if (currentRectangle.x + currentRectangle.width == boxCenterX) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = values[0];
                }
                if (currentRectangle.y == boxCenterY) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = values[1];
                } else if (currentRectangle.y + currentRectangle.height == boxCenterY) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = values[1];
                }
                boolean changeX = false;
                boolean changeY = false;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                    changeX = true;
                }
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1) {
                    changeY = true;
                }
                if (changeX || changeY) {
                    switch (highlightBox) {
                        case 0: {
                            if (!changeX) break;
                            highlightBox = 3;
                            break;
                        }
                        case 1: {
                            if (!changeY) break;
                            highlightBox = 2;
                            break;
                        }
                        case 2: {
                            if (!changeY) break;
                            highlightBox = 1;
                            break;
                        }
                        case 3: {
                            if (!changeX) break;
                            highlightBox = 0;
                            break;
                        }
                        case 4: {
                            if (changeX) {
                                highlightBox = 6;
                            } else if (changeY) {
                                highlightBox = 5;
                            }
                            if (!changeX || !changeY) break;
                            highlightBox = 7;
                            break;
                        }
                        case 5: {
                            if (changeX) {
                                highlightBox = 7;
                            } else if (changeY) {
                                highlightBox = 4;
                            }
                            if (!changeX || !changeY) break;
                            highlightBox = 6;
                            break;
                        }
                        case 6: {
                            if (changeX) {
                                highlightBox = 4;
                            } else if (changeY) {
                                highlightBox = 7;
                            }
                            if (!changeX || !changeY) break;
                            highlightBox = 5;
                            break;
                        }
                        case 7: {
                            if (changeX) {
                                highlightBox = 5;
                            } else if (changeY) {
                                highlightBox = 6;
                            }
                            if (!changeX || !changeY) break;
                            highlightBox = 4;
                        }
                    }
                }
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, highlightBox, Color.red);
                SwingMouseHandler.this.scrollAndUpdateCoords(event);
                this.generateNewCursorBox();
                SwingMouseHandler.this.dragAltering = true;
                SwingMouseHandler.this.oldX = values[0];
                SwingMouseHandler.this.oldY = values[1];
            } else {
                SwingMouseHandler.this.drawingCursorBox = true;
                SwingMouseHandler.this.boxContained = -1;
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = SwingMouseHandler.this.oldX;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = SwingMouseHandler.this.oldY;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = values[0];
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = values[1];
                SwingMouseHandler.this.scrollAndUpdateCoords(event);
                this.generateNewCursorBox();
            }
        }

        public void mouseMoved(MouseEvent event) {
            super.mouseMoved(event);
            Rectangle currentRectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            SwingMouseHandler.this.boxes = this.createNewRectangles(currentRectangle);
            if (SwingMouseHandler.this.boxes != null) {
                int oldBox = SwingMouseHandler.this.boxContained;
                SwingMouseHandler.this.boxContained = -1;
                int i = 0;
                while (i < SwingMouseHandler.this.boxes.length) {
                    if (SwingMouseHandler.this.boxes[i].contains(SwingMouseHandler.this.cx, SwingMouseHandler.this.cy)) {
                        SwingMouseHandler.this.boxContained = i;
                        break;
                    }
                    ++i;
                }
                if (SwingMouseHandler.this.boxContained != oldBox) {
                    this.handleChange = true;
                }
            }
            if (currentRectangle != null) {
                if (currentRectangle.x - SwingMouseHandler.this.handlesGap < SwingMouseHandler.this.cx && currentRectangle.x + currentRectangle.width + SwingMouseHandler.this.handlesGap > SwingMouseHandler.this.cx && currentRectangle.y - SwingMouseHandler.this.handlesGap < SwingMouseHandler.this.cy && currentRectangle.y + currentRectangle.height + SwingMouseHandler.this.handlesGap > SwingMouseHandler.this.cy) {
                    SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                    if (!this.inRect || this.handleChange) {
                        SwingMouseHandler.this.decode_pdf.repaint();
                        this.handleChange = false;
                        this.inRect = true;
                    }
                } else {
                    SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(false, SwingMouseHandler.this.boxContained, Color.red);
                    if (this.inRect || this.handleChange) {
                        SwingMouseHandler.this.decode_pdf.repaint();
                        this.handleChange = false;
                        this.inRect = false;
                    }
                }
            }
        }

        private Rectangle[] createNewRectangles(Rectangle currentRectangle) {
            if (currentRectangle != null) {
                int x1 = currentRectangle.x;
                int y1 = currentRectangle.y;
                int x2 = x1 + currentRectangle.width;
                int y2 = y1 + currentRectangle.height;
                Rectangle[] cursorBoxHandles = new Rectangle[]{new Rectangle(x1 - SwingMouseHandler.this.handlesGap, y1 + Math.abs(y2 - y1) / 2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x1 + Math.abs(x2 - x1) / 2 - SwingMouseHandler.this.handlesGap, y1 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x1 + Math.abs(x2 - x1) / 2 - SwingMouseHandler.this.handlesGap, y2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x2 - SwingMouseHandler.this.handlesGap, y1 + Math.abs(y2 - y1) / 2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x1 - SwingMouseHandler.this.handlesGap, y1 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x1 - SwingMouseHandler.this.handlesGap, y2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x2 - SwingMouseHandler.this.handlesGap, y1 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(x2 - SwingMouseHandler.this.handlesGap, y2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2)};
                return cursorBoxHandles;
            }
            return null;
        }
    }

    protected class mouse_clicker
    extends MouseAdapter {
        public Rectangle area = null;
        public int id = -1;
        public int lastId = -1;

        protected mouse_clicker() {
        }

        public void mousePressed(MouseEvent event) {
            SwingMouseHandler.this.decode_pdf.grabFocus();
            float scaling = SwingMouseHandler.this.currentGUI.getScaling();
            int inset = SwingMouseHandler.this.currentGUI.getPDFDisplayInset();
            int rotation = SwingMouseHandler.this.currentGUI.getRotation();
            int x = (int)((float)(SwingMouseHandler.this.currentGUI.AdjustForAlignment(event.getX()) - inset) / scaling);
            int y = (int)((float)(event.getY() - inset) / scaling);
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.maxViewY != 0) {
                x = (int)((double)((float)x - (float)((SwingMouseHandler)SwingMouseHandler.this).commonValues.dx * scaling) / ((SwingMouseHandler)SwingMouseHandler.this).commonValues.viewportScale);
                y = (int)(((double)((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (double)((float)((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (float)y / scaling - (float)((SwingMouseHandler)SwingMouseHandler.this).commonValues.dy) / ((SwingMouseHandler)SwingMouseHandler.this).commonValues.viewportScale) * (double)scaling);
            }
            if (rotation == 90) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = x + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = y + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX;
            } else if (rotation == 180) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - (x + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = y + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY;
            } else if (rotation == 270) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (x + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - (y + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX);
            } else {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = x + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (y + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY);
            }
            SwingMouseHandler.this.updateCords(event);
        }

        public void mouseClicked(MouseEvent event) {
            this.id = SwingMouseHandler.this.decode_pdf.getDynamicRenderer().isInsideImage(SwingMouseHandler.this.cx, SwingMouseHandler.this.cy);
            if (this.lastId != this.id && this.id != -1) {
                this.area = SwingMouseHandler.this.decode_pdf.getDynamicRenderer().getArea(this.id);
                if (this.area != null) {
                    int h = this.area.height;
                    int w = this.area.width;
                    int x = this.area.x;
                    int y = this.area.y;
                    ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getDynamicRenderer().needsHorizontalInvert = false;
                    ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getDynamicRenderer().needsVerticalInvert = false;
                    if (w < 0) {
                        ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getDynamicRenderer().needsHorizontalInvert = true;
                        w = -w;
                        x -= w;
                    }
                    if (h < 0) {
                        ((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.getDynamicRenderer().needsVerticalInvert = true;
                        h = -h;
                        y -= h;
                    }
                    if (SwingMouseHandler.this.decode_pdf.isImageExtractionAllowed()) {
                        if (SwingMouseHandler.this.decode_pdf.getHighlightImage() == null) {
                            SwingMouseHandler.this.currentCommands.executeCommand(13);
                        }
                        SwingMouseHandler.this.decode_pdf.setHighlightedImage(new int[]{x, y, w, h});
                    }
                }
                if (firstImageSelected && SwingMouseHandler.this.decode_pdf.isImageExtractionAllowed()) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewer.HighlightImageExtraction"), "Extracting Images", 1);
                    firstImageSelected = false;
                }
                this.lastId = this.id;
            } else {
                if (SwingMouseHandler.this.decode_pdf.isImageExtractionAllowed()) {
                    if (SwingMouseHandler.this.decode_pdf.getHighlightImage() != null) {
                        SwingMouseHandler.this.currentCommands.executeCommand(13);
                    }
                    SwingMouseHandler.this.decode_pdf.setHighlightedImage(null);
                }
                this.lastId = -1;
            }
            if (!((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.showAnnotations) {
                SwingMouseHandler.this.checkLinks(true);
            }
        }

        public void mouseReleased(MouseEvent event) {
            SwingMouseHandler.this.old_m_x2 = -1;
            SwingMouseHandler.this.old_m_y2 = -1;
            SwingMouseHandler.this.updateCords(event);
            if (SwingMouseHandler.this.decode_pdf.getHighlightImage() != null && SwingMouseHandler.this.decode_pdf.getDynamicRenderer().isInsideImage(SwingMouseHandler.this.cx, SwingMouseHandler.this.cy) != -1 && !SwingMouseHandler.this.dragged) {
                if (SwingMouseHandler.this.commonValues.isPDF() && event.isShiftDown() && SwingMouseHandler.this.decode_pdf.getDisplayView() == 1) {
                    JFileChooser jf = new JFileChooser();
                    FileFilter ff1 = new FileFilter(){

                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg");
                        }

                        public String getDescription() {
                            return "JPG (*.jpg)";
                        }
                    };
                    FileFilter ff2 = new FileFilter(){

                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith(".png");
                        }

                        public String getDescription() {
                            return "PNG (*.png)";
                        }
                    };
                    FileFilter ff3 = new FileFilter(){

                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith(".tif") || f.getName().toLowerCase().endsWith(".tiff");
                        }

                        public String getDescription() {
                            return "TIF (*.tiff)";
                        }
                    };
                    jf.addChoosableFileFilter(ff3);
                    jf.addChoosableFileFilter(ff2);
                    jf.addChoosableFileFilter(ff1);
                    jf.showSaveDialog(null);
                    File f = jf.getSelectedFile();
                    boolean failed = false;
                    if (f != null) {
                        String filename = f.getAbsolutePath();
                        String type = jf.getFileFilter().getDescription().substring(0, 3).toLowerCase();
                        if (filename.indexOf(46) != -1) {
                            String testExt = filename.substring(filename.indexOf(46) + 1).toLowerCase();
                            if (testExt.equals("jpg") || testExt.equals("jpeg")) {
                                type = "jpg";
                            } else if (testExt.equals("png")) {
                                type = "png";
                            } else if (testExt.equals("tif") || testExt.equals("tiff")) {
                                type = "tiff";
                            } else {
                                JOptionPane.showMessageDialog(null, "Sorry, we can not currently save images to ." + testExt + " files.");
                                failed = true;
                            }
                        }
                        if (type.equals("tif")) {
                            type = "tiff";
                        }
                        if (type.equals("all")) {
                            type = "png";
                        }
                        if (!filename.toLowerCase().endsWith(String.valueOf('.') + type)) {
                            filename = String.valueOf(filename) + '.' + type;
                        }
                        if (!failed) {
                            SwingMouseHandler.this.decode_pdf.getDynamicRenderer().saveImage(this.id, filename, type);
                        }
                    }
                }
            } else if (SwingMouseHandler.this.commonValues.isPDF() && event.isShiftDown()) {
                if (SwingMouseHandler.this.commonValues.isExtractImageOnSelection()) {
                    if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1) {
                        SwingMouseHandler.this.currentCommands.extractSelectedScreenAsImage();
                    } else {
                        JOptionPane.showMessageDialog(SwingMouseHandler.this.currentGUI.getFrame(), "Image Extraction is only avalible in single page display mode");
                    }
                } else if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1) {
                    SwingMouseHandler.this.currentCommands.extractSelectedText();
                } else {
                    JOptionPane.showMessageDialog(SwingMouseHandler.this.currentGUI.getFrame(), "Text Extraction is only avalible in single page display mode");
                }
            }
            SwingMouseHandler.this.decode_pdf.updateCursorBoxOnScreen(null, null);
            SwingMouseHandler.this.decode_pdf.setHighlightedAreas(null);
            SwingMouseHandler.this.decode_pdf.repaintArea(new Rectangle(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY), ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH);
            SwingMouseHandler.this.decode_pdf.repaint();
            SwingMouseHandler.this.dragged = false;
        }

        public void mouseExited(MouseEvent arg0) {
            SwingMouseHandler.this.scrollThread.setAutoScroll(false, 0, 0, 0);
        }
    }

    protected class mouse_mover
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent event) {
            SwingMouseHandler.this.dragged = true;
            int[] values = SwingMouseHandler.this.updateXY(event);
            ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = values[0];
            ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = values[1];
            SwingMouseHandler.this.scrollAndUpdateCoords(event);
            if (SwingMouseHandler.this.commonValues.isPDF()) {
                this.generateNewCursorBox();
            }
            if (!((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.showAnnotations) {
                SwingMouseHandler.this.checkLinks(false);
            }
        }

        protected void generateNewCursorBox() {
            if (SwingMouseHandler.this.old_m_x2 != -1 | SwingMouseHandler.this.old_m_y2 != -1 | Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - SwingMouseHandler.this.old_m_x2) > 5 | Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - SwingMouseHandler.this.old_m_y2) > 5) {
                int top_x = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                    top_x = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                }
                int top_y = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2) {
                    top_y = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
                }
                int w = Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1);
                int h = Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1);
                Rectangle currentRectangle = new Rectangle(top_x, top_y, w, h);
                SwingMouseHandler.this.currentGUI.setRectangle(currentRectangle);
                SwingMouseHandler.this.decode_pdf.updateCursorBoxOnScreen(currentRectangle, Color.blue);
                Rectangle[] highlightedAreas = new Rectangle[2];
                highlightedAreas[0] = currentRectangle;
                SwingMouseHandler.this.decode_pdf.setHighlightedAreas(highlightedAreas);
                SwingMouseHandler.this.old_m_x2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                SwingMouseHandler.this.old_m_y2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
            }
        }

        public void mouseMoved(MouseEvent event) {
            SwingMouseHandler.this.updateCords(event);
            if (!((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.showAnnotations) {
                SwingMouseHandler.this.checkLinks(false);
            }
        }
    }
}

