/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jpedal.examples.simpleviewer.gui.GUI;
import org.jpedal.utils.Messages;

public class Preferences {
    JFrame jf = new JFrame("JPedal PDF Preferences");
    JLabel title = new JLabel("Preferences");
    JPanel mainPane = new JPanel(new GridBagLayout());
    JPanel[] settings = new JPanel[2];
    JButton confirm = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    JTextField dpi_Input = new JTextField("96");
    String dpiDefaultValue = "96";
    JComboBox searchStyle = new JComboBox<String>(new String[]{"Ext. Window", "Tab Pane", "Menu Bar"});
    int searchStyleDefaultValue = 1;
    JCheckBox border = new JCheckBox();
    int borderDefaultValue = 1;
    JCheckBox autoScroll = new JCheckBox();
    boolean scrollDefaultValue = false;
    JComboBox pageLayout = new JComboBox<String>(new String[]{"Single Page", "Continuous", "Continuous Facing", "Facing"});
    int pageLayoutDefaultValue = 1;
    JList settingsList = new JList<String>(new String[]{"Display", "Viewer"});
    Box setButtons = Box.createHorizontalBox();
    int currentListSelection = 0;

    public void createPreferanceWindow(final GUI gui) {
        this.jf = new JFrame(Messages.getMessage("PageLayoutViewMenu.PreferencesWindowTitle"));
        int i = 0;
        while (i != this.settings.length) {
            this.settings[i] = new JPanel(new BorderLayout());
            ++i;
        }
        this.settingsList = new JList<String>(new String[]{"Display", "Viewer"});
        this.settingsList.setSelectedIndex(this.currentListSelection);
        this.settingsList.setSize(50, 100);
        this.dpi_Input = new JTextField(this.dpiDefaultValue);
        this.dpi_Input.setPreferredSize(new Dimension(this.dpi_Input.getFont().getSize() * 4, this.dpi_Input.getFont().getSize() + 10));
        this.searchStyle = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")});
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.Facing")});
        this.border = new JCheckBox();
        this.autoScroll = new JCheckBox();
        this.confirm = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.title = new JLabel(Messages.getMessage("PageLayoutViewMenu.Preferences"));
        this.title.setFont(new Font(null, 1, 14));
        this.setButtons.add(this.confirm);
        this.setButtons.add(Box.createHorizontalStrut(30));
        this.setButtons.add(this.cancel);
        i = 0;
        while (i != this.settingsList.countComponents() + 1) {
            switch (i) {
                case 0: {
                    this.createDisplaySettings(this.settings[0]);
                    break;
                }
                case 1: {
                    this.createViewerSettings(this.settings[1]);
                    break;
                }
            }
            ++i;
        }
        this.mainPane = this.buildMainPane(this.mainPane);
        this.jf.getContentPane().setLayout(new BorderLayout());
        this.jf.getContentPane().add((Component)this.mainPane, "Center");
        this.jf.setSize(400, 300);
        this.jf.setResizable(false);
        this.confirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Preferences.this.dpiDefaultValue = Preferences.this.dpi_Input.getText();
                int dpi = Integer.parseInt(Preferences.this.dpi_Input.getText());
                int style = Preferences.this.searchStyleDefaultValue = Preferences.this.searchStyle.getSelectedIndex();
                int pageMode = Preferences.this.pageLayoutDefaultValue = Preferences.this.pageLayout.getSelectedIndex() + 57;
                Preferences.this.borderDefaultValue = 0;
                int borderStyle = 0;
                if (Preferences.this.border.isSelected()) {
                    Preferences.this.borderDefaultValue = 1;
                    borderStyle = 1;
                }
                boolean toggleScroll = Preferences.this.scrollDefaultValue = Preferences.this.autoScroll.isSelected();
                gui.setPreferences(dpi, style, borderStyle, toggleScroll, pageMode);
                Preferences.this.jf.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Preferences.this.jf.setVisible(false);
            }
        });
        this.dpi_Input.addKeyListener(new KeyListener(){
            boolean consume = false;

            public void keyPressed(KeyEvent e) {
                this.consume = false;
                if (!(e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyCode() == 8 && e.getKeyCode() == 127)) {
                    this.consume = true;
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                if (this.consume) {
                    e.consume();
                }
            }
        });
        this.settingsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Preferences.this.changeDisplayedSettings();
            }
        });
        this.searchStyle.setSelectedIndex(this.searchStyleDefaultValue);
        this.dpi_Input.setText(this.dpiDefaultValue);
        if (this.borderDefaultValue == 1) {
            this.border.setSelected(true);
        } else {
            this.border.setSelected(false);
        }
        this.autoScroll.setSelected(this.scrollDefaultValue);
    }

    private JPanel buildMainPane(JPanel mainPane) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 10, 0, 10);
        c.ipadx = 10;
        c.ipady = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        mainPane.add((Component)this.title, c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridheight = 5;
        c.gridwidth = 5;
        mainPane.add((Component)this.settings[0], c);
        c.gridx = 5;
        c.gridy = 10;
        c.gridwidth = 2;
        c.gridheight = 1;
        mainPane.add((Component)this.setButtons, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 9;
        c.gridwidth = 2;
        mainPane.add((Component)this.settingsList, c);
        return mainPane;
    }

    private void changeDisplayedSettings() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 2;
        c.gridy = 1;
        c.gridheight = 5;
        c.gridwidth = 5;
        c.weighty = 1.0;
        c.ipadx = 10;
        c.ipady = 10;
        c.insets = new Insets(0, 10, 0, 10);
        this.mainPane.remove(this.settings[this.currentListSelection]);
        this.mainPane.add((Component)this.settings[this.settingsList.getSelectedIndex()], c);
        this.mainPane.validate();
        this.mainPane.repaint();
        this.currentListSelection = this.settingsList.getSelectedIndex();
    }

    public void showPreferanceWindow() {
        this.jf.setVisible(true);
    }

    private JPanel createViewerSettings(JPanel pane) {
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        pane.setPreferredSize(new Dimension(250, 100));
        pane.setMinimumSize(new Dimension(250, 100));
        c.insets = new Insets(10, 0, 10, 0);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout")), c);
        c.gridx = 2;
        c.gridy = 0;
        pane.add((Component)this.searchStyle, c);
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout")), c);
        c.gridx = 2;
        c.gridy = 1;
        pane.add((Component)this.pageLayout, c);
        c.gridx = 0;
        c.gridy = 2;
        pane.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text")), c);
        c.gridx = 2;
        c.gridy = 2;
        pane.add((Component)this.autoScroll, c);
        pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.3f, 0.5f, 1.0f), 1), "Viewer Settings"));
        return pane;
    }

    private JPanel createDisplaySettings(JPanel pane) {
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        pane.setPreferredSize(new Dimension(250, 100));
        pane.setMinimumSize(new Dimension(250, 100));
        c.insets = new Insets(10, 0, 10, 0);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenu.Dpi")), c);
        c.gridx = 2;
        c.gridy = 0;
        pane.add((Component)this.dpi_Input, c);
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)new JLabel(Messages.getMessage("PageLayoutViewMenu.Borders_Show")), c);
        c.gridx = 2;
        c.gridy = 1;
        pane.add((Component)this.border, c);
        pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.3f, 0.5f, 1.0f), 1), "Display Settings"));
        return pane;
    }

    public void setAutoScrollDefaultValue(boolean autoScrollDefaultValue) {
        this.scrollDefaultValue = autoScrollDefaultValue;
    }

    public void setBorderDefaultValue(int borderDefaultValue) {
        this.borderDefaultValue = borderDefaultValue;
    }

    public void setDpiDefaultValue(String dpiDefaultValue) {
        this.dpiDefaultValue = dpiDefaultValue;
    }

    public void setSearchStyleDefaultValue(int searchStyleDefaultValue) {
        this.searchStyleDefaultValue = searchStyleDefaultValue;
    }
}

