/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.GUI;
import org.jpedal.examples.simpleviewer.gui.SignaturesTreeCellRenderer;
import org.jpedal.examples.simpleviewer.gui.VTextIcon;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.generic.GUICombo;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.swing.CommandListener;
import org.jpedal.examples.simpleviewer.gui.swing.FrameCloser;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.examples.simpleviewer.gui.swing.SwingButton;
import org.jpedal.examples.simpleviewer.gui.swing.SwingCombo;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMenuItem;
import org.jpedal.examples.simpleviewer.gui.swing.SwingOutline;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Int;
import org.w3c.dom.Node;

public class SwingGUI
extends GUI
implements GUIFactory {
    boolean finishedDecoding = false;
    static final int startSize = 30;
    static final int expandedSize = 190;
    String pageTitle;
    String bookmarksTitle;
    String signaturesTitle;
    boolean hasListener = false;
    private boolean isSetup = false;
    int lastTabSelected = -1;
    public boolean messageShown = false;
    ButtonGroup layoutGroup = new ButtonGroup();
    ButtonGroup searchLayoutGroup = new ButtonGroup();
    ButtonGroup borderGroup = new ButtonGroup();
    private CommandListener currentCommandListener;
    private JToolBar topButtons = new JToolBar();
    private JToolBar comboBar = new JToolBar();
    private JToolBar bottomNavButtons = new JToolBar();
    private JMenuBar currentMenu = new JMenuBar();
    private boolean firstTimeFormMessage = true;
    private JLabel coords = new JLabel();
    private JFrame frame = new JFrame();
    private JTabbedPane navOptionsPanel = new JTabbedPane();
    private JSplitPane displayPane;
    private JScrollPane scrollPane = new JScrollPane();
    private final Font headFont = new Font("SansSerif", 1, 14);
    private final Font textFont = new Font("Serif", 0, 12);
    private StatusBar statusBar = new StatusBar(Color.orange);
    public JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3;
    private JLabel optimizationLabel;
    private JTree signaturesTree = new JTree();
    private String user_dir = System.getProperty("user.dir");
    private boolean tabsNotInitialised = true;
    private JToolBar navToolBar = new JToolBar();
    private JToolBar pagesToolBar = new JToolBar();
    public GUIButton nextSearch;
    public GUIButton previousSearch;
    GUISearchWindow searchFrame = null;
    boolean addSearchTab = false;
    boolean searchInMenu = false;
    JTextField searchText = null;
    SearchList results = null;

    public SwingGUI(PdfDecoder decode_pdf, Values commonValues, GUIThumbnailPanel thumbnails, PropertiesFile properties) {
        this.decode_pdf = decode_pdf;
        this.commonValues = commonValues;
        this.thumbnails = thumbnails;
        this.properties = properties;
        if (commonValues.isContentExtractor()) {
            this.titleMessage = "IDRsolutions Extraction Solution 3.31b05STD ";
            this.showOutlines = false;
        }
        SignaturesTreeCellRenderer treeCellRenderer = new SignaturesTreeCellRenderer();
        this.signaturesTree.setCellRenderer(treeCellRenderer);
    }

    public JComponent getDisplayPane() {
        return this.displayPane;
    }

    public int AdjustForAlignment(int cx) {
        if (this.decode_pdf.getPageAlignment() == 2) {
            int width = this.decode_pdf.getBounds().width;
            int pdfWidth = this.decode_pdf.getPDFWidth();
            if (this.decode_pdf.getDisplayView() != 1) {
                pdfWidth = (int)this.decode_pdf.getMaximumSize().getWidth();
            }
            if (width > pdfWidth) {
                cx -= (width - pdfWidth) / 2;
            }
        }
        return cx;
    }

    public String getBookmark(String bookmark) {
        return this.tree.getPage(bookmark);
    }

    public void reinitialiseTabs() {
        this.displayPane.setDividerLocation(30);
        this.lastTabSelected = -1;
        if (this.commonValues.isContentExtractor()) {
            this.navOptionsPanel.removeAll();
            this.displayPane.setDividerLocation(0);
        } else if (!this.commonValues.isPDF()) {
            this.navOptionsPanel.setVisible(false);
        } else {
            AcroRenderer currentFormRenderer;
            Iterator signatureObjects;
            String tabName;
            int outlineTab;
            this.navOptionsPanel.setVisible(true);
            if (!this.decode_pdf.hasOutline()) {
                int jj;
                outlineTab = -1;
                if (PdfDecoder.isRunningOnMac) {
                    tabName = "";
                    jj = 0;
                    while (jj < this.navOptionsPanel.getTabCount()) {
                        if (this.navOptionsPanel.getTitleAt(jj).equals(this.bookmarksTitle)) {
                            outlineTab = jj;
                        }
                        ++jj;
                    }
                } else {
                    tabName = "";
                    jj = 0;
                    while (jj < this.navOptionsPanel.getTabCount()) {
                        if (this.navOptionsPanel.getIconAt(jj).toString().equals(this.bookmarksTitle)) {
                            outlineTab = jj;
                        }
                        ++jj;
                    }
                }
                if (outlineTab != -1) {
                    this.navOptionsPanel.remove(outlineTab);
                }
            } else {
                outlineTab = -1;
                if (PdfDecoder.isRunningOnMac) {
                    tabName = "";
                    int jj = 0;
                    while (jj < this.navOptionsPanel.getTabCount()) {
                        if (this.navOptionsPanel.getTitleAt(jj).equals(this.bookmarksTitle)) {
                            outlineTab = jj;
                        }
                        ++jj;
                    }
                    if (outlineTab == -1) {
                        this.navOptionsPanel.addTab(this.bookmarksTitle, (SwingOutline)this.tree);
                    }
                } else {
                    tabName = "";
                    int jj = 0;
                    while (jj < this.navOptionsPanel.getTabCount()) {
                        if (this.navOptionsPanel.getIconAt(jj).toString().equals(this.bookmarksTitle)) {
                            outlineTab = jj;
                        }
                        ++jj;
                    }
                    if (outlineTab == -1) {
                        VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle, 2);
                        this.navOptionsPanel.addTab(null, textIcon2, (SwingOutline)this.tree);
                    }
                }
            }
            if ((signatureObjects = (currentFormRenderer = this.decode_pdf.getCurrentFormRenderer()).getSignatureObjects()) != null) {
                String tabName2;
                DefaultMutableTreeNode root = new DefaultMutableTreeNode("Signatures");
                DefaultMutableTreeNode signed = new DefaultMutableTreeNode("The following people have digitally counter-signed this document");
                DefaultMutableTreeNode blank = new DefaultMutableTreeNode("The following signature fields are not signed");
                while (signatureObjects.hasNext()) {
                    FormObject formObj = (FormObject)signatureObjects.next();
                    Map sigObject = currentFormRenderer.getSignatureObject(formObj.getPDFRef());
                    if (sigObject == null) {
                        if (!blank.isNodeChild(root)) {
                            root.add(blank);
                        }
                        DefaultMutableTreeNode blankNode = new DefaultMutableTreeNode(String.valueOf(formObj.getFieldName()) + " on page " + formObj.getPageNumber());
                        blank.add(blankNode);
                        continue;
                    }
                    if (!signed.isNodeChild(root)) {
                        root.add(signed);
                    }
                    String name = (String)sigObject.get("Name");
                    DefaultMutableTreeNode owner = new DefaultMutableTreeNode("Signed by " + name);
                    signed.add(owner);
                    DefaultMutableTreeNode type = new DefaultMutableTreeNode("Type");
                    owner.add(type);
                    String filter = (String)sigObject.get("Filter");
                    DefaultMutableTreeNode filterNode = new DefaultMutableTreeNode("Filter: " + filter.substring(1, filter.length()));
                    type.add(filterNode);
                    String subFilter = (String)sigObject.get("SubFilter");
                    DefaultMutableTreeNode subFilterNode = new DefaultMutableTreeNode("Sub Filter: " + subFilter.substring(1, subFilter.length()));
                    type.add(subFilterNode);
                    DefaultMutableTreeNode details = new DefaultMutableTreeNode("Details");
                    owner.add(details);
                    StringBuffer date = new StringBuffer((String)sigObject.get("M"));
                    date.delete(0, 2);
                    date.insert(4, '/');
                    date.insert(7, '/');
                    date.insert(10, ' ');
                    date.insert(13, ':');
                    date.insert(16, ':');
                    date.insert(19, ' ');
                    DefaultMutableTreeNode time = new DefaultMutableTreeNode("Time: " + date);
                    details.add(time);
                    String reason = (String)sigObject.get("Reason");
                    DefaultMutableTreeNode reasonNode = new DefaultMutableTreeNode("Reason: " + reason);
                    details.add(reasonNode);
                    String location = (String)sigObject.get("Location");
                    DefaultMutableTreeNode locationNode = new DefaultMutableTreeNode("Location: " + location);
                    details.add(locationNode);
                    DefaultMutableTreeNode field = new DefaultMutableTreeNode("Field: " + formObj.getFieldName() + " on page " + formObj.getPageNumber());
                    details.add(field);
                }
                ((DefaultTreeModel)this.signaturesTree.getModel()).setRoot(root);
                int outlineTab2 = -1;
                if (PdfDecoder.isRunningOnMac) {
                    tabName2 = "";
                    int jj = 0;
                    while (jj < this.navOptionsPanel.getTabCount()) {
                        if (this.navOptionsPanel.getTitleAt(jj).equals(this.signaturesTitle)) {
                            outlineTab2 = jj;
                        }
                        ++jj;
                    }
                    if (outlineTab2 == -1) {
                        this.navOptionsPanel.addTab(this.signaturesTitle, this.signaturesTree);
                    }
                } else {
                    tabName2 = "";
                    int jj = 0;
                    while (jj < this.navOptionsPanel.getTabCount()) {
                        if (this.navOptionsPanel.getIconAt(jj).toString().equals(this.signaturesTitle)) {
                            outlineTab2 = jj;
                        }
                        ++jj;
                    }
                    if (outlineTab2 == -1) {
                        VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.signaturesTitle, 2);
                        this.navOptionsPanel.addTab(null, textIcon2, this.signaturesTree);
                    }
                }
            } else {
                int outlineTab3 = -1;
                if (PdfDecoder.isRunningOnMac) {
                    String tabName3 = "";
                    int jj = 0;
                    while (jj < this.navOptionsPanel.getTabCount()) {
                        if (this.navOptionsPanel.getTitleAt(jj).equals(this.signaturesTitle)) {
                            outlineTab3 = jj;
                        }
                        ++jj;
                    }
                } else {
                    String tabName4 = "";
                    int jj = 0;
                    while (jj < this.navOptionsPanel.getTabCount()) {
                        if (this.navOptionsPanel.getIconAt(jj).toString().equals(this.signaturesTitle)) {
                            outlineTab3 = jj;
                        }
                        ++jj;
                    }
                }
                if (outlineTab3 != -1) {
                    this.navOptionsPanel.remove(outlineTab3);
                }
            }
            this.setBookmarks(false);
        }
    }

    public void stopThumbnails() {
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
            this.thumbnails.removeAllListeners();
        }
    }

    public void reinitThumbnails() {
        this.isSetup = false;
    }

    public void resetNavBar() {
        this.displayPane.setDividerLocation(30);
        this.tabsNotInitialised = true;
    }

    public void alignLayoutMenuOption(int mode) {
        int i = 1;
        Enumeration<AbstractButton> menuOptions = this.layoutGroup.getElements();
        while (menuOptions.hasMoreElements() && i != mode) {
            menuOptions.nextElement();
            ++i;
        }
        ((JMenuItem)menuOptions.nextElement()).setSelected(true);
    }

    private JScrollPane getFontsAliasesInfoBox() {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        StringBuffer fullList = new StringBuffer();
        for (Object nextFont : FontMappings.fontSubstitutionAliasTable.keySet()) {
            fullList.append(nextFont);
            fullList.append(" ==> ");
            fullList.append(FontMappings.fontSubstitutionAliasTable.get(nextFont));
            fullList.append('\n');
        }
        String xmlText = fullList.toString();
        if (xmlText.length() > 0) {
            JTextArea xml = new JTextArea();
            xml.setLineWrap(false);
            xml.setText(xmlText);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
            details.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return scrollPane;
    }

    private JScrollPane getFontsFoundInfoBox() {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        StringBuffer fullList = new StringBuffer();
        for (Object nextFont : FontMappings.fontSubstitutionTable.keySet()) {
            fullList.append(nextFont);
            fullList.append(" = ");
            fullList.append(FontMappings.fontSubstitutionLocation.get(nextFont));
            fullList.append('\n');
        }
        String xmlText = fullList.toString();
        if (xmlText.length() > 0) {
            JTextArea xml = new JTextArea();
            xml.setLineWrap(false);
            xml.setText(xmlText);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
            details.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return scrollPane;
    }

    private JScrollPane getFontInfoBox() {
        JPanel details = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        details.setOpaque(true);
        details.setBackground(Color.white);
        details.setEnabled(false);
        details.setLayout(new BoxLayout(details, 3));
        String xmlText = this.decode_pdf.getFontsInFile();
        if (xmlText.length() > 0) {
            JTextArea xml = new JTextArea();
            xml.setLineWrap(false);
            xml.setText(xmlText);
            details.add(xml);
            xml.setCaretPosition(0);
            xml.setOpaque(false);
            details.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return scrollPane;
    }

    public void getInfoBox() {
        final JPanel details = new JPanel();
        details.setPreferredSize(new Dimension(400, 260));
        details.setOpaque(false);
        details.setLayout(new BoxLayout(details, 1));
        JLabel header1 = new JLabel(Messages.getMessage("PdfViewerInfo.title"));
        header1.setOpaque(false);
        header1.setFont(this.headFont);
        header1.setAlignmentX(0.5f);
        details.add(header1);
        details.add(Box.createRigidArea(new Dimension(0, 15)));
        String xmlText = String.valueOf(Messages.getMessage("PdfViewerInfo1")) + Messages.getMessage("PdfViewerInfo2");
        if (xmlText.length() > 0) {
            JTextArea xml = new JTextArea();
            xml.setOpaque(false);
            xml.setText(String.valueOf(xmlText) + "\n\nVersion: " + "3.31b05STD" + "\n\n" + "Java version " + System.getProperty("java.version"));
            xml.setLineWrap(true);
            xml.setWrapStyleWord(true);
            xml.setEditable(false);
            details.add(xml);
            xml.setAlignmentX(0.5f);
        }
        ImageIcon logo = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/logo.gif"));
        details.add(Box.createRigidArea(new Dimension(0, 25)));
        JLabel idr = new JLabel(logo);
        idr.setAlignmentX(0.5f);
        details.add(idr);
        final JLabel url = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
        url.setForeground(Color.blue);
        url.setHorizontalAlignment(0);
        url.setAlignmentX(0.5f);
        url.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent e) {
                details.setCursor(new Cursor(12));
                url.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress") + "</a></center>");
            }

            public void mouseExited(MouseEvent e) {
                details.setCursor(new Cursor(0));
                url.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
            }

            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                }
                catch (IOException e1) {
                    SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        details.add(url);
        details.add(Box.createRigidArea(new Dimension(0, 5)));
        details.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.showMessageDialog(details, Messages.getMessage("PdfViewerInfo3"), -1);
    }

    public void resetRotationBox() {
        PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
        if (this.decode_pdf.getDisplayView() == 1) {
            this.rotation = currentPageData.getRotation(this.commonValues.getCurrentPage());
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!this.commonValues.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    private JScrollPane getPropertiesBox(String file, String path, String user_dir, long size, int pageCount, int currentPage) {
        PdfFileInformation currentFileInformation = this.decode_pdf.getFileInformationData();
        if (currentFileInformation != null) {
            JPanel details = new JPanel();
            details.setOpaque(true);
            details.setBackground(Color.white);
            details.setLayout(new BoxLayout(details, 1));
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(400, 300));
            scrollPane.getViewport().add(details);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            JLabel header1 = new JLabel(Messages.getMessage("PdfViewerGeneral"));
            header1.setFont(this.headFont);
            header1.setOpaque(false);
            details.add(header1);
            JLabel g1 = new JLabel(String.valueOf(Messages.getMessage("PdfViewerFileName")) + file);
            g1.setFont(this.textFont);
            g1.setOpaque(false);
            details.add(g1);
            JLabel g2 = new JLabel(String.valueOf(Messages.getMessage("PdfViewerFilePath")) + path);
            g2.setFont(this.textFont);
            g2.setOpaque(false);
            details.add(g2);
            JLabel g3 = new JLabel(String.valueOf(Messages.getMessage("PdfViewerCurrentWorkingDir")) + ' ' + user_dir);
            g3.setFont(this.textFont);
            g3.setOpaque(false);
            details.add(g3);
            JLabel g4 = new JLabel(String.valueOf(Messages.getMessage("PdfViewerFileSize")) + size + " K");
            g4.setFont(this.textFont);
            g4.setOpaque(false);
            details.add(g4);
            JLabel g5 = new JLabel(String.valueOf(Messages.getMessage("PdfViewerPageCount")) + pageCount);
            g5.setOpaque(false);
            g5.setFont(this.textFont);
            details.add(g5);
            JLabel g6 = new JLabel("PDF " + this.decode_pdf.getPDFVersion());
            g6.setOpaque(false);
            g6.setFont(this.textFont);
            details.add(g6);
            details.add(Box.createVerticalStrut(10));
            JLabel header2 = new JLabel(Messages.getMessage("PdfViewerProperties"));
            header2.setFont(this.headFont);
            header2.setOpaque(false);
            details.add(header2);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = currentFileInformation.getFieldNames();
            int count = fields.length;
            JLabel[] displayValues = new JLabel[count];
            int i = 0;
            while (i < count) {
                if (values[i].length() > 0) {
                    displayValues[i] = new JLabel(String.valueOf(fields[i]) + " = " + values[i]);
                    displayValues[i].setFont(this.textFont);
                    displayValues[i].setOpaque(false);
                    details.add(displayValues[i]);
                }
                ++i;
            }
            details.add(Box.createVerticalStrut(10));
            PdfPageData currentPageSize = this.decode_pdf.getPdfPageData();
            if (currentPageSize != null) {
                JLabel header3 = new JLabel(Messages.getMessage("PdfViewerCoords.text"));
                header3.setFont(this.headFont);
                details.add(header3);
                JLabel g7 = new JLabel(String.valueOf(Messages.getMessage("PdfViewermediaBox.text")) + currentPageSize.getMediaValue(currentPage));
                g7.setFont(this.textFont);
                details.add(g7);
                JLabel g8 = new JLabel(String.valueOf(Messages.getMessage("PdfViewercropBox.text")) + currentPageSize.getCropValue(currentPage));
                g8.setFont(this.textFont);
                details.add(g8);
                JLabel g9 = new JLabel(String.valueOf(Messages.getMessage("PdfViewerLabel.Rotation")) + currentPageSize.getRotation(currentPage));
                g3.setFont(this.textFont);
                details.add(g9);
            }
            details.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return scrollPane;
        }
        return new JScrollPane();
    }

    private JScrollPane getXMLInfoBox(String xmlText) {
        JPanel details = new JPanel();
        details.setLayout(new BoxLayout(details, 3));
        details.setOpaque(true);
        details.setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(400, 300));
        scrollPane.getViewport().add(details);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        JTextArea xml = new JTextArea();
        xml.setRows(5);
        xml.setColumns(15);
        xml.setLineWrap(true);
        xml.setText(xmlText);
        details.add(new JScrollPane(xml));
        xml.setCaretPosition(0);
        xml.setOpaque(true);
        xml.setBackground(Color.white);
        return scrollPane;
    }

    public void showDocumentProperties(String selectedFile, String inputDir, long size, int pageCount, int currentPage) {
        JTabbedPane tabbedPane = new JTabbedPane();
        if (selectedFile == null) {
            this.showMessageDialog(Messages.getMessage("PdfVieweremptyFile.message"), Messages.getMessage("PdfViewerTooltip.pageSize"), -1);
        } else {
            String filename = selectedFile;
            int ptr = filename.lastIndexOf(92);
            if (ptr == -1) {
                ptr = filename.lastIndexOf(47);
            }
            String file = filename.substring(ptr + 1, filename.length());
            String path = filename.substring(0, ptr + 1);
            tabbedPane.add(this.getPropertiesBox(file, path, this.user_dir, size, pageCount, currentPage));
            tabbedPane.setTitleAt(0, Messages.getMessage("PdfViewerTab.Properties"));
            tabbedPane.add(this.getFontInfoBox());
            tabbedPane.setTitleAt(1, Messages.getMessage("PdfViewerTab.Fonts"));
            tabbedPane.add(this.getFontsFoundInfoBox());
            tabbedPane.setTitleAt(2, "Available");
            tabbedPane.add(this.getFontsAliasesInfoBox());
            tabbedPane.setTitleAt(3, "Aliases");
            PdfFileInformation currentFileInformation = this.decode_pdf.getFileInformationData();
            String xmlText = currentFileInformation.getFileXMLMetaData();
            if (xmlText.length() > 0) {
                tabbedPane.add(this.getXMLInfoBox(xmlText));
                tabbedPane.setTitleAt(4, "XML");
            }
            this.showMessageDialog(tabbedPane, Messages.getMessage("PdfViewerTab.DocumentProperties"), -1);
        }
    }

    public void searchInTab(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
        if (PdfDecoder.isRunningOnMac) {
            if (this.thumbnails.isShownOnscreen()) {
                this.navOptionsPanel.addTab("Search", searchFrame.getContentPanel());
            }
        } else {
            VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, "Search", 2);
            this.navOptionsPanel.addTab(null, textIcon2, searchFrame.getContentPanel());
        }
        this.addSearchTab = true;
    }

    public void searchInMenu(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
        this.searchInMenu = true;
        searchFrame.find();
        this.searchText.setPreferredSize(new Dimension(150, 20));
        this.topButtons.add(this.searchText);
        this.addButton(0, "Previous Search Result", "/org/jpedal/examples/simpleviewer/res/search_previous.gif", 18);
        this.addButton(0, "Next Search Result", "/org/jpedal/examples/simpleviewer/res/search_next.gif", 19);
        this.nextSearch.setVisible(false);
        this.previousSearch.setVisible(false);
    }

    public void init(String[] scalingValues, final Object currentCommands, Object currentPrinter) {
        this.currentCommandListener = new CommandListener((Commands)currentCommands);
        this.setViewerTitle(String.valueOf(Messages.getMessage("PdfViewerEnhanced.titlebar")) + "  " + "3.31b05STD");
        this.decode_pdf.setInset(25, 25);
        this.decode_pdf.setBackground(new Color(190, 190, 190));
        this.scalingBox = new SwingCombo(scalingValues);
        this.scalingBox.setBackground(Color.white);
        this.scalingBox.setEditable(true);
        this.scalingBox.setSelectedIndex(0);
        this.rotationBox = new SwingCombo(this.rotationValues);
        this.rotationBox.setBackground(Color.white);
        this.rotationBox.setSelectedIndex(0);
        this.scrollPane.getViewport().add(this.decode_pdf);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(80);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        this.bottomNavButtons.setBorder(BorderFactory.createEmptyBorder());
        this.bottomNavButtons.setLayout(new FlowLayout(3));
        this.bottomNavButtons.setFloatable(false);
        this.bottomNavButtons.setFont(new Font("SansSerif", 0, 8));
        this.navOptionsPanel.setTabPlacement(2);
        this.navOptionsPanel.setOpaque(true);
        this.navOptionsPanel.setMinimumSize(new Dimension(0, 100));
        this.pageTitle = Messages.getMessage("PdfViewerJPanel.thumbnails");
        this.bookmarksTitle = Messages.getMessage("PdfViewerJPanel.bookmarks");
        this.signaturesTitle = "Signatures";
        this.displayPane = new JSplitPane(1, this.navOptionsPanel, this.scrollPane);
        this.displayPane.setOneTouchExpandable(true);
        if (!this.commonValues.isContentExtractor()) {
            if (PdfDecoder.isRunningOnMac) {
                if (this.thumbnails.isShownOnscreen()) {
                    this.navOptionsPanel.addTab(this.bookmarksTitle, (SwingOutline)this.tree);
                }
                this.navOptionsPanel.addTab(this.pageTitle, (Component)((Object)this.thumbnails));
            } else {
                VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle, 2);
                this.navOptionsPanel.addTab(null, textIcon2, (SwingOutline)this.tree);
                if (this.thumbnails.isShownOnscreen()) {
                    VTextIcon textIcon1 = new VTextIcon(this.navOptionsPanel, this.pageTitle, 2);
                    this.navOptionsPanel.addTab(null, textIcon1, (Component)((Object)this.thumbnails));
                }
            }
            this.displayPane.setDividerLocation(30);
        } else {
            this.displayPane.setDividerLocation(0);
        }
        this.frame.getContentPane().add((Component)this.displayPane, "Center");
        if (!this.hasListener) {
            this.hasListener = true;
            this.navOptionsPanel.addMouseListener(new MouseListener(){

                public void focusLost(FocusEvent focusEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    SwingGUI.this.handleTabbedPanes();
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
        }
        if (!this.commonValues.isContentExtractor()) {
            this.first = new SwingButton();
            this.fback = new SwingButton();
            this.back = new SwingButton();
            this.forward = new SwingButton();
            this.fforward = new SwingButton();
            this.end = new SwingButton();
        }
        this.snapshotButton = new SwingButton();
        this.singleButton = new SwingButton();
        this.continuousButton = new SwingButton();
        this.continuousFacingButton = new SwingButton();
        this.facingButton = new SwingButton();
        this.previousSearch = new SwingButton();
        this.nextSearch = new SwingButton();
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setToolTipText(Messages.getMessage("PdfViewerTooltip.goto"));
        this.pageCounter2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String value = SwingGUI.this.pageCounter2.getText().trim();
                ((Commands)currentCommands).gotoPage(value);
            }
        });
        this.pageCounter3 = new JLabel(String.valueOf(Messages.getMessage("PdfViewerOfLabel.text")) + ' ');
        this.pageCounter3.setOpaque(false);
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)top, "North");
        this.navToolBar.setLayout(new BoxLayout(this.navToolBar, 2));
        this.navToolBar.setFloatable(false);
        this.pagesToolBar.setFloatable(false);
        this.comboBar.setBorder(BorderFactory.createEmptyBorder());
        this.comboBar.setLayout(new BorderLayout());
        this.comboBar.setFloatable(false);
        this.comboBar.setPreferredSize(new Dimension(5, 24));
        this.frame.getContentPane().add((Component)this.comboBar, "South");
        top.add((Component)this.currentMenu, "North");
        this.topButtons.setBorder(BorderFactory.createEmptyBorder());
        this.topButtons.setLayout(new FlowLayout(3));
        this.topButtons.setFloatable(false);
        this.topButtons.setFont(new Font("SansSerif", 0, 8));
        top.add((Component)this.topButtons, "Center");
        top.add((Component)this.bottomNavButtons, "South");
        this.createNavbar();
        if (this.commonValues.getModeOfOperation() != 1) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            int width = d.width / 2;
            int height = d.height / 2;
            if (width < 700) {
                width = 700;
            }
            this.frame.setSize(width, height);
            this.frame.setLocationRelativeTo(null);
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new FrameCloser((Commands)currentCommands, this, this.decode_pdf, (Printer)currentPrinter, this.thumbnails, this.commonValues));
            this.frame.setVisible(true);
        }
    }

    private void handleTabbedPanes() {
        if (this.tabsNotInitialised) {
            return;
        }
        int currentSize = this.displayPane.getDividerLocation();
        int tabSelected = this.navOptionsPanel.getSelectedIndex();
        if (tabSelected == -1) {
            return;
        }
        if (currentSize == 30) {
            String tabName = "";
            tabName = PdfDecoder.isRunningOnMac ? this.navOptionsPanel.getTitleAt(tabSelected) : this.navOptionsPanel.getIconAt(tabSelected).toString();
            this.setupThumbnailPanel();
            this.setBookmarks(true);
            if (this.searchFrame != null) {
                this.searchFrame.find();
            }
            this.displayPane.setDividerLocation(190);
        } else if (tabSelected == this.lastTabSelected) {
            this.displayPane.setDividerLocation(30);
        }
        this.lastTabSelected = tabSelected;
    }

    public void addCursor() {
        JToolBar cursor = new JToolBar();
        cursor.setBorder(BorderFactory.createEmptyBorder());
        cursor.setLayout(new FlowLayout(3));
        cursor.setFloatable(false);
        cursor.setFont(new Font("SansSerif", 2, 10));
        cursor.add(new JLabel(Messages.getMessage("PdfViewerToolbarCursorLoc.text")));
        cursor.add(this.initCoordBox());
        cursor.setPreferredSize(new Dimension(170, 32));
        this.topButtons.add(cursor);
    }

    private void setKeyAccelerators(int ID, JMenuItem menuItem) {
        switch (ID) {
            case 12: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
                break;
            }
            case 5: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
                break;
            }
            case 6: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
                break;
            }
            case 7: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
                break;
            }
            case 9: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
                break;
            }
            case 10: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
                break;
            }
            case 14: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
                break;
            }
            case 16: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(37, 9));
                break;
            }
            case 17: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(39, 9));
                break;
            }
            case 50: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(36, 2));
                break;
            }
            case 52: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(37, 2));
                break;
            }
            case 53: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(39, 2));
                break;
            }
            case 55: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(35, 2));
                break;
            }
            case 56: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 3));
            }
        }
    }

    public void addButton(int line, String toolTip, String path, int ID) {
        GUIButton newButton = new SwingButton();
        switch (ID) {
            case 50: {
                newButton = this.first;
                break;
            }
            case 51: {
                newButton = this.fback;
                break;
            }
            case 52: {
                newButton = this.back;
                break;
            }
            case 53: {
                newButton = this.forward;
                break;
            }
            case 54: {
                newButton = this.fforward;
                break;
            }
            case 55: {
                newButton = this.end;
                break;
            }
            case 13: {
                newButton = this.snapshotButton;
                break;
            }
            case 57: {
                newButton = this.singleButton;
                break;
            }
            case 58: {
                newButton = this.continuousButton;
                break;
            }
            case 59: {
                newButton = this.continuousFacingButton;
                break;
            }
            case 60: {
                newButton = this.facingButton;
                break;
            }
            case 18: {
                newButton = this.previousSearch;
                break;
            }
            case 19: {
                newButton = this.nextSearch;
            }
        }
        if (ID == 10) {
            newButton.setName("open");
        }
        newButton.init(path, ID, toolTip);
        ((AbstractButton)((Object)newButton)).addActionListener(this.currentCommandListener);
        if (line == 0) {
            this.topButtons.add((AbstractButton)((Object)newButton));
            this.topButtons.add(Box.createHorizontalGlue());
        } else if (line == 1) {
            this.navToolBar.add((AbstractButton)((Object)newButton));
        } else if (line == 2) {
            this.pagesToolBar.add((Component)((AbstractButton)((Object)newButton)), "Center");
        }
    }

    public void addMenuItem(JMenu parentMenu, String text, String toolTip, int ID) {
        SwingMenuItem menuItem = new SwingMenuItem(text);
        if (toolTip.length() > 0) {
            menuItem.setToolTipText(toolTip);
        }
        menuItem.setID(ID);
        this.setKeyAccelerators(ID, menuItem);
        menuItem.addActionListener(this.currentCommandListener);
        parentMenu.add(menuItem);
    }

    public void addCombo(String title, String tooltip, int ID) {
        GUICombo combo = null;
        switch (ID) {
            case 252: {
                combo = this.scalingBox;
                break;
            }
            case 251: {
                combo = this.rotationBox;
            }
        }
        combo.setID(ID);
        this.optimizationLabel = new JLabel(title);
        if (tooltip.length() > 0) {
            combo.setToolTipText(tooltip);
        }
        this.bottomNavButtons.add(this.optimizationLabel);
        this.bottomNavButtons.add((SwingCombo)combo);
        ((SwingCombo)combo).addActionListener(this.currentCommandListener);
    }

    public void setViewerTitle(String title) {
        if (title != null) {
            this.frame.setTitle(title);
        } else {
            String finalMessage = "";
            finalMessage = this.titleMessage == null ? String.valueOf(Messages.getMessage("PdfViewerEnhanced.titlebar")) + "3.31b05STD" + ' ' + this.commonValues.getSelectedFile() : String.valueOf(this.titleMessage) + this.commonValues.getSelectedFile();
            if (this.commonValues.isFormsChanged()) {
                finalMessage = "* " + finalMessage;
            }
            this.frame.setTitle(finalMessage);
        }
    }

    public void resetComboBoxes(boolean value) {
        this.scalingBox.setEnabled(value);
        this.rotationBox.setEnabled(value);
    }

    public final JScrollPane createPane(JTextPane text_pane, String content, boolean useXML) throws BadLocationException {
        text_pane.setEditable(true);
        text_pane.setFont(new Font("Lucida", 0, 14));
        text_pane.setToolTipText(Messages.getMessage("PdfViewerTooltip.text"));
        Document doc = text_pane.getDocument();
        text_pane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), Messages.getMessage("PdfViewerTitle.text")));
        text_pane.setForeground(Color.black);
        SimpleAttributeSet token_attribute = new SimpleAttributeSet();
        SimpleAttributeSet text_attribute = new SimpleAttributeSet();
        SimpleAttributeSet plain_attribute = new SimpleAttributeSet();
        StyleConstants.setForeground(token_attribute, Color.blue);
        StyleConstants.setForeground(text_attribute, Color.black);
        StyleConstants.setForeground(plain_attribute, Color.black);
        int pointer = 0;
        if (useXML && content != null) {
            StringTokenizer data_As_tokens = new StringTokenizer(content, "<>", true);
            while (data_As_tokens.hasMoreTokens()) {
                String next_item = data_As_tokens.nextToken();
                if (next_item.equals("<") && data_As_tokens.hasMoreTokens()) {
                    String current_token = String.valueOf(next_item) + data_As_tokens.nextToken() + data_As_tokens.nextToken();
                    doc.insertString(pointer, current_token, token_attribute);
                    pointer += current_token.length();
                    continue;
                }
                doc.insertString(pointer, next_item, text_attribute);
                pointer += next_item.length();
            }
        } else {
            doc.insertString(pointer, content, plain_attribute);
        }
        JScrollPane text_scroll = new JScrollPane();
        text_scroll.getViewport().add(text_pane);
        text_scroll.setHorizontalScrollBarPolicy(31);
        text_scroll.setVerticalScrollBarPolicy(20);
        return text_scroll;
    }

    public int getSelectedComboIndex(int ID) {
        switch (ID) {
            case 252: {
                return this.scalingBox.getSelectedIndex();
            }
            case 251: {
                return this.rotationBox.getSelectedIndex();
            }
        }
        return -1;
    }

    public void setSelectedComboIndex(int ID, int index) {
        switch (ID) {
            case 252: {
                this.scalingBox.setSelectedIndex(index);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedIndex(index);
            }
        }
    }

    public void setSelectedComboItem(int ID, String index) {
        switch (ID) {
            case 252: {
                this.scalingBox.setSelectedItem(index);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedItem(index);
            }
        }
    }

    public Object getSelectedComboItem(int ID) {
        switch (ID) {
            case 252: {
                return this.scalingBox.getSelectedItem();
            }
            case 251: {
                return this.rotationBox.getSelectedItem();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void zoom(boolean Rotated) {
        width = this.scrollPane.getViewport().getWidth() - 25 - 25;
        height = this.scrollPane.getViewport().getHeight() - 25 - 25;
        if (this.decode_pdf != null) {
            index = this.getSelectedComboIndex(252);
            if (index == -1) {
                numberValue = (String)this.getSelectedComboItem(252);
                zoom = -1.0f;
                if (numberValue != null && numberValue.length() > 0) {
                    block24: {
                        try {
                            zoom = Float.parseFloat(numberValue);
                            break block24;
                        }
                        catch (Exception e) {
                            zoom = -1.0f;
                            length = numberValue.length();
                            ii = 0;
                            ** while (ii < length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            c = numberValue.charAt(ii);
                            if (!((c >= '0' && c <= '9') | c == '.')) break;
                            ++ii;
                            continue;
                        }
lbl21:
                        // 2 sources

                        if (ii > 0) {
                            numberValue = numberValue.substring(0, ii);
                        }
                        if (zoom == -1.0f) {
                            try {
                                zoom = Float.parseFloat(numberValue);
                            }
                            catch (Exception e1) {
                                zoom = -1.0f;
                            }
                        }
                    }
                    if (zoom > 1000.0f) {
                        zoom = 1000.0f;
                    }
                }
                if (zoom == -1.0f) {
                    index = 0;
                    this.setSelectedComboIndex(252, index);
                } else {
                    this.scaling = this.convertToCorrectedScaling(zoom / 100.0f);
                    this.setSelectedComboItem(252, String.valueOf(zoom));
                }
            }
            if (index != -1) {
                if (index < 3) {
                    pageData = this.decode_pdf.getPdfPageData();
                    raw_rotation = pageData.getRotation(this.commonValues.getCurrentPage());
                    if (this.rotation == 90 || this.rotation == 270) {
                        cw = pageData.getCropBoxHeight(this.commonValues.getCurrentPage());
                        ch = pageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                    } else {
                        cw = pageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                        ch = pageData.getCropBoxHeight(this.commonValues.getCurrentPage());
                    }
                    if (this.displayPane != null) {
                        width -= (float)this.displayPane.getDividerSize();
                    }
                    x_factor = 0.0f;
                    y_factor = 0.0f;
                    x_factor = width / (float)cw;
                    y_factor = height / (float)ch;
                    if (index == 0) {
                        this.scaling = x_factor < y_factor ? x_factor : y_factor;
                    } else if (index == 1) {
                        this.scaling = y_factor;
                    } else if (index == 2) {
                        this.scaling = x_factor;
                    }
                } else {
                    this.scaling = this.convertToCorrectedScaling(this.scalingFloatValues[index]);
                }
            }
            this.decode_pdf.setPageParameters(this.scaling, this.commonValues.getCurrentPage(), this.rotation);
            updateAComponent = new Runnable(){

                public void run() {
                    SwingGUI.this.decode_pdf.invalidate();
                    SwingGUI.this.decode_pdf.updateUI();
                    SwingGUI.this.decode_pdf.validate();
                    SwingGUI.this.scrollPane.invalidate();
                    SwingGUI.this.scrollPane.updateUI();
                    SwingGUI.this.scrollPane.validate();
                    if (SwingGUI.this.commonValues.isPDF()) {
                        SwingGUI.this.scrollToPage(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
            };
            SwingUtilities.invokeLater(updateAComponent);
        }
    }

    private float convertToCorrectedScaling2(float rawScaling) {
        if (PdfDecoder.isRunningOnWindows) {
            return rawScaling * 1.533f;
        }
        return rawScaling;
    }

    public void rotate() {
        this.rotation = Integer.parseInt((String)this.getSelectedComboItem(251));
        this.zoom(true);
        this.decode_pdf.updateUI();
    }

    public void scrollToPage(int page) {
        this.commonValues.setCurrentPage(page);
        if (this.commonValues.getCurrentPage() > 0) {
            int yCord = 0;
            int xCord = 0;
            if (this.decode_pdf.getDisplayView() != 1) {
                yCord = this.decode_pdf.getYCordForPage(this.commonValues.getCurrentPage(), this.scaling);
                xCord = this.decode_pdf.getXDisplacement();
            }
            PdfPageData pageData = this.decode_pdf.getPdfPageData();
            int ch = (int)((float)pageData.getCropBoxHeight(this.commonValues.getCurrentPage()) * this.scaling);
            int cw = (int)((float)pageData.getCropBoxWidth(this.commonValues.getCurrentPage()) * this.scaling);
            int centerH = xCord + (cw - this.scrollPane.getHorizontalScrollBar().getVisibleAmount()) / 2;
            int centerV = yCord + (ch - this.scrollPane.getVerticalScrollBar().getVisibleAmount()) / 2;
            this.scrollPane.getHorizontalScrollBar().setValue(centerH);
            this.scrollPane.getVerticalScrollBar().setValue(centerV);
        }
    }

    public void decodePage(boolean resizePanel) {
        if (this.decode_pdf.getHighlightImage() != null) {
            this.commonValues.toggleExtractImageOnSelection();
            this.toggleSnapshotButton();
        }
        this.decode_pdf.setHighlightedImage(null);
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.setupThumbnailPanel();
        }
        if (this.decode_pdf.getDisplayView() == 1) {
            this.pageCounter2.setForeground(Color.black);
            this.pageCounter2.setText(" " + this.commonValues.getCurrentPage());
            this.pageCounter3.setText(String.valueOf(Messages.getMessage("PdfViewerOfLabel.text")) + ' ' + this.commonValues.getPageCount());
        }
        this.tabsNotInitialised = false;
        boolean isContentExtractor = this.commonValues.isContentExtractor();
        this.decode_pdf.unsetScaling();
        if (isContentExtractor) {
            this.decode_pdf.setExtractionMode(1);
        } else {
            this.decode_pdf.setExtractionMode(65);
        }
        this.decode_pdf.setFoundTextArea(null);
        this.decode_pdf.setFoundTextAreas(null);
        this.decode_pdf.setHighlightedAreas(null);
        this.setRectangle(null);
        if (this.decode_pdf.getDisplayView() == 3) {
            this.zoom(false);
            this.scrollToPage(this.commonValues.getCurrentPage());
            this.decode_pdf.decodeOtherPages(this.commonValues.getPageCount());
            return;
        }
        if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4) {
            this.zoom(false);
            this.scrollToPage(this.commonValues.getCurrentPage());
            return;
        }
        this.resetComboBoxes(false);
        if (!this.commonValues.isContentExtractor()) {
            this.commonValues.setProcessing(true);
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    String status;
                    SwingGUI.this.statusBar.updateStatus("Decoding Page", 0);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    try {
                        SwingGUI.this.decode_pdf.decodePage(SwingGUI.this.commonValues.getCurrentPage());
                        if (!SwingGUI.this.decode_pdf.hasAllImages()) {
                            status = String.valueOf(Messages.getMessage("PdfViewer.ImageDisplayError")) + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                            SwingGUI.this.showMessageDialog(status);
                        }
                        PdfPageData page_data = SwingGUI.this.decode_pdf.getPdfPageData();
                        SwingGUI.this.mediaW = page_data.getMediaBoxWidth(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaH = page_data.getMediaBoxHeight(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaX = page_data.getMediaBoxX(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaY = page_data.getMediaBoxY(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropX = page_data.getCropBoxX(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropY = page_data.getCropBoxY(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropW = page_data.getCropBoxWidth(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropH = page_data.getCropBoxHeight(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.resetRotationBox();
                        SwingGUI.this.commonValues.setPageAnnotations(SwingGUI.this.decode_pdf.getPdfAnnotsData(null));
                        if (!SwingGUI.this.decode_pdf.showAnnotations) {
                            SwingGUI.this.createUniqueAnnotationIcons();
                        }
                        SwingGUI.this.statusBar.updateStatus("Displaying Page", 0);
                    }
                    catch (Exception e) {
                        System.err.println(String.valueOf(Messages.getMessage("PdfViewerError.Exception")) + ' ' + e + ' ' + Messages.getMessage("PdfViewerError.DecodePage"));
                        e.printStackTrace();
                        SwingGUI.this.commonValues.setProcessing(false);
                    }
                    status = SwingGUI.this.decode_pdf.getPageDecodeReport();
                    if (status.indexOf("java.lang.OutOfMemoryError") != -1 && PdfDecoder.showErrorMessages) {
                        status = String.valueOf(Messages.getMessage("PdfViewer.OutOfMemoryDisplayError")) + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError1") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError2") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError3") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError4") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError5");
                        SwingGUI.this.showMessageDialog(status);
                    }
                    if (SwingGUI.this.decode_pdf.getPageDecodeReport().indexOf("JBIG") != -1) {
                        status = "This File Contains a JBIG image. \n\nSupport for JBIG images is currently in development";
                        SwingGUI.this.showMessageDialog(status);
                    }
                    if (ColorspaceDecoder.unsupportPatterns) {
                        ColorspaceDecoder.unsupportPatterns = false;
                        status = "Pattern Colourspace are not supported in GPL version and will appear as black";
                        SwingGUI.this.showMessageDialog(status);
                    }
                    if (SwingGUI.this.thumbnails != null && SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.addDisplayedPageAsThumbnail(SwingGUI.this.commonValues.getCurrentPage(), null);
                    }
                    SwingGUI.this.commonValues.setProcessing(false);
                    SwingGUI.this.setViewerTitle(null);
                    if (SwingGUI.this.thumbnails.isShownOnscreen() && SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.generateOtherVisibleThumbnails(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
                catch (Exception e) {
                    SwingGUI.this.setViewerTitle(null);
                }
                SwingGUI.this.selectBookmark();
                SwingGUI.this.statusBar.setProgress(100);
                SwingGUI.this.resetComboBoxes(true);
                SwingGUI.this.addFormsListeners();
                SwingGUI.this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
                SwingGUI.this.decode_pdf.disableBorderForPrinting();
                SwingGUI.this.zoom(false);
                SwingGUI.this.reinitialiseTabs();
                SwingGUI.this.finishedDecoding = true;
                SwingGUI.this.zoom(false);
                return null;
            }
        };
        worker.start();
    }

    public void addFormsListeners() {
        AcroRenderer formRenderer;
        this.commonValues.setFormsChanged(false);
        boolean showMessage = false;
        String formsFlag = System.getProperty("listenForms");
        if (formsFlag != null) {
            showMessage = true;
        }
        if ((formRenderer = this.decode_pdf.getCurrentFormRenderer()) == null) {
            return;
        }
        List formsOnPage = null;
        try {
            formsOnPage = formRenderer.getComponentNameList(this.commonValues.getCurrentPage());
        }
        catch (PdfException e) {
            LogWriter.writeLog("Exception " + e + " reading component list");
        }
        if (formsOnPage == null) {
            if (showMessage) {
                this.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
            }
            return;
        }
        int formCount = formsOnPage.size();
        JPanel formPanel = new JPanel();
        if (showMessage) {
            formPanel.setLayout(new BoxLayout(formPanel, 1));
            JLabel formHeader = new JLabel("This page contains " + formCount + " form objects");
            formHeader.setFont(this.headFont);
            formPanel.add(formHeader);
            formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            JTextPane instructions = new JTextPane();
            instructions.setPreferredSize(new Dimension(450, 180));
            instructions.setEditable(false);
            instructions.setText("This provides a simple example of Forms handling. We have added a listener to each form so clicking on it shows the form name.\n\nCode is in addExampleListeners() in org.examples.simpleviewer.SimpleViewer\n\nThis could be easily be extended to interface with a database directly or collect results on an action and write back using itext.\n\nForms have been converted into Swing components and are directly accessible (as is the original data).\n\nIf you don't like the standard SwingSet you can replace with your own set.");
            instructions.setFont(this.textFont);
            formPanel.add(instructions);
            formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        int i = 0;
        while (i < formCount) {
            String formName = (String)formsOnPage.get(i);
            Component[] comp = (Component[])formRenderer.getComponentsByName(formName);
            Integer pageKey = new Integer(i);
            if (comp != null && this.pagesDecoded.get(pageKey) == null) {
                this.pagesDecoded.put(pageKey, "x");
                int count = comp.length;
                int index = 0;
                while (index < count) {
                    if (showMessage && index == 0) {
                        JLabel type = new JLabel();
                        JLabel label = new JLabel("Form name=" + formName);
                        String labelS = "type=" + comp[index].getClass();
                        if (count > 1) {
                            labelS = "Group of " + count + " Objects, type=" + comp[index].getClass();
                            type.setForeground(Color.red);
                        }
                        type.setText(labelS);
                        label.setFont(this.headFont);
                        type.setFont(this.textFont);
                        formPanel.add(label);
                        formPanel.add(type);
                        formPanel.add(new JLabel(" "));
                    }
                    FormActionListener changeList = new FormActionListener(String.valueOf(formName) + index, this.frame, showMessage);
                    if (comp[index] instanceof JComboBox) {
                        ((JComboBox)comp[index]).addActionListener(changeList);
                    } else if (comp[index] instanceof JCheckBox) {
                        ((JCheckBox)comp[index]).addActionListener(changeList);
                    } else if (comp[index] instanceof JRadioButton) {
                        ((JRadioButton)comp[index]).addActionListener(changeList);
                    } else if (comp[index] instanceof JTextField) {
                        ((JTextField)comp[index]).addActionListener(changeList);
                    }
                    ++index;
                }
            }
            ++i;
        }
        if (showMessage) {
            final JDialog displayFrame = new JDialog((Frame)this.frame, true);
            if (this.commonValues.getModeOfOperation() != 1) {
                displayFrame.setLocationRelativeTo(null);
                displayFrame.setLocation(this.frame.getLocationOnScreen().x + 10, this.frame.getLocationOnScreen().y + 10);
            }
            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().add(formPanel);
            scroll.setHorizontalScrollBarPolicy(30);
            scroll.setVerticalScrollBarPolicy(20);
            displayFrame.setSize(500, 500);
            displayFrame.setTitle("List of forms on this page");
            displayFrame.getContentPane().setLayout(new BorderLayout());
            displayFrame.getContentPane().add((Component)scroll, "Center");
            JPanel buttonBar = new JPanel();
            buttonBar.setLayout(new BorderLayout());
            displayFrame.getContentPane().add((Component)buttonBar, "South");
            JButton no = new JButton(Messages.getMessage("PdfViewerButton.Close"));
            no.setFont(new Font("SansSerif", 0, 12));
            buttonBar.add((Component)no, "East");
            no.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    displayFrame.dispose();
                }
            });
            displayFrame.setVisible(true);
        }
    }

    private void createOutlinePanels() {
        this.setupThumbnailPanel();
        this.setBookmarks(false);
    }

    private void setupThumbnailPanel() {
        this.decode_pdf.addExternalHandler(this.thumbnails, 8);
        if (this.isSetup) {
            return;
        }
        this.isSetup = true;
        if (!this.commonValues.isContentExtractor() && this.thumbnails.isShownOnscreen()) {
            int pages = this.decode_pdf.getPageCount();
            this.thumbnails.setupThumbnails(pages, this.textFont, Messages.getMessage("PdfViewerPageLabel.text"), this.decode_pdf.getPdfPageData());
            Object[] buttons = this.thumbnails.getButtons();
            int i = 0;
            while (i < pages) {
                ((JButton)buttons[i]).addActionListener(new PageChanger(i));
                ++i;
            }
            this.thumbnails.addComponentListener();
        }
    }

    public void setBookmarks(boolean alwaysGenerate) {
        int currentSize = this.displayPane.getDividerLocation();
        if (currentSize == 30 && !alwaysGenerate) {
            return;
        }
        boolean hasNavBars = true;
        org.w3c.dom.Document doc = this.decode_pdf.getOutlineAsXML();
        Node rootNode = null;
        if (doc != null) {
            rootNode = doc.getFirstChild();
        }
        if (rootNode != null) {
            this.tree.reset(rootNode);
            ((JTree)this.tree.getTree()).addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    if (SwingGUI.this.tree.isIgnoreAlteredBookmark()) {
                        return;
                    }
                    DefaultMutableTreeNode node = SwingGUI.this.tree.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    Object nodeInfo = node.getUserObject();
                    String title = (String)node.getUserObject();
                    String page = SwingGUI.this.tree.getPage(title);
                    if (page != null && page.length() > 0) {
                        Point p;
                        int pageToDisplay = Integer.parseInt(page);
                        if (!SwingGUI.this.commonValues.isProcessing() && SwingGUI.this.commonValues.getCurrentPage() != pageToDisplay) {
                            SwingGUI.this.commonValues.setCurrentPage(pageToDisplay);
                            SwingGUI.this.setScalingToDefault();
                            SwingGUI.this.decode_pdf.setPageParameters(SwingGUI.this.getScaling(), SwingGUI.this.commonValues.getCurrentPage());
                            SwingGUI.this.decodePage(false);
                        }
                        if ((p = SwingGUI.this.tree.getPoint(title)) != null) {
                            SwingGUI.this.decode_pdf.ensurePointIsVisible(p);
                        }
                    } else {
                        SwingGUI.this.showMessageDialog(String.valueOf(Messages.getMessage("PdfViewerError.NoBookmarkLink")) + title);
                        System.out.println("No dest page set for " + title);
                    }
                }
            });
        } else {
            hasNavBars = false;
            this.tree.reset(null);
        }
    }

    private void selectBookmark() {
        if (this.decode_pdf.hasOutline() && this.tree != null) {
            this.tree.selectBookmark();
        }
    }

    public void initStatus() {
        this.decode_pdf.setStatusBarObject(this.statusBar);
        this.resetStatus();
    }

    public void resetStatus() {
        this.statusBar.setColorForSubroutines(Color.blue);
        this.bottomNavButtons.add(this.statusBar.getStatusObject());
    }

    public void initThumbnails(int itemSelectedCount, Vector_Int pageUsed) {
        this.navOptionsPanel.removeAll();
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.setupThumbnails(itemSelectedCount - 1, pageUsed.get(), this.commonValues.getPageCount());
        }
        if (PdfDecoder.isRunningOnMac) {
            this.navOptionsPanel.add((Component)((Object)this.thumbnails), "Extracted items");
        } else {
            VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, "Extracted items", 2);
            this.navOptionsPanel.addTab(null, textIcon2, (Component)((Object)this.thumbnails));
        }
        this.displayPane.setDividerLocation(150);
    }

    public void setCoordText(String string) {
        this.coords.setText(string);
    }

    private JLabel initCoordBox() {
        this.coords.setBackground(Color.white);
        this.coords.setOpaque(true);
        this.coords.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.coords.setText("  X:  Y:   ");
        this.coords.setPreferredSize(new Dimension(90, 20));
        return this.coords;
    }

    public void toggleSnapshotButton() {
        if (!this.commonValues.isExtractImageOnSelection()) {
            this.snapshotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/snapshotX.gif")));
        } else {
            this.snapshotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/snapshot.gif")));
        }
    }

    public void setPageNumber() {
        this.pageCounter2.setForeground(Color.black);
        this.pageCounter2.setText(" " + this.commonValues.getCurrentPage());
        this.pageCounter3.setText(String.valueOf(Messages.getMessage("PdfViewerOfLabel.text")) + ' ' + this.commonValues.getPageCount());
    }

    private void createNavbar() {
        this.comboBar.add(Box.createHorizontalGlue());
        JLabel pageCounter1 = new JLabel(Messages.getMessage("PdfViewerPageLabel.text"));
        pageCounter1.setOpaque(false);
        this.navToolBar.add(Box.createHorizontalGlue());
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.RewindToStart"), "/org/jpedal/examples/simpleviewer/res/start.gif", 50);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind10"), "/org/jpedal/examples/simpleviewer/res/fback.gif", 51);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind1"), "/org/jpedal/examples/simpleviewer/res/back.gif", 52);
        this.navToolBar.add(pageCounter1);
        this.pageCounter2.setMaximumSize(new Dimension(5, 50));
        this.navToolBar.add(this.pageCounter2);
        this.navToolBar.add(this.pageCounter3);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward1"), "/org/jpedal/examples/simpleviewer/res/forward.gif", 53);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward10"), "/org/jpedal/examples/simpleviewer/res/fforward.gif", 54);
        this.addButton(1, Messages.getMessage("PdfViewerNavBar.ForwardLast"), "/org/jpedal/examples/simpleviewer/res/end.gif", 55);
        this.navToolBar.add(Box.createHorizontalGlue());
        this.comboBar.add((Component)this.navToolBar, "Center");
        this.comboBar.add((Component)this.pagesToolBar, "East");
        Dimension size = this.pagesToolBar.getPreferredSize();
        final JProgressBar pb = new JProgressBar();
        pb.setPreferredSize(size);
        Timer memoryMonitor = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int free = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
                int total = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                if (SwingGUI.this.finishedDecoding) {
                    SwingGUI.this.finishedDecoding = false;
                }
                pb.setMaximum(total);
                pb.setValue(total - free);
                pb.setStringPainted(true);
                pb.setString(String.valueOf(total - free) + "M of " + total + 'M');
            }
        });
        memoryMonitor.start();
        Box.Filler filler = new Box.Filler(size, size, size);
        this.comboBar.add((Component)pb, "West");
    }

    public void setPage(int page) {
        this.commonValues.setCurrentPage(page);
        this.pageCounter2.setText(String.valueOf(page));
        this.setThumbnails();
    }

    public void setRotation() {
        PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
        this.rotation = currentPageData.getRotation(this.commonValues.getCurrentPage());
        System.out.println("rotation ==" + this.rotation + '<');
        this.rotation += this.getSelectedComboIndex(251) * 90;
        System.out.println("rotation ==" + this.rotation + '<');
        if (this.rotation > 360) {
            this.rotation -= 360;
        }
        System.out.println("rotation ==" + this.rotation + '<');
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!this.commonValues.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    public void addToMainMenu(JMenu fileMenuList) {
        this.currentMenu.add(fileMenuList);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JToolBar getTopButtonBar() {
        return this.topButtons;
    }

    public void showMessageDialog(Object message1) {
        JOptionPane.showMessageDialog(this.frame, message1);
    }

    public void showMessageDialog(Object message, String title, int type) {
        JOptionPane.showMessageDialog(this.frame, message, title, type);
    }

    public String showInputDialog(Object message, String title, int type) {
        return JOptionPane.showInputDialog(this.frame, message, title, type);
    }

    public String showInputDialog(String message) {
        return JOptionPane.showInputDialog(this.frame, (Object)message);
    }

    public int showOptionDialog(Object displayValue, String message, int option, int type, Object icon, Object[] options, Object initial) {
        return JOptionPane.showOptionDialog(this.frame, displayValue, message, option, type, (Icon)icon, options, initial);
    }

    public int showConfirmDialog(String message, String message2, int option) {
        return JOptionPane.showConfirmDialog(this.frame, message, message2, option);
    }

    public int showOverwriteDialog(String file, boolean yesToAllPresent) {
        int n = -1;
        if (yesToAllPresent) {
            Object[] buttonRowObjects = new Object[]{Messages.getMessage("PdfViewerConfirmButton.Yes"), Messages.getMessage("PdfViewerConfirmButton.YesToAll"), Messages.getMessage("PdfViewerConfirmButton.No"), Messages.getMessage("PdfViewerConfirmButton.Cancel")};
            n = JOptionPane.showOptionDialog(this.frame, String.valueOf(file) + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, null, buttonRowObjects, buttonRowObjects[0]);
        } else {
            n = JOptionPane.showOptionDialog(this.frame, String.valueOf(file) + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), 0, 3, null, null, null);
        }
        return n;
    }

    public void showMessageDialog(JTextArea info) {
        JOptionPane.showMessageDialog(this.frame, info);
    }

    public void showItextPopup() {
        JEditorPane p = new JEditorPane("text/html", "Itext is not on the classpath.<BR>JPedal includes code to take advantage of itext and<BR>provide additional functionality with options<BR>to spilt pdf files, and resave forms data<BR>\nItext website - <a href=http://www.lowagie.com/iText/>http://www.lowagie.com/iText/</a>");
        p.setEditable(false);
        p.setOpaque(false);
        p.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        BrowserLauncher.openURL("http://www.lowagie.com/iText/");
                    }
                    catch (IOException e1) {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            }
        });
        this.showMessageDialog(p);
    }

    public void showFirstTimePopup() {
        try {
            final JPanel a = new JPanel();
            a.setLayout(new BorderLayout());
            JLabel lab = new JLabel(new ImageIcon(this.getClass().getResource("/org/jpedal/objects/acroforms/ceo.jpg")));
            a.add((Component)lab, "North");
            final JLabel message = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
            message.setHorizontalAlignment(0);
            message.setForeground(Color.blue);
            message.setFont(new Font("Lucida", 0, 16));
            message.addMouseListener(new MouseListener(){

                public void mouseEntered(MouseEvent e) {
                    a.setCursor(new Cursor(12));
                    message.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress") + "</a></center>");
                }

                public void mouseExited(MouseEvent e) {
                    a.setCursor(new Cursor(0));
                    message.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text") + Messages.getMessage("PdfViewer.WebAddress"));
                }

                public void mouseClicked(MouseEvent e) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                    }
                    catch (IOException e1) {
                        SwingGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
            a.add((Component)message, "Center");
            a.setPreferredSize(new Dimension(300, 240));
            Object[] options = new Object[]{Messages.getMessage("PdfViewerButton.RunSoftware")};
            int n = JOptionPane.showOptionDialog(this.frame, a, Messages.getMessage("PdfViewerTitle.RunningFirstTime"), -1, -1, null, options, options[0]);
        }
        catch (Exception e) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error"));
        }
        catch (Error e) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error"));
        }
    }

    public void showConfirmDialog(Object label, String message, int option, int plain_message) {
        JOptionPane.showConfirmDialog(this.frame, label, message, option, plain_message);
    }

    public void updateStatusMessage(String message) {
        this.statusBar.updateStatus(message, 0);
    }

    public void resetStatusMessage(String message) {
        this.statusBar.resetStatus(message);
    }

    public void setStatusProgress(int size) {
        this.statusBar.setProgress(size);
    }

    public boolean isPDFOutlineVisible() {
        return this.navOptionsPanel.isVisible();
    }

    public void setPDFOutlineVisible(boolean visible) {
        this.navOptionsPanel.setVisible(visible);
    }

    public void setSplitDividerLocation(int size) {
        this.displayPane.setDividerLocation(size);
    }

    public void setQualityBoxVisible(boolean visible) {
    }

    private void setThumbnails() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                if (SwingGUI.this.thumbnails.isShownOnscreen()) {
                    SwingGUI.this.setupThumbnailPanel();
                    if (SwingGUI.this.decode_pdf.getDisplayView() == 1) {
                        SwingGUI.this.thumbnails.generateOtherVisibleThumbnails(SwingGUI.this.commonValues.getCurrentPage());
                    }
                }
                return null;
            }
        };
        worker.start();
    }

    public void setSearchText(JTextField searchText) {
        this.searchText = searchText;
    }

    public void setResults(SearchList results) {
        this.results = results;
    }

    public SearchList getResults() {
        return this.results;
    }

    public JToolBar getComboBar() {
        return this.comboBar;
    }

    public ButtonGroup getSearchLayoutGroup() {
        return this.searchLayoutGroup;
    }

    public void setSearchFrame(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
    }

    class FormActionListener
    implements ActionListener {
        private Container c;
        private String formName;
        boolean showMessage;

        public FormActionListener(String formName, Container c, boolean showMessage) {
            this.c = c;
            this.formName = formName;
            this.showMessage = showMessage;
        }

        public void actionPerformed(ActionEvent arg0) {
            Object comp = arg0.getSource();
            Object value = null;
            if (comp instanceof JComboBox) {
                value = ((JComboBox)comp).getSelectedItem();
            } else if (comp instanceof JCheckBox) {
                value = String.valueOf(((JCheckBox)comp).isSelected());
            } else if (comp instanceof JRadioButton) {
                value = String.valueOf(((JRadioButton)comp).isSelected());
            } else if (comp instanceof JTextField) {
                value = ((JTextField)comp).getText();
            }
            boolean showSaveFormsMessage = SwingGUI.this.properties.getValue("showsaveformsmessage").equals("true");
            if (showSaveFormsMessage && SwingGUI.this.firstTimeFormMessage && !SwingGUI.this.commonValues.isFormsChanged()) {
                SwingGUI.this.firstTimeFormMessage = false;
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                GridBagConstraints p = new GridBagConstraints();
                p.anchor = 17;
                p.gridx = 0;
                p.gridy = 0;
                String str = Messages.getMessage("PdfViewerFormsWarning.ChangedFormsValue");
                if (!SwingGUI.this.commonValues.isItextOnClasspath()) {
                    str = Messages.getMessage("PdfViewerFormsWarning.ChangedFormsValueNoItext");
                }
                JCheckBox cb = new JCheckBox();
                cb.setText(Messages.getMessage("PdfViewerFormsWarning.CheckBox"));
                Font font = cb.getFont();
                JTextArea ta = new JTextArea(str);
                ta.setOpaque(false);
                ta.setFont(font);
                p.ipady = 20;
                panel.add((Component)ta, p);
                p.ipady = 0;
                p.gridy = 1;
                panel.add((Component)cb, p);
                JOptionPane.showMessageDialog(this.c, panel);
                if (cb.isSelected()) {
                    SwingGUI.this.properties.setValue("showsaveformsmessage", "false");
                }
            }
            SwingGUI.this.commonValues.setFormsChanged(true);
            SwingGUI.this.setViewerTitle(null);
            if (this.showMessage) {
                JOptionPane.showMessageDialog(this.c, "FormName >>" + this.formName + "<<. Value changed to " + value);
            }
        }
    }

    private class PageChanger
    implements ActionListener {
        int page;

        public PageChanger(int i) {
            this.page = ++i;
        }

        public void actionPerformed(ActionEvent e) {
            if (!SwingGUI.this.commonValues.isProcessing() && SwingGUI.this.commonValues.getCurrentPage() != this.page) {
                SwingGUI.this.commonValues.setCurrentPage(this.page);
                SwingGUI.this.statusBar.resetStatus("");
                SwingGUI.this.decodePage(false);
            }
        }
    }
}

