/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.util.Stack;
import java.util.StringTokenizer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;

public class RecentDocuments {
    int noOfRecentDocs;
    PropertiesFile properties;
    private Stack previousFiles = new Stack();
    private Stack nextFiles = new Stack();

    public RecentDocuments(int noOfRecentDocs, PropertiesFile properties) {
        this.noOfRecentDocs = noOfRecentDocs;
        this.properties = properties;
    }

    String getShortenedFileName(String fileNameToAdd) {
        int maxChars = 30;
        if (fileNameToAdd.length() <= 30) {
            return fileNameToAdd;
        }
        StringTokenizer st = new StringTokenizer(fileNameToAdd, "\\/");
        int noOfTokens = st.countTokens();
        String[] arrayedFile = new String[noOfTokens];
        int i = 0;
        while (i < noOfTokens) {
            arrayedFile[i] = st.nextToken();
            ++i;
        }
        String filePathBody = fileNameToAdd.substring(arrayedFile[0].length(), fileNameToAdd.length() - arrayedFile[noOfTokens - 1].length());
        StringBuffer sb = new StringBuffer(filePathBody);
        int i2 = noOfTokens - 2;
        while (i2 > 0) {
            int start = sb.lastIndexOf(arrayedFile[i2]);
            int end = start + arrayedFile[i2].length();
            sb.replace(start, end, "...");
            if (sb.toString().length() <= 30) break;
            --i2;
        }
        return String.valueOf(arrayedFile[0]) + sb + arrayedFile[noOfTokens - 1];
    }

    public String getPreviousDocument() {
        String fileToOpen = null;
        if (this.previousFiles.size() > 1) {
            this.nextFiles.push(this.previousFiles.pop());
            fileToOpen = (String)this.previousFiles.pop();
        }
        return fileToOpen;
    }

    public String getNextDocument() {
        String fileToOpen = null;
        if (!this.nextFiles.isEmpty()) {
            fileToOpen = (String)this.nextFiles.pop();
        }
        return fileToOpen;
    }

    public void addToFileList(String selectedFile) {
        this.previousFiles.push(selectedFile);
    }
}

