/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.printing;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.LogWriter;

public class SilentPrint {
    private static boolean debugCode = false;
    private final String separator = System.getProperty("file.separator");
    private PdfDecoder decode_pdf = null;
    private int maxCopies = 5;
    private int copiesToPrint = 1;
    private int pageCount;
    private static String printer = "FinePrint";
    private String tray = null;
    public static boolean customSetting = false;
    public static int pageMark = 1;

    public SilentPrint() {
    }

    public SilentPrint(String file_name) {
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodeAndPrintFile(file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = String.valueOf(file_name) + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    SilentPrint.logMessage(String.valueOf(file_name) + files[i]);
                    this.decodeAndPrintFile(String.valueOf(file_name) + files[i]);
                }
                ++i;
            }
        }
    }

    private void decodeAndPrintFile(String file_name) {
        try {
            SilentPrint.logMessage("Opening file :" + file_name + " to print.");
            this.decode_pdf = new PdfDecoder(true);
            this.decode_pdf.openPdfFile(file_name);
            this.pageCount = this.decode_pdf.getPageCount();
        }
        catch (Exception e) {
            SilentPrint.reportError("Exception " + e + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isExtractionAllowed()) {
            SilentPrint.logMessage("Encrypted settings");
        } else {
            this.printAllCopies();
        }
        this.decode_pdf.closePdfFile();
    }

    private final void printAllCopies() {
        int currentCopy = 0;
        while (currentCopy < this.copiesToPrint) {
            SilentPrint.logMessage("========================");
            SilentPrint.logMessage("\nPrinting copy " + (currentCopy + 1));
            SilentPrint.logMessage("========================");
            this.printPages();
            ++currentCopy;
        }
    }

    private void printPages() {
        try {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            PageFormat pf = printJob.defaultPage();
            HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
            PrintService[] service = PrinterJob.lookupPrintServices();
            boolean matchFound = SilentPrint.validatePrinter(printer);
            if (matchFound) {
                if (this.tray != null) {
                    boolean hasTrayValues = printJob.getPrintService().isAttributeCategorySupported(Media.class);
                    if (hasTrayValues) {
                        Hashtable<String, Object> possibleValues = new Hashtable<String, Object>();
                        Class<Media> category = Media.class;
                        Object o = printJob.getPrintService().getSupportedAttributeValues(category, null, null);
                        if (o == null) {
                            SilentPrint.logMessage("Attribute " + category + " not supported");
                        } else if (o.getClass().isArray()) {
                            int i = 0;
                            while (i < Array.getLength(o)) {
                                Object v = Array.get(o, i);
                                possibleValues.put(v.toString(), v);
                                SilentPrint.logMessage("Atribute values " + v.toString());
                                ++i;
                            }
                        }
                        Object trayValue = possibleValues.get(this.tray);
                        if (trayValue != null) {
                            attributeSet.add((Attribute)trayValue);
                        }
                    } else {
                        SilentPrint.logMessage("Tray " + this.tray + " not implemented");
                        SilentPrint.logMessage("Atributes implemented are ");
                        Class<?>[] c = printJob.getPrintService().getSupportedAttributeCategories();
                        int j = 0;
                        while (j < c.length) {
                            SilentPrint.logMessage(">>" + c[j].getName());
                            ++j;
                        }
                    }
                }
                if (debugCode) {
                    Attribute[] attribs = attributeSet.toArray();
                    int count1 = attribs.length;
                    int i = 0;
                    while (i < count1) {
                        SilentPrint.logMessage(String.valueOf(i) + " " + attribs[i].getName() + ' ' + attribs[i].toString());
                        ++i;
                    }
                }
                Paper paper = new Paper();
                paper.setSize(595.0, 842.0);
                paper.setImageableArea(0.0, 0.0, 595.0, 842.0);
                pf.setPaper(paper);
                printJob.setCopies(1);
                this.decode_pdf.setCenterOnScaling(true);
                this.decode_pdf.setPrintAutoRotateAndCenter(true);
                this.decode_pdf.setPageFormat(pf);
                if (customSetting) {
                    this.decode_pdf.setPagePrintRange(pageMark, pageMark);
                    System.out.println("Pagemark set to: " + pageMark);
                } else {
                    this.decode_pdf.setPagePrintRange(1, this.decode_pdf.getPageCount());
                }
                printJob.setPageable(this.decode_pdf);
                printJob.print();
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception " + ee + " printing");
        }
        catch (Error err) {
            LogWriter.writeLog("Error " + err + " printing");
        }
    }

    private static boolean validatePrinter(String newPrinter) throws PrinterException {
        boolean matchFound = false;
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PrintService[] service = PrinterJob.lookupPrintServices();
        int count = service.length;
        int i = 0;
        while (i < count) {
            if (service[i].getName().indexOf(newPrinter) != -1) {
                printJob.setPrintService(service[i]);
                i = count;
                matchFound = true;
                printer = newPrinter;
            }
            ++i;
        }
        if (!matchFound) {
            String list = "";
            int i2 = 0;
            while (i2 < count) {
                list = String.valueOf(list) + '\"' + service[i2].getName() + "\",";
                ++i2;
            }
            SilentPrint.reportError("Printer " + newPrinter + " not supported. Options=" + list);
        }
        return matchFound;
    }

    private static void logMessage(String message) {
        if (debugCode) {
            System.out.println(message);
            LogWriter.writeLog(message);
        }
    }

    private static void reportError(String message) {
        System.err.println(message);
        LogWriter.writeLog(message);
    }

    public static void main(String[] args) {
        SilentPrint.logMessage("Simple demo to print pages");
        if (args.length != 2) {
            SilentPrint.logMessage("Printing needs 2 paramters");
            SilentPrint.logMessage("Parameter 1 - File name or directory (put in quotes if it contains spaces");
            SilentPrint.logMessage("Parameter 2- a printer name");
            SilentPrint.logMessage("If the printer name is not valid a list will be supplied of valid printers");
        }
        String file_name = args[0];
        String printerName = args[1];
        SilentPrint.logMessage("File :" + file_name);
        SilentPrint.logMessage("Printer :" + printerName);
        boolean validPrinter = false;
        try {
            validPrinter = SilentPrint.validatePrinter(printerName);
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            SilentPrint.logMessage("File " + file_name + " not found");
        } else if (!validPrinter) {
            SilentPrint.logMessage("Printer " + printerName + " not found");
        } else {
            SilentPrint silentPrint = new SilentPrint(file_name);
        }
    }
}

