/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.media.jai.JAI;
import org.jpedal.PdfDecoder;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;

public class ExtractPagesAsThumbnails {
    private String user_dir = System.getProperty("user.dir");
    private int dpi = 72;
    public static boolean outputMessages = false;
    public static boolean multipleSizes = true;
    String output_dir = "";
    String separator = System.getProperty("file.separator");
    PdfDecoder decode_pdf = null;
    private static String format = "png";
    private String[] ocr = new String[]{"TeleForm"};
    private boolean useHiresImage = false;
    private static String test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
    public static boolean isTest = false;
    private static int scaling = 100;

    private ExtractPagesAsThumbnails() {
    }

    public ExtractPagesAsThumbnails(String file_name, String output_dir) {
        String hiresFlag;
        String userDpi = System.getProperty("dpi");
        if (userDpi != null) {
            try {
                this.dpi = Integer.parseInt(userDpi);
            }
            catch (Exception e) {
                System.err.println("Problem with value " + userDpi + " (must be integer)");
                System.err.println(e);
                System.exit(1);
            }
        }
        if ((hiresFlag = System.getProperty("hires")) != null) {
            this.useHiresImage = true;
        }
        this.output_dir = output_dir;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = String.valueOf(this.user_dir) + this.separator;
        }
        if (file_name.toLowerCase().endsWith(".pdf")) {
            if (!isTest) {
                output_dir = String.valueOf(this.user_dir) + "thumbnails" + this.separator;
            }
            this.decodeFile(file_name, output_dir);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = String.valueOf(file_name) + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    if (outputMessages) {
                        System.out.println(String.valueOf(file_name) + files[i]);
                    }
                    this.decodeFile(String.valueOf(file_name) + files[i], output_dir);
                }
                ++i;
            }
        }
        if (outputMessages) {
            System.out.println("Thumbnails created");
        }
    }

    private void decodeFile(String file_name, String output_dir) {
        String name = "demo";
        int pointer = file_name.lastIndexOf(this.separator);
        if (pointer == -1) {
            pointer = file_name.lastIndexOf(47);
        }
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        } else if (!isTest && file_name.toLowerCase().endsWith(".pdf")) {
            name = file_name.substring(0, file_name.length() - 4);
        }
        if (output_dir == null) {
            output_dir = String.valueOf(this.user_dir) + "thumbnails" + this.separator;
        }
        try {
            this.decode_pdf = new PdfDecoder(true);
            if (!isTest) {
                String[] aliases1 = new String[]{"helvetica", "arial"};
                this.decode_pdf.setSubstitutedFontAliases("arial", aliases1);
                String[] aliases2 = new String[]{"Helvetica-Bold"};
                this.decode_pdf.setSubstitutedFontAliases("Arial-BoldMT", aliases2);
                String[] aliases3 = new String[]{"Times-Bold", "Times-Roman"};
                this.decode_pdf.setSubstitutedFontAliases("timesbd", aliases3);
                PdfDecoder.setFontDirs(new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/System/Library/Fonts/", "/Library/Fonts/"});
            }
            this.decode_pdf.setExtractionMode(0, this.dpi, this.dpi / 72);
            if (outputMessages) {
                System.out.println("Opening file :" + file_name + " at " + this.dpi + " dpi");
            }
            this.decode_pdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
            }
        } else {
            File output_path = new File(output_dir);
            if (!output_path.exists()) {
                output_path.mkdirs();
            }
            int start = 1;
            int end = this.decode_pdf.getPageCount();
            if (end > 10 && isTest) {
                end = 10;
            }
            if (outputMessages) {
                System.out.println("Thumbnails will be in  " + output_dir);
            }
            try {
                int page = start;
                while (page < end + 1) {
                    if (outputMessages) {
                        System.out.println("Page " + page);
                    }
                    String image_name = String.valueOf(name) + '_' + this.dpi + "_page_" + page;
                    PdfFileInformation currentFileInformation = this.decode_pdf.getFileInformationData();
                    String[] values = currentFileInformation.getFieldValues();
                    String[] fields = currentFileInformation.getFieldNames();
                    int i = 0;
                    while (i < fields.length) {
                        if (fields[i].equals("Creator")) {
                            int j = 0;
                            while (j < this.ocr.length) {
                                if (values[i].equals(this.ocr[j])) {
                                    this.decode_pdf.setRenderMode(2);
                                    this.decode_pdf.setEnableLegacyJPEGConversion(true);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    BufferedImage image_to_save = this.decode_pdf.getPageAsImage(page);
                    if (image_to_save == null) {
                        if (outputMessages) {
                            System.out.println("No image generated - are you using client mode?");
                        }
                    } else {
                        String tiffFlag;
                        boolean compressTiffs;
                        String maxDimensionAsString = System.getProperty("maxDimension");
                        int maxDimension = -1;
                        if (maxDimensionAsString != null) {
                            maxDimension = Integer.parseInt(maxDimensionAsString);
                        }
                        if (scaling != 100 || maxDimension != -1) {
                            int newWidth = image_to_save.getWidth() * scaling / 100;
                            int newHeight = image_to_save.getHeight() * scaling / 100;
                            Image scaledImage = null;
                            if (maxDimension != -1 && (newWidth > maxDimension || newHeight > maxDimension)) {
                                if (newWidth > newHeight) {
                                    newWidth = maxDimension;
                                    scaledImage = image_to_save.getScaledInstance(newWidth, -1, 4);
                                } else {
                                    newHeight = maxDimension;
                                    scaledImage = image_to_save.getScaledInstance(-1, newHeight, 4);
                                }
                            } else {
                                scaledImage = image_to_save.getScaledInstance(newWidth, -1, 4);
                            }
                            image_to_save = format.toLowerCase().startsWith("jp") ? new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 1) : new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
                            Graphics2D g2 = image_to_save.createGraphics();
                            g2.drawImage(scaledImage, 0, 0, null);
                        }
                        boolean bl = compressTiffs = (tiffFlag = System.getProperty("compress_tiff")) != null;
                        if (JAIHelper.isJAIused()) {
                            JAIHelper.confirmJAIOnClasspath();
                        }
                        if (compressTiffs && JAIHelper.isJAIused()) {
                            TIFFEncodeParam params = null;
                            params = new TIFFEncodeParam();
                            params.setCompression(32946);
                            FileOutputStream os = new FileOutputStream(String.valueOf(output_dir) + page + image_name + ".tif");
                            JAI.create((String)"encode", (RenderedImage)image_to_save, (Object)os, (Object)"TIFF", (Object)params);
                        } else {
                            boolean bl2 = this.decode_pdf.getObjectStore().saveStoredImage(String.valueOf(output_dir) + page + image_name, image_to_save, true, false, format);
                        }
                    }
                    this.decode_pdf.flushObjectValues(true);
                    ++page;
                }
            }
            catch (Exception e) {
                this.decode_pdf.closePdfFile();
                System.err.println("Exception " + e.getMessage() + " with thumbnails");
            }
        }
        this.decode_pdf.closePdfFile();
    }

    public static void main(String[] args) {
        File pdf_file;
        System.out.println("Simple demo to extract images from a page");
        String file_name = test_file;
        boolean failed = false;
        int len = args.length;
        if (len == 0) {
            ExtractPagesAsThumbnails.showCommandLineValues();
        } else if (len == 1) {
            file_name = args[0];
            System.out.println("file name=" + file_name);
        } else if (len < 4) {
            file_name = args[0];
            System.out.println("File :" + file_name);
            int j = 1;
            while (j < args.length) {
                String value = args[j];
                boolean isNumber = ExtractPagesAsThumbnails.isNumber(value);
                if (isNumber) {
                    try {
                        scaling = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        System.out.println(String.valueOf(value) + " is not an integer");
                        System.exit(1);
                    }
                } else {
                    String in = value.toLowerCase();
                    if (in.equals("jpg") | in.equals("jpeg")) {
                        format = "jpg";
                    } else if (in.equals("tif") | in.equals("tiff")) {
                        format = "tif";
                    } else if (in.equals("png")) {
                        format = "png";
                    } else {
                        failed = true;
                        System.out.println("value args not recognised as valid parameter.");
                        System.out.println("please enter \"jpg\", \"jpeg\", \"tif\", \"tiff\" or \"png\".");
                    }
                }
                ++j;
            }
        } else {
            failed = true;
            System.out.println("too many arguments entered - run with no values to see defaults");
        }
        if (failed) {
            String arguments = "";
            int a = 0;
            while (a < args.length) {
                arguments = String.valueOf(arguments) + args[a] + '\n';
                ++a;
            }
            System.out.println("you entered:\n" + arguments + "as the arguments");
            ExtractPagesAsThumbnails.showCommandLineValues();
        }
        if (!(pdf_file = new File(file_name)).exists()) {
            System.out.println("File " + pdf_file + " not found");
            System.out.println("MAy need full path");
            return;
        }
        ExtractPagesAsThumbnails images1 = new ExtractPagesAsThumbnails(file_name, null);
    }

    private static void showCommandLineValues() {
        System.out.println("Example can take 1, 2 or 3 parameters");
        System.out.println("Value 1 is the file name or directory of PDF files to process");
        System.out.println("2 optional values of image type (jpeg,tiff,png) and scaling (100 = full size) can also be added");
        System.exit(1);
    }

    private static boolean isNumber(String value) {
        boolean isNumber = true;
        int charCount = value.length();
        int i = 0;
        while (i < charCount) {
            char c = value.charAt(i);
            if (c < '0' | c > '9') {
                isNumber = false;
                i = charCount;
            }
            ++i;
        }
        return isNumber;
    }

    public String getOutputDir() {
        return this.output_dir;
    }
}

