/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.PdfDecoder;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfImageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.TimeNow;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtractImages {
    private String user_dir = System.getProperty("user.dir");
    public static boolean outputMessages = true;
    PdfDecoder decode_pdf = null;
    String separator = System.getProperty("file.separator");
    private String output_dir = "";
    public static String testOutputDir = "current_images/";
    public static boolean isTest;
    private static String prefix;
    private static String test_file;

    static {
        prefix = "png";
        test_file = "/mnt/shared/Poloznicel_nalozbene_test_1.pdf";
    }

    public ExtractImages() {
    }

    public ExtractImages(String file_name) {
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = String.valueOf(this.user_dir) + this.separator;
        }
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decode(file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = String.valueOf(file_name) + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(String.valueOf(file_name) + " is not a directory. Exiting program");
                }
                files = inputFiles.list();
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                System.out.println(String.valueOf(i) + "/ " + fileCount + ' ' + files[i]);
                if (files[i].endsWith(".pdf")) {
                    System.out.println(String.valueOf(file_name) + files[i]);
                    this.decode(String.valueOf(file_name) + files[i]);
                }
                ++i;
            }
        }
    }

    private void decode(String file_name) {
        String name = "demo";
        int pointer = file_name.lastIndexOf(this.separator);
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        }
        try {
            this.decode_pdf = new PdfDecoder(false);
            String opiFlag = System.getProperty("opi");
            if (opiFlag == null) {
                this.decode_pdf.setExtractionMode(6);
            } else {
                this.decode_pdf.setExtractionMode(262);
            }
            if (outputMessages) {
                System.out.println("Opening file :" + file_name);
            }
            this.decode_pdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                System.out.println("Or get support/consultancy");
            }
        } else {
            int start = 1;
            int end = this.decode_pdf.getPageCount();
            this.output_dir = String.valueOf(this.user_dir) + "images" + this.separator + name + this.separator;
            File output_path = new File(this.output_dir);
            if (!output_path.exists()) {
                output_path.mkdirs();
            }
            if (outputMessages) {
                System.out.println("Images will be in directory " + this.output_dir);
            }
            try {
                int page = start;
                while (page < end + 1) {
                    this.decode_pdf.decodePage(page);
                    PdfImageData pdf_images = this.decode_pdf.getPdfImageData();
                    int image_count = pdf_images.getImageCount();
                    if (image_count > 0) {
                        String target;
                        File page_path;
                        if (outputMessages) {
                            System.out.println("Page " + page + " contains " + image_count + " images");
                        }
                        if (!(page_path = new File(target = String.valueOf(this.output_dir) + this.separator + page)).exists()) {
                            page_path.mkdirs();
                        }
                    }
                    int i = 0;
                    while (i < image_count) {
                        String image_name = pdf_images.getImageName(i);
                        try {
                            BufferedImage image_to_save = this.decode_pdf.getObjectStore().loadStoredImage(String.valueOf('R') + image_name);
                            String outputDir = String.valueOf(this.output_dir) + page + this.separator;
                            this.saveImage(image_to_save, String.valueOf(outputDir) + 'R' + image_name + '.' + prefix, prefix);
                            image_to_save = this.decode_pdf.getObjectStore().loadStoredImage(image_name);
                            this.saveImage(image_to_save, String.valueOf(outputDir) + image_name + '.' + prefix, prefix);
                            this.outputMetaDataToXML(file_name, page, pdf_images, i, image_name);
                        }
                        catch (Exception ee) {
                            System.err.println("Exception " + ee + " in extracting images");
                        }
                        ++i;
                    }
                    this.decode_pdf.flushObjectValues(true);
                    ++page;
                }
            }
            catch (Exception e) {
                this.decode_pdf.closePdfFile();
                System.err.println("Exception " + e.getMessage());
            }
            if (outputMessages) {
                System.out.println("Images read");
            }
        }
        this.decode_pdf.closePdfFile();
    }

    private void saveImage(BufferedImage image_to_save, String fileName, String prefix) {
        if (JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
        }
        if (prefix.indexOf("tif") != -1 && JAIHelper.isJAIused()) {
            try {
                FileOutputStream os = new FileOutputStream(fileName);
                String tiffFlag = System.getProperty("compress_tiff");
                boolean compressTiffs = tiffFlag != null;
                TIFFEncodeParam params = null;
                if (compressTiffs) {
                    params = new TIFFEncodeParam();
                    params.setCompression(32946);
                }
                JAI.create((String)"encode", (RenderedImage)image_to_save, (Object)os, (Object)"TIFF", (Object)params);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            try {
                ImageIO.write((RenderedImage)image_to_save, prefix, new File(fileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void outputMetaDataToXML(String file_name, int page, PdfImageData pdf_images, int i, String image_name) {
        float x1 = pdf_images.getImageXCoord(i);
        float y1 = pdf_images.getImageYCoord(i);
        float w = pdf_images.getImageWidth(i);
        float h = pdf_images.getImageHeight(i);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement("meta");
            doc.appendChild(root);
            Comment creation = doc.createComment("Created " + TimeNow.getShortTimeNow());
            doc.appendChild(creation);
            Comment info = doc.createComment("Pixel Location of image x1,y1,x2,y2");
            doc.appendChild(info);
            Comment moreInfo = doc.createComment("x1,y1 is top left corner origin is bottom left corner");
            doc.appendChild(moreInfo);
            Element location = doc.createElement("PAGELOCATION");
            location.setAttribute("x1", String.valueOf(x1));
            location.setAttribute("y1", String.valueOf(y1 + h));
            location.setAttribute("x2", String.valueOf(x1 + w));
            location.setAttribute("y2", String.valueOf(y1));
            root.appendChild(location);
            Element fileName = doc.createElement("FILE");
            fileName.setAttribute("value", file_name);
            root.appendChild(fileName);
            String parentXform = pdf_images.getParentXForm(image_name);
            if (parentXform != null) {
                Element opiData = doc.createElement("OPI");
                root.appendChild(opiData);
                Map XformData = pdf_images.getXFormData(parentXform);
                this.addOPIDataToXML(opiData, XformData, doc);
            }
            if (!isTest) {
                InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
                transformer.transform(new DOMSource(doc), new StreamResult(String.valueOf(this.output_dir) + page + this.separator + image_name + ".xml"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addOPIDataToXML(Element opiData, Map XformData, Document doc) {
        for (String key : XformData.keySet()) {
            Element subKey;
            Object value = XformData.get(key);
            if (value instanceof String) {
                subKey = doc.createElement(key);
                opiData.appendChild(subKey);
                subKey.setAttribute("value", (String)value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            subKey = null;
            if (key.equals("1.3") || key.equals("2.0")) {
                subKey = opiData;
                subKey.setAttribute("version", key);
            } else {
                subKey = doc.createElement(key);
                opiData.appendChild(subKey);
            }
            this.addOPIDataToXML(subKey, (Map)value, doc);
        }
    }

    public static void main(String[] args) {
        File pdf_file;
        if (outputMessages) {
            System.out.println("Simple demo to extract images from a page");
        }
        String file_name = test_file;
        boolean failed = false;
        int len = args.length;
        if (len == 0) {
            System.out.println("Example can take 1 or 2 parameters");
            System.out.println("Value 1 is the file name or directory of PDF files to process");
            System.out.println("Value 2 is optional values of image type (jpeg,tiff,png). Default is png");
            System.exit(1);
        } else if (len == 1) {
            file_name = args[0];
            System.out.println("file name=" + file_name);
        } else if (len < 3) {
            file_name = args[0];
            if (outputMessages) {
                System.out.println("File :" + file_name);
            }
            int j = 1;
            while (j < args.length) {
                String value = args[j];
                String in = value.toLowerCase();
                if (in.equals("tif") | in.equals("tiff")) {
                    prefix = "tif";
                } else if (in.equals("png")) {
                    prefix = "png";
                } else {
                    failed = true;
                    System.out.println("value args not recognised as valid parameter.");
                    System.out.println("please enter \"tif\", \"tiff\" or \"png\".");
                }
                ++j;
            }
        } else {
            failed = true;
            System.out.println("too many arguments entered - run with no values to see defaults");
        }
        if (failed) {
            String arguments = "";
            int a = 0;
            while (a < args.length) {
                arguments = String.valueOf(arguments) + args[a] + '\n';
                ++a;
            }
            System.out.println("you entered:\n" + arguments + "as the arguments");
        }
        if (!(pdf_file = new File(file_name)).exists()) {
            System.out.println("File " + file_name + " not found");
        }
        ExtractImages images1 = new ExtractImages(file_name);
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    private byte[] toByteArray(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] transfer = new byte[8192];
        int count = 0;
        while (count != -1) {
            count = in.read(transfer);
            if (count <= 0) continue;
            buffer.write(transfer, 0, count);
        }
        return buffer.toByteArray();
    }
}

