/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import org.jpedal.PdfDecoder;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfImageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class ExtractClippedImages {
    public static boolean outputMessages = false;
    private static String processed_dir = "processed";
    public static boolean testing = false;
    private static String inputDir = "";
    private static int outputCount;
    private static float[] outputSizes;
    private static String[] outputDirectories;
    PdfDecoder decode_pdf = null;
    private static final String separator;
    private String output_dir = "clippedImages";
    private String imageType = "tiff";
    private Color backgroundColor = Color.WHITE;
    private static RenderingHints hint;

    static {
        separator = System.getProperty("file.separator");
        hint = null;
        hint = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hint.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hint.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
    }

    public ExtractClippedImages(String rootDir) {
        String newImageType = System.getProperty("org.jpedal.imageType");
        if (newImageType != null) {
            this.imageType = newImageType.toLowerCase();
            if (this.imageType.equals("tif") || this.imageType.equals("tiff")) {
                this.imageType = "tiff";
            } else if (this.imageType.equals("jpg") || this.imageType.equals("jpeg")) {
                this.imageType = "jpg";
            } else if (!this.imageType.equals("png")) {
                ExtractClippedImages.exit("Imagetype " + this.imageType + " not supported");
            }
        }
        this.processFiles(rootDir);
    }

    private void processFiles(String rootDir) {
        File testDir;
        if (!rootDir.endsWith("\\") && !rootDir.endsWith("/")) {
            rootDir = String.valueOf(rootDir) + separator;
        }
        if (!processed_dir.endsWith(separator)) {
            processed_dir = String.valueOf(processed_dir) + separator;
        }
        if (!(testDir = new File(rootDir)).isDirectory()) {
            ExtractClippedImages.exit("No root directory " + rootDir);
        }
        String[] files = null;
        try {
            File inputFiles = new File(rootDir);
            System.out.println(inputFiles.getAbsolutePath());
            if (!inputFiles.isDirectory()) {
                System.err.println(String.valueOf(rootDir) + " is not a directory. Exiting program");
            }
            files = inputFiles.list();
        }
        catch (Exception ee) {
            ExtractClippedImages.exit("Exception trying to access file " + ee.getMessage());
        }
        long fileCount = files.length;
        int i = 0;
        while ((long)i < fileCount) {
            if (files[i].toLowerCase().endsWith(".pdf")) {
                if (outputMessages) {
                    System.out.println(String.valueOf(rootDir) + files[i]);
                }
                this.decode(String.valueOf(rootDir) + files[i], 72);
                File currentFile = new File(String.valueOf(rootDir) + files[i]);
                currentFile.renameTo(new File(String.valueOf(processed_dir) + files[i]));
            }
            ++i;
        }
    }

    private static void exit(String string) {
        System.out.println("Exit message " + string);
        LogWriter.writeLog("Exit message " + string);
    }

    private void decode(String file_name, int dpi) {
        String name = "demo";
        LogWriter.writeLog("==================");
        LogWriter.writeLog("File " + file_name);
        int pointer = file_name.lastIndexOf(separator);
        if (pointer != -1) {
            name = file_name.substring(pointer + 1, file_name.length() - 4);
        }
        try {
            this.decode_pdf = new PdfDecoder(false);
            this.decode_pdf.setExtractionMode(36, dpi, 1.0f);
            this.decode_pdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            ExtractClippedImages.exit(String.valueOf(Messages.getMessage("PdfViewerError.Exception")) + ' ' + e + ' ' + Messages.getMessage("PdfViewerError.OpeningPdfFiles"));
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
            ExtractClippedImages.exit(Messages.getMessage("PdfViewerError.EncryptedNotSupported"));
        } else {
            int start = 1;
            int end = this.decode_pdf.getPageCount();
            try {
                int page = start;
                while (page < end + 1) {
                    LogWriter.writeLog(String.valueOf(Messages.getMessage("PdfViewerDecoding.page")) + ' ' + page);
                    this.decode_pdf.decodePage(page);
                    PdfImageData pdf_images = this.decode_pdf.getPdfImageData();
                    int image_count = pdf_images.getImageCount();
                    if (image_count > 0) {
                        LogWriter.writeLog("page " + page + "contains " + image_count + " images");
                    } else {
                        LogWriter.writeLog("No bitmapped images on page " + page);
                    }
                    LogWriter.writeLog("Writing out images");
                    int i = 0;
                    while (i < image_count) {
                        String image_name = pdf_images.getImageName(i);
                        float x1 = pdf_images.getImageXCoord(i);
                        float y1 = pdf_images.getImageYCoord(i);
                        float w = pdf_images.getImageWidth(i);
                        float h = pdf_images.getImageHeight(i);
                        int versions = 0;
                        while (versions < outputCount) {
                            try {
                                String tiffFlag;
                                String type = this.decode_pdf.getObjectStore().getImageType(image_name);
                                BufferedImage image_to_save = this.decode_pdf.getObjectStore().loadStoredImage("CLIP_" + image_name);
                                int index = file_name.lastIndexOf(92);
                                if (index == -1) {
                                    index = file_name.lastIndexOf(47);
                                }
                                if (index == -1) {
                                    index = 0;
                                }
                                String nameToUse = file_name.substring(index, file_name.length() - 4);
                                String outputName = String.valueOf(outputDirectories[versions]) + nameToUse + '_' + page + '_' + i;
                                float scaling = 1.0f;
                                int newHeight = image_to_save.getHeight();
                                if (outputSizes[versions] > 0.0f) {
                                    scaling = outputSizes[versions] / (float)newHeight;
                                    if (scaling > 1.0f) {
                                        scaling = 1.0f;
                                    } else {
                                        Image scaledImage = image_to_save.getScaledInstance(-1, (int)outputSizes[versions], 4);
                                        image_to_save = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
                                        Graphics2D g2 = image_to_save.createGraphics();
                                        g2.drawImage(scaledImage, 0, 0, null);
                                    }
                                }
                                boolean compressTiffs = (tiffFlag = System.getProperty("compress_tiff")) != null;
                                JAIHelper.confirmJAIOnClasspath();
                                if (this.imageType.startsWith("jp")) {
                                    int iw = image_to_save.getWidth();
                                    int ih = image_to_save.getHeight();
                                    BufferedImage background = new BufferedImage(iw, ih, 1);
                                    Graphics2D g2 = (Graphics2D)background.getGraphics();
                                    g2.setPaint(this.backgroundColor);
                                    g2.fillRect(0, 0, iw, ih);
                                    g2.drawImage((Image)image_to_save, 0, 0, null);
                                    image_to_save = background;
                                }
                                if (testing) {
                                    this.decode_pdf.getObjectStore().saveStoredImage(outputName, image_to_save, true, false, this.imageType);
                                } else if (JAIHelper.isJAIused() && this.imageType.startsWith("tif")) {
                                    LogWriter.writeLog("Saving image with JAI " + outputName + '.' + this.imageType);
                                    TIFFEncodeParam params = null;
                                    if (compressTiffs) {
                                        params = new TIFFEncodeParam();
                                        params.setCompression(32946);
                                    }
                                    FileOutputStream os = new FileOutputStream(String.valueOf(outputName) + ".tif");
                                    JAI.create((String)"encode", (RenderedImage)image_to_save, (Object)os, (Object)"TIFF", (Object)params);
                                    os.flush();
                                    os.close();
                                } else {
                                    LogWriter.writeLog("Saving image " + outputName + '.' + this.imageType);
                                    ImageIO.write((RenderedImage)image_to_save, this.imageType, new File(String.valueOf(outputName) + '.' + this.imageType));
                                }
                                OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(outputName) + ".xml"), "UTF-8");
                                output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                                output_stream.write("<!-- Pixel Location of image x1,y1,x2,y2\n");
                                output_stream.write("(x1,y1 is top left corner)\n");
                                output_stream.write("(origin is bottom left corner)  -->\n");
                                output_stream.write("\n\n<META>\n");
                                output_stream.write("<PAGELOCATION x1=\"" + x1 + "\" " + "y1=\"" + (y1 + h) + "\" " + "x2=\"" + (x1 + w) + "\" " + "y2=\"" + y1 + "\" />\n");
                                output_stream.write("<FILE>" + file_name + "</FILE>\n");
                                output_stream.write("<ORIGINALHEIGHT>" + newHeight + "</ORIGINALHEIGHT>\n");
                                output_stream.write("<SCALEDHEIGHT>" + image_to_save.getHeight() + "</SCALEDHEIGHT>\n");
                                output_stream.write("<SCALING>" + scaling + "</SCALING>\n");
                                output_stream.write("</META>\n");
                                output_stream.close();
                            }
                            catch (Exception ee) {
                                LogWriter.writeLog("Exception " + ee + " in extracting images");
                            }
                            ++versions;
                        }
                        ++i;
                    }
                    this.decode_pdf.flushObjectValues(true);
                    ++page;
                }
            }
            catch (Exception e) {
                this.decode_pdf.closePdfFile();
                LogWriter.writeLog("Exception " + e.getMessage());
            }
        }
        this.decode_pdf.closePdfFile();
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    public static void main(String[] args) {
        Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
        if (outputMessages) {
            System.out.println("Simple demo to extract images from a page at various heights");
        }
        if ((args.length & 1) == 0 | args.length < 5) {
            LogWriter.writeLog("Values read");
            LogWriter.writeLog("inputDir=" + inputDir);
            LogWriter.writeLog("processedDir=" + processed_dir);
            LogWriter.writeLog("logFile=" + LogWriter.log_name);
            LogWriter.writeLog("Directory and height pair values");
            int i = 3;
            while (i < outputCount) {
                LogWriter.writeLog(args[i]);
                ++i;
            }
            if (args.length < 5 | (args.length & 1) == 0) {
                System.out.println("Requires");
                System.out.println("inputDir processedDir logFile");
                System.out.println("height Directory (as many pairs as you like)");
                ExtractClippedImages.exit("Not enough parameters passed to software");
            } else {
                ExtractClippedImages.exit("Incorrect number of values");
            }
        }
        inputDir = args[0];
        processed_dir = args[1];
        String logging = System.getProperty("org.jpedal.logging");
        if (logging != null && logging.toLowerCase().equals("true")) {
            LogWriter.log_name = args[2];
            LogWriter.setupLogFile(true, 0, "1.0", "", false);
        }
        File pdf_file = new File(inputDir);
        File processedDir = new File(processed_dir);
        if (!processedDir.exists()) {
            processedDir.mkdirs();
        }
        if (!pdf_file.exists()) {
            ExtractClippedImages.exit("Directory " + inputDir + " not found");
        }
        outputCount = (args.length - 3) / 2;
        outputSizes = new float[outputCount];
        outputDirectories = new String[outputCount];
        int i = 0;
        while (i < outputCount) {
            try {
                ExtractClippedImages.outputSizes[i] = Float.parseFloat(args[3 + i * 2]);
            }
            catch (Exception e) {
                ExtractClippedImages.exit("Exception " + e + " reading integer " + args[3 + i * 2]);
            }
            try {
                File dir;
                ExtractClippedImages.outputDirectories[i] = args[4 + i * 2];
                if (!outputDirectories[i].endsWith("\\") && !outputDirectories[i].endsWith("/")) {
                    ExtractClippedImages.outputDirectories[i] = String.valueOf(outputDirectories[i]) + separator;
                }
                if (!(dir = new File(outputDirectories[i])).exists()) {
                    dir.mkdirs();
                }
            }
            catch (Exception e) {
                ExtractClippedImages.exit("Exception " + e + " with directory " + args[4 + i * 2]);
            }
            ++i;
        }
        ExtractClippedImages images1 = new ExtractClippedImages(inputDir);
        LogWriter.writeLog("Process completed");
    }
}

