/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.handlers;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.AbsoluteDescriptor;
import javax.media.jai.operator.CropDescriptor;
import org.jpedal.color.ColorSpaces;
import org.jpedal.external.ImageHandler;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;

public class ExampleImageDrawOnScreenHandler
implements ImageHandler {
    public boolean alwaysIgnoreGenericHandler() {
        return false;
    }

    public BufferedImage processImageData(Map values, GraphicsState gs) {
        return null;
    }

    public boolean imageHasBeenScaled() {
        return false;
    }

    public boolean drawImageOnscreen(BufferedImage image, int optionsApplied, AffineTransform upside_down, String currentImageFile, Graphics2D g2, boolean renderDirect, ObjectStore objectStoreRef, boolean isPrinting) {
        boolean isSlightlyRotated;
        double[] values = new double[6];
        upside_down.getMatrix(values);
        boolean bl = isSlightlyRotated = values[0] * values[1] != 0.0 || values[2] * values[3] != 0.0;
        if (isSlightlyRotated || image.getWidth() < 800 || renderDirect) {
            g2.drawImage(image, upside_down, null);
        } else {
            double dy = 0.0;
            double dx = 0.0;
            if (optionsApplied != 0) {
                double tmp3;
                double tmp1;
                if ((optionsApplied & 2) == 2) {
                    if (values[0] > 0.0 && values[3] < 0.0 && (optionsApplied & 1) == 1) {
                        double newWidth = values[0] * (double)image.getWidth();
                        double newHeight = -(values[3] * (double)image.getHeight());
                        dy = values[5] - newHeight;
                        values[5] = newHeight;
                        if (newWidth - (double)((int)newWidth) > 0.5) {
                            dx -= 1.0;
                        }
                    } else if (values[0] < 0.0 && values[3] > 0.0) {
                        tmp1 = values[0];
                        tmp3 = values[2];
                        values[0] = values[3];
                        values[3] = tmp1;
                        values[4] = 0.0;
                        values[5] = (int)(values[4] * (double)image.getHeight() / (double)image.getWidth());
                    }
                } else if (values[0] > 0.0 && values[3] > 0.0 && (optionsApplied & 1) == 1) {
                    dy = values[5];
                    tmp1 = values[0];
                    tmp3 = values[2];
                    values[0] = values[3];
                    values[3] = tmp1;
                    values[4] = 0.0;
                    values[5] = (int)(values[4] * (double)image.getHeight() / (double)image.getWidth());
                }
                upside_down = new AffineTransform(values);
            }
            boolean imageProcessed = false;
            if (JAIHelper.isJAIused()) {
                if (!imageProcessed && currentImageFile != null) {
                    imageProcessed = true;
                    try {
                        Dimension tileSize = new Dimension(512, 512);
                        float quality = 1.0f;
                        FileSeekableStream s = new FileSeekableStream(new File(objectStoreRef.getFileForCachedImage(currentImageFile)));
                        ImageDecodeParam param = null;
                        ImageDecoder dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)s, param);
                        int imageToLoad = 0;
                        NullOpImage ri = new NullOpImage(dec.decodeAsRenderedImage(imageToLoad), null, 2, null);
                        ColorModel cm = ri.getColorModel();
                        ColorSpace cs = cm.getColorSpace();
                        RenderingHints hints = null;
                        if (ri.getTileWidth() * ri.getTileHeight() > tileSize.width * tileSize.height) {
                            cm = ri.getColorModel();
                            SampleModel sm = ri.getSampleModel().createCompatibleSampleModel(tileSize.width, tileSize.height);
                            ImageLayout layout = new ImageLayout(0, 0, tileSize.width, tileSize.height, sm, cm);
                            hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                            ri = AbsoluteDescriptor.create((RenderedImage)ri, (RenderingHints)hints);
                        }
                        image = JAI.create((String)"affine", (RenderedImage)ri, (Object)upside_down, (Object)new InterpolationBicubic(1)).getAsBufferedImage();
                        ri = null;
                        dec = null;
                    }
                    catch (Exception ee) {
                        imageProcessed = false;
                        ee.printStackTrace();
                    }
                    catch (Error err) {
                        imageProcessed = false;
                    }
                    currentImageFile = null;
                }
                if (!imageProcessed) {
                    LogWriter.writeLog("Unable to use JAI for image inversion");
                }
            } else {
                imageProcessed = true;
            }
            if (!imageProcessed) {
                imageProcessed = true;
                try {
                    AffineTransformOp invert = new AffineTransformOp(upside_down, ColorSpaces.hints);
                    image = invert.filter(image, null);
                }
                catch (Exception ee) {
                    imageProcessed = false;
                    ee.printStackTrace();
                }
                catch (Error err) {
                    imageProcessed = false;
                }
            }
            if (imageProcessed) {
                Shape rawClip = null;
                if (isPrinting && dy == 0.0) {
                    double[] affValues = new double[6];
                    g2.getTransform().getMatrix(affValues);
                    dx = affValues[4] / affValues[0];
                    if (dx > 0.0) {
                        dx = -dx;
                    }
                    if ((dy = affValues[5] / affValues[3]) > 0.0) {
                        dy = -dy;
                    }
                    dy = -(dy + (double)image.getHeight());
                }
                if (dy != 0.0) {
                    rawClip = g2.getClip();
                    int xDiff = 1;
                    double xScale = g2.getTransform().getScaleX();
                    xDiff = xScale < 1.0 ? (int)(1.0 / xScale) : (int)(xScale + 0.5);
                    int yDiff = 1;
                    double yScale = g2.getTransform().getScaleY();
                    yDiff = yScale < 1.0 ? (int)(1.0 / yScale) : (int)(yScale + 0.5);
                    g2.clipRect((int)dx, (int)(dy + 1.5), image.getWidth() - xDiff, image.getHeight() - yDiff);
                }
                g2.drawImage((Image)image, (int)dx, (int)dy, null);
                if (rawClip != null) {
                    g2.setClip(rawClip);
                }
            } else {
                g2.drawImage(image, upside_down, null);
            }
        }
        return true;
    }

    public static synchronized BufferedImage getAffineTransform(RenderedImage ri, AffineTransform src2me, RenderingHints hints, float quality) {
        double[] values = new double[6];
        src2me.getMatrix(values);
        Dimension preferredTileSize = new Dimension((int)(values[0] * (double)ri.getWidth()), (int)(values[3] * (double)ri.getHeight()));
        Point2D pt = new Point2D.Double(ri.getTileGridXOffset(), ri.getTileGridYOffset());
        pt = src2me.transform(pt, null);
        Rectangle $bounds = new Rectangle((int)pt.getX(), (int)pt.getY(), ri.getWidth(), ri.getHeight());
        Rectangle bounds = src2me.createTransformedShape($bounds).getBounds();
        System.out.println(">>" + ri);
        System.out.println(">>" + bounds);
        ColorModel cm = ri.getColorModel();
        SampleModel sm = cm.createCompatibleSampleModel(ri.getTileWidth(), ri.getTileHeight());
        TiledImage img = new TiledImage((int)bounds.getMinX(), (int)bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight(), (int)pt.getX(), (int)pt.getY(), sm, cm);
        KernelJAI kernel = ExampleImageDrawOnScreenHandler.createBlurKernel((float)src2me.getScaleX(), (float)src2me.getScaleY(), quality);
        int kw = kernel.getWidth();
        int kh = kernel.getHeight();
        AffineTransform at = (AffineTransform)src2me.clone();
        at.translate(pt.getX(), pt.getY());
        double $numXTiles = (double)ri.getWidth() / preferredTileSize.getWidth();
        double $numYTiles = (double)ri.getHeight() / preferredTileSize.getHeight();
        if ($numXTiles % 2.0 > 0.0) {
            $numXTiles += 1.0;
        }
        if ($numYTiles % 2.0 > 0.0) {
            $numYTiles += 1.0;
        }
        int numXTiles = (int)$numXTiles;
        int numYTiles = (int)$numYTiles;
        int x = 0;
        while (x < numXTiles) {
            int y = 0;
            while (y < numYTiles) {
                int $x = (int)((double)x * preferredTileSize.getWidth());
                int $y = (int)((double)y * preferredTileSize.getWidth());
                int $w = (int)preferredTileSize.getWidth();
                int $h = (int)preferredTileSize.getHeight();
                if ($x < 0) {
                    $x = 0;
                }
                if ($y < 0) {
                    $y = 0;
                }
                if ($x + $w > ri.getWidth()) {
                    $w = ri.getWidth() - $x;
                }
                if ($y + $h > ri.getHeight()) {
                    $h = ri.getHeight() - $y;
                }
                Rectangle tileBounds = new Rectangle($x, $y, $w, $h);
                $x = tileBounds.x - kw;
                $y = tileBounds.y - kh;
                $w = tileBounds.width + kw * 2;
                $h = tileBounds.height + kh * 2;
                if ($x < 0) {
                    $x = 0;
                }
                if ($y < 0) {
                    $y = 0;
                }
                if ($x + $w > ri.getWidth()) {
                    $w = ri.getWidth() - $x;
                }
                if ($y + $h > ri.getHeight()) {
                    $h = ri.getHeight() - $y;
                }
                Rectangle $tileBounds = new Rectangle($x, $y, $w, $h);
                WritableRaster wr = null;
                try {
                    wr = (WritableRaster)ri.getData($tileBounds);
                }
                catch (Exception e) {
                    wr = null;
                }
                if (wr == null) {
                    System.out.println(">>>");
                } else {
                    BufferedImage buf;
                    wr = wr.createWritableTranslatedChild(0, 0);
                    BufferedImage $ri = buf = new BufferedImage(ri.getColorModel(), wr, ri.getColorModel().isAlphaPremultiplied(), null);
                    if (quality > 0.0f) {
                        $ri = JAI.create((String)"convolve", (RenderedImage)buf, (Object)kernel);
                        if (wr.getWidth() - kw * 2 > 0 && wr.getHeight() - kh * 2 > 0) {
                            $ri = CropDescriptor.create((RenderedImage)$ri, (Float)new Float(kw), (Float)new Float(kh), (Float)new Float(wr.getWidth() - kw * 2), (Float)new Float((float)wr.getHeight() - (float)(kh * 2)), (RenderingHints)hints);
                        }
                    }
                    AffineTransform $at = (AffineTransform)at.clone();
                    $at.translate(tileBounds.getX(), tileBounds.getY());
                    Graphics2D g2d = img.createGraphics();
                    g2d.drawRenderedImage($ri, $at);
                    g2d.dispose();
                }
                ++y;
            }
            ++x;
        }
        return img.getAsBufferedImage();
    }

    public static KernelJAI createBlurKernel(float scaleX, float scaleY, float quality) {
        scaleX = Math.abs(scaleX);
        scaleY = Math.abs(scaleY);
        int sizeX = 1 + Math.round(quality / scaleX);
        int sizeY = 1 + Math.round(quality / scaleY);
        if (sizeX == 4 && sizeY == 4) {
            sizeX = 3;
            sizeY = 3;
        }
        if (sizeX == 5 && sizeY == 5) {
            sizeX = 3;
            sizeY = 3;
        }
        if (sizeX == 6 && sizeY == 6) {
            sizeX = 7;
            sizeY = 7;
        }
        float[] data = new float[sizeX * sizeY];
        float factor = 1.0f / (float)data.length;
        int i = 0;
        while (i < data.length) {
            data[i] = factor;
            ++i;
        }
        return new KernelJAI(sizeX, sizeY, data);
    }
}

