/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private int[] a1 = new int[256];
    private int[] b1 = new int[256];
    private int[] c1 = new int[256];

    public ICCColorSpace(PdfObjectReader currentPdfFile, String currentColorspace) {
        byte[] icc_data;
        int i = 0;
        while (i < 256) {
            this.a1[i] = -1;
            this.b1[i] = -1;
            this.c1[i] = -1;
            ++i;
        }
        this.value = 7;
        this.cs = ColorSpace.getInstance(1000);
        int pointer = currentColorspace.indexOf("/ICCBased");
        String object_ref = currentColorspace.substring(pointer + 9);
        if ((pointer = object_ref.indexOf(93)) != -1) {
            object_ref = object_ref.substring(0, pointer - 1);
        }
        if ((icc_data = currentPdfFile.readStream(object_ref.trim(), true)) == null) {
            LogWriter.writeLog("Error in reading ICC data with ref " + object_ref);
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(icc_data));
            }
            catch (Exception e) {
                LogWriter.writeLog("[PDF] Problem " + e.getMessage() + " with ICC data ");
                this.failed = true;
            }
        }
        this.componentCount = this.cs.getNumComponents();
    }

    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        int ii = 0;
        while (ii < items) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
            ++ii;
        }
        this.setColor(colValues, items);
    }

    public final void setColor(float[] operand, int size) {
        float[] values = new float[size];
        int[] lookup = new int[size];
        int i = 0;
        while (i < size) {
            float val;
            values[size - i - 1] = val = operand[i];
            lookup[size - i - 1] = (int)(val * 255.0f);
            ++i;
        }
        if (size == 3 && this.a1[lookup[0]] != -1 && this.b1[lookup[1]] != -1 && this.c1[lookup[2]] != -1) {
            this.currentColor = new PdfColor(this.a1[lookup[0]], this.b1[lookup[1]], this.c1[lookup[2]]);
        } else {
            values = this.cs.toRGB(values);
            this.currentColor = new PdfColor(values[0], values[1], values[2]);
            if (size == 3) {
                this.a1[lookup[0]] = (int)(values[0] * 255.0f);
                this.b1[lookup[1]] = (int)(values[1] * 255.0f);
                this.c1[lookup[2]] = (int)(values[2] * 255.0f);
            }
        }
    }

    public byte[] convertIndexToRGB(byte[] data) {
        if (this.componentCount == 4) {
            return this.convert4Index(data);
        }
        return data;
    }

    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, String decodeArray) {
        int type = this.getJPEGTransform(data);
        if (data.length > 9 && data[6] == 74 && data[7] == 70 && data[8] == 73 && data[9] == 70) {
            return this.nonRGBJPEGToRGBImage(data, w, h, null);
        }
        if (this.alternative != null && this.alternative.indexOf("DeviceRGB") != -1 && this.componentCount == 3 && (type == 0 || type == 3) && (this.intent == null || this.intent != null && this.intent.equals("/RelativeColorimetric"))) {
            return this.algorithmicICCToRGB(data, w, h, false);
        }
        return this.nonRGBJPEGToRGBImage(data, w, h, null);
    }

    public BufferedImage algorithmicICCToRGB(byte[] data, int w, int h, boolean debug) {
        BufferedImage image = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            iir = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            Raster ras = iir.readRaster(0, null);
            byte[] new_data = new byte[w * h * 3];
            data = ((DataBufferByte)ras.getDataBuffer()).getData();
            int pixelCount = w * h * 3;
            float lastR = 0.0f;
            float lastG = 0.0f;
            float lastB = 0.0f;
            int pixelReached = 0;
            float lastIn1 = -1.0f;
            float lastIn2 = -1.0f;
            float lastIn3 = -1.0f;
            int i = 0;
            while (i < pixelCount) {
                float in1 = (float)(data[i] & 0xFF) / 255.0f;
                float in2 = (float)(data[1 + i] & 0xFF) / 255.0f;
                float in3 = (float)(data[2 + i] & 0xFF) / 255.0f;
                float[] outputValues = new float[3];
                if (lastIn1 != in1 || lastIn2 != in2 || lastIn3 != in3) {
                    if (debug) {
                        System.out.println(String.valueOf(in1) + " " + in2 + ' ' + in3);
                    }
                    float[] inputValues = new float[]{in1, in2, in3};
                    outputValues = this.cs.toRGB(inputValues);
                    outputValues = inputValues;
                    lastR = outputValues[0] * 255.0f;
                    lastG = outputValues[1] * 255.0f;
                    lastB = outputValues[2] * 255.0f;
                    lastIn1 = in1;
                    lastIn2 = in2;
                    lastIn3 = in3;
                }
                new_data[pixelReached++] = (byte)lastR;
                new_data[pixelReached++] = (byte)lastG;
                new_data[pixelReached++] = (byte)lastB;
                i += 3;
            }
            try {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                int[] bands = nArray;
                DataBufferByte db = new DataBufferByte(new_data, new_data.length);
                image = new BufferedImage(w, h, 1);
                WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 3, 3, bands, null);
                image.setData(raster);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
                LogWriter.writeLog("Exception " + e + " with 24 bit RGB image");
            }
        }
        catch (Exception ras) {
            // empty catch block
        }
        try {
            in.close();
            iir.dispose();
            iin.close();
        }
        catch (Exception ee) {
            LogWriter.writeLog("Problem closing  " + ee);
        }
        return image;
    }
}

