/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;

public class DeviceRGBColorSpace
extends GenericColorSpace {
    public DeviceRGBColorSpace() {
        this.value = 2;
    }

    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        int ii = 0;
        while (ii < items) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
            ++ii;
        }
        this.setColor(colValues, items);
    }

    public final void setColor(float[] operand, int length) {
        if (length == 1) {
            float raw = operand[0];
            int[] val = new int[3];
            int id = (int)(operand[0] * 3.0f);
            int i = 0;
            while (i < 3) {
                int value;
                val[i] = value = this.getIndexedColorComponent(id + i);
                ++i;
            }
            this.currentColor = new PdfColor(val[0], val[1], val[2]);
        } else if (length > 2) {
            float[] val = new float[3];
            int i = 0;
            while (i < 3) {
                val[i] = operand[2 - i];
                if (val[i] < 0.0f) {
                    val[i] = 0.0f;
                }
                if (val[i] > 1.0f) {
                    val[i] = 1.0f;
                }
                ++i;
            }
            this.currentColor = new PdfColor(val[0], val[1], val[2]);
        }
    }
}

