/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.color.CalGrayColorSpace;
import org.jpedal.color.CalRGBColorSpace;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceNColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.ICCColorSpace;
import org.jpedal.color.LabColorSpace;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ColorspaceDecoder {
    public static boolean unsupportPatterns = false;

    private ColorspaceDecoder() {
    }

    public static final GenericColorSpace getColorSpaceInstance(boolean isPrinting, float[][] CTM, String currentColorspace, Map colorValues, PdfObjectReader currentPdfFile) {
        int ptr = -1;
        if (currentColorspace != null) {
            ptr = currentColorspace.indexOf("<<");
            if (colorValues == null && ptr != -1) {
                colorValues = currentPdfFile.directValuesToMap(currentColorspace, false);
                currentColorspace = String.valueOf(currentColorspace.substring(0, ptr)) + ']';
            }
        }
        if (ptr == -1 && colorValues != null && !colorValues.isEmpty()) {
            String current = Strip.removeArrayDeleminators((String)colorValues.get("rawValue"));
            if (current.indexOf(47) != -1) {
                currentColorspace = current;
            } else {
                Iterator ii = colorValues.keySet().iterator();
                StringBuffer buf = new StringBuffer();
                while (ii.hasNext()) {
                    String next = (String)ii.next();
                    if (next.equals("rawValue")) continue;
                    buf.append(next);
                }
                currentColorspace = buf.toString();
            }
        } else if (currentColorspace.startsWith("[")) {
            currentColorspace = Strip.removeArrayDeleminators(currentColorspace);
        }
        int ID = ColorSpaces.convertNameToID(currentColorspace);
        if (ID == 10) {
            return new SeparationColorSpace(currentPdfFile, currentColorspace, colorValues);
        }
        if (ID == 11 && ColorSpaces.useDeviceN) {
            return new DeviceNColorSpace(currentPdfFile, currentColorspace, colorValues);
        }
        return ColorspaceDecoder.getColorSpaceInstance(isPrinting, CTM, currentColorspace, ID, colorValues, currentPdfFile);
    }

    public static final GenericColorSpace getColorSpaceInstance(boolean isPrinting, float[][] CTM, String currentColorspace, int ID, Map colorValues, PdfObjectReader currentPdfFile) {
        Map colorData;
        String object_ref;
        int pointer;
        String whitepoint = null;
        String blackpoint = null;
        String range = null;
        String gamma = null;
        String matrix = null;
        boolean isIndexed = false;
        String CMap = "";
        String hvalue = "";
        String alt = null;
        if (colorValues == null && currentColorspace.indexOf("<<") != -1) {
            colorValues = currentPdfFile.directValuesToMap(currentColorspace, true);
        }
        GenericColorSpace currentColorData = new DeviceRGBColorSpace();
        if (ID == 8) {
            pointer = currentColorspace.indexOf("/Indexed");
            String rawColorspace = currentColorspace.substring(pointer + 8, currentColorspace.length()).trim();
            StringTokenizer values = new StringTokenizer(rawColorspace, "] ");
            if ((currentColorspace = values.nextToken()).equals("[")) {
                if (colorValues == null) {
                    int endCount = rawColorspace.indexOf(93);
                    if ((endCount = rawColorspace.indexOf(93, endCount + 1)) != -1) {
                        currentColorspace = rawColorspace.substring(1, endCount).trim();
                        values = new StringTokenizer(rawColorspace.substring(endCount + 1, rawColorspace.length()).trim(), "] ");
                    }
                } else {
                    Iterator ii = colorValues.keySet().iterator();
                    StringBuffer buf = new StringBuffer();
                    while (ii.hasNext()) {
                        String next = (String)ii.next();
                        if (next.equals("rawValue")) continue;
                        buf.append(next);
                    }
                    currentColorspace = buf.toString();
                }
            }
            hvalue = values.nextToken();
            CMap = values.nextToken();
            if (CMap.equals("R")) {
                Map colorData2 = currentPdfFile.readObject(String.valueOf(currentColorspace) + ' ' + hvalue + " R", true, null);
                if ((currentColorspace = Strip.removeArrayDeleminators((String)colorData2.get("rawValue")).trim()).length() == 0) {
                    colorValues = colorData2;
                    Iterator ii = colorData2.keySet().iterator();
                    StringBuffer buf = new StringBuffer();
                    while (ii.hasNext()) {
                        String next = (String)ii.next();
                        if (next.equals("rawValue")) continue;
                        buf.append(next);
                    }
                    currentColorspace = buf.toString();
                }
                hvalue = values.nextToken();
                CMap = values.nextToken();
            }
            StringBuffer buf = new StringBuffer(CMap);
            while (values.hasMoreTokens()) {
                buf.append(' ');
                buf.append(values.nextToken());
            }
            CMap = buf.toString();
            isIndexed = true;
            ID = ColorSpaces.convertNameToID(currentColorspace);
        }
        if (ID == 10) {
            currentColorData = new SeparationColorSpace(currentPdfFile, currentColorspace, colorValues);
        } else if (ID == 11 && ColorSpaces.useDeviceN) {
            currentColorData = new DeviceNColorSpace(currentPdfFile, currentColorspace, colorValues);
        } else if (ID == 7) {
            pointer = currentColorspace.indexOf("/ICCBased");
            object_ref = currentColorspace.substring(pointer + 9);
            if ((pointer = object_ref.indexOf(93)) != -1) {
                object_ref = object_ref.substring(0, pointer - 1);
            }
            if (object_ref.indexOf(" R") != -1) {
                colorData = currentPdfFile.readObject(object_ref.trim(), false, null);
                alt = (String)colorData.get("Alternate");
            } else {
                alt = object_ref.trim();
            }
        }
        if (ID == 1) {
            currentColorData = new DeviceGrayColorSpace();
        } else if (ID == 2) {
            currentColorData = new DeviceRGBColorSpace();
        } else if (ID == 3) {
            currentColorData = new DeviceCMYKColorSpace();
        } else if (ID == 4) {
            Map calValues = (Map)colorValues.get("CalGray");
            if (calValues == null) {
                calValues = colorValues;
            }
            whitepoint = currentPdfFile.getValue((String)calValues.get("WhitePoint"));
            blackpoint = currentPdfFile.getValue((String)calValues.get("BlackPoint"));
            gamma = currentPdfFile.getValue((String)calValues.get("Gamma"));
            currentColorData = new CalGrayColorSpace(whitepoint, blackpoint, gamma);
        } else if (ID == 5) {
            Map calValues = null;
            if (colorValues != null) {
                calValues = (Map)colorValues.get("CalRGB");
            }
            if (calValues == null) {
                calValues = colorValues;
            }
            if (calValues != null) {
                whitepoint = currentPdfFile.getValue((String)calValues.get("WhitePoint"));
                blackpoint = currentPdfFile.getValue((String)calValues.get("BlackPoint"));
                matrix = currentPdfFile.getValue((String)calValues.get("Matrix"));
                gamma = currentPdfFile.getValue((String)calValues.get("Gamma"));
            }
            currentColorData = new CalRGBColorSpace(whitepoint, blackpoint, matrix, gamma);
        } else if (ID == 6) {
            Map labValues = (Map)colorValues.get("Lab");
            whitepoint = currentPdfFile.getValue((String)labValues.get("WhitePoint"));
            blackpoint = currentPdfFile.getValue((String)labValues.get("BlackPoint"));
            range = currentPdfFile.getValue((String)labValues.get("Range"));
            currentColorData = new LabColorSpace(whitepoint, blackpoint, range);
        } else if (ID == 7) {
            currentColorData = new ICCColorSpace(currentPdfFile, currentColorspace);
            if (currentColorData.isInvalid()) {
                pointer = currentColorspace.indexOf("/ICCBased");
                object_ref = currentColorspace.substring(pointer + 9);
                if ((pointer = object_ref.indexOf(93)) != -1) {
                    object_ref = object_ref.substring(0, pointer - 1);
                }
                if (object_ref.indexOf(" R") != -1) {
                    colorData = currentPdfFile.readObject(object_ref.trim(), false, null);
                    alt = (String)colorData.get("Alternate");
                } else {
                    alt = object_ref.trim();
                }
                if (alt != null && alt.length() > 1) {
                    currentColorspace = alt;
                    ID = ColorSpaces.convertNameToID(currentColorspace);
                }
            }
        } else if (ID == 9) {
            LogWriter.writeLog("Pattern Colorspace unsupported in GPL version");
            unsupportPatterns = true;
        }
        if (isIndexed) {
            int size = Integer.parseInt(hvalue);
            if (CMap.endsWith(" R")) {
                currentColorData.setIndex(currentPdfFile.readStream(CMap, true), size);
            } else {
                currentColorData.setIndex(CMap, currentColorspace, size);
            }
        }
        currentColorData.setAlternative(alt);
        return currentColorData;
    }
}

