/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.io.Serializable;
import java.util.Map;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.PdfArray;
import org.jpedal.io.PdfObjectReader;

public class ColorMapping
implements Serializable {
    protected PDFFunction function;
    protected float[] domain;
    int functionType;

    public ColorMapping(PdfObjectReader currentPdfFile, Map tintTransform, byte[] stream, float[] range) {
        this.functionType = Integer.parseInt((String)tintTransform.get("FunctionType"));
        String value = currentPdfFile.getValue((String)tintTransform.get("Domain"));
        if (value != null) {
            this.domain = PdfArray.convertToFloatArray(value);
        }
        if ((value = currentPdfFile.getValue((String)tintTransform.get("Range"))) != null) {
            range = PdfArray.convertToFloatArray(value);
        }
        this.function = FunctionFactory.getFunction(stream, tintTransform, this.domain, range, this.functionType, currentPdfFile);
    }

    public float[] getOperandFloat(float[] values) {
        return this.function.compute(values);
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public float[] getDomain() {
        return this.domain;
    }
}

