/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.Gmarker;
import org.zkoss.gmaps.event.MarkerDropEvent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

class MarkerDropCommand
extends Command {
    public MarkerDropCommand(String evtnm, int flags) {
        super(evtnm, flags);
    }

    protected void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        String[] data = request.getData();
        if (data == null || data.length != 2) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        Gmarker gmarker = (Gmarker)comp;
        double lat = Double.parseDouble(data[0]);
        double lng = Double.parseDouble(data[1]);
        gmarker.setLatByClient(lat);
        gmarker.setLngByClient(lng);
        Events.postEvent((Event)new MarkerDropEvent(this.getId(), comp, lat, lng));
    }
}

