/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.event.MapOpenEvent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class MapOpenCommand
extends Command {
    public MapOpenCommand(String evtnm, int flags) {
        super(evtnm, flags);
    }

    protected void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        String[] data = request.getData();
        if (data == null || data.length != 5) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        boolean open = "true".equals(data[0]);
        Component ref = request.getDesktop().getComponentByUuidIfAny(data[1]);
        Object xc = ((ComponentCtrl)comp).getExtraCtrl();
        if (xc instanceof Openable) {
            ((Openable)xc).setOpenByClient(open);
        }
        double lat = Double.parseDouble(data[3]);
        double lng = Double.parseDouble(data[4]);
        Events.postEvent((Event)new MapOpenEvent(this.getId(), comp, open, ref, data[2], lat, lng));
    }
}

