/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.Gmaps;
import org.zkoss.gmaps.event.MapMoveEvent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

class MapMoveCommand
extends Command {
    public MapMoveCommand(String evtnm, int flags) {
        super(evtnm, flags);
    }

    protected void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        String[] data = request.getData();
        if (data == null || data.length != 6) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        Gmaps gmaps = (Gmaps)comp;
        double lat = Double.parseDouble(data[0]);
        double lng = Double.parseDouble(data[1]);
        double swlat = Double.parseDouble(data[2]);
        double swlng = Double.parseDouble(data[3]);
        double nelat = Double.parseDouble(data[4]);
        double nelng = Double.parseDouble(data[5]);
        gmaps.setCenterByClient(lat, lng);
        gmaps.setBoundsByClient(swlat, swlng, nelat, nelng);
        Events.postEvent((Event)new MapMoveEvent(this.getId(), comp, lat, lng, swlat, swlng, nelat, nelng));
    }
}

