/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.Ginfo;
import org.zkoss.gmaps.Gmaps;
import org.zkoss.gmaps.event.InfoChangeEvent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

class InfoChangeCommand
extends Command {
    public InfoChangeCommand(String evtnm, int flags) {
        super(evtnm, flags);
    }

    protected void process(AuRequest request) {
        Ginfo info;
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        String[] data = request.getData();
        if (data != null && data.length != 1) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        Gmaps gmaps = (Gmaps)comp;
        Ginfo ginfo = info = data == null ? null : (Ginfo)comp.getDesktop().getComponentByUuidIfAny(data[0]);
        if (info != null && info.getParent() != comp) {
            info = null;
        }
        gmaps.setInfoByClient(info);
        Events.postEvent((Event)new InfoChangeEvent(this.getId(), comp, info));
    }
}

