/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.Gimage;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.image.Image;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;

public class Gscreen
extends HtmlBasedComponent
implements Mapitem {
    private static final long serialVersionUID = 200807021855L;
    protected String _screenX = "0";
    protected String _screenY = "0";
    protected String _offsetX = "0";
    protected String _offsetY = "0";
    protected String _width = "50";
    protected String _height = "50";
    private String _src;
    private Image _image;
    private int _imgver;

    public Gscreen() {
    }

    public Gscreen(String src, String screenX, String screenY, String offsetX, String offsetY, String width, String height) {
        this.setSrc(src);
        this.setScreenX(screenX);
        this.setScreenY(screenY);
        this.setOffsetX(offsetX);
        this.setOffsetY(offsetY);
        this.setWidth(width);
        this.setHeight(height);
    }

    public String getScreenX() {
        if (this._screenX == null) {
            throw new NullPointerException("screenX");
        }
        return this._screenX;
    }

    public void setScreenX(String screenX) {
        if (screenX == null) {
            throw new NullPointerException("screenX");
        }
        if (!Objects.equals((Object)(screenX = screenX.trim()), (Object)this._screenX)) {
            this.validate(screenX, "screenX");
            this._screenX = screenX;
            this.invalidate();
        }
    }

    public String getScreenY() {
        if (this._screenY == null) {
            throw new NullPointerException("screenY");
        }
        return this._screenY;
    }

    public void setScreenY(String screenY) {
        if (screenY == null) {
            throw new NullPointerException("screenY");
        }
        if (!Objects.equals((Object)(screenY = screenY.trim()), (Object)this._screenY)) {
            this.validate(screenY, "screenY");
            this._screenY = screenY;
            this.invalidate();
        }
    }

    public String getOffsetX() {
        if (this._offsetX == null) {
            throw new NullPointerException("offsetX");
        }
        return this._offsetX;
    }

    public void setOffsetX(String offsetX) {
        if (offsetX == null) {
            throw new NullPointerException("offsetX");
        }
        if (!Objects.equals((Object)(offsetX = offsetX.trim()), (Object)this._offsetX)) {
            this.validate(offsetX, "offsetX");
            this._offsetX = offsetX;
            this.invalidate();
        }
    }

    public String getOffsetY() {
        if (this._offsetY == null) {
            throw new NullPointerException("offsetY");
        }
        return this._offsetY;
    }

    public void setOffsetY(String offsetY) {
        if (offsetY == null) {
            throw new NullPointerException("offsetY");
        }
        if (!Objects.equals((Object)(offsetY = offsetY.trim()), (Object)this._offsetY)) {
            this.validate(offsetY, "offsetY");
            this._offsetY = offsetY;
            this.invalidate();
        }
    }

    public void setWidth(String width) {
        if (width == null) {
            throw new NullPointerException("width");
        }
        if (!Objects.equals((Object)(width = width.trim()), (Object)this._width)) {
            this.validate(width, "width");
            this._width = width;
            this.invalidate();
        }
    }

    public String getWidth() {
        return this._width;
    }

    public void setHeight(String height) {
        if (height == null) {
            throw new NullPointerException("height");
        }
        if (!Objects.equals((Object)(height = height.trim()), (Object)this._height)) {
            this.validate(height, "height");
            this._height = height;
            this.invalidate();
        }
    }

    public String getHeight() {
        return this._height;
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            if (this._image == null) {
                this.invalidate();
            }
        }
    }

    private String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._image != null ? this.getContentSrc() : (dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "");
    }

    public void setContent(Image image) {
        if (image != this._image) {
            this._image = image;
            if (this._image != null) {
                ++this._imgver;
            }
            this.invalidate();
        }
    }

    public Image getContent() {
        return this._image;
    }

    private String getContentSrc() {
        return Gimage.getDynamicMediaURI((AbstractComponent)this, this._imgver, this._image.getName(), this._image.getFormat());
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        StringBuffer sb = new StringBuffer(128);
        if (attrs != null) {
            sb.append(attrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.src", (String)this.getEncodedSrc());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sx", (String)("" + this.getScreenX()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sy", (String)("" + this.getScreenY()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ox", (String)("" + this.getOffsetX()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.oy", (String)("" + this.getOffsetY()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.w", (String)("" + this.getWidth()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.h", (String)("" + this.getHeight()));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pid", (String)this.getParent().getUuid());
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }

    private void validate(String arg, String name) {
        try {
            String numstr = arg;
            if (arg.endsWith("px")) {
                numstr = arg.substring(0, arg.length() - 2);
                double num = Double.parseDouble(numstr);
                int inum = (int)num;
                if ((double)inum != num) {
                    throw new UiException(name + " allow px, or % only: " + arg);
                }
            } else if (arg.endsWith("%")) {
                numstr = arg.substring(0, arg.length() - 1);
                Double.parseDouble(numstr);
            } else {
                double num = Double.parseDouble(numstr);
                int inum = (int)num;
                if ((double)inum != num) {
                    throw new UiException(name + " allows px, or % only: " + arg);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new UiException(name + " allow px, or % only: " + arg);
        }
    }
}

