/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.lang.Objects;
import org.zkoss.util.CollectionsX;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.impl.XulElement;

public class Gpolyline
extends XulElement
implements Mapitem {
    private static final long serialVersionUID = 200807041530L;
    protected List _points = new ArrayList(32);
    private String _strpoints;
    private String _color = "#808080";
    private int _weight = 5;
    private int _opacity = 50;
    private int _numLevels = 4;
    private int _zoomFactor = 32;
    protected String _encodedPolyline;
    protected String _encodedLevels;

    public void addPoint(double lat, double lng, int level) {
        if (lat > 90.0 || lat < -90.0) {
            throw new IllegalArgumentException("latitude must be from -90 ~ +90: " + lat);
        }
        if (lng > 180.0 || lng < -180.0) {
            throw new IllegalArgumentException("longtitude must be from -180 ~ +180: " + lng);
        }
        if (level < 0 || level >= this._numLevels) {
            throw new IllegalArgumentException("level must be from 0 ~ " + (this._numLevels - 1) + ": " + level);
        }
        this._points.add(new Tuple(lat, lng, level));
        this.clearCacheAndInvalidate();
    }

    private void clearCacheAndInvalidate() {
        this._encodedPolyline = null;
        this._encodedLevels = null;
        this.invalidate();
    }

    public void setPoints(String points) {
        if (!Objects.equals((Object)points, (Object)this._strpoints)) {
            this._strpoints = points;
            if (points != null) {
                Collection list = CollectionsX.parse(null, (String)points, (char)',');
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    double lat = Double.parseDouble((String)it.next());
                    double lng = Double.parseDouble((String)it.next());
                    int level = Integer.parseInt((String)it.next());
                    this.addPoint(lat, lng, level);
                }
            }
            this.clearCacheAndInvalidate();
        }
    }

    public String getEncodedPolyline() {
        if (this._encodedPolyline == null) {
            int lat = 0;
            int lng = 0;
            StringBuffer sb = new StringBuffer(this._points.size() * 4);
            Iterator it = this._points.iterator();
            while (it.hasNext()) {
                Tuple tuple = (Tuple)it.next();
                int tlat = this.e5(tuple.lat);
                int tlng = this.e5(tuple.lng);
                sb.append(Gpolyline.encodeLatLng(tlat - lat)).append(Gpolyline.encodeLatLng(tlng - lng));
                lat = tlat;
                lng = tlng;
            }
            this._encodedPolyline = sb.length() == 0 ? "??" : sb.toString();
        }
        return this._encodedPolyline;
    }

    protected int e5(double db) {
        return (int)Math.floor(db * 100000.0);
    }

    public String getEncodedLevels() {
        if (this._encodedLevels == null) {
            StringBuffer sb = new StringBuffer(this._points.size() * 2);
            Iterator it = this._points.iterator();
            while (it.hasNext()) {
                Tuple tuple = (Tuple)it.next();
                sb.append(Gpolyline.encodeInt(tuple.level));
            }
            this._encodedLevels = sb.length() == 0 ? "?" : sb.toString();
        }
        return this._encodedLevels;
    }

    protected static String encodeLatLng(int e5) {
        boolean sign = e5 < 0;
        e5 <<= 1;
        if (sign) {
            e5 ^= 0xFFFFFFFF;
        }
        return Gpolyline.encodeInt(e5);
    }

    protected static String encodeInt(int x) {
        StringBuffer sb = new StringBuffer(6);
        do {
            int chunk = x & 0x1F;
            if ((x >>>= 5) != 0) {
                chunk |= 0x20;
            }
            sb.append((char)(chunk += 63));
        } while (x != 0);
        return sb.toString();
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        StringBuffer sb = new StringBuffer(128);
        if (attrs != null) {
            sb.append(attrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pts", (String)this.getEncodedPolyline());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.lvs", (String)this.getEncodedLevels());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.zf", (int)this.getZoomFactor());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.nlvs", (int)this.getNumLevels());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.cr", (String)this.getColor());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.wg", (int)this.getWeight());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.lop", (String)("" + (double)this.getOpacity() / 100.0));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pid", (String)this.getParent().getUuid());
        return sb.toString();
    }

    public String getColor() {
        return this._color;
    }

    public void setColor(String color) {
        if (color == null) {
            color = "#808080";
        }
        if (!color.equals(this._color)) {
            this._color = color;
            this.invalidate();
        }
    }

    public int getWeight() {
        return this._weight;
    }

    public void setWeight(int weight) {
        if (weight != this._weight) {
            this._weight = weight;
            this.invalidate();
        }
    }

    public int getOpacity() {
        return this._opacity;
    }

    public void setOpacity(int opacity) {
        if (opacity < 0 || opacity > 100) {
            throw new UiException("Line opacity must be between 0 to 100 (inclusive): " + opacity);
        }
        if (opacity != this._opacity) {
            this._opacity = opacity;
            this.invalidate();
        }
    }

    public int getNumLevels() {
        return this._numLevels;
    }

    public void setNumLevels(int numLevels) {
        if (numLevels < 1 || numLevels > 19) {
            throw new IllegalArgumentException("numLevels must be from 1 ~ 19: " + numLevels);
        }
        if (this._numLevels != numLevels) {
            this._numLevels = numLevels;
            int factor = 19 / numLevels;
            int mod = 19 % numLevels;
            this._zoomFactor = 2 << (mod > numLevels >> 1 ? factor + 1 : factor);
            this.invalidate();
        }
    }

    public int getZoomFactor() {
        return this._zoomFactor;
    }

    public boolean isChildable() {
        return false;
    }

    protected static class Tuple
    implements Serializable {
        public double lat;
        public double lng;
        public int level;

        public Tuple(double lat, double lng, int level) {
            this.lat = lat;
            this.lng = lng;
            this.level = level;
        }
    }
}

