/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import org.zkoss.gmaps.Ginfo;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Events;

public class Gmarker
extends Ginfo {
    private static final long serialVersionUID = 200807041527L;
    public static final int ZOOM_LIMIT = 19;
    private String _iconImage;
    private String _iconShadow;
    private int _iconWidth = -100;
    private int _iconHeight = -100;
    private int _iconShadowWidth = -100;
    private int _iconShadowHeight = -100;
    private int _iconAnchorX = -100;
    private int _iconAnchorY = -100;
    private int _iconInfoAnchorX = -100;
    private int _iconInfoAnchorY = -100;
    private String _iconPrintImage;
    private String _iconMozPrintImage;
    private String _iconPrintShadow;
    private String _iconTransparent;
    private String _iconImageMap;
    private int _iconMaxHeight = -100;
    private String _iconDragCrossImage;
    private int _iconDragCrossWidth = -100;
    private int _iconDragCrossHeight = -100;
    private int _iconDragCrossAnchorX = -100;
    private int _iconDragCrossAnchorY = -100;
    private int _maxzoom = 19;
    private int _minzoom = 0;
    private boolean _draggingEnabled = true;

    public Gmarker() {
    }

    public Gmarker(String content) {
        super(content);
    }

    public Gmarker(String content, double lat, double lng) {
        super(content, lat, lng);
    }

    public void setDraggingEnabled(boolean b) {
        if (this._draggingEnabled != b) {
            if (b) {
                this.smartUpdate("z.dgen", true);
            } else {
                this.smartUpdate("z.dgen", null);
            }
            this._draggingEnabled = b;
        }
    }

    public boolean isDraggingEnabled() {
        return this._draggingEnabled;
    }

    public int getIconAnchorX() {
        return this._iconAnchorX;
    }

    public void setIconAnchorX(int iconAnchorX) {
        if (this._iconAnchorX != iconAnchorX && iconAnchorX > -100) {
            this._iconAnchorX = iconAnchorX;
            this.invalidate();
        }
    }

    public int getIconAnchorY() {
        return this._iconAnchorY;
    }

    public void setIconAnchorY(int iconAnchorY) {
        if (this._iconAnchorY != iconAnchorY && iconAnchorY > -100) {
            this._iconAnchorY = iconAnchorY;
            this.invalidate();
        }
    }

    private String getIconAnchor() {
        return this.getIconAnchorX() <= -100 || this.getIconAnchorY() <= -100 ? null : "" + this.getIconAnchorX() + "," + this.getIconAnchorY();
    }

    public int getIconDragCrossAnchorX() {
        return this._iconDragCrossAnchorX;
    }

    public void setIconDragCrossAnchorX(int iconDragCrossAnchorX) {
        if (this._iconDragCrossAnchorX != iconDragCrossAnchorX && iconDragCrossAnchorX > -100) {
            this._iconDragCrossAnchorX = iconDragCrossAnchorX;
            this.invalidate();
        }
    }

    public int getIconDragCrossAnchorY() {
        return this._iconDragCrossAnchorY;
    }

    public void setIconDragCrossAnchorY(int iconDragCrossAnchorY) {
        if (this._iconDragCrossAnchorY != iconDragCrossAnchorY && iconDragCrossAnchorY > -100) {
            this._iconDragCrossAnchorY = iconDragCrossAnchorY;
            this.invalidate();
        }
    }

    private String getIconDragCrossAnchor() {
        return this.getIconDragCrossAnchorX() < 0 || this.getIconDragCrossAnchorY() < 0 ? null : "" + this.getIconDragCrossAnchorX() + "," + this.getIconDragCrossAnchorY();
    }

    public int getIconDragCrossHeight() {
        return this._iconDragCrossHeight;
    }

    public void setIconDragCrossHeight(int iconDragCrossHeight) {
        if (this._iconDragCrossHeight != iconDragCrossHeight && iconDragCrossHeight >= 0) {
            this._iconDragCrossHeight = iconDragCrossHeight;
            this.invalidate();
        }
    }

    public String getIconDragCrossImage() {
        return this._iconDragCrossImage;
    }

    public void setIconDragCrossImage(String iconDragCrossImage) {
        if (iconDragCrossImage != null && !iconDragCrossImage.equals(this._iconDragCrossImage)) {
            this._iconDragCrossImage = iconDragCrossImage;
            this.invalidate();
        }
    }

    public int getIconDragCrossWidth() {
        return this._iconDragCrossWidth;
    }

    public void setIconDragCrossWidth(int iconDragCrossWidth) {
        if (this._iconDragCrossWidth != iconDragCrossWidth && iconDragCrossWidth >= 0) {
            this._iconDragCrossWidth = iconDragCrossWidth;
            this.invalidate();
        }
    }

    private String getIconDragCrossSize() {
        return this.getIconDragCrossWidth() < 0 || this.getIconDragCrossHeight() < 0 ? null : "" + this.getIconDragCrossWidth() + "," + this.getIconDragCrossHeight();
    }

    public String getIconImage() {
        return this._iconImage;
    }

    public void setIconImage(String iconImage) {
        if (iconImage != null && !iconImage.equals(this._iconImage)) {
            this._iconImage = iconImage;
            this.smartUpdate("z.iimg", this.encodeURL(iconImage));
        }
    }

    public String getIconImageMap() {
        return this._iconImageMap;
    }

    public void setIconImageMap(String iconImageMap) {
        if (iconImageMap != null && !iconImageMap.equals(this._iconImageMap)) {
            this._iconImageMap = iconImageMap;
            this.invalidate();
        }
    }

    public int getIconInfoAnchorX() {
        return this._iconInfoAnchorX;
    }

    public void setIconInfoAnchorX(int iconInfoAnchorX) {
        if (this._iconInfoAnchorX != iconInfoAnchorX && iconInfoAnchorX > -100) {
            this._iconInfoAnchorX = iconInfoAnchorX;
            this.invalidate();
        }
    }

    public int getIconInfoAnchorY() {
        return this._iconInfoAnchorY;
    }

    public void setIconInfoAnchorY(int iconInfoAnchorY) {
        if (this._iconInfoAnchorY != iconInfoAnchorY && iconInfoAnchorY > -100) {
            this._iconInfoAnchorY = iconInfoAnchorY;
            this.invalidate();
        }
    }

    private String getIconInfoAnchor() {
        return this.getIconInfoAnchorX() < 0 || this.getIconInfoAnchorY() < 0 ? null : "" + this.getIconInfoAnchorX() + "," + this.getIconInfoAnchorY();
    }

    public int getIconMaxHeight() {
        return this._iconMaxHeight;
    }

    public void setIconMaxHeight(int iconMaxHeight) {
        if (this._iconMaxHeight != iconMaxHeight && iconMaxHeight >= 0) {
            this._iconMaxHeight = iconMaxHeight;
            this.invalidate();
        }
    }

    public String getIconMozPrintImage() {
        return this._iconMozPrintImage;
    }

    public void setIconMozPrintImage(String iconMozPrintImage) {
        if (iconMozPrintImage != null && !iconMozPrintImage.equals(this._iconMozPrintImage)) {
            this._iconMozPrintImage = iconMozPrintImage;
            this.invalidate();
        }
    }

    public String getIconPrintImage() {
        return this._iconPrintImage;
    }

    public void setIconPrintImage(String iconPrintImage) {
        if (iconPrintImage != null && !iconPrintImage.equals(this._iconPrintImage)) {
            this._iconPrintImage = iconPrintImage;
            this.invalidate();
        }
    }

    public String getIconPrintShadow() {
        return this._iconPrintShadow;
    }

    public void setIconPrintShadow(String iconPrintShadow) {
        if (iconPrintShadow != null && !iconPrintShadow.equals(this._iconPrintShadow)) {
            this._iconPrintShadow = iconPrintShadow;
            this.invalidate();
        }
    }

    public String getIconShadow() {
        return this._iconShadow;
    }

    public void setIconShadow(String iconShadow) {
        if (iconShadow != null && !iconShadow.equals(this._iconShadow)) {
            this._iconShadow = iconShadow;
            this.invalidate();
        }
    }

    public int getIconShadowHeight() {
        return this._iconShadowHeight;
    }

    public void setIconShadowHeight(int iconShadowHeight) {
        if (this._iconShadowHeight != iconShadowHeight && iconShadowHeight >= 0) {
            this._iconShadowHeight = iconShadowHeight;
            this.invalidate();
        }
    }

    public int getIconShadowWidth() {
        return this._iconShadowWidth;
    }

    public void setIconShadowWidth(int iconShadowWidth) {
        if (this._iconShadowWidth != iconShadowWidth && iconShadowWidth >= 0) {
            this._iconShadowWidth = iconShadowWidth;
            this.invalidate();
        }
    }

    private String getIconShadowSize() {
        return this.getIconShadowWidth() < 0 || this.getIconShadowHeight() < 0 ? null : "" + this.getIconShadowWidth() + "," + this.getIconShadowHeight();
    }

    public int getIconHeight() {
        return this._iconHeight;
    }

    public void setIconHeight(int iconHeight) {
        if (this._iconHeight != iconHeight && iconHeight >= 0) {
            this._iconHeight = iconHeight;
            this.invalidate();
        }
    }

    public void setIconSizeHeight(int iconHeight) {
        if (this._iconHeight != iconHeight && iconHeight >= 0) {
            this._iconHeight = iconHeight;
            this.invalidate();
        }
    }

    public int getIconWidth() {
        return this._iconWidth;
    }

    public void setIconWidth(int iconWidth) {
        if (this._iconWidth != iconWidth && iconWidth >= 0) {
            this._iconWidth = iconWidth;
            this.invalidate();
        }
    }

    private String getIconSize() {
        return this.getIconWidth() < 0 || this.getIconHeight() < 0 ? null : "" + this.getIconWidth() + "," + this.getIconHeight();
    }

    public String getIconTransparent() {
        return this._iconTransparent;
    }

    public void setIconTransparent(String iconTransparent) {
        if (iconTransparent != null && !iconTransparent.equals(this._iconTransparent)) {
            this._iconTransparent = iconTransparent;
            this.invalidate();
        }
    }

    public int getMaxzoom() {
        return this._maxzoom;
    }

    public void setMaxzoom(int lv) {
        if (lv > 19 || lv < 0) {
            throw new UiException("maxzoom level must be between 0 ~ 19. maxzoom: " + lv);
        }
        if (this._maxzoom != lv) {
            this._maxzoom = lv;
            this.invalidate();
        }
    }

    public int getMinzoom() {
        return this._minzoom;
    }

    public void setMinzoom(int lv) {
        if (lv > 19 || lv < 0) {
            throw new UiException("maxzoom level must be between 0 ~ 19. maxzoom: " + lv);
        }
        if (this._minzoom != lv) {
            this._minzoom = lv;
            this.invalidate();
        }
    }

    private String encodeURL(String url) {
        Desktop desktop = this.getDesktop();
        return (desktop == null ? Executions.getCurrent() : desktop.getExecution()).encodeURL(url);
    }

    boolean isGinfo() {
        return false;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        StringBuffer sb = new StringBuffer(128);
        if (attrs != null) {
            sb.append(attrs);
        }
        if (this.getIconImage() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.iimg", (String)this.encodeURL(this.getIconImage()));
        }
        if (this.getIconShadow() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.isdw", (String)this.encodeURL(this.getIconShadow()));
        }
        if (this.getIconSize() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.isz", (String)this.getIconSize());
        }
        if (this.getIconShadowSize() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.isdwsz", (String)this.getIconShadowSize());
        }
        if (this.getIconAnchor() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ianch", (String)this.getIconAnchor());
        }
        if (this.getIconInfoAnchor() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.iinfanch", (String)this.getIconInfoAnchor());
        }
        if (this.getIconPrintImage() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.iprtimg", (String)this.encodeURL(this.getIconPrintImage()));
        }
        if (this.getIconMozPrintImage() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.imozprtimg", (String)this.encodeURL(this.getIconMozPrintImage()));
        }
        if (this.getIconPrintShadow() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.iprtsdw", (String)this.encodeURL(this.getIconPrintShadow()));
        }
        if (this.getIconTransparent() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.itrpt", (String)this.encodeURL(this.getIconTransparent()));
        }
        if (this.getIconImageMap() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.iimgmap", (String)this.getIconImageMap());
        }
        if (this.getIconMaxHeight() >= 0) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.imaxhgt", (int)this.getIconMaxHeight());
        }
        if (this.getIconDragCrossImage() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.idrgcrsimg", (String)this.encodeURL(this.getIconDragCrossImage()));
        }
        if (this.getIconDragCrossSize() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.idrgcrssz", (String)this.getIconDragCrossSize());
        }
        if (this.getIconDragCrossAnchor() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.idrgcrsanch", (String)this.getIconDragCrossAnchor());
        }
        if (Events.isListened((Component)this, (String)"onMarkerDrop", (boolean)true)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onMarkerDrop", (String)"true");
        }
        if (this.isDraggingEnabled()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dgen", (boolean)true);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.maxz", (int)this.getMaxzoom());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.minz", (int)this.getMinzoom());
        return sb.toString();
    }

    void setLatByClient(double lat) {
        this._lat = lat;
    }

    void setLngByClient(double lng) {
        this._lng = lng;
    }
}

