/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.gmaps.MapModel;
import org.zkoss.gmaps.event.MapDataEvent;
import org.zkoss.gmaps.event.MapDataListener;
import org.zkoss.io.Serializables;

public abstract class AbstractMapModel
implements MapModel,
Serializable {
    private transient List _listeners = new LinkedList();

    protected void fireEvent(int type, Collection items) {
        MapDataEvent evt = new MapDataEvent(this, type, items);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            ((MapDataListener)it.next()).onChange(evt);
        }
    }

    public void addMapDataListener(MapDataListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this._listeners.add(listener);
    }

    public void removeMapDataListener(MapDataListener listener) {
        this._listeners.remove(listener);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList();
        Serializables.smartRead((ObjectInputStream)s, (Collection)this._listeners);
    }
}

