/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support.oldconfig;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.OldTypeToJ2EETypeMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OldProps {
    private final ObjectName mObjectName;
    private final Map<String, String> mValues;
    private static final String SERVER_CONFIG_KEY = "ServerConfig";
    private static final List<String> POSSIBLE_NAME_KEYS = Collections.unmodifiableList(ListUtil.newListFromArray(new String[]{"name", "id", "ref", "thread-pool-id", "jndi-name", "resource-adapter-name", "provider-id", "connector-resource-jndi-name", "auth-layer"}));

    private static void debug(Object o) {
        AMXDebug.getInstance().getOutput("OldProps").println(o);
    }

    public static List<String> getPossibleNameKeys() {
        return POSSIBLE_NAME_KEYS;
    }

    public ObjectName getOldObjectName() {
        return this.mObjectName;
    }

    public String getNewProps() {
        return JMXUtil.mapToProps(this.mValues);
    }

    private String getOldName(ObjectName oldObjectName) {
        String key;
        String oldName = null;
        Iterator<String> i$ = OldProps.getPossibleNameKeys().iterator();
        while (i$.hasNext() && (oldName = oldObjectName.getKeyProperty(key = i$.next())) == null) {
        }
        if (oldName == null && oldObjectName.getKeyProperty("type").equals("root")) {
            oldName = oldObjectName.getKeyProperty("server");
        }
        return oldName;
    }

    private static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    public static Set j2eeTypesToOldTypes(Set<String> j2eeTypes, OldTypeToJ2EETypeMapper mapper) {
        HashSet<String> old = new HashSet<String>();
        Object match = null;
        for (String j2eeType : j2eeTypes) {
            String oldType = mapper.j2eeTypeToOldType(j2eeType);
            if (oldType == null) continue;
            old.add(oldType);
        }
        return old;
    }

    public OldProps(ObjectName oldObjectName, OldTypeToJ2EETypeMapper mapper) {
        this.mObjectName = oldObjectName;
        this.mValues = new HashMap<String, String>();
        String j2eeType = mapper.oldObjectNameToJ2EEType(oldObjectName);
        if (j2eeType == null) {
            throw new IllegalArgumentException("" + oldObjectName);
        }
        this.mValues.put("j2eeType", j2eeType);
        String oldName = this.getOldName(oldObjectName);
        String name = oldName != null ? oldName : ObjectNames.getSingletonName(j2eeType);
        this.mValues.put("name", name);
        Set<String> keys = TypeCast.asSet(oldObjectName.getKeyPropertyList().keySet());
        for (String prop : keys) {
            String newType = mapper.oldTypeToJ2EEType(prop, oldObjectName);
            if (newType == null) continue;
            this.mValues.put(newType, oldObjectName.getKeyProperty(prop));
        }
        if (j2eeType.equals("X-JMXConnectorConfig")) {
            if (this.mValues.containsKey("X-ConfigConfig")) {
                this.mValues.put("X-AdminServiceConfig", ObjectNames.getSingletonName("X-AdminServiceConfig"));
            } else if (!this.mValues.containsKey("X-NodeAgentConfig")) {
                throw new IllegalArgumentException("unrecognized ObjectName for jmx-connector");
            }
        } else if (j2eeType.equals("X-SSLConfig")) {
            if (this.mValues.containsKey("X-NodeAgentConfig")) {
                this.mValues.put("X-JMXConnectorConfig", ObjectNames.getSingletonName("X-JMXConnectorConfig"));
            } else if (this.mValues.containsKey("X-JMXConnectorConfig")) {
                this.mValues.put("X-AdminServiceConfig", ObjectNames.getSingletonName("X-AdminServiceConfig"));
            } else if (this.mValues.containsKey("X-ConfigConfig") && !this.mValues.containsKey("X-HTTPListenerConfig") && !this.mValues.containsKey("X-IIOPListenerConfig")) {
                this.mValues.put("X-IIOPServiceConfig", ObjectNames.getSingletonName("X-IIOPServiceConfig"));
            }
        } else if (j2eeType.equals("X-AuthRealmConfig")) {
            if (this.mValues.containsKey("X-ConfigConfig")) {
                this.mValues.put("X-SecurityServiceConfig", ObjectNames.getSingletonName("X-SecurityServiceConfig"));
            } else if (!this.mValues.containsKey("X-NodeAgentConfig")) {
                throw new IllegalArgumentException("unrecognized ObjectName for ssl or jmx-connector");
            }
        }
    }
}

