/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.MBeanInfoConverter;
import com.sun.enterprise.management.support.TypeData;
import com.sun.enterprise.management.support.TypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeInfos {
    private static volatile TypeInfos INSTANCE;
    private final Map<String, TypeInfo> mTypeToInfoMap = new HashMap<String, TypeInfo>();
    private final Map<Class, MBeanInfo> mMBeanInfos;
    private static final String[] EXTRA_REMOVALS;
    private static final Set<String> CLUSTER_OR_SERVER_CONFIG;
    private static TypeData[] DATA;

    private static Logger getLogger() {
        return Logger.getLogger("javax.enterprise.system.tools.admin");
    }

    private TypeInfos() {
        this.initMap();
        this.mMBeanInfos = new HashMap<Class, MBeanInfo>();
        this.populateMBeanInfos();
    }

    private void populateMBeanInfos() {
        MBeanAttributeInfo[] extra = TypeInfos.getExtraAttributeInfos();
        for (TypeInfo typeInfo : this.mTypeToInfoMap.values()) {
            Class theInterface = typeInfo.getInterface();
            MBeanInfo info = MBeanInfoConverter.getInstance().convert(theInterface, extra);
            this.mMBeanInfos.put(theInterface, info);
        }
    }

    private static MBeanAttributeInfo[] getExtraAttributeInfos() {
        MBeanAttributeInfo[] extraInfos = JMXUtil.interfaceToMBeanInfo(Extra.class).getAttributes();
        Map<String, MBeanAttributeInfo> m = JMXUtil.attributeInfosToMap(extraInfos);
        for (int i = 0; i < EXTRA_REMOVALS.length; ++i) {
            m.remove(EXTRA_REMOVALS[i]);
        }
        MBeanAttributeInfo[] result = new MBeanAttributeInfo[m.values().size()];
        m.values().toArray(result);
        return result;
    }

    public MBeanInfo getMBeanInfoForInterface(Class theInterface) {
        return this.mMBeanInfos.get(theInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfos getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<TypeInfos> clazz = TypeInfos.class;
        synchronized (TypeInfos.class) {
            if (INSTANCE == null) {
                INSTANCE = new TypeInfos();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private void add(TypeData typeData) throws ClassNotFoundException {
        String j2eeType = typeData.getJ2EEType();
        TypeInfo info = new TypeInfo(typeData);
        this.mTypeToInfoMap.put(j2eeType, info);
    }

    private void initData() {
        TypeData[] data = DATA;
        for (int i = 0; i < data.length; ++i) {
            TypeData typeData = data[i];
            assert (!this.mTypeToInfoMap.containsKey(typeData.getJ2EEType())) : "init(): type already exists: " + typeData.getJ2EEType();
            try {
                this.add(typeData);
                continue;
            }
            catch (ClassNotFoundException e) {
                TypeInfos.getLogger().warning("SKIPPING AMX type--missing implementation class for: " + typeData.getJ2EEType());
            }
        }
    }

    private void initParentsForChildType(TypeInfo info) {
        if (info.isSubType()) {
            Set<String> possibleParents = info.getLegalParentJ2EETypes();
            for (String parentJ2EEType : possibleParents) {
                TypeInfo parentInfo = this.getInfo(parentJ2EEType);
                parentInfo.addChildJ2EEType(info.getJ2EEType());
            }
        }
    }

    private void initChildAndContaineeTypes() {
        Set<String> keys = this.getJ2EETypes();
        for (String childJ2EEType : keys) {
            TypeInfo info = this.getInfo(childJ2EEType);
            if (info.isSubType()) {
                this.initParentsForChildType(info);
                continue;
            }
            String containedByJ2EEType = info.getContainedByJ2EEType();
            if (containedByJ2EEType == null) continue;
            TypeInfo parentInfo = this.getInfo(containedByJ2EEType);
            parentInfo.addContaineeJ2EEType(childJ2EEType);
        }
    }

    private void initMap() {
        this.initData();
        this.initChildAndContaineeTypes();
    }

    public TypeInfo getInfo(String j2eeType) {
        if (j2eeType == null) {
            throw new IllegalArgumentException("null");
        }
        TypeInfo info = this.mTypeToInfoMap.get(j2eeType);
        if (info == null) {
            throw new IllegalArgumentException(j2eeType);
        }
        return info;
    }

    public Set<String> getJ2EETypes() {
        return this.mTypeToInfoMap.keySet();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Set<String> keys = this.getJ2EETypes();
        for (String j2eeType : keys) {
            TypeInfo info = this.getInfo(j2eeType);
            buf.append(info.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public String[] getContaineeByChain(String j2eeType) {
        TypeInfo info = this.getInfo(j2eeType);
        if (info.isSubType()) {
            throw new IllegalArgumentException("j2eeType is a subtype: " + j2eeType);
        }
        ArrayList<String> list = new ArrayList<String>();
        String containedByType = null;
        while ((containedByType = info.getContainedByJ2EEType()) != null) {
            list.add(containedByType);
            info = this.getInfo(containedByType);
        }
        Collections.reverse(list);
        return ListUtil.toStringArray(list);
    }

    public String[] getJ2EETypeChain(ObjectName objectName) {
        String j2eeType = Util.getJ2EEType(objectName);
        if (j2eeType == null) {
            throw new IllegalArgumentException(objectName.toString());
        }
        TypeInfo info = this.getInfo(j2eeType);
        if (info == null) {
            throw new IllegalArgumentException("uknown j2eeType: " + j2eeType);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(j2eeType);
        while (info.isSubType()) {
            Set<String> possibleParentTypes = info.getLegalParentJ2EETypes();
            String parentJ2EEType = null;
            parentJ2EEType = possibleParentTypes.size() == 1 ? GSetUtil.getSingleton(possibleParentTypes) : JMXUtil.findKey(possibleParentTypes, objectName);
            if (parentJ2EEType == null) {
                throw new IllegalArgumentException("MBean: " + objectName + " does not have any of the possible parent keys: {" + this.toString(possibleParentTypes) + "}");
            }
            list.add(parentJ2EEType);
            info = this.getInfo(parentJ2EEType);
        }
        Collections.reverse(list);
        return ListUtil.toStringArray(list);
    }

    private String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    static {
        EXTRA_REMOVALS = new String[]{"ProxyFactory", "ConnectionSource", "MBeanInfo", "AllAttributes"};
        CLUSTER_OR_SERVER_CONFIG = GSetUtil.newUnmodifiableStringSet("X-ClusterConfig", "X-StandaloneServerConfig", "X-ClusteredServerConfig");
        DATA = new TypeData[]{new MiscChild("X-DomainRoot", null, null), new DomainRootChild("X-SystemInfo"), new DomainRootChild("X-UploadDownloadMgr"), new DomainRootChild("X-DomainConfig"), new DomainRootChild("X-NotificationServiceMgr"), new DomainRootChild("X-DeploymentMgr"), new DomainRootChild("X-QueryMgr"), new DomainRootChild("X-WebServiceMgr"), new DomainRootChild("X-UpdateStatus"), new DomainRootChild("X-BulkAccess"), new DomainRootChild("X-Sample"), new DomainRootChild("X-ConfigDottedNames"), new DomainRootChild("X-MonitoringDottedNames"), new DomainRootChild("X-NotificationEmitterService"), new DomainRootChild("X-LoadBalancer"), new MiscChild("X-NotificationService", "X-NotificationServiceMgr"), new DomainConfigChild("X-ConfigConfig"), new DomainConfigChild("X-WebModuleConfig"), new DomainConfigChild("X-EJBModuleConfig"), new DomainConfigChild("X-J2EEApplicationConfig"), new DomainConfigChild("X-RARModuleConfig"), new DomainConfigChild("X-AppClientModuleConfig"), new DomainConfigChild("X-NodeAgentConfig"), new DomainConfigChild("X-ResourceAdapterConfig"), new DomainConfigChild("X-LifecycleModuleConfig"), new DomainConfigChild("X-LoadBalancerConfig"), new DomainConfigChild("X-LBConfig"), new DomainConfigChild("X-ClusterConfig"), new DomainConfigChild("X-StandaloneServerConfig"), new DomainConfigChild("X-ConnectorModuleConfig"), new DomainConfigChild("X-CustomMBeanConfig"), new DomainConfigChild("X-ClusteredServerConfig"), new ConfigConfigChild("X-ManagementRulesConfig"), new MiscChild("X-ManagementRuleConfig", "X-ManagementRulesConfig"), new MiscChild("X-EventConfig", "X-ManagementRuleConfig"), new MiscChild("X-ActionConfig", "X-ManagementRuleConfig"), new MiscChild("X-SecurityMapConfig", "X-ConnectorConnectionPoolConfig"), new MiscChild("X-BackendPrincipalConfig", "X-SecurityMapConfig"), new MixedChild("X-WebServiceEndpointConfig", GSetUtil.newUnmodifiableStringSet("X-J2EEApplicationConfig", "X-EJBModuleConfig", "X-WebModuleConfig")), new MiscChild("X-RegistryLocationConfig", "X-WebServiceEndpointConfig"), new MiscChild("X-TransformationRuleConfig", "X-WebServiceEndpointConfig"), new ConfigResource("X-ConnectorConnectionPoolConfig"), new ConfigResource("X-CustomResourceConfig"), new ConfigResource("X-JDBCResourceConfig"), new ConfigResource("X-JNDIResourceConfig"), new ConfigResource("X-PersistenceManagerFactoryResourceConfig"), new ConfigResource("X-MailResourceConfig"), new ConfigResource("X-JDBCConnectionPoolConfig"), new ConfigResource("X-AdminObjectResourceConfig"), new ConfigResource("X-ConnectorResourceConfig"), new AdminServiceConfigChild("X-DASConfig"), new MixedChild("X-JMXConnectorConfig", GSetUtil.newUnmodifiableStringSet("X-AdminServiceConfig", "X-NodeAgentConfig")), new SecurityServiceChild("X-AuditModuleConfig"), new MixedChild("X-AuthRealmConfig", GSetUtil.newUnmodifiableStringSet("X-SecurityServiceConfig", "X-NodeAgentConfig")), new SecurityServiceChild("X-JACCProviderConfig"), new SecurityServiceChild("X-MessageSecurityConfig"), new ConfigConfigChild("X-AdminServiceConfig"), new ConfigConfigChild("X-AvailabilityServiceConfig"), new ConfigConfigChild("X-EJBContainerConfig"), new ConfigConfigChild("X-HTTPServiceConfig"), new ConfigConfigChild("X-IIOPServiceConfig"), new ConfigConfigChild("X-JavaConfig"), new MixedChild("X-LogServiceConfig", GSetUtil.newUnmodifiableStringSet("X-ConfigConfig", "X-NodeAgentConfig")), new ConfigConfigChild("X-MDBContainerConfig"), new ConfigConfigChild("X-MonitoringServiceConfig"), new ConfigConfigChild("X-SecurityServiceConfig"), new ConfigConfigChild("X-ConnectorServiceConfig"), new ConfigConfigChild("X-WebContainerConfig"), new ConfigConfigChild("X-TransactionServiceConfig"), new ConfigConfigChild("X-JMSServiceConfig"), new ConfigConfigChild("X-ThreadPoolConfig"), new ConfigConfigChild("X-GroupManagementServiceConfig"), new ConfigConfigChild("X-DiagnosticServiceConfig"), new HTTPServiceChild("X-HTTPListenerConfig"), new HTTPServiceChild("X-AccessLogConfig"), new HTTPServiceChild("X-KeepAliveConfig"), new HTTPServiceChild("X-RequestProcessingConfig"), new HTTPServiceChild("X-ConnectionPoolConfig"), new HTTPServiceChild("X-HTTPProtocolConfig"), new HTTPServiceChild("X-HTTPFileCacheConfig"), new HTTPServiceChild("X-VirtualServerConfig"), new IIOPServiceChild("X-IIOPListenerConfig"), new IIOPServiceChild("X-ORBConfig"), new LBConfigChild("X-ClusterRefConfig"), new MiscChild("X-ProfilerConfig", "X-JavaConfig"), new MiscChild("X-JMSHostConfig", "X-JMSServiceConfig"), new MiscChild("X-HTTPAccessLogConfig", "X-VirtualServerConfig"), new MiscChild("X-ModuleLogLevelsConfig", "X-LogServiceConfig"), new MiscChild("X-ModuleMonitoringLevelsConfig", "X-MonitoringServiceConfig"), new MiscChild("X-SessionConfig", "X-WebContainerConfig"), new MiscChild("X-SessionManagerConfig", "X-SessionConfig"), new MiscChild("X-SessionPropertiesConfig", "X-SessionConfig"), new MiscChild("X-ManagerPropertiesConfig", "X-SessionManagerConfig"), new MiscChild("X-StorePropertiesConfig", "X-SessionManagerConfig"), new MiscChild("X-EJBTimerServiceConfig", "X-EJBContainerConfig"), new MiscChild("X-EJBContainerAvailabilityConfig", "X-AvailabilityServiceConfig"), new MiscChild("X-WebContainerAvailabilityConfig", "X-AvailabilityServiceConfig"), new MiscChild("X-JMSAvailabilityConfig", "X-AvailabilityServiceConfig"), new MixedChild("X-DeployedItemRefConfig", CLUSTER_OR_SERVER_CONFIG), new MixedChild("X-ResourceRefConfig", CLUSTER_OR_SERVER_CONFIG), new MixedChild("X-SSLConfig", GSetUtil.newUnmodifiableStringSet("X-IIOPListenerConfig", "X-IIOPServiceConfig", "X-HTTPListenerConfig", "X-JMXConnectorConfig")), new MixedChild("X-HealthCheckerConfig", GSetUtil.newUnmodifiableStringSet("X-ServerRefConfig", "X-ClusterRefConfig")), new MixedChild("X-ServerRefConfig", GSetUtil.newUnmodifiableStringSet("X-ClusterConfig", "X-LBConfig")), new MiscChild("X-ProviderConfig", "X-MessageSecurityConfig"), new MiscChild("X-RequestPolicyConfig", "X-ProviderConfig"), new MiscChild("X-ResponsePolicyConfig", "X-ProviderConfig"), new DomainRootChild("J2EEDomain"), new J2EEDomainChild("X-J2EECluster"), new J2EEDomainChild("J2EEServer"), new J2EEServerChild("JVM"), new J2EEServerChild("J2EEApplication"), new J2EEServerChild("JDBCDriver"), new J2EEServerChild("JDBCResource"), new J2EEServerChild("JMSResource"), new J2EEServerChild("JNDIResource"), new J2EEServerChild("JTAResource"), new J2EEServerChild("ResourceAdapterModule"), new J2EEServerChild("RMI_IIOPResource"), new J2EEServerChild("URL_Resource"), new J2EEServerChild("JavaMailResource"), new J2EEServerChild("JCAResource"), new MiscChild("AppClientModule", "J2EEApplication"), new MiscChild("EJBModule", "J2EEApplication"), new MiscChild("WebModule", "J2EEApplication"), new MiscChild("ResourceAdapter", "ResourceAdapterModule"), new EJBModuleChild("EntityBean"), new EJBModuleChild("StatefulSessionBean"), new EJBModuleChild("MessageDrivenBean"), new EJBModuleChild("StatelessSessionBean"), new MiscChild("JCAConnectionFactory", "JCAResource"), new MiscChild("JCAManagedConnectionFactory", "JCAResource"), new MiscChild("JDBCDataSource", "JDBCResource"), new MiscChild("Servlet", "WebModule"), new MixedChild("WebServiceEndpoint", GSetUtil.newUnmodifiableStringSet("WebModule", "EJBModule")), new DomainRootChild("X-JMXMonitorMgr"), new DomainRootChild("X-AMXCounterMonitor"), new DomainRootChild("X-AMXGaugeMonitor"), new DomainRootChild("X-AMXStringMonitor"), new DomainRootChild("X-MonitoringRoot"), new Containee("X-ServerRootMonitor", "X-MonitoringRoot"), new ServerRootMonitorChild("X-JVMMonitor"), new ServerRootMonitorChild("X-CallFlowMonitor"), new ServerRootMonitorChild("X-TransactionServiceMonitor"), new ServerRootMonitorChild("X-HTTPServiceMonitor"), new ServerRootMonitorChild("X-JDBCConnectionPoolMonitor"), new ServerRootMonitorChild("X-ApplicationMonitor"), new ServerRootMonitorChild("X-Logging"), new MiscChild("X-WebModuleVirtualServerMonitor", "X-ApplicationMonitor"), new MiscChild("X-ServletMonitor", "X-WebModuleVirtualServerMonitor"), new MiscChild("X-WebServiceEndpointMonitor", GSetUtil.newUnmodifiableStringSet("X-WebModuleVirtualServerMonitor", "X-EJBModuleMonitor")), new MiscChild("X-EJBModuleMonitor", "X-ApplicationMonitor"), new MiscChild("X-StatelessSessionBeanMonitor", "X-EJBModuleMonitor"), new MiscChild("X-StatefulSessionBeanMonitor", "X-EJBModuleMonitor"), new MiscChild("X-EntityBeanMonitor", "X-EJBModuleMonitor"), new MiscChild("X-MessageDrivenBeanMonitor", "X-EJBModuleMonitor"), new MiscChild("X-BeanPoolMonitor", GSetUtil.newUnmodifiableStringSet("X-EntityBeanMonitor", "X-StatefulSessionBeanMonitor", "X-StatelessSessionBeanMonitor", "X-MessageDrivenBeanMonitor")), new MiscChild("X-BeanCacheMonitor", GSetUtil.newUnmodifiableStringSet("X-EntityBeanMonitor", "X-MessageDrivenBeanMonitor", "X-StatefulSessionBeanMonitor", "X-StatelessSessionBeanMonitor")), new MiscChild("X-BeanMethodMonitor", GSetUtil.newUnmodifiableStringSet("X-EntityBeanMonitor", "X-StatefulSessionBeanMonitor", "X-StatelessSessionBeanMonitor", "X-MessageDrivenBeanMonitor")), new ServerRootMonitorChild("X-ConnectorConnectionPoolMonitor"), new ServerRootMonitorChild("X-ThreadPoolMonitor"), new ServerRootMonitorChild("X-ConnectionManagerMonitor"), new MiscChild("X-HTTPServiceVirtualServerMonitor", "X-HTTPServiceMonitor"), new HTTPServiceMonitorChild("X-HTTPListenerMonitor"), new HTTPServiceMonitorChild("X-FileCacheMonitor"), new HTTPServiceMonitorChild("X-KeepAliveMonitor"), new HTTPServiceMonitorChild("X-ConnectionQueueMonitor")};
    }

    private static final class AdminServiceConfigChild
    extends TypeData {
        public AdminServiceConfigChild(String j2eeType) {
            super(j2eeType, "X-AdminServiceConfig");
        }
    }

    private static final class ConfigConfigChild
    extends TypeData {
        public ConfigConfigChild(String j2eeType) {
            super(j2eeType, "X-ConfigConfig");
        }
    }

    private static final class ConfigResource
    extends TypeData {
        public ConfigResource(String j2eeType) {
            super(j2eeType, null, "X-DomainConfig");
        }
    }

    private static final class Containee
    extends TypeData {
        public Containee(String j2eeType, String containerType) {
            super(j2eeType, null, containerType);
        }
    }

    private static class DomainConfigChild
    extends TypeData {
        public DomainConfigChild(String j2eeType) {
            super(j2eeType, null, "X-DomainConfig");
        }
    }

    private static final class DomainRootChild
    extends TypeData {
        public DomainRootChild(String j2eeType) {
            super(j2eeType, null, "X-DomainRoot");
        }
    }

    private static final class EJBModuleChild
    extends TypeData {
        public EJBModuleChild(String j2eeType) {
            super(j2eeType, "EJBModule");
        }
    }

    private static final class HTTPServiceChild
    extends TypeData {
        public HTTPServiceChild(String j2eeType) {
            super(j2eeType, "X-HTTPServiceConfig");
        }
    }

    private static final class HTTPServiceMonitorChild
    extends TypeData {
        public HTTPServiceMonitorChild(String j2eeType) {
            super(j2eeType, "X-HTTPServiceMonitor");
        }
    }

    private static final class IIOPServiceChild
    extends TypeData {
        public IIOPServiceChild(String j2eeType) {
            super(j2eeType, "X-IIOPServiceConfig");
        }
    }

    private static final class J2EEDomainChild
    extends TypeData {
        public J2EEDomainChild(String j2eeType) {
            super(j2eeType, null, "J2EEDomain");
        }
    }

    private static final class J2EEServerChild
    extends TypeData {
        public J2EEServerChild(String j2eeType) {
            super(j2eeType, "J2EEServer");
        }
    }

    private static final class LBConfigChild
    extends TypeData {
        public LBConfigChild(String j2eeType) {
            super(j2eeType, "X-LBConfig");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MiscChild
    extends TypeData {
        public MiscChild(String j2eeType, String parentJ2EEType) {
            super(j2eeType, parentJ2EEType);
        }

        public MiscChild(String j2eeType, Set<String> legalParentJ2EETypes) {
            super(j2eeType, legalParentJ2EETypes);
        }

        public MiscChild(String j2eeType, Set<String> legalParentJ2EETypes, String containedByJ2EEType) {
            super(j2eeType, legalParentJ2EETypes, containedByJ2EEType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MixedChild
    extends TypeData {
        public MixedChild(String j2eeType, Set<String> legalParentJ2EETypes) {
            super(j2eeType, legalParentJ2EETypes);
        }
    }

    private static final class ResourceConfigMgr
    extends TypeData {
        public ResourceConfigMgr(String j2eeType) {
            super(j2eeType, null, "X-DomainConfig");
        }
    }

    private static final class SecurityServiceChild
    extends TypeData {
        public SecurityServiceChild(String j2eeType) {
            super(j2eeType, "X-SecurityServiceConfig");
        }
    }

    private static final class ServerRootMonitorChild
    extends TypeData {
        public ServerRootMonitorChild(String j2eeType) {
            super(j2eeType, "X-ServerRootMonitor");
        }
    }
}

